/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model;

import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.model.ModelObject;
import com.sun.xml.rpc.processor.model.ModelVisitor;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class Service
extends ModelObject
implements com.sun.xml.rpc.spi.model.Service {
    private QName name;
    private List ports = new ArrayList();
    private Map portsByName = new HashMap();
    private JavaInterface javaInterface;

    public Service() {
    }

    public Service(QName name, JavaInterface javaInterface) {
        this.name = name;
        this.javaInterface = javaInterface;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName n) {
        this.name = n;
    }

    public void addPort(Port port) {
        if (this.portsByName.containsKey(port.getName())) {
            throw new ModelException("model.uniqueness");
        }
        this.ports.add(port);
        this.portsByName.put(port.getName(), port);
    }

    public Iterator getPorts() {
        return this.ports.iterator();
    }

    public Port getPortByName(QName n) {
        if (this.portsByName.size() != this.ports.size()) {
            this.initializePortsByName();
        }
        return (Port)this.portsByName.get(n);
    }

    public List getPortsList() {
        return this.ports;
    }

    public void setPortsList(List m) {
        this.ports = m;
    }

    private void initializePortsByName() {
        this.portsByName = new HashMap();
        if (this.ports != null) {
            for (Port port : this.ports) {
                if (port.getName() != null && this.portsByName.containsKey(port.getName())) {
                    throw new ModelException("model.uniqueness");
                }
                this.portsByName.put(port.getName(), port);
            }
        }
    }

    public com.sun.xml.rpc.spi.model.JavaInterface getJavaIntf() {
        return this.getJavaInterface();
    }

    public JavaInterface getJavaInterface() {
        return this.javaInterface;
    }

    public void setJavaInterface(JavaInterface i) {
        this.javaInterface = i;
    }

    public void accept(ModelVisitor visitor) throws Exception {
        visitor.visit(this);
    }
}

