/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.beam.model.expansion.v1.ExpansionApi;
import org.apache.beam.model.jobmanagement.v1.ArtifactApi;
import org.apache.beam.model.jobmanagement.v1.ArtifactRetrievalServiceGrpc;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.CoderTranslation;
import org.apache.beam.runners.core.construction.DefaultExpansionServiceClientFactory;
import org.apache.beam.runners.core.construction.ExpansionServiceClientFactory;
import org.apache.beam.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.resourcehints.ResourceHints;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValues;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.Channel;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.ManagedChannel;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.ManagedChannelBuilder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.PORTABILITY)
public class External {
    private static final String EXPANDED_TRANSFORM_BASE_NAME = "external";
    private static final String IMPULSE_PREFIX = "IMPULSE";
    private static AtomicInteger namespaceCounter = new AtomicInteger(0);
    private static final ExpansionServiceClientFactory DEFAULT = DefaultExpansionServiceClientFactory.create(endPoint -> ManagedChannelBuilder.forTarget((String)endPoint.getUrl()).usePlaintext().build());

    private static int getFreshNamespaceIndex() {
        return namespaceCounter.getAndIncrement();
    }

    public static <InputT extends PInput, OutputT> SingleOutputExpandableTransform<InputT, OutputT> of(String urn, byte[] payload, String endpoint) {
        Endpoints.ApiServiceDescriptor apiDesc = Endpoints.ApiServiceDescriptor.newBuilder().setUrl(endpoint).build();
        return new SingleOutputExpandableTransform(urn, payload, apiDesc, DEFAULT, External.getFreshNamespaceIndex(), (Map<String, Coder<?>>)ImmutableMap.of());
    }

    @VisibleForTesting
    public static <InputT extends PInput, OutputT> SingleOutputExpandableTransform<InputT, OutputT> of(String urn, byte[] payload, String endpoint, ExpansionServiceClientFactory clientFactory) {
        Endpoints.ApiServiceDescriptor apiDesc = Endpoints.ApiServiceDescriptor.newBuilder().setUrl(endpoint).build();
        return new SingleOutputExpandableTransform(urn, payload, apiDesc, clientFactory, External.getFreshNamespaceIndex(), (Map<String, Coder<?>>)ImmutableMap.of());
    }

    public static abstract class ExpandableTransform<InputT extends PInput, OutputT extends POutput>
    extends PTransform<InputT, OutputT> {
        private final String urn;
        private final byte[] payload;
        private final Endpoints.ApiServiceDescriptor endpoint;
        private final ExpansionServiceClientFactory clientFactory;
        private final Integer namespaceIndex;
        private final Map<String, Coder<?>> outputCoders;
        private transient // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable RunnerApi.Components expandedComponents;
        private transient // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable RunnerApi.PTransform expandedTransform;
        private transient @Nullable List<String> expandedRequirements;
        private transient @Nullable Map<PCollection, String> externalPCollectionIdMap;
        private transient @Nullable Map<Coder<?>, String> externalCoderIdMap;

        ExpandableTransform(String urn, byte[] payload, Endpoints.ApiServiceDescriptor endpoint, ExpansionServiceClientFactory clientFactory, Integer namespaceIndex, Map<String, Coder<?>> outputCoders) {
            this.urn = urn;
            this.payload = payload;
            this.endpoint = endpoint;
            this.clientFactory = clientFactory;
            this.namespaceIndex = namespaceIndex;
            this.outputCoders = outputCoders;
        }

        public OutputT expand(InputT input) {
            Pipeline p = input.getPipeline();
            SdkComponents components = SdkComponents.create(p.getOptions());
            RunnerApi.PTransform.Builder ptransformBuilder = RunnerApi.PTransform.newBuilder().setUniqueName(External.EXPANDED_TRANSFORM_BASE_NAME + this.namespaceIndex).setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(this.urn).setPayload(ByteString.copyFrom((byte[])this.payload)).build());
            ImmutableMap.Builder externalPCollectionIdMapBuilder = ImmutableMap.builder();
            for (Map.Entry entry : input.expand().entrySet()) {
                if (!(entry.getValue() instanceof PCollection)) continue;
                try {
                    String id = components.registerPCollection((PCollection)entry.getValue());
                    externalPCollectionIdMapBuilder.put((Object)((PCollection)entry.getValue()), (Object)id);
                    ptransformBuilder.putInputs(((TupleTag)entry.getKey()).getId(), id);
                    AppliedPTransform fakeImpulse = AppliedPTransform.of((String)String.format("%s_%s", External.IMPULSE_PREFIX, ((TupleTag)entry.getKey()).getId()), (Map)PValues.expandInput((PInput)PBegin.in((Pipeline)p)), (Map)ImmutableMap.of((Object)((TupleTag)entry.getKey()), (Object)((PCollection)entry.getValue())), (PTransform)Impulse.create(), (ResourceHints)ResourceHints.create(), (Pipeline)p);
                    components.registerPTransform(fakeImpulse, Collections.emptyList());
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("cannot register component: %s", e.getMessage()));
                }
            }
            ExpansionApi.ExpansionRequest.Builder requestBuilder = ExpansionApi.ExpansionRequest.newBuilder();
            requestBuilder.putAllOutputCoderRequests(this.outputCoders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, kv -> {
                try {
                    return components.registerCoder((Coder)kv.getValue());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            })));
            RunnerApi.Components originalComponents = components.toComponents();
            ExpansionApi.ExpansionRequest request = requestBuilder.setComponents(originalComponents).setTransform(ptransformBuilder.build()).setNamespace(this.getNamespace()).build();
            ExpansionApi.ExpansionResponse response = this.clientFactory.getExpansionServiceClient(this.endpoint).expand(request);
            if (!Strings.isNullOrEmpty((String)response.getError())) {
                throw new RuntimeException(String.format("expansion service error: %s", response.getError()));
            }
            Map<String, RunnerApi.Environment> newEnvironmentsWithDependencies = response.getComponents().getEnvironmentsMap().entrySet().stream().filter(kv -> !originalComponents.getEnvironmentsMap().containsKey(kv.getKey()) && ((RunnerApi.Environment)kv.getValue()).getDependenciesCount() != 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.expandedComponents = response.getComponents().toBuilder().putAllEnvironments(this.resolveArtifacts(newEnvironmentsWithDependencies)).build();
            this.expandedTransform = response.getTransform();
            this.expandedRequirements = response.getRequirementsList();
            RehydratedComponents rehydratedComponents = RehydratedComponents.forComponents(this.expandedComponents).withPipeline(p);
            ImmutableMap.Builder outputMapBuilder = ImmutableMap.builder();
            this.expandedTransform.getOutputsMap().forEach((localId, pCollectionId) -> {
                try {
                    PCollection<?> col = rehydratedComponents.getPCollection((String)pCollectionId);
                    externalPCollectionIdMapBuilder.put(col, pCollectionId);
                    outputMapBuilder.put((Object)new TupleTag(localId), col);
                }
                catch (IOException e) {
                    throw new RuntimeException("cannot rehydrate PCollection.");
                }
            });
            this.externalPCollectionIdMap = externalPCollectionIdMapBuilder.build();
            HashMap externalCoderIdMapBuilder = new HashMap();
            this.expandedComponents.getPcollectionsMap().forEach((pcolId, pCol) -> {
                try {
                    String coderId = pCol.getCoderId();
                    if (this.isJavaSDKCompatible(this.expandedComponents, coderId)) {
                        Coder<?> coder = rehydratedComponents.getCoder(coderId);
                        externalCoderIdMapBuilder.putIfAbsent(coder, coderId);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("cannot rehydrate Coder.");
                }
            });
            this.externalCoderIdMap = ImmutableMap.copyOf(externalCoderIdMapBuilder);
            return this.toOutputCollection((Map<TupleTag<?>, PCollection>)outputMapBuilder.build());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, RunnerApi.Environment> resolveArtifacts(Map<String, RunnerApi.Environment> environments) {
            if (environments.size() == 0) {
                return environments;
            }
            ManagedChannel channel = ManagedChannelBuilder.forTarget((String)this.endpoint.getUrl()).usePlaintext().maxInboundMessageSize(Integer.MAX_VALUE).build();
            try {
                ArtifactRetrievalServiceGrpc.ArtifactRetrievalServiceBlockingStub retrievalStub = ArtifactRetrievalServiceGrpc.newBlockingStub((Channel)channel);
                Map<String, RunnerApi.Environment> map = environments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, kv -> {
                    try {
                        return this.resolveArtifacts(retrievalStub, (RunnerApi.Environment)kv.getValue());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }));
                return map;
            }
            finally {
                channel.shutdown();
            }
        }

        private RunnerApi.Environment resolveArtifacts(ArtifactRetrievalServiceGrpc.ArtifactRetrievalServiceBlockingStub retrievalStub, RunnerApi.Environment environment) throws IOException {
            return environment.toBuilder().clearDependencies().addAllDependencies(this.resolveArtifacts(retrievalStub, environment.getDependenciesList())).build();
        }

        private List<RunnerApi.ArtifactInformation> resolveArtifacts(ArtifactRetrievalServiceGrpc.ArtifactRetrievalServiceBlockingStub retrievalStub, List<RunnerApi.ArtifactInformation> artifacts) throws IOException {
            ArrayList<RunnerApi.ArtifactInformation> resolved = new ArrayList<RunnerApi.ArtifactInformation>();
            for (RunnerApi.ArtifactInformation artifact : retrievalStub.resolveArtifacts(ArtifactApi.ResolveArtifactsRequest.newBuilder().addAllArtifacts(artifacts).build()).getReplacementsList()) {
                Path path = Files.createTempFile("beam-artifact", "", new FileAttribute[0]);
                try (FileOutputStream fout = new FileOutputStream(path.toFile());){
                    Iterator it = retrievalStub.getArtifact(ArtifactApi.GetArtifactRequest.newBuilder().setArtifact(artifact).build());
                    while (it.hasNext()) {
                        ((ArtifactApi.GetArtifactResponse)it.next()).getData().writeTo((OutputStream)fout);
                    }
                }
                resolved.add(artifact.toBuilder().setTypeUrn("beam:artifact:type:file:v1").setTypePayload(RunnerApi.ArtifactFilePayload.newBuilder().setPath(path.toString()).build().toByteString()).build());
            }
            return resolved;
        }

        boolean isJavaSDKCompatible(RunnerApi.Components components, String coderId) {
            RunnerApi.Coder coder = components.getCodersOrThrow(coderId);
            if (!"beam:coders:javasdk:0.1".equals(coder.getSpec().getUrn()) && !CoderTranslation.KNOWN_CODER_URNS.containsValue((Object)coder.getSpec().getUrn())) {
                return false;
            }
            for (String componentId : coder.getComponentCoderIdsList()) {
                if (this.isJavaSDKCompatible(components, componentId)) continue;
                return false;
            }
            return true;
        }

        abstract OutputT toOutputCollection(Map<TupleTag<?>, PCollection> var1);

        String getNamespace() {
            return String.format("External_%s", this.namespaceIndex);
        }

        String getImpulsePrefix() {
            return External.IMPULSE_PREFIX;
        }

        RunnerApi.PTransform getExpandedTransform() {
            return this.expandedTransform;
        }

        RunnerApi.Components getExpandedComponents() {
            return this.expandedComponents;
        }

        List<String> getExpandedRequirements() {
            return this.expandedRequirements;
        }

        Map<PCollection, String> getExternalPCollectionIdMap() {
            return this.externalPCollectionIdMap;
        }

        Map<Coder<?>, String> getExternalCoderIdMap() {
            return this.externalCoderIdMap;
        }

        String getUrn() {
            return this.urn;
        }

        byte[] getPayload() {
            return this.payload;
        }

        Endpoints.ApiServiceDescriptor getEndpoint() {
            return this.endpoint;
        }

        ExpansionServiceClientFactory getClientFactory() {
            return this.clientFactory;
        }

        Integer getNamespaceIndex() {
            return this.namespaceIndex;
        }

        Map<String, Coder<?>> getOutputCoders() {
            return this.outputCoders;
        }
    }

    public static class MultiOutputExpandableTransform<InputT extends PInput>
    extends ExpandableTransform<InputT, PCollectionTuple> {
        MultiOutputExpandableTransform(String urn, byte[] payload, Endpoints.ApiServiceDescriptor endpoint, ExpansionServiceClientFactory clientFactory, Integer namespaceIndex, Map<String, Coder<?>> outputCoders) {
            super(urn, payload, endpoint, clientFactory, namespaceIndex, outputCoders);
        }

        @Override
        PCollectionTuple toOutputCollection(Map<TupleTag<?>, PCollection> output) {
            Preconditions.checkArgument((output.size() > 0 ? 1 : 0) != 0, (Object)"output shouldn't be empty.");
            PCollection firstElem = (PCollection)Iterables.getFirst(output.values(), null);
            PCollectionTuple pCollectionTuple = PCollectionTuple.empty((Pipeline)firstElem.getPipeline());
            for (Map.Entry<TupleTag<?>, PCollection> entry : output.entrySet()) {
                pCollectionTuple = pCollectionTuple.and(entry.getKey(), entry.getValue());
            }
            return pCollectionTuple;
        }

        public MultiOutputExpandableTransform<InputT> withOutputCoder(Map<String, Coder<?>> outputCoders) {
            return new MultiOutputExpandableTransform<InputT>(this.getUrn(), this.getPayload(), this.getEndpoint(), this.getClientFactory(), this.getNamespaceIndex(), outputCoders);
        }
    }

    public static class SingleOutputExpandableTransform<InputT extends PInput, OutputT>
    extends ExpandableTransform<InputT, PCollection<OutputT>> {
        SingleOutputExpandableTransform(String urn, byte[] payload, Endpoints.ApiServiceDescriptor endpoint, ExpansionServiceClientFactory clientFactory, Integer namespaceIndex, Map<String, Coder<?>> outputCoders) {
            super(urn, payload, endpoint, clientFactory, namespaceIndex, outputCoders);
        }

        @Override
        PCollection<OutputT> toOutputCollection(Map<TupleTag<?>, PCollection> output) {
            Preconditions.checkArgument((output.size() > 0 ? 1 : 0) != 0, (Object)"output shouldn't be empty.");
            return (PCollection)Iterables.getOnlyElement(output.values());
        }

        public MultiOutputExpandableTransform<InputT> withMultiOutputs() {
            return new MultiOutputExpandableTransform(this.getUrn(), this.getPayload(), this.getEndpoint(), this.getClientFactory(), this.getNamespaceIndex(), this.getOutputCoders());
        }

        public SingleOutputExpandableTransform<InputT, OutputT> withOutputCoder(Coder<?> outputCoder) {
            return new SingleOutputExpandableTransform<InputT, OutputT>(this.getUrn(), this.getPayload(), this.getEndpoint(), this.getClientFactory(), this.getNamespaceIndex(), (Map<String, Coder<?>>)ImmutableMap.of((Object)"0", outputCoder));
        }
    }
}

