/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class Reify {
    private Reify() {
    }

    public static <T> PTransform<PCollection<T>, PCollection<TimestampedValue<T>>> timestamps() {
        return new Timestamp();
    }

    public static <K, V> PTransform<PCollection<KV<K, V>>, PCollection<KV<K, TimestampedValue<V>>>> timestampsInValue() {
        return new TimestampInValue();
    }

    public static <T> PTransform<PCollection<T>, PCollection<ValueInSingleWindow<T>>> windows() {
        return new Window();
    }

    public static <K, V> PTransform<PCollection<KV<K, V>>, PCollection<KV<K, ValueInSingleWindow<V>>>> windowsInValue() {
        return new WindowInValue();
    }

    public static <K, V> PTransform<PCollection<KV<K, TimestampedValue<V>>>, PCollection<KV<K, V>>> extractTimestampsFromValues() {
        return new ExtractTimestampsFromValues();
    }

    public static <K, V> PTransform<PCollection<K>, PCollection<KV<K, V>>> viewAsValues(PCollectionView<V> view, Coder<V> coder) {
        return new ReifyView(view, coder);
    }

    public static <K, V> PTransform<PBegin, PCollection<V>> viewInGlobalWindow(PCollectionView<V> view, Coder<V> coder) {
        return new ReifyViewInGlobalWindow(view, coder);
    }

    private static class ExtractTimestampsFromValues<K, V>
    extends PTransform<PCollection<KV<K, TimestampedValue<V>>>, PCollection<KV<K, V>>> {
        private ExtractTimestampsFromValues() {
        }

        @Override
        public PCollection<KV<K, V>> expand(PCollection<KV<K, TimestampedValue<V>>> input) {
            KvCoder kvCoder = (KvCoder)input.getCoder();
            TimestampedValue.TimestampedValueCoder tvCoder = (TimestampedValue.TimestampedValueCoder)kvCoder.getValueCoder();
            return ((PCollection)input.apply(ParDo.of(new DoFn<KV<K, TimestampedValue<V>>, KV<K, V>>(){

                @Override
                public Duration getAllowedTimestampSkew() {
                    return Duration.millis((long)Long.MAX_VALUE);
                }

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element KV<K, TimestampedValue<V>> kv, DoFn.OutputReceiver<KV<K, V>> r) {
                    r.outputWithTimestamp(KV.of(kv.getKey(), kv.getValue().getValue()), kv.getValue().getTimestamp());
                }
            }))).setCoder(KvCoder.of(kvCoder.getKeyCoder(), tvCoder.getValueCoder()));
        }
    }

    private static class TimestampInValue<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, TimestampedValue<V>>>> {
        private TimestampInValue() {
        }

        @Override
        public PCollection<KV<K, TimestampedValue<V>>> expand(PCollection<KV<K, V>> input) {
            KvCoder coder = (KvCoder)input.getCoder();
            return ((PCollection)input.apply(ParDo.of(new DoFn<KV<K, V>, KV<K, TimestampedValue<V>>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element KV<K, V> element, @DoFn.Timestamp Instant timestamp, DoFn.OutputReceiver<KV<K, TimestampedValue<V>>> r) {
                    r.output(KV.of(element.getKey(), TimestampedValue.of(element.getValue(), timestamp)));
                }
            }))).setCoder(KvCoder.of(coder.getKeyCoder(), TimestampedValue.TimestampedValueCoder.of(coder.getValueCoder())));
        }
    }

    private static class WindowInValue<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, ValueInSingleWindow<V>>>> {
        private WindowInValue() {
        }

        @Override
        public PCollection<KV<K, ValueInSingleWindow<V>>> expand(PCollection<KV<K, V>> input) {
            KvCoder coder = (KvCoder)input.getCoder();
            return ((PCollection)input.apply(ParDo.of(new DoFn<KV<K, V>, KV<K, ValueInSingleWindow<V>>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element KV<K, V> element, @DoFn.Timestamp Instant timestamp, BoundedWindow window, PaneInfo pane, DoFn.OutputReceiver<KV<K, ValueInSingleWindow<V>>> r) {
                    r.output(KV.of(element.getKey(), ValueInSingleWindow.of(element.getValue(), timestamp, window, pane)));
                }
            }))).setCoder(KvCoder.of(coder.getKeyCoder(), ValueInSingleWindow.Coder.of(coder.getValueCoder(), input.getWindowingStrategy().getWindowFn().windowCoder())));
        }
    }

    private static class Timestamp<T>
    extends PTransform<PCollection<T>, PCollection<TimestampedValue<T>>> {
        private Timestamp() {
        }

        @Override
        public PCollection<TimestampedValue<T>> expand(PCollection<T> input) {
            return ((PCollection)input.apply(ParDo.of(new DoFn<T, TimestampedValue<T>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element T element, @DoFn.Timestamp Instant timestamp, DoFn.OutputReceiver<TimestampedValue<T>> r) {
                    r.output(TimestampedValue.of(element, timestamp));
                }
            }))).setCoder(TimestampedValue.TimestampedValueCoder.of(input.getCoder()));
        }
    }

    private static class Window<T>
    extends PTransform<PCollection<T>, PCollection<ValueInSingleWindow<T>>> {
        private Window() {
        }

        @Override
        public PCollection<ValueInSingleWindow<T>> expand(PCollection<T> input) {
            return ((PCollection)input.apply(ParDo.of(new DoFn<T, ValueInSingleWindow<T>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element T element, @DoFn.Timestamp Instant timestamp, BoundedWindow window, PaneInfo pane, DoFn.OutputReceiver<ValueInSingleWindow<T>> r) {
                    r.outputWithTimestamp(ValueInSingleWindow.of(element, timestamp, window, pane), timestamp);
                }
            }))).setCoder(ValueInSingleWindow.Coder.of(input.getCoder(), input.getWindowingStrategy().getWindowFn().windowCoder()));
        }
    }

    private static class ReifyViewInGlobalWindow<V>
    extends PTransform<PBegin, PCollection<V>> {
        private final PCollectionView<V> view;
        private final Coder<V> coder;

        private ReifyViewInGlobalWindow(PCollectionView<V> view, Coder<V> coder) {
            this.view = view;
            this.coder = coder;
        }

        @Override
        public PCollection<V> expand(PBegin input) {
            return (PCollection)((PCollection)input.apply(Create.of(null, new Void[0]).withCoder(VoidCoder.of()))).apply(Reify.viewAsValues(this.view, this.coder)).apply(Values.create());
        }
    }

    private static class ReifyView<K, V>
    extends PTransform<PCollection<K>, PCollection<KV<K, V>>> {
        private final PCollectionView<V> view;
        private final Coder<V> coder;

        private ReifyView(PCollectionView<V> view, Coder<V> coder) {
            this.view = view;
            this.coder = coder;
        }

        @Override
        public PCollection<KV<K, V>> expand(PCollection<K> input) {
            return ((PCollection)input.apply(ParDo.of(new DoFn<K, KV<K, V>>(){

                @DoFn.ProcessElement
                public void process(DoFn.ProcessContext c) {
                    c.output(KV.of(c.element(), c.sideInput(view)));
                }
            }).withSideInputs(this.view))).setCoder(KvCoder.of(input.getCoder(), this.coder));
        }
    }
}

