/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.Timer;
import org.apache.beam.sdk.state.TimerSpec;
import org.apache.beam.sdk.state.TimerSpecs;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Keys;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

public final class Deduplicate {
    public static final TimeDomain DEFAULT_TIME_DOMAIN = TimeDomain.PROCESSING_TIME;
    public static final Duration DEFAULT_DURATION = Duration.standardMinutes((long)10L);

    public static <T> Values<T> values() {
        return new Values(DEFAULT_TIME_DOMAIN, DEFAULT_DURATION);
    }

    public static <K, V> KeyedValues<K, V> keyedValues() {
        return new KeyedValues(DEFAULT_TIME_DOMAIN, DEFAULT_DURATION);
    }

    public static <T, IdT> WithRepresentativeValues<T, IdT> withRepresentativeValueFn(SerializableFunction<T, IdT> representativeValueFn) {
        return new WithRepresentativeValues(DEFAULT_TIME_DOMAIN, DEFAULT_DURATION, representativeValueFn, null, null);
    }

    private Deduplicate() {
    }

    private static class DeduplicateFn<K, V>
    extends DoFn<KV<K, V>, KV<K, V>> {
        private static final String EXPIRY_TIMER = "expiryTimer";
        private static final String SEEN_STATE = "seen";
        @DoFn.TimerId(value="expiryTimer")
        private final TimerSpec expiryTimerSpec;
        @DoFn.StateId(value="seen")
        private final StateSpec<ValueState<Boolean>> seenState = StateSpecs.value(BooleanCoder.of());
        private final Duration duration;

        private DeduplicateFn(TimeDomain timeDomain, Duration duration) {
            this.expiryTimerSpec = TimerSpecs.timer(timeDomain);
            this.duration = duration;
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element KV<K, V> element, BoundedWindow window, DoFn.OutputReceiver<KV<K, V>> receiver, @DoFn.StateId(value="seen") ValueState<Boolean> seenState, @DoFn.TimerId(value="expiryTimer") Timer expiryTimer) {
            Boolean seen = (Boolean)seenState.read();
            if (seen == null) {
                expiryTimer.offset(this.duration).withOutputTimestamp(window.maxTimestamp()).setRelative();
                seenState.write(true);
                receiver.output(element);
            }
        }

        @DoFn.OnTimer(value="expiryTimer")
        public void onExpiry(DoFn.OnTimerContext context, @DoFn.StateId(value="seen") ValueState<Boolean> seenState) {
            seenState.clear();
        }
    }

    public static final class KeyedValues<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, V>>> {
        private final TimeDomain timeDomain;
        private final Duration duration;

        private KeyedValues(TimeDomain timeDomain, Duration duration) {
            this.timeDomain = timeDomain;
            this.duration = duration;
        }

        @Override
        public PCollection<KV<K, V>> expand(PCollection<KV<K, V>> input) {
            return (PCollection)input.apply(ParDo.of(new DeduplicateFn(this.timeDomain, this.duration)));
        }

        public KeyedValues<K, V> withTimeDomain(TimeDomain timeDomain) {
            return new KeyedValues<K, V>(timeDomain, this.duration);
        }

        public KeyedValues<K, V> withDuration(Duration duration) {
            return new KeyedValues<K, V>(this.timeDomain, duration);
        }
    }

    public static final class WithRepresentativeValues<T, IdT>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private final SerializableFunction<T, IdT> fn;
        private final @Nullable TypeDescriptor<IdT> type;
        private final @Nullable Coder<IdT> coder;
        private final TimeDomain timeDomain;
        private final Duration duration;

        private WithRepresentativeValues(TimeDomain timeDomain, Duration duration, SerializableFunction<T, IdT> fn, @Nullable TypeDescriptor<IdT> type, @Nullable Coder<IdT> coder) {
            this.timeDomain = timeDomain;
            this.duration = duration;
            this.fn = fn;
            this.type = type;
            this.coder = coder;
        }

        public WithRepresentativeValues<T, IdT> withRepresentativeType(TypeDescriptor<IdT> type) {
            return new WithRepresentativeValues<T, IdT>(this.timeDomain, this.duration, this.fn, type, null);
        }

        public WithRepresentativeValues<T, IdT> withRepresentativeCoder(Coder<IdT> coder) {
            return new WithRepresentativeValues<T, IdT>(this.timeDomain, this.duration, this.fn, null, coder);
        }

        public WithRepresentativeValues<T, IdT> withTimeDomain(TimeDomain timeDomain) {
            return new WithRepresentativeValues<T, IdT>(timeDomain, this.duration, this.fn, this.type, this.coder);
        }

        public WithRepresentativeValues<T, IdT> withDuration(Duration duration) {
            return new WithRepresentativeValues<T, IdT>(this.timeDomain, duration, this.fn, this.type, this.coder);
        }

        @Override
        public PCollection<T> expand(PCollection<T> input) {
            WithKeys withKeys = WithKeys.of(this.fn);
            if (this.type != null) {
                withKeys = withKeys.withKeyType(this.type);
            }
            PCollection inputWithKey = (PCollection)input.apply(withKeys);
            if (this.coder != null) {
                inputWithKey.setCoder(KvCoder.of(this.coder, input.getCoder()));
            }
            return (PCollection)((PCollection)inputWithKey.apply(new KeyedValues(this.timeDomain, this.duration))).apply(org.apache.beam.sdk.transforms.Values.create());
        }
    }

    public static final class Values<T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private final TimeDomain timeDomain;
        private final Duration duration;

        private Values(TimeDomain timeDomain, Duration duration) {
            this.timeDomain = timeDomain;
            this.duration = duration;
        }

        @Override
        public PCollection<T> expand(PCollection<T> input) {
            return (PCollection)((PCollection)((PCollection)input.apply("KeyByElement", MapElements.via(new SimpleFunction<T, KV<T, Void>>(){

                @Override
                public KV<T, Void> apply(T element) {
                    return KV.of(element, null);
                }
            }))).apply(new KeyedValues(this.timeDomain, this.duration))).apply(Keys.create());
        }

        public Values<T> withTimeDomain(TimeDomain timeDomain) {
            return new Values<T>(timeDomain, this.duration);
        }

        public Values<T> withDuration(Duration duration) {
            return new Values<T>(this.timeDomain, duration);
        }
    }
}

