/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.io.opencensus.common.Scope;
import com.google.bigtable.repackaged.io.opencensus.trace.AttributeValue;
import com.google.bigtable.repackaged.io.opencensus.trace.Span;
import com.google.bigtable.repackaged.io.opencensus.trace.Status;
import com.google.bigtable.repackaged.io.opencensus.trace.Tracer;
import com.google.bigtable.repackaged.io.opencensus.trace.Tracing;
import com.google.cloud.bigtable.hbase.BatchExecutor;
import com.google.cloud.bigtable.hbase.adapters.Adapters;
import com.google.cloud.bigtable.hbase.adapters.CheckAndMutateUtil;
import com.google.cloud.bigtable.hbase.adapters.HBaseRequestAdapter;
import com.google.cloud.bigtable.hbase.util.FutureUtil;
import com.google.cloud.bigtable.hbase.util.Logger;
import com.google.cloud.bigtable.hbase.wrappers.BigtableApi;
import com.google.cloud.bigtable.hbase.wrappers.BigtableHBaseSettings;
import com.google.cloud.bigtable.hbase.wrappers.DataClientWrapper;
import com.google.cloud.bigtable.metrics.BigtableClientMetrics;
import com.google.cloud.bigtable.metrics.Timer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractBigtableConnection;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Descriptors;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Service;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ServiceException;
import org.apache.hadoop.hbase.util.Bytes;

@InternalApi(value="For internal usage only")
public abstract class AbstractBigtableTable
implements Table {
    protected static final Logger LOG = new Logger(AbstractBigtableTable.class);
    private static final Tracer TRACER = Tracing.getTracer();
    protected final TableName tableName;
    protected final BigtableHBaseSettings settings;
    protected final HBaseRequestAdapter hbaseAdapter;
    protected final DataClientWrapper clientWrapper;
    protected final AbstractBigtableConnection bigtableConnection;
    private TableMetrics metrics = new TableMetrics();

    private static void addBatchSizeAnnotation(Collection<?> c) {
        TRACER.getCurrentSpan().addAnnotation("batchSize", ImmutableMap.of("size", AttributeValue.longAttributeValue(c.size())));
    }

    public AbstractBigtableTable(AbstractBigtableConnection bigtableConnection, HBaseRequestAdapter hbaseAdapter) {
        this.bigtableConnection = bigtableConnection;
        this.settings = bigtableConnection.getBigtableSettings();
        BigtableApi bigtableApi = bigtableConnection.getBigtableApi();
        this.clientWrapper = bigtableApi.getDataClient();
        this.hbaseAdapter = hbaseAdapter;
        this.tableName = hbaseAdapter.getTableName();
    }

    public TableName getName() {
        return this.tableName;
    }

    public final Configuration getConfiguration() {
        return this.settings.getConfiguration();
    }

    /*
     * Exception decompiling
     */
    public HTableDescriptor getTableDescriptor() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean exists(Get get) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean[] existsAll(List<Get> gets) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
        LOG.trace("batch(List<>, Object[])", new Object[0]);
        try (Scope scope = TRACER.spanBuilder("BigtableTable.batch").startScopedSpan();){
            AbstractBigtableTable.addBatchSizeAnnotation(actions);
            try (BatchExecutor executor = this.createBatchExecutor();){
                executor.batch(actions, results);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Deprecated
    public Object[] batch(List<? extends Row> actions) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        LOG.trace("batchCallback(List<>, Object[], Batch.Callback)", new Object[0]);
        try (Scope scope = TRACER.spanBuilder("BigtableTable.batchCallback").startScopedSpan();){
            AbstractBigtableTable.addBatchSizeAnnotation(actions);
            try (BatchExecutor executor = this.createBatchExecutor();){
                executor.batchCallback(actions, results, callback);
            }
        }
    }

    @Deprecated
    public <R> Object[] batchCallback(List<? extends Row> actions, Batch.Callback<R> callback) throws IOException, InterruptedException {
        LOG.trace("batchCallback(List<>, Batch.Callback)", new Object[0]);
        try (Scope scope = TRACER.spanBuilder("BigtableTable.batchCallback").startScopedSpan();){
            AbstractBigtableTable.addBatchSizeAnnotation(actions);
            Object[] results = new Object[actions.size()];
            try (BatchExecutor executor = this.createBatchExecutor();){
                executor.batchCallback(actions, results, callback);
            }
            Object[] objectArray = results;
            return objectArray;
        }
    }

    /*
     * Exception decompiling
     */
    public Result[] get(List<Get> gets) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private RetriesExhaustedWithDetailsException createRetriesExhaustedWithDetailsException(Throwable e, Row action) {
        return new RetriesExhaustedWithDetailsException(Arrays.asList(e), Arrays.asList(action), Arrays.asList(this.settings.getDataHost()));
    }

    /*
     * Exception decompiling
     */
    public Result get(Get get) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultScanner getScanner(Scan scan) throws IOException {
        LOG.trace("getScanner(Scan)", new Object[0]);
        Span span = TRACER.spanBuilder("BigtableTable.scan").startSpan();
        try (Scope scope = TRACER.withSpan(span);){
            ResultScanner scanner = this.clientWrapper.readRows(this.hbaseAdapter.adapt(scan));
            if (AbstractBigtableTable.hasWhileMatchFilter(scan.getFilter())) {
                ResultScanner resultScanner = Adapters.BIGTABLE_WHILE_MATCH_RESULT_RESULT_SCAN_ADAPTER.adapt(scanner, span);
                return resultScanner;
            }
            ResultScanner resultScanner = scanner;
            return resultScanner;
        }
        catch (Throwable throwable) {
            LOG.error("Encountered exception when executing getScanner.", throwable, new Object[0]);
            span.setStatus(Status.UNKNOWN);
            span.end();
            throw new IOException(AbstractBigtableTable.makeGenericExceptionMessage("getScanner", this.settings.getProjectId(), this.tableName.getQualifierAsString()), throwable);
        }
    }

    public static boolean hasWhileMatchFilter(Filter filter) {
        if (filter instanceof WhileMatchFilter) {
            return true;
        }
        if (filter instanceof FilterList) {
            FilterList list = (FilterList)filter;
            for (Filter subFilter : list.getFilters()) {
                if (!AbstractBigtableTable.hasWhileMatchFilter(subFilter)) continue;
                return true;
            }
        }
        return false;
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        LOG.trace("getScanner(byte[])", new Object[0]);
        return this.getScanner(new Scan().addFamily(family));
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        LOG.trace("getScanner(byte[], byte[])", new Object[0]);
        return this.getScanner(new Scan().addColumn(family, qualifier));
    }

    public void put(Put put) throws IOException {
        LOG.trace("put(Put)", new Object[0]);
        RowMutation rowMutation = this.hbaseAdapter.adapt(put);
        this.mutateRow((Mutation)put, rowMutation, "put");
    }

    public void put(List<Put> puts) throws IOException {
        LOG.trace("put(List<Put>)", new Object[0]);
        Preconditions.checkNotNull(puts);
        if (puts.isEmpty()) {
            return;
        }
        if (puts.size() == 1) {
            try {
                this.put(puts.get(0));
            }
            catch (IOException e) {
                throw this.createRetriesExhaustedWithDetailsException(e, (Row)puts.get(0));
            }
        }
        try (BatchExecutor executor = this.createBatchExecutor();){
            executor.batch(puts);
        }
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        return this.checkAndPut(row, family, qualifier, CompareFilter.CompareOp.EQUAL, value, put);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Put put) throws IOException {
        LOG.trace("checkAndPut(byte[], byte[], byte[], CompareOp, value, Put)", new Object[0]);
        ConditionalRowMutation request = new CheckAndMutateUtil.RequestBuilder(this.hbaseAdapter, row, family).qualifier(qualifier).ifMatches(compareOp, value).withPut(put).build();
        return this.checkAndMutate(row, request, "checkAndPut");
    }

    public void delete(Delete delete) throws IOException {
        LOG.trace("delete(Delete)", new Object[0]);
        RowMutation rowMutation = this.hbaseAdapter.adapt(delete);
        this.mutateRow((Mutation)delete, rowMutation, "delete");
    }

    public void delete(List<Delete> deletes) throws IOException {
        LOG.trace("delete(List<Delete>)", new Object[0]);
        try (Scope scope = TRACER.spanBuilder("BigtableTable.delete").startScopedSpan();
             BatchExecutor executor = this.createBatchExecutor();){
            executor.batch(deletes, true);
        }
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        return this.checkAndDelete(row, family, qualifier, CompareFilter.CompareOp.EQUAL, value, delete);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Delete delete) throws IOException {
        LOG.trace("checkAndDelete(byte[], byte[], byte[], CompareOp, byte[], Delete)", new Object[0]);
        ConditionalRowMutation request = new CheckAndMutateUtil.RequestBuilder(this.hbaseAdapter, row, family).qualifier(qualifier).ifMatches(compareOp, value).withDelete(delete).build();
        return this.checkAndMutate(row, request, "checkAndDelete");
    }

    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations rm) throws IOException {
        LOG.trace("checkAndMutate(byte[], byte[], byte[], CompareOp, byte[], RowMutations)", new Object[0]);
        ConditionalRowMutation request = new CheckAndMutateUtil.RequestBuilder(this.hbaseAdapter, row, family).qualifier(qualifier).ifMatches(compareOp, value).withMutations(rm).build();
        return this.checkAndMutate(row, request, "checkAndMutate");
    }

    /*
     * Exception decompiling
     */
    private boolean checkAndMutate(byte[] row, ConditionalRowMutation request, String type) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void mutateRow(Mutation mutation, RowMutation rowMutation, String type) throws IOException {
        Span span = TRACER.spanBuilder("BigtableTable." + type).startSpan();
        try (Scope scope = TRACER.withSpan(span);){
            FutureUtil.unwrap(this.clientWrapper.mutateRowAsync(rowMutation));
        }
        catch (Throwable t) {
            span.setStatus(Status.UNKNOWN);
            throw this.logAndCreateIOException(type, mutation.getRow(), t);
        }
        finally {
            span.end();
        }
    }

    public void mutateRow(RowMutations rowMutations) throws IOException {
        LOG.trace("mutateRow(RowMutation)", new Object[0]);
        if (rowMutations.getMutations().isEmpty()) {
            return;
        }
        Span span = TRACER.spanBuilder("BigtableTable.mutateRow").startSpan();
        try (Scope scope = TRACER.withSpan(span);){
            FutureUtil.unwrap(this.clientWrapper.mutateRowAsync(this.hbaseAdapter.adapt(rowMutations)));
        }
        catch (Throwable t) {
            span.setStatus(Status.UNKNOWN);
            throw this.logAndCreateIOException("mutateRow", rowMutations.getRow(), t);
        }
        finally {
            span.end();
        }
    }

    /*
     * Exception decompiling
     */
    public Result append(Append append) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Result increment(Increment increment) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IOException logAndCreateIOException(String type, byte[] row, Throwable t) {
        LOG.error("Encountered exception when executing " + type + ".", t, new Object[0]);
        return new DoNotRetryIOException(AbstractBigtableTable.makeGenericExceptionMessage(type, this.settings.getProjectId(), this.tableName.getQualifierAsString(), row), t);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        LOG.trace("incrementColumnValue(byte[], byte[], byte[], long)", new Object[0]);
        try (Scope scope = TRACER.spanBuilder("BigtableTable.incrementColumnValue").startScopedSpan();){
            Increment incr = new Increment(row);
            incr.addColumn(family, qualifier, amount);
            Result result = this.increment(incr);
            Cell cell = result.getColumnLatestCell(family, qualifier);
            if (cell == null) {
                LOG.error("Failed to find a incremented value in result of increment", new Object[0]);
                throw new IOException(AbstractBigtableTable.makeGenericExceptionMessage("increment", this.settings.getProjectId(), this.tableName.getQualifierAsString(), row));
            }
            long l = Bytes.toLong((byte[])CellUtil.cloneValue((Cell)cell));
            return l;
        }
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        LOG.trace("incrementColumnValue(byte[], byte[], byte[], long, Durability)", new Object[0]);
        return this.incrementColumnValue(row, family, qualifier, amount);
    }

    public void close() throws IOException {
    }

    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        LOG.error("Unsupported coprocessorService(byte[]) called.", new Object[0]);
        throw new UnsupportedOperationException();
    }

    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        LOG.error("Unsupported coprocessorService(Class, byte[], byte[], Batch.Call) called.", new Object[0]);
        throw new UnsupportedOperationException();
    }

    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        LOG.error("Unsupported coprocessorService(Class, byte[], byte[], Batch.Call, Batch.Callback) called.", new Object[0]);
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public long getWriteBufferSize() {
        LOG.error("Unsupported getWriteBufferSize() called", new Object[0]);
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setWriteBufferSize(long writeBufferSize) throws IOException {
        LOG.error("Unsupported getWriteBufferSize() called", new Object[0]);
        throw new UnsupportedOperationException();
    }

    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message message, byte[] bytes, byte[] bytes2, R r) throws ServiceException, Throwable {
        LOG.error("Unsupported batchCoprocessorService(MethodDescriptor, Message, byte[], byte[], R) called.", new Object[0]);
        throw new UnsupportedOperationException();
    }

    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message message, byte[] bytes, byte[] bytes2, R r, Batch.Callback<R> rCallback) throws ServiceException, Throwable {
        LOG.error("Unsupported batchCoprocessorService(MethodDescriptor, Message, byte[], byte[], R, Batch.Callback<R>) called.", new Object[0]);
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return MoreObjects.toStringHelper(AbstractBigtableTable.class).add("hashCode", "0x" + Integer.toHexString(this.hashCode())).add("project", this.settings.getProjectId()).add("instance", this.settings.getInstanceId()).add("table", this.tableName.getNameAsString()).add("host", this.settings.getDataHost()).toString();
    }

    static String makeGenericExceptionMessage(String operation, String projectId, String tableName) {
        return String.format("Failed to perform operation. Operation='%s', projectId='%s', tableName='%s'", operation, projectId, tableName);
    }

    static String makeGenericExceptionMessage(String operation, String projectId, String tableName, byte[] rowKey) {
        return String.format("Failed to perform operation. Operation='%s', projectId='%s', tableName='%s', rowKey='%s'", operation, projectId, tableName, Bytes.toStringBinary((byte[])rowKey));
    }

    protected BatchExecutor createBatchExecutor() {
        return new BatchExecutor(this.bigtableConnection.getBigtableApi(), this.settings, this.hbaseAdapter);
    }

    public void setOperationTimeout(int i) {
        throw new UnsupportedOperationException("setOperationTimeout");
    }

    public int getOperationTimeout() {
        throw new UnsupportedOperationException("getOperationTimeout");
    }

    public void setRpcTimeout(int i) {
        throw new UnsupportedOperationException("setRpcTimeout");
    }

    public int getReadRpcTimeout() {
        throw new UnsupportedOperationException("getReadRpcTimeout");
    }

    public void setReadRpcTimeout(int i) {
        throw new UnsupportedOperationException("setReadRpcTimeout");
    }

    public int getWriteRpcTimeout() {
        throw new UnsupportedOperationException("getWriteRpcTimeout");
    }

    public void setWriteRpcTimeout(int i) {
        throw new UnsupportedOperationException("setWriteRpcTimeout");
    }

    public int getRpcTimeout() {
        throw new UnsupportedOperationException("getRpcTimeout");
    }

    private static class TableMetrics {
        Timer putTimer = BigtableClientMetrics.timer(BigtableClientMetrics.MetricLevel.Info, "table.put.latency");
        Timer getTimer = BigtableClientMetrics.timer(BigtableClientMetrics.MetricLevel.Info, "table.get.latency");

        private TableMetrics() {
        }
    }
}

