/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.xds.internal.sds;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.xds.Bootstrapper;
import com.google.bigtable.repackaged.io.grpc.xds.EnvoyServerProtoData;
import com.google.bigtable.repackaged.io.grpc.xds.internal.certprovider.CertProviderServerSslContextProvider;
import com.google.bigtable.repackaged.io.grpc.xds.internal.sds.CommonTlsContextUtil;
import com.google.bigtable.repackaged.io.grpc.xds.internal.sds.ReferenceCountingMap;
import com.google.bigtable.repackaged.io.grpc.xds.internal.sds.SslContextProvider;

final class ServerSslContextProviderFactory
implements ReferenceCountingMap.ValueFactory<EnvoyServerProtoData.DownstreamTlsContext, SslContextProvider> {
    private Bootstrapper.BootstrapInfo bootstrapInfo;
    private final CertProviderServerSslContextProvider.Factory certProviderServerSslContextProviderFactory;

    ServerSslContextProviderFactory(Bootstrapper.BootstrapInfo bootstrapInfo) {
        this(bootstrapInfo, CertProviderServerSslContextProvider.Factory.getInstance());
    }

    ServerSslContextProviderFactory(Bootstrapper.BootstrapInfo bootstrapInfo, CertProviderServerSslContextProvider.Factory factory) {
        this.bootstrapInfo = bootstrapInfo;
        this.certProviderServerSslContextProviderFactory = factory;
    }

    @Override
    public SslContextProvider create(EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext) {
        Preconditions.checkNotNull(downstreamTlsContext, "downstreamTlsContext");
        Preconditions.checkNotNull(downstreamTlsContext.getCommonTlsContext(), "downstreamTlsContext should have CommonTlsContext");
        if (CommonTlsContextUtil.hasCertProviderInstance(downstreamTlsContext.getCommonTlsContext())) {
            return this.certProviderServerSslContextProviderFactory.getProvider(downstreamTlsContext, this.bootstrapInfo.node().toEnvoyProtoNode(), this.bootstrapInfo.certProviders());
        }
        throw new UnsupportedOperationException("Unsupported configurations in DownstreamTlsContext!");
    }
}

