/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.xds.internal.certprovider;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Internal;
import com.google.bigtable.repackaged.io.grpc.netty.GrpcSslContexts;
import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import com.google.bigtable.repackaged.io.grpc.xds.Bootstrapper;
import com.google.bigtable.repackaged.io.grpc.xds.EnvoyServerProtoData;
import com.google.bigtable.repackaged.io.grpc.xds.internal.certprovider.CertProviderSslContextProvider;
import com.google.bigtable.repackaged.io.grpc.xds.internal.certprovider.CertificateProviderStore;
import com.google.bigtable.repackaged.io.grpc.xds.internal.sds.trust.SdsTrustManagerFactory;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Node;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import java.io.IOException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.annotation.Nullable;

@Internal
public final class CertProviderServerSslContextProvider
extends CertProviderSslContextProvider {
    private CertProviderServerSslContextProvider(Node node, @Nullable Map<String, Bootstrapper.CertificateProviderInfo> certProviders, CommonTlsContext.CertificateProviderInstance certInstance, CommonTlsContext.CertificateProviderInstance rootCertInstance, CertificateValidationContext staticCertValidationContext, EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext, CertificateProviderStore certificateProviderStore) {
        super(node, certProviders, Preconditions.checkNotNull(certInstance, "Server SSL requires certInstance"), rootCertInstance, staticCertValidationContext, downstreamTlsContext, certificateProviderStore);
    }

    @Override
    protected final SslContextBuilder getSslContextBuilder(CertificateValidationContext certificateValidationContextdationContext) throws CertStoreException, CertificateException, IOException {
        SslContextBuilder sslContextBuilder = SslContextBuilder.forServer(this.savedKey, this.savedCertChain);
        this.setClientAuthValues(sslContextBuilder, this.isMtls() ? new SdsTrustManagerFactory(this.savedTrustedRoots.toArray(new X509Certificate[0]), certificateValidationContextdationContext) : null);
        sslContextBuilder = GrpcSslContexts.configure(sslContextBuilder);
        return sslContextBuilder;
    }

    @Internal
    public static final class Factory {
        private static final Factory DEFAULT_INSTANCE = new Factory(CertificateProviderStore.getInstance());
        private final CertificateProviderStore certificateProviderStore;

        @VisibleForTesting
        public Factory(CertificateProviderStore certificateProviderStore) {
            this.certificateProviderStore = certificateProviderStore;
        }

        public static Factory getInstance() {
            return DEFAULT_INSTANCE;
        }

        public CertProviderServerSslContextProvider getProvider(EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext, Node node, @Nullable Map<String, Bootstrapper.CertificateProviderInfo> certProviders) {
            Preconditions.checkNotNull(downstreamTlsContext, "downstreamTlsContext");
            CommonTlsContext commonTlsContext = downstreamTlsContext.getCommonTlsContext();
            CertificateValidationContext staticCertValidationContext = CertProviderSslContextProvider.getStaticValidationContext(commonTlsContext);
            CommonTlsContext.CertificateProviderInstance rootCertInstance = CertProviderSslContextProvider.getRootCertProviderInstance(commonTlsContext);
            CommonTlsContext.CertificateProviderInstance certInstance = CertProviderSslContextProvider.getCertProviderInstance(commonTlsContext);
            return new CertProviderServerSslContextProvider(node, certProviders, certInstance, rootCertInstance, staticCertValidationContext, downstreamTlsContext, this.certificateProviderStore);
        }
    }
}

