/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutureCallback;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutures;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcResponseMetadata;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracer;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.RpcViews;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.Util;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import javax.annotation.Nonnull;

@InternalApi
public class HeaderTracerUnaryCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final UnaryCallable<RequestT, ResponseT> innerCallable;

    public HeaderTracerUnaryCallable(@Nonnull UnaryCallable<RequestT, ResponseT> innerCallable) {
        this.innerCallable = Preconditions.checkNotNull(innerCallable, "Inner callable must be set");
    }

    @Override
    public ApiFuture futureCall(RequestT request, ApiCallContext context) {
        if (RpcViews.isGfeMetricsRegistered() && context.getTracer() instanceof BigtableTracer) {
            GrpcResponseMetadata responseMetadata = new GrpcResponseMetadata();
            GrpcCallContext contextWithResponseMetadata = responseMetadata.addHandlers(context);
            HeaderTracerUnaryCallback callback = new HeaderTracerUnaryCallback((BigtableTracer)context.getTracer(), responseMetadata);
            ApiFuture<ResponseT> future = this.innerCallable.futureCall(request, contextWithResponseMetadata);
            ApiFutures.addCallback(future, callback, MoreExecutors.directExecutor());
            return future;
        }
        return this.innerCallable.futureCall(request, context);
    }

    class HeaderTracerUnaryCallback<ResponseT>
    implements ApiFutureCallback<ResponseT> {
        private final BigtableTracer tracer;
        private final GrpcResponseMetadata responseMetadata;

        HeaderTracerUnaryCallback(BigtableTracer tracer, GrpcResponseMetadata responseMetadata) {
            this.tracer = tracer;
            this.responseMetadata = responseMetadata;
        }

        @Override
        public void onFailure(Throwable throwable) {
            Metadata metadata = this.responseMetadata.getMetadata();
            Long latency = Util.getGfeLatency(metadata);
            this.tracer.recordGfeMetadata(latency, throwable);
        }

        @Override
        public void onSuccess(ResponseT response) {
            Metadata metadata = this.responseMetadata.getMetadata();
            Long latency = Util.getGfeLatency(metadata);
            this.tracer.recordGfeMetadata(latency, null);
        }
    }
}

