/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.monetdbbulkloader;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.databases.monetdb.MonetDBDatabaseMeta;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.monetdbbulkloader.MonetDbBulkLoader;
import org.apache.hop.pipeline.transforms.monetdbbulkloader.MonetDbBulkLoaderData;
import org.apache.hop.pipeline.transforms.monetdbbulkloader.MonetDbVersion;
import org.w3c.dom.Node;

@Transform(id="MonetDBBulkLoader", image="monetdbbulkloader.svg", name="i18n::MonetDBBulkLoaderDialog.TypeLongDesc.MonetDBBulkLoader", description="i18n::MonetDBBulkLoaderDialog.TypeTooltipDesc.MonetDBBulkLoader", documentationUrl="/pipeline/transforms/monetdbbulkloader.html", keywords={"i18n::MonetDbBulkLoaderMeta.keyword"}, categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output")
@InjectionSupported(localizationPrefix="MonetDBBulkLoaderDialog.Injection.")
public class MonetDbBulkLoaderMeta
extends BaseTransformMeta<MonetDbBulkLoader, MonetDbBulkLoaderData> {
    private static final Class<?> PKG = MonetDbBulkLoaderMeta.class;
    @Injection(name="CONNECTIONNAME")
    private String dbConnectionName;
    @Injection(name="SCHEMANAME")
    private String schemaName;
    @Injection(name="TABLENAME")
    private String tableName;
    @Injection(name="LOGFILE")
    private String logFile;
    private DatabaseMeta databaseMeta;
    @Injection(name="TARGETFIELDS")
    private String[] fieldTable;
    @Injection(name="SOURCEFIELDS")
    private String[] fieldStream;
    @Injection(name="FIELDFORMATOK")
    private boolean[] fieldFormatOk;
    @Injection(name="SEPARATOR")
    private String fieldSeparator;
    @Injection(name="FIELDENCLOSURE")
    private String fieldEnclosure;
    @Injection(name="NULLVALUE")
    private String nullRepresentation;
    @Injection(name="ENCODING")
    private String encoding;
    @Injection(name="TRUNCATE")
    private boolean truncate = false;
    @Injection(name="QUOTEFIELDS")
    private boolean fullyQuoteSQL;
    private boolean autoSchema = false;
    private boolean autoStringWidths = false;
    private String bufferSize;
    private boolean compatibilityDbVersionMode = false;

    public boolean isAutoStringWidths() {
        return this.autoStringWidths;
    }

    public boolean isTruncate() {
        return this.truncate;
    }

    public void setTruncate(boolean truncate) {
        this.truncate = truncate;
    }

    public boolean isFullyQuoteSQL() {
        return this.fullyQuoteSQL;
    }

    public void setFullyQuoteSQL(boolean fullyQuoteSQLbool) {
        this.fullyQuoteSQL = fullyQuoteSQLbool;
    }

    public boolean isAutoSchema() {
        return this.autoSchema;
    }

    public void setAutoSchema(boolean autoSchema) {
        this.autoSchema = autoSchema;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public DatabaseMeta getDatabaseMeta(MonetDbBulkLoader loader) {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String[] getFieldTable() {
        return this.fieldTable;
    }

    public void setFieldTable(String[] fieldTable) {
        this.fieldTable = fieldTable;
    }

    public String[] getFieldStream() {
        return this.fieldStream;
    }

    public void setFieldStream(String[] fieldStream) {
        this.fieldStream = fieldStream;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public void allocate(int nrvalues) {
        this.fieldTable = new String[nrvalues];
        this.fieldStream = new String[nrvalues];
        this.fieldFormatOk = new boolean[nrvalues];
    }

    public Object clone() {
        MonetDbBulkLoaderMeta retval = (MonetDbBulkLoaderMeta)((Object)super.clone());
        int nrvalues = this.fieldTable.length;
        retval.allocate(nrvalues);
        System.arraycopy(this.fieldTable, 0, retval.fieldTable, 0, nrvalues);
        System.arraycopy(this.fieldStream, 0, retval.fieldStream, 0, nrvalues);
        System.arraycopy(this.fieldFormatOk, 0, retval.fieldFormatOk, 0, nrvalues);
        return retval;
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.dbConnectionName = XmlHandler.getTagValue((Node)transformNode, (String)"connection");
            this.databaseMeta = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)this.dbConnectionName);
            this.schemaName = XmlHandler.getTagValue((Node)transformNode, (String)"schema");
            this.tableName = XmlHandler.getTagValue((Node)transformNode, (String)"table");
            this.bufferSize = XmlHandler.getTagValue((Node)transformNode, (String)"buffer_size");
            this.logFile = XmlHandler.getTagValue((Node)transformNode, (String)"log_file");
            this.truncate = "Y".equals(XmlHandler.getTagValue((Node)transformNode, (String)"truncate"));
            this.fullyQuoteSQL = "Y".equals(XmlHandler.getTagValue((Node)transformNode, (String)"fully_quote_sql"));
            this.fieldSeparator = XmlHandler.getTagValue((Node)transformNode, (String)"field_separator");
            if (this.fieldSeparator == null) {
                this.fieldSeparator = "|";
            }
            this.fieldEnclosure = XmlHandler.getTagValue((Node)transformNode, (String)"field_enclosure");
            if (this.fieldEnclosure == null) {
                this.fieldEnclosure = "\"";
            }
            this.nullRepresentation = XmlHandler.getTagValue((Node)transformNode, (String)"null_representation");
            if (this.nullRepresentation == null) {
                this.nullRepresentation = "null";
            }
            this.encoding = XmlHandler.getTagValue((Node)transformNode, (String)"encoding");
            if (this.encoding == null) {
                this.encoding = "UTF-8";
            }
            int nrvalues = XmlHandler.countNodes((Node)transformNode, (String)"mapping");
            this.allocate(nrvalues);
            for (int i = 0; i < nrvalues; ++i) {
                Node vnode = XmlHandler.getSubNodeByNr((Node)transformNode, (String)"mapping", (int)i);
                this.fieldTable[i] = XmlHandler.getTagValue((Node)vnode, (String)"stream_name");
                this.fieldStream[i] = XmlHandler.getTagValue((Node)vnode, (String)"field_name");
                if (this.fieldStream[i] == null) {
                    this.fieldStream[i] = this.fieldTable[i];
                }
                this.fieldFormatOk[i] = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)vnode, (String)"field_format_ok"));
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.Exception.UnableToReadTransformInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.fieldTable = null;
        this.databaseMeta = null;
        this.schemaName = "";
        this.tableName = BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.DefaultTableName", (String[])new String[0]);
        this.bufferSize = "100000";
        this.logFile = "";
        this.truncate = false;
        this.fullyQuoteSQL = true;
        this.fieldSeparator = "|";
        this.fieldEnclosure = "\"";
        this.nullRepresentation = "";
        this.encoding = "UTF-8";
        this.allocate(0);
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    ").append(XmlHandler.addTagValue((String)"connection", (String)this.dbConnectionName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"buffer_size", (String)this.bufferSize));
        retval.append("    ").append(XmlHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"table", (String)this.tableName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"log_file", (String)this.logFile));
        retval.append("    ").append(XmlHandler.addTagValue((String)"truncate", (boolean)this.truncate));
        retval.append("    ").append(XmlHandler.addTagValue((String)"fully_quote_sql", (boolean)this.fullyQuoteSQL));
        retval.append("    ").append(XmlHandler.addTagValue((String)"field_separator", (String)this.fieldSeparator));
        retval.append("    ").append(XmlHandler.addTagValue((String)"field_enclosure", (String)this.fieldEnclosure));
        retval.append("    ").append(XmlHandler.addTagValue((String)"null_representation", (String)this.nullRepresentation));
        retval.append("    ").append(XmlHandler.addTagValue((String)"encoding", (String)this.encoding));
        for (int i = 0; i < this.fieldTable.length; ++i) {
            Boolean fieldFormat = false;
            if (this.fieldFormatOk.length == this.fieldTable.length) {
                fieldFormat = this.fieldFormatOk[i];
            }
            retval.append("      <mapping>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"stream_name", (String)this.fieldTable[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"field_name", (String)this.fieldStream[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"field_format_ok", (boolean)fieldFormat));
            retval.append("      </mapping>").append(Const.CR);
        }
        return retval.toString();
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        Object erroMessage = "";
        if (this.databaseMeta != null) {
            Database db = new Database(loggingObject, variables, this.databaseMeta);
            try {
                boolean errorFound;
                boolean first;
                db.connect();
                if (!Utils.isEmpty((CharSequence)this.tableName)) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.TableNameOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    first = true;
                    errorFound = false;
                    erroMessage = "";
                    String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tableName);
                    IRowMeta r = db.getTableFields(schemaTable);
                    if (r != null) {
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.TableExists", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        first = true;
                        errorFound = false;
                        erroMessage = "";
                        for (String field : this.fieldTable) {
                            IValueMeta v = r.searchValueMeta(field);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                erroMessage = (String)erroMessage + BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.MissingFieldsToLoadInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            errorFound = true;
                            erroMessage = (String)erroMessage + "\t\t" + field + Const.CR;
                        }
                        cr = errorFound ? new CheckResult(4, (String)erroMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.AllFieldsFoundInTargetTable", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    } else {
                        erroMessage = BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                        cr = new CheckResult(4, (String)erroMessage, (ICheckResultSource)transformMeta);
                    }
                    remarks.add((ICheckResult)cr);
                }
                if (prev != null && prev.size() > 0) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.TransformReceivingDatas", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    first = true;
                    erroMessage = "";
                    errorFound = false;
                    for (String s : this.fieldStream) {
                        IValueMeta v = prev.searchValueMeta(s);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            erroMessage = (String)erroMessage + BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.MissingFieldsInInput", (String[])new String[0]) + Const.CR;
                        }
                        errorFound = true;
                        erroMessage = (String)erroMessage + "\t\t" + s + Const.CR;
                    }
                    cr = errorFound ? new CheckResult(4, (String)erroMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.AllFieldsFoundInInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                erroMessage = BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.MissingFieldsInInput3", (String[])new String[0]) + Const.CR;
                cr = new CheckResult(4, (String)erroMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopException e) {
                erroMessage = BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.DatabaseErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, (String)erroMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            erroMessage = BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, (String)erroMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.TransformReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.NoInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public SqlStatement getTableDdl(IVariables variables, PipelineMeta pipelineMeta, String transformName, boolean autoSchema, MonetDbBulkLoaderData data, boolean safeMode) throws HopException {
        TransformMeta transformMeta = new TransformMeta(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.transformMeta.Title", (String[])new String[0]), transformName, (ITransformMeta)this);
        IRowMeta prev = pipelineMeta.getPrevTransformFields(variables, transformName);
        return this.getSqlStatements(variables, transformMeta, prev, autoSchema, data, safeMode);
    }

    public IRowMeta updateFields(IVariables variables, PipelineMeta pipelineMeta, String transformName, MonetDbBulkLoaderData data) throws HopTransformException {
        IRowMeta prev = pipelineMeta.getPrevTransformFields(variables, transformName);
        return this.updateFields(prev, data);
    }

    public IRowMeta updateFields(IRowMeta prev, MonetDbBulkLoaderData data) {
        RowMeta tableFields = new RowMeta();
        List fields = prev.getValueMetaList();
        this.fieldTable = new String[fields.size()];
        this.fieldStream = new String[fields.size()];
        this.fieldFormatOk = new boolean[fields.size()];
        int idx = 0;
        for (IValueMeta field : fields) {
            IValueMeta tableField = field.clone();
            tableFields.addValueMeta(tableField);
            this.fieldTable[idx] = field.getName();
            this.fieldStream[idx] = field.getName();
            this.fieldFormatOk[idx] = true;
            ++idx;
        }
        data.keynrs = new int[this.getFieldStream().length];
        for (int i = 0; i < data.keynrs.length; ++i) {
            data.keynrs[i] = i;
        }
        return tableFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlStatement getSqlStatements(IVariables variables, TransformMeta transformMeta, IRowMeta prev, boolean autoSchema, MonetDbBulkLoaderData data, boolean safeMode) {
        SqlStatement retval = new SqlStatement(transformMeta.getName(), this.databaseMeta, null);
        if (this.databaseMeta != null) {
            if (prev != null && prev.size() > 0) {
                RowMeta tableFields;
                if (autoSchema) {
                    tableFields = this.updateFields(prev, data);
                } else {
                    tableFields = new RowMeta();
                    for (int i = 0; i < this.fieldTable.length; ++i) {
                        IValueMeta v = prev.searchValueMeta(this.fieldStream[i]);
                        if (v == null) continue;
                        IValueMeta tableField = v.clone();
                        tableField.setName(this.fieldTable[i]);
                        tableFields.addValueMeta(tableField);
                    }
                }
                if (!Utils.isEmpty((CharSequence)this.tableName)) {
                    Database db = new Database(loggingObject, variables, this.databaseMeta);
                    try {
                        String createTable;
                        db.connect();
                        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tableName);
                        MonetDBDatabaseMeta.safeModeLocal.set(safeMode);
                        String sql = createTable = db.getDDL(schemaTable, (IRowMeta)tableFields, null, false, null, true);
                        if (sql.length() == 0) {
                            retval.setSql(null);
                        }
                        retval.setSql(sql);
                    }
                    catch (HopException e) {
                        retval.setError(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.GetSQL.ErrorOccurred", (String[])new String[0]) + e.getMessage());
                    }
                    finally {
                        db.disconnect();
                        MonetDBDatabaseMeta.safeModeLocal.remove();
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.GetSQL.NoTableDefinedOnConnection", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.GetSQL.NotReceivingAnyFields", (String[])new String[0]));
            }
        } else {
            retval.setError(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.GetSQL.NoConnectionDefined", (String[])new String[0]));
        }
        return retval;
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (prev != null) {
            for (int i = 0; i < this.fieldTable.length; ++i) {
                IValueMeta v = prev.searchValueMeta(this.fieldStream[i]);
                DatabaseImpact ii = new DatabaseImpact(3, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), variables.resolve(this.tableName), this.fieldTable[i], this.fieldStream[i], v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRowMeta getRequiredFields(IVariables variables) throws HopException {
        String realTableName = variables.resolve(this.tableName);
        String realSchemaName = variables.resolve(this.schemaName);
        if (this.databaseMeta == null) throw new HopException(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        Database db = new Database(loggingObject, variables, this.databaseMeta);
        try {
            db.connect();
            if (Utils.isEmpty((CharSequence)realTableName)) throw new HopException(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.Exception.TableNotSpecified", (String[])new String[0]));
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(variables, realSchemaName, realTableName);
            if (db.checkTableExists(realSchemaName, realTableName)) {
                IRowMeta iRowMeta = db.getTableFields(schemaTable);
                return iRowMeta;
            }
            try {
                throw new HopException(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new HopException(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            db.disconnect();
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public String getFieldSeparator() {
        return this.fieldSeparator;
    }

    public void setFieldSeparator(String fieldSeparatorStr) {
        this.fieldSeparator = fieldSeparatorStr;
    }

    public String getFieldEnclosure() {
        return this.fieldEnclosure;
    }

    public void setFieldEnclosure(String fieldEnclosureStr) {
        this.fieldEnclosure = fieldEnclosureStr;
    }

    public String getNullRepresentation() {
        return this.nullRepresentation;
    }

    public void setNullRepresentation(String nullRepresentationString) {
        this.nullRepresentation = nullRepresentationString;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(String bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean[] getFieldFormatOk() {
        return this.fieldFormatOk;
    }

    public void setFieldFormatOk(boolean[] fieldFormatOk) {
        this.fieldFormatOk = fieldFormatOk;
    }

    public void setDbConnectionName(String dbConnectionName) {
        this.dbConnectionName = dbConnectionName;
    }

    public String getDbConnectionName() {
        return this.dbConnectionName;
    }

    private MonetDbVersion getMonetDBVersion(IVariables variables) throws HopException {
        Database db = null;
        db = new Database(loggingObject, variables, this.databaseMeta);
        try {
            db.connect();
            MonetDbVersion monetDbVersion = new MonetDbVersion(db.getDatabaseMetaData().getDatabaseProductVersion());
            return monetDbVersion;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
        finally {
            if (db != null) {
                db.disconnect();
            }
        }
    }

    public boolean isCompatibilityDbVersionMode() {
        return this.compatibilityDbVersionMode;
    }

    public void setCompatibilityDbVersionMode(IVariables variables) {
        block3: {
            try {
                MonetDbVersion monetDBVersion = this.getMonetDBVersion(variables);
                boolean bl = this.compatibilityDbVersionMode = monetDBVersion.compareTo(MonetDbVersion.JAN_2014_SP2_DB_VERSION) >= 0;
                if (this.isDebug() && this.compatibilityDbVersionMode) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"MonetDBVersion.Info.UsingCompatibilityMode", (Object[])new Object[]{MonetDbVersion.JAN_2014_SP2_DB_VERSION}));
                }
            }
            catch (HopException e) {
                if (!this.isDebug()) break block3;
                this.logDebug(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.Exception.ErrorOnGettingDbVersion", (String[])new String[]{e.getMessage()}));
            }
        }
    }
}

