/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.io;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.transform.BeamInputTransform;
import org.apache.hop.beam.core.util.JsonRowMeta;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.metadata.FileDefinition;
import org.apache.hop.beam.pipeline.IBeamPipelineTransformHandler;
import org.apache.hop.beam.transforms.io.BeamInput;
import org.apache.hop.beam.transforms.io.BeamInputData;
import org.apache.hop.beam.transforms.io.BeamInputDialog;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

@Transform(id="BeamInput", name="Beam Input", description="Describes a Beam Input", image="beam-input.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.BigData", keywords={"i18n::BeamInputMeta.keyword"}, documentationUrl="/pipeline/transforms/beaminput.html")
public class BeamInputMeta
extends BaseTransformMeta<BeamInput, BeamInputData>
implements IBeamPipelineTransformHandler {
    @HopMetadataProperty(key="input_location")
    private String inputLocation;
    @HopMetadataProperty(key="file_description_name")
    private String fileDefinitionName;

    public String getDialogClassName() {
        return BeamInputDialog.class.getName();
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (metadataProvider != null) {
            FileDefinition fileDefinition = this.loadFileDefinition(metadataProvider);
            try {
                inputRowMeta.clear();
                inputRowMeta.addRowMeta(fileDefinition.getRowMeta());
            }
            catch (HopPluginException e) {
                throw new HopTransformException("Unable to get row layout of file definition '" + fileDefinition.getName() + "'", (Throwable)e);
            }
        }
    }

    public FileDefinition loadFileDefinition(IHopMetadataProvider metadataProvider) throws HopTransformException {
        FileDefinition fileDefinition;
        if (StringUtils.isEmpty((String)this.fileDefinitionName)) {
            throw new HopTransformException("No file description name provided");
        }
        try {
            IHopMetadataSerializer serializer = metadataProvider.getSerializer(FileDefinition.class);
            fileDefinition = (FileDefinition)serializer.load(this.fileDefinitionName);
        }
        catch (Exception e) {
            throw new HopTransformException("Unable to load file description '" + this.fileDefinitionName + "' from the metadata", (Throwable)e);
        }
        if (fileDefinition == null) {
            throw new HopTransformException("Unable to find file definition '" + this.fileDefinitionName + "' in the metadata");
        }
        return fileDefinition;
    }

    @Override
    public boolean isInput() {
        return true;
    }

    @Override
    public boolean isOutput() {
        return false;
    }

    @Override
    public void handleTransform(ILogChannel log, IVariables variables, IBeamPipelineEngineRunConfiguration runConfiguration, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, List<String> transformPluginClasses, List<String> xpPluginClasses, TransformMeta transformMeta, Map<String, PCollection<HopRow>> transformCollectionMap, Pipeline pipeline, IRowMeta rowMeta, List<TransformMeta> previousTransforms, PCollection<HopRow> input) throws HopException {
        FileDefinition inputFileDefinition = this.loadFileDefinition(metadataProvider);
        IRowMeta fileRowMeta = inputFileDefinition.getRowMeta();
        String fileInputLocation = variables.resolve(this.inputLocation);
        BeamInputTransform beamInputTransform = new BeamInputTransform(transformMeta.getName(), transformMeta.getName(), fileInputLocation, variables.resolve(inputFileDefinition.getSeparator()), JsonRowMeta.toJson(fileRowMeta), transformPluginClasses, xpPluginClasses);
        PCollection afterInput = (PCollection)pipeline.apply((PTransform)beamInputTransform);
        transformCollectionMap.put(transformMeta.getName(), (PCollection<HopRow>)afterInput);
        log.logBasic("Handled transform (INPUT) : " + transformMeta.getName());
    }

    public String getInputLocation() {
        return this.inputLocation;
    }

    public void setInputLocation(String inputLocation) {
        this.inputLocation = inputLocation;
    }

    public String getFileDefinitionName() {
        return this.fileDefinitionName;
    }

    public void setFileDefinitionName(String fileDefinitionName) {
        this.fileDefinitionName = fileDefinitionName;
    }
}

