/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.injection.bean;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.injection.InjectionTypeConverter;
import org.apache.hop.core.injection.bean.BeanLevelInfo;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.util.ReflectionUtil;

public class BeanInjectionInfo<Meta> {
    private static ILogChannel log;
    protected final Class<Meta> clazz;
    protected final InjectionSupported clazzAnnotation;
    protected Map<String, Property> properties = new HashMap<String, Property>();
    protected List<Group> groupsList = new ArrayList<Group>();
    protected Map<String, Group> groupsMap = new HashMap<String, Group>();
    protected Set<String> hideProperties = new HashSet<String>();

    public BeanInjectionInfo(Class<Meta> clazz) {
        log = LogChannel.GENERAL;
        if (log.isDebug()) {
            log.logDebug("Collect bean injection info for " + clazz);
        }
        try {
            this.clazz = clazz;
            this.clazzAnnotation = clazz.getAnnotation(InjectionSupported.class);
            if (!BeanInjectionInfo.isInjectionSupported(clazz)) {
                throw new RuntimeException("Injection not supported in " + clazz);
            }
            if (this.clazzAnnotation == null) {
                this.extractMetadataProperties(clazz);
            } else {
                this.extractInjectionInfo(clazz);
            }
        }
        catch (Throwable ex) {
            log.logError("Error bean injection info collection for " + clazz + ": " + ex.getMessage(), ex);
            throw ex;
        }
    }

    public static <Meta> boolean isInjectionSupported(Class<Meta> clazz) {
        InjectionSupported annotation = clazz.getAnnotation(InjectionSupported.class);
        if (annotation != null) {
            return true;
        }
        for (Field field : ReflectionUtil.findAllFields(clazz)) {
            HopMetadataProperty property = field.getAnnotation(HopMetadataProperty.class);
            if (property == null) continue;
            return true;
        }
        return false;
    }

    private void extractMetadataProperties(Class<Meta> clazz) {
        BeanLevelInfo classLevelInfo = new BeanLevelInfo();
        classLevelInfo.leafClass = clazz;
        Group rootGroup = new Group("", "");
        this.groupsList.add(rootGroup);
        this.groupsMap.put(rootGroup.getKey(), rootGroup);
        List<BeanLevelInfo> parentPath = Arrays.asList(classLevelInfo);
        boolean hasChildren = this.extractMetadataProperties(rootGroup, parentPath, clazz);
        if (!hasChildren) {
            throw new RuntimeException("Injection not supported in " + clazz);
        }
        this.properties = Collections.unmodifiableMap(this.properties);
        this.groupsList = Collections.unmodifiableList(this.groupsList);
    }

    private boolean extractMetadataProperties(Group rootGroup, List<BeanLevelInfo> parentPath, Class<?> clazz) {
        HashMap<Field, HopMetadataProperty> propertyFields = new HashMap<Field, HopMetadataProperty>();
        for (Field field : ReflectionUtil.findAllFields(clazz)) {
            HopMetadataProperty property = field.getAnnotation(HopMetadataProperty.class);
            if (property == null) continue;
            propertyFields.put(field, property);
        }
        if (propertyFields.isEmpty()) {
            return false;
        }
        for (Field field : propertyFields.keySet()) {
            ArrayList<BeanLevelInfo> path;
            Class fieldType = field.getType();
            HopMetadataProperty property = (HopMetadataProperty)propertyFields.get(field);
            String injectionKey = this.calculateInjectionKey(field, property);
            String injectionKeyDescription = this.calculateInjectionKeyDescription(property);
            String injectionGroupKey = this.calculateInjectionGroupKey(property);
            String injectionGroupDescription = this.calculateInjectionGroupDescription(property);
            BeanLevelInfo fieldLevelInfo = this.getLevelInfo(clazz, parentPath.get(parentPath.size() - 1), field, fieldType, property, injectionKey);
            Group group = null;
            if (StringUtils.isNotEmpty((String)injectionGroupKey) && (group = this.groupsMap.get(injectionGroupKey)) == null) {
                group = new Group(injectionGroupKey, injectionGroupDescription);
                this.groupsMap.put(injectionGroupKey, group);
                this.groupsList.add(group);
            }
            if (StringUtils.isNotEmpty((String)injectionGroupKey)) {
                if (fieldType.equals(List.class)) {
                    ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
                    fieldType = (Class)parameterizedType.getActualTypeArguments()[0];
                    fieldLevelInfo.dim = BeanLevelInfo.DIMENSION.LIST;
                    fieldLevelInfo.leafClass = fieldType;
                }
                if (String.class.equals(fieldType)) {
                    fieldLevelInfo.leafClass = field.getType();
                    BeanLevelInfo childLevelInfo = this.getLevelInfo(fieldType, fieldLevelInfo, null, fieldType, property, injectionKey);
                    childLevelInfo.stringList = true;
                    ArrayList<BeanLevelInfo> path2 = new ArrayList<BeanLevelInfo>(parentPath);
                    path2.add(fieldLevelInfo);
                    path2.add(childLevelInfo);
                    Property p = new Property(injectionKey, injectionKeyDescription, injectionGroupKey, path2, property.isExcludedFromInjection());
                    group.properties.add(p);
                    this.properties.put(injectionKey, p);
                    continue;
                }
                for (Field childField : ReflectionUtil.findAllFields(fieldType)) {
                    Class<?> childFieldType = childField.getType();
                    HopMetadataProperty childProperty = childField.getAnnotation(HopMetadataProperty.class);
                    if (childProperty == null) continue;
                    String childInjectionKey = this.calculateInjectionKey(childField, childProperty);
                    String childInjectionKeyDescription = this.calculateInjectionKeyDescription(childProperty);
                    BeanLevelInfo childLevelInfo = this.getLevelInfo(fieldType, fieldLevelInfo, childField, childFieldType, childProperty, childInjectionKey);
                    ArrayList<BeanLevelInfo> path3 = new ArrayList<BeanLevelInfo>(parentPath);
                    path3.add(fieldLevelInfo);
                    path3.add(childLevelInfo);
                    if (this.isChildlessClass(childFieldType, childProperty)) {
                        Property p = new Property(childInjectionKey, childInjectionKeyDescription, injectionGroupKey, path3, property.isExcludedFromInjection());
                        group.properties.add(p);
                        this.properties.put(childInjectionKey, p);
                        continue;
                    }
                    this.extractMetadataProperties(rootGroup, path3, childFieldType);
                }
                continue;
            }
            if (this.isChildlessClass(fieldType, property)) {
                path = new ArrayList<BeanLevelInfo>(parentPath);
                path.add(fieldLevelInfo);
                Property p = new Property(injectionKey, injectionKeyDescription, "", path, property.isExcludedFromInjection());
                rootGroup.properties.add(p);
                this.properties.put(injectionKey, p);
                continue;
            }
            path = new ArrayList<BeanLevelInfo>(parentPath);
            path.add(fieldLevelInfo);
            this.extractMetadataProperties(rootGroup, path, fieldType);
        }
        return true;
    }

    private boolean isChildlessClass(Class<?> fieldType, HopMetadataProperty property) {
        return fieldType.isPrimitive() || fieldType.isEnum() || String.class.equals(fieldType) || Date.class.equals(fieldType) || property.storeWithName() || property.storeWithCode();
    }

    private BeanLevelInfo getLevelInfo(Class<?> parentClass, BeanLevelInfo parent, Field field, Class<?> fieldType, HopMetadataProperty property, String injectionKey) {
        boolean isBoolean;
        BeanLevelInfo fieldLevelInfo = new BeanLevelInfo();
        fieldLevelInfo.parent = parent;
        fieldLevelInfo.leafClass = fieldType;
        if (property != null) {
            fieldLevelInfo.storeWithName = property.storeWithName();
            try {
                fieldLevelInfo.converter = (InjectionTypeConverter)property.injectionConverter().newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate injection metadata converter class " + property.injectionConverter().getName(), e);
            }
        }
        fieldLevelInfo.nameKey = injectionKey;
        fieldLevelInfo.field = field;
        if (field != null) {
            fieldLevelInfo.field.setAccessible(true);
        }
        fieldLevelInfo.dim = BeanLevelInfo.DIMENSION.NONE;
        boolean bl = isBoolean = Boolean.class.equals(fieldType) || Boolean.TYPE.equals(fieldType);
        if (field != null) {
            try {
                fieldLevelInfo.getter = parentClass.getMethod(ReflectionUtil.getGetterMethodName((String)field.getName(), (boolean)isBoolean), new Class[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to find getter for field " + field.getName() + " in class " + parentClass.getName(), e);
            }
            try {
                fieldLevelInfo.setter = parentClass.getMethod(ReflectionUtil.getSetterMethodName((String)field.getName()), fieldType);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to find setter for field " + field.getName() + " in class " + parentClass.getName(), e);
            }
        }
        return fieldLevelInfo;
    }

    private String calculateInjectionGroupDescription(HopMetadataProperty property) {
        String injectionGroupDescription = property.injectionGroupDescription();
        if (StringUtils.isEmpty((String)injectionGroupDescription)) {
            injectionGroupDescription = "";
        }
        return injectionGroupDescription;
    }

    private String calculateInjectionGroupKey(HopMetadataProperty property) {
        String injectionGroupKey = property.injectionGroupKey();
        if (StringUtils.isEmpty((String)injectionGroupKey)) {
            injectionGroupKey = property.groupKey();
        }
        return injectionGroupKey;
    }

    private String calculateInjectionKeyDescription(HopMetadataProperty property) {
        String injectionKeyDescription = property.injectionKeyDescription();
        if (StringUtils.isEmpty((String)injectionKeyDescription)) {
            injectionKeyDescription = "";
        }
        return injectionKeyDescription;
    }

    private String calculateInjectionKey(Field field, HopMetadataProperty property) {
        String injectionKey = property.injectionKey();
        if (StringUtils.isEmpty((String)injectionKey)) {
            injectionKey = property.key();
        }
        if (StringUtils.isEmpty((String)injectionKey)) {
            injectionKey = field.getName();
        }
        return injectionKey;
    }

    private void extractInjectionInfo(Class<Meta> clazz) {
        TypeVariable<Class<Meta>>[] typeParameters;
        HashMap<String, Type> parameterTypesMap = new HashMap<String, Type>();
        for (TypeVariable<Class<Meta>> typeParameter : typeParameters = clazz.getTypeParameters()) {
            String parameterTypeName = typeParameter.getName();
            Type parameterType = typeParameter.getBounds()[0];
            parameterTypesMap.put(parameterTypeName, parameterType);
        }
        Group gr0 = new Group("", "");
        this.groupsList.add(gr0);
        this.groupsMap.put(gr0.getKey(), gr0);
        for (String group : this.clazzAnnotation.groups()) {
            String groupDescription = this.clazzAnnotation.localizationPrefix() + group;
            Group gr = new Group(group, groupDescription);
            this.groupsList.add(gr);
            this.groupsMap.put(gr.getKey(), gr);
        }
        for (String p : this.clazzAnnotation.hide()) {
            this.hideProperties.add(p);
        }
        BeanLevelInfo root = new BeanLevelInfo();
        root.leafClass = clazz;
        if (parameterTypesMap.isEmpty()) {
            root.init(this);
        } else {
            root.init(this, parameterTypesMap);
        }
        this.properties = Collections.unmodifiableMap(this.properties);
        this.groupsList = Collections.unmodifiableList(this.groupsList);
        this.groupsMap = null;
    }

    public String getLocalizationPrefix() {
        return this.clazzAnnotation.localizationPrefix();
    }

    public Map<String, Property> getProperties() {
        return this.properties;
    }

    public List<Group> getGroups() {
        return this.groupsList;
    }

    protected void addInjectionProperty(Injection metaInj, BeanLevelInfo leaf) {
        if (StringUtils.isBlank((String)metaInj.name())) {
            throw new RuntimeException("Property name shouldn't be blank in the " + this.clazz);
        }
        String propertyName = this.calcPropertyName(metaInj, leaf);
        if (this.properties.containsKey(propertyName)) {
            throw new RuntimeException("Property '" + propertyName + "' already defined for " + this.clazz);
        }
        if (this.hideProperties.contains(propertyName)) {
            return;
        }
        String injectionKeyDescription = this.clazzAnnotation.localizationPrefix() + propertyName;
        Property prop = new Property(propertyName, injectionKeyDescription, metaInj.group(), leaf.createCallStack(), false);
        this.properties.put(prop.key, prop);
        Group gr = this.groupsMap.get(metaInj.group());
        if (gr == null) {
            throw new RuntimeException("Group '" + metaInj.group() + "' for property '" + metaInj.name() + "' is not defined " + this.clazz);
        }
        gr.properties.add(prop);
    }

    public String getDescription(String description) {
        if (StringUtils.isEmpty((String)description)) {
            return "";
        }
        String translated = BaseMessages.getString(this.clazz, (String)description, (String[])new String[0]);
        if (translated != null && translated.startsWith("!") && translated.endsWith("!")) {
            for (Class<Meta> baseClass = this.clazz.getSuperclass(); baseClass != null; baseClass = baseClass.getSuperclass()) {
                InjectionSupported baseAnnotation = baseClass.getAnnotation(InjectionSupported.class);
                if (baseAnnotation == null || (translated = BaseMessages.getString(baseClass, (String)description, (String[])new String[0])) == null || translated.startsWith("!") || translated.endsWith("!")) continue;
                return translated;
            }
        }
        return translated;
    }

    private String calcPropertyName(Injection metaInj, BeanLevelInfo leaf) {
        Object name = metaInj.name();
        while (leaf != null) {
            if (StringUtils.isNotEmpty((String)leaf.nameKey)) {
                name = leaf.nameKey + "." + (String)name;
            }
            leaf = leaf.parent;
        }
        if (!((String)name).equals(metaInj.name()) && !metaInj.group().isEmpty()) {
            throw new RuntimeException("Group shouldn't be declared with prefix in " + this.clazz);
        }
        return name;
    }

    public class Group {
        private final String key;
        private final String description;
        protected final List<Property> properties = new ArrayList<Property>();

        public Group(String key, String description) {
            this.key = key;
            this.description = description;
        }

        public String getKey() {
            return this.key;
        }

        public String getDescription() {
            return this.description;
        }

        public List<Property> getProperties() {
            return Collections.unmodifiableList(this.properties);
        }

        public String getTranslatedDescription() {
            return BeanInjectionInfo.this.getDescription(this.description);
        }

        public boolean hasMatchingProperty(String filterString) {
            if (StringUtils.isEmpty((String)filterString)) {
                return true;
            }
            if (this.key.toUpperCase().contains(filterString.toUpperCase())) {
                return true;
            }
            for (Property property : this.properties) {
                if (!property.hasMatch(filterString)) continue;
                return true;
            }
            return false;
        }
    }

    public class Property {
        private final String key;
        private final String description;
        private final String groupKey;
        protected final List<BeanLevelInfo> path;
        public final int pathArraysCount;
        private final boolean isExcludedFromInjection;

        public Property(String key, String description, String groupKey, List<BeanLevelInfo> path, boolean isExcludedFromInjection) {
            this.key = key;
            this.description = description;
            this.groupKey = groupKey;
            this.path = path;
            this.isExcludedFromInjection = isExcludedFromInjection;
            int ac = 0;
            for (BeanLevelInfo level : path) {
                if (level.dim == BeanLevelInfo.DIMENSION.NONE) continue;
                ++ac;
            }
            this.pathArraysCount = ac;
        }

        public String getKey() {
            return this.key;
        }

        public String getDescription() {
            return this.description;
        }

        public String getGroupKey() {
            return this.groupKey;
        }

        public String getTranslatedDescription() {
            return BeanInjectionInfo.this.getDescription(this.description);
        }

        public Class<?> getPropertyClass() {
            return this.path.get((int)(this.path.size() - 1)).leafClass;
        }

        public boolean isExcludedFromInjection() {
            return this.isExcludedFromInjection;
        }

        public boolean hasMatch(String filterString) {
            if (StringUtils.isEmpty((String)filterString)) {
                return true;
            }
            if (this.getKey().toUpperCase().contains(filterString.toUpperCase())) {
                return true;
            }
            return this.getTranslatedDescription().toUpperCase().contains(filterString.toUpperCase());
        }

        public List<BeanLevelInfo> getPath() {
            return this.path;
        }
    }
}

