/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.unzip;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.apache.hop.workflow.actions.unzip.ActionUnZip;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ActionUnZipDialog
extends ActionDialog
implements IActionDialog {
    private static final Class<?> PKG = ActionUnZip.class;
    private static final String[] FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"ActionUnZip.Filetype.Zip", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionUnZip.Filetype.Jar", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionUnZip.Filetype.All", (String[])new String[0])};
    private Text wName;
    private Label wlZipFilename;
    private Button wbZipFilename;
    private Button wbSourceDirectory;
    private TextVar wZipFilename;
    private ActionUnZip action;
    private Shell shell;
    private TextVar wTargetDirectory;
    private Label wlMovetoDirectory;
    private TextVar wMovetoDirectory;
    private Label wlCreateMoveToDirectory;
    private Button wCreateMoveToDirectory;
    private TextVar wWildcard;
    private TextVar wWildcardExclude;
    private CCombo wAfterUnZip;
    private Button wAddFileToResult;
    private Button wbMovetoDirectory;
    private Button wSetModificationDateToOriginal;
    private Label wlWildcardSource;
    private TextVar wWildcardSource;
    private Button wArgsPrevious;
    private Button wRootZip;
    private CCombo wIfFileExists;
    private CCombo wSuccessCondition;
    private Label wlNrErrorsLessThan;
    private TextVar wNrErrorsLessThan;
    private Label wlAddDate;
    private Button wAddDate;
    private Label wlAddOriginalTimestamp;
    private Button wAddOriginalTimestamp;
    private Label wlAddTime;
    private Button wAddTime;
    private Button wSpecifyFormat;
    private Label wlDateTimeFormat;
    private CCombo wDateTimeFormat;
    private Button wCreateFolder;
    private boolean changed;

    public ActionUnZipDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = (ActionUnZip)action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionUnZip.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.Name.Label", (String[])new String[0]));
        this.props.setLook((Control)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.Tab.General.Label", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)generalLayout);
        Group wSource = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wSource);
        wSource.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.Source.Group.Label", (String[])new String[0]));
        FormLayout groupSourceLayout = new FormLayout();
        groupSourceLayout.marginWidth = 10;
        groupSourceLayout.marginHeight = 10;
        wSource.setLayout((Layout)groupSourceLayout);
        Label wlArgsPrevious = new Label((Composite)wSource, 131072);
        wlArgsPrevious.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.ArgsPrevious.Label", (String[])new String[0]));
        this.props.setLook((Control)wlArgsPrevious);
        FormData fdlArgsPrevious = new FormData();
        fdlArgsPrevious.left = new FormAttachment(0, 0);
        fdlArgsPrevious.top = new FormAttachment(0, margin);
        fdlArgsPrevious.right = new FormAttachment(middle, -margin);
        wlArgsPrevious.setLayoutData((Object)fdlArgsPrevious);
        this.wArgsPrevious = new Button((Composite)wSource, 32);
        this.props.setLook((Control)this.wArgsPrevious);
        this.wArgsPrevious.setToolTipText(BaseMessages.getString(PKG, (String)"ActionUnZip.ArgsPrevious.Tooltip", (String[])new String[0]));
        FormData fdArgsPrevious = new FormData();
        fdArgsPrevious.left = new FormAttachment(middle, 0);
        fdArgsPrevious.top = new FormAttachment((Control)wlArgsPrevious, 0, 0x1000000);
        fdArgsPrevious.right = new FormAttachment(100, 0);
        this.wArgsPrevious.setLayoutData((Object)fdArgsPrevious);
        this.wArgsPrevious.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionUnZipDialog.this.setArgdPrevious();
                ActionUnZipDialog.this.action.setChanged();
            }
        });
        this.wlZipFilename = new Label((Composite)wSource, 131072);
        this.wlZipFilename.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.ZipFilename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlZipFilename);
        FormData fdlZipFilename = new FormData();
        fdlZipFilename.left = new FormAttachment(0, 0);
        fdlZipFilename.top = new FormAttachment((Control)wlArgsPrevious, 2 * margin);
        fdlZipFilename.right = new FormAttachment(middle, -margin);
        this.wlZipFilename.setLayoutData((Object)fdlZipFilename);
        this.wbSourceDirectory = new Button((Composite)wSource, 0x1000008);
        this.props.setLook((Control)this.wbSourceDirectory);
        this.wbSourceDirectory.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.BrowseFolders.Label", (String[])new String[0]));
        FormData fdbSourceDirectory = new FormData();
        fdbSourceDirectory.right = new FormAttachment(100, 0);
        fdbSourceDirectory.top = new FormAttachment((Control)wlArgsPrevious, 2 * margin);
        this.wbSourceDirectory.setLayoutData((Object)fdbSourceDirectory);
        this.wbSourceDirectory.addListener(13, e -> BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wZipFilename, (IVariables)this.variables));
        this.wbZipFilename = new Button((Composite)wSource, 0x1000008);
        this.props.setLook((Control)this.wbZipFilename);
        this.wbZipFilename.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.BrowseFiles.Label", (String[])new String[0]));
        FormData fdbZipFilename = new FormData();
        fdbZipFilename.right = new FormAttachment((Control)this.wbSourceDirectory, -margin);
        fdbZipFilename.top = new FormAttachment((Control)wlArgsPrevious, 2 * margin);
        this.wbZipFilename.setLayoutData((Object)fdbZipFilename);
        this.wZipFilename = new TextVar(this.variables, (Composite)wSource, 18436);
        this.props.setLook((Control)this.wZipFilename);
        this.wZipFilename.addModifyListener(lsMod);
        FormData fdZipFilename = new FormData();
        fdZipFilename.left = new FormAttachment(middle, 0);
        fdZipFilename.top = new FormAttachment((Control)wlArgsPrevious, 2 * margin);
        fdZipFilename.right = new FormAttachment((Control)this.wbZipFilename, -margin);
        this.wZipFilename.setLayoutData((Object)fdZipFilename);
        this.wZipFilename.addModifyListener(e -> this.wZipFilename.setToolTipText(this.variables.resolve(this.wZipFilename.getText())));
        this.wbZipFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wZipFilename, (IVariables)this.variables, (String[])new String[]{"*.zip;*.ZIP", "*.jar;*.JAR", "*"}, (String[])FILETYPES, (boolean)true));
        this.wlWildcardSource = new Label((Composite)wSource, 131072);
        this.wlWildcardSource.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.WildcardSource.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlWildcardSource);
        FormData fdlWildcardSource = new FormData();
        fdlWildcardSource.left = new FormAttachment(0, 0);
        fdlWildcardSource.top = new FormAttachment((Control)this.wZipFilename, margin);
        fdlWildcardSource.right = new FormAttachment(middle, -margin);
        this.wlWildcardSource.setLayoutData((Object)fdlWildcardSource);
        this.wWildcardSource = new TextVar(this.variables, (Composite)wSource, 18436, BaseMessages.getString(PKG, (String)"ActionUnZip.WildcardSource.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wWildcardSource);
        this.wWildcardSource.addModifyListener(lsMod);
        FormData fdWildcardSource = new FormData();
        fdWildcardSource.left = new FormAttachment(middle, 0);
        fdWildcardSource.top = new FormAttachment((Control)this.wZipFilename, margin);
        fdWildcardSource.right = new FormAttachment(100, 0);
        this.wWildcardSource.setLayoutData((Object)fdWildcardSource);
        FormData fdSource = new FormData();
        fdSource.left = new FormAttachment(0, margin);
        fdSource.top = new FormAttachment((Control)this.wName, margin);
        fdSource.right = new FormAttachment(100, -margin);
        wSource.setLayoutData((Object)fdSource);
        Group wUnzippedFiles = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wUnzippedFiles);
        wUnzippedFiles.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.UnzippedFiles.Group.Label", (String[])new String[0]));
        FormLayout groupLayoutUnzipped = new FormLayout();
        groupLayoutUnzipped.marginWidth = 10;
        groupLayoutUnzipped.marginHeight = 10;
        wUnzippedFiles.setLayout((Layout)groupLayoutUnzipped);
        Label wlRootZip = new Label((Composite)wUnzippedFiles, 131072);
        wlRootZip.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.RootZip.Label", (String[])new String[0]));
        this.props.setLook((Control)wlRootZip);
        FormData fdlRootZip = new FormData();
        fdlRootZip.left = new FormAttachment(0, 0);
        fdlRootZip.top = new FormAttachment((Control)wSource, margin);
        fdlRootZip.right = new FormAttachment(middle, -margin);
        wlRootZip.setLayoutData((Object)fdlRootZip);
        this.wRootZip = new Button((Composite)wUnzippedFiles, 32);
        this.props.setLook((Control)this.wRootZip);
        this.wRootZip.setToolTipText(BaseMessages.getString(PKG, (String)"ActionUnZip.RootZip.Tooltip", (String[])new String[0]));
        FormData fdRootZip = new FormData();
        fdRootZip.left = new FormAttachment(middle, 0);
        fdRootZip.top = new FormAttachment((Control)wlRootZip, 0, 0x1000000);
        fdRootZip.right = new FormAttachment(100, 0);
        this.wRootZip.setLayoutData((Object)fdRootZip);
        this.wRootZip.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionUnZipDialog.this.action.setChanged();
            }
        });
        Label wlTargetDirectory = new Label((Composite)wUnzippedFiles, 131072);
        wlTargetDirectory.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.TargetDir.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTargetDirectory);
        FormData fdlTargetDirectory = new FormData();
        fdlTargetDirectory.left = new FormAttachment(0, 0);
        fdlTargetDirectory.top = new FormAttachment((Control)wlRootZip, 2 * margin);
        fdlTargetDirectory.right = new FormAttachment(middle, -margin);
        wlTargetDirectory.setLayoutData((Object)fdlTargetDirectory);
        Button wbTargetDirectory = new Button((Composite)wUnzippedFiles, 0x1000008);
        this.props.setLook((Control)wbTargetDirectory);
        wbTargetDirectory.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.BrowseFolders.Label", (String[])new String[0]));
        FormData fdbTargetDirectory = new FormData();
        fdbTargetDirectory.right = new FormAttachment(100, 0);
        fdbTargetDirectory.top = new FormAttachment((Control)wlRootZip, 2 * margin);
        wbTargetDirectory.setLayoutData((Object)fdbTargetDirectory);
        wbTargetDirectory.addListener(13, e -> BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wTargetDirectory, (IVariables)this.variables));
        this.wTargetDirectory = new TextVar(this.variables, (Composite)wUnzippedFiles, 18436, BaseMessages.getString(PKG, (String)"ActionUnZip.TargetDir.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wTargetDirectory);
        this.wTargetDirectory.addModifyListener(lsMod);
        FormData fdTargetDirectory = new FormData();
        fdTargetDirectory.left = new FormAttachment(middle, 0);
        fdTargetDirectory.top = new FormAttachment((Control)wlRootZip, 2 * margin);
        fdTargetDirectory.right = new FormAttachment((Control)wbTargetDirectory, -margin);
        this.wTargetDirectory.setLayoutData((Object)fdTargetDirectory);
        Label wlCreateFolder = new Label((Composite)wUnzippedFiles, 131072);
        wlCreateFolder.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.CreateFolder.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCreateFolder);
        FormData fdlCreateFolder = new FormData();
        fdlCreateFolder.left = new FormAttachment(0, 0);
        fdlCreateFolder.top = new FormAttachment((Control)this.wTargetDirectory, margin);
        fdlCreateFolder.right = new FormAttachment(middle, -margin);
        wlCreateFolder.setLayoutData((Object)fdlCreateFolder);
        this.wCreateFolder = new Button((Composite)wUnzippedFiles, 32);
        this.wCreateFolder.setToolTipText(BaseMessages.getString(PKG, (String)"ActionUnZip.CreateFolder.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCreateFolder);
        FormData fdCreateFolder = new FormData();
        fdCreateFolder.left = new FormAttachment(middle, 0);
        fdCreateFolder.top = new FormAttachment((Control)wlCreateFolder, 0, 0x1000000);
        fdCreateFolder.right = new FormAttachment(100, 0);
        this.wCreateFolder.setLayoutData((Object)fdCreateFolder);
        this.wCreateFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionUnZipDialog.this.action.setChanged();
            }
        });
        Label wlWildcard = new Label((Composite)wUnzippedFiles, 131072);
        wlWildcard.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.Wildcard.Label", (String[])new String[0]));
        this.props.setLook((Control)wlWildcard);
        FormData fdlWildcard = new FormData();
        fdlWildcard.left = new FormAttachment(0, 0);
        fdlWildcard.top = new FormAttachment((Control)wlCreateFolder, 2 * margin);
        fdlWildcard.right = new FormAttachment(middle, -margin);
        wlWildcard.setLayoutData((Object)fdlWildcard);
        this.wWildcard = new TextVar(this.variables, (Composite)wUnzippedFiles, 18436, BaseMessages.getString(PKG, (String)"ActionUnZip.Wildcard.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wWildcard);
        this.wWildcard.addModifyListener(lsMod);
        FormData fdWildcard = new FormData();
        fdWildcard.left = new FormAttachment(middle, 0);
        fdWildcard.top = new FormAttachment((Control)wlCreateFolder, 2 * margin);
        fdWildcard.right = new FormAttachment(100, 0);
        this.wWildcard.setLayoutData((Object)fdWildcard);
        Label wlWildcardExclude = new Label((Composite)wUnzippedFiles, 131072);
        wlWildcardExclude.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.WildcardExclude.Label", (String[])new String[0]));
        this.props.setLook((Control)wlWildcardExclude);
        FormData fdlWildcardExclude = new FormData();
        fdlWildcardExclude.left = new FormAttachment(0, 0);
        fdlWildcardExclude.top = new FormAttachment((Control)this.wWildcard, margin);
        fdlWildcardExclude.right = new FormAttachment(middle, -margin);
        wlWildcardExclude.setLayoutData((Object)fdlWildcardExclude);
        this.wWildcardExclude = new TextVar(this.variables, (Composite)wUnzippedFiles, 18436, BaseMessages.getString(PKG, (String)"ActionUnZip.WildcardExclude.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wWildcardExclude);
        this.wWildcardExclude.addModifyListener(lsMod);
        FormData fdWildcardExclude = new FormData();
        fdWildcardExclude.left = new FormAttachment(middle, 0);
        fdWildcardExclude.top = new FormAttachment((Control)this.wWildcard, margin);
        fdWildcardExclude.right = new FormAttachment(100, 0);
        this.wWildcardExclude.setLayoutData((Object)fdWildcardExclude);
        this.wlAddDate = new Label((Composite)wUnzippedFiles, 131072);
        this.wlAddDate.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.AddDate.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddDate);
        FormData fdlAddDate = new FormData();
        fdlAddDate.left = new FormAttachment(0, 0);
        fdlAddDate.top = new FormAttachment((Control)this.wWildcardExclude, margin);
        fdlAddDate.right = new FormAttachment(middle, -margin);
        this.wlAddDate.setLayoutData((Object)fdlAddDate);
        this.wAddDate = new Button((Composite)wUnzippedFiles, 32);
        this.props.setLook((Control)this.wAddDate);
        this.wAddDate.setToolTipText(BaseMessages.getString(PKG, (String)"ActionUnZip.AddDate.Tooltip", (String[])new String[0]));
        FormData fdAddDate = new FormData();
        fdAddDate.left = new FormAttachment(middle, 0);
        fdAddDate.top = new FormAttachment((Control)this.wlAddDate, 0, 0x1000000);
        fdAddDate.right = new FormAttachment(100, 0);
        this.wAddDate.setLayoutData((Object)fdAddDate);
        this.wAddDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionUnZipDialog.this.action.setChanged();
                ActionUnZipDialog.this.setDateTime();
            }
        });
        this.wlAddTime = new Label((Composite)wUnzippedFiles, 131072);
        this.wlAddTime.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.AddTime.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddTime);
        FormData fdlAddTime = new FormData();
        fdlAddTime.left = new FormAttachment(0, 0);
        fdlAddTime.top = new FormAttachment((Control)this.wlAddDate, 2 * margin);
        fdlAddTime.right = new FormAttachment(middle, -margin);
        this.wlAddTime.setLayoutData((Object)fdlAddTime);
        this.wAddTime = new Button((Composite)wUnzippedFiles, 32);
        this.props.setLook((Control)this.wAddTime);
        this.wAddTime.setToolTipText(BaseMessages.getString(PKG, (String)"ActionUnZip.AddTime.Tooltip", (String[])new String[0]));
        FormData fdAddTime = new FormData();
        fdAddTime.left = new FormAttachment(middle, 0);
        fdAddTime.top = new FormAttachment((Control)this.wlAddTime, 0, 0x1000000);
        fdAddTime.right = new FormAttachment(100, 0);
        this.wAddTime.setLayoutData((Object)fdAddTime);
        this.wAddTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionUnZipDialog.this.action.setChanged();
                ActionUnZipDialog.this.setDateTime();
            }
        });
        Label wlSpecifyFormat = new Label((Composite)wUnzippedFiles, 131072);
        wlSpecifyFormat.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.SpecifyFormat.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSpecifyFormat);
        FormData fdlSpecifyFormat = new FormData();
        fdlSpecifyFormat.left = new FormAttachment(0, 0);
        fdlSpecifyFormat.top = new FormAttachment((Control)this.wlAddTime, 2 * margin);
        fdlSpecifyFormat.right = new FormAttachment(middle, -margin);
        wlSpecifyFormat.setLayoutData((Object)fdlSpecifyFormat);
        this.wSpecifyFormat = new Button((Composite)wUnzippedFiles, 32);
        this.props.setLook((Control)this.wSpecifyFormat);
        this.wSpecifyFormat.setToolTipText(BaseMessages.getString(PKG, (String)"ActionUnZip.SpecifyFormat.Tooltip", (String[])new String[0]));
        FormData fdSpecifyFormat = new FormData();
        fdSpecifyFormat.left = new FormAttachment(middle, 0);
        fdSpecifyFormat.top = new FormAttachment((Control)wlSpecifyFormat, 0, 0x1000000);
        fdSpecifyFormat.right = new FormAttachment(100, 0);
        this.wSpecifyFormat.setLayoutData((Object)fdSpecifyFormat);
        this.wSpecifyFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionUnZipDialog.this.action.setChanged();
                ActionUnZipDialog.this.setDateTimeFormat();
            }
        });
        String[] dats = Const.getDateFormats();
        this.wlDateTimeFormat = new Label((Composite)wUnzippedFiles, 131072);
        this.wlDateTimeFormat.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.DateTimeFormat.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDateTimeFormat);
        FormData fdlDateTimeFormat = new FormData();
        fdlDateTimeFormat.left = new FormAttachment(0, 0);
        fdlDateTimeFormat.top = new FormAttachment((Control)wlSpecifyFormat, 2 * margin);
        fdlDateTimeFormat.right = new FormAttachment(middle, -margin);
        this.wlDateTimeFormat.setLayoutData((Object)fdlDateTimeFormat);
        this.wDateTimeFormat = new CCombo((Composite)wUnzippedFiles, 2056);
        this.wDateTimeFormat.setEditable(true);
        this.props.setLook((Control)this.wDateTimeFormat);
        this.wDateTimeFormat.addModifyListener(lsMod);
        FormData fdDateTimeFormat = new FormData();
        fdDateTimeFormat.left = new FormAttachment(middle, 0);
        fdDateTimeFormat.top = new FormAttachment((Control)wlSpecifyFormat, 2 * margin);
        fdDateTimeFormat.right = new FormAttachment(100, 0);
        this.wDateTimeFormat.setLayoutData((Object)fdDateTimeFormat);
        for (String dat : dats) {
            this.wDateTimeFormat.add(dat);
        }
        this.wlAddOriginalTimestamp = new Label((Composite)wUnzippedFiles, 131072);
        this.wlAddOriginalTimestamp.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.AddOriginalTimestamp.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddOriginalTimestamp);
        FormData fdlAddOriginalTimestamp = new FormData();
        fdlAddOriginalTimestamp.left = new FormAttachment(0, 0);
        fdlAddOriginalTimestamp.top = new FormAttachment((Control)this.wDateTimeFormat, margin);
        fdlAddOriginalTimestamp.right = new FormAttachment(middle, -margin);
        this.wlAddOriginalTimestamp.setLayoutData((Object)fdlAddOriginalTimestamp);
        this.wAddOriginalTimestamp = new Button((Composite)wUnzippedFiles, 32);
        this.props.setLook((Control)this.wAddOriginalTimestamp);
        this.wAddOriginalTimestamp.setToolTipText(BaseMessages.getString(PKG, (String)"ActionUnZip.AddOriginalTimestamp.Tooltip", (String[])new String[0]));
        FormData fdAddOriginalTimestamp = new FormData();
        fdAddOriginalTimestamp.left = new FormAttachment(middle, 0);
        fdAddOriginalTimestamp.top = new FormAttachment((Control)this.wlAddOriginalTimestamp, 0, 0x1000000);
        fdAddOriginalTimestamp.right = new FormAttachment(100, 0);
        this.wAddOriginalTimestamp.setLayoutData((Object)fdAddOriginalTimestamp);
        this.wAddOriginalTimestamp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionUnZipDialog.this.action.setChanged();
            }
        });
        Label wlSetModificationDateToOriginal = new Label((Composite)wUnzippedFiles, 131072);
        wlSetModificationDateToOriginal.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.SetModificationDateToOriginal.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSetModificationDateToOriginal);
        FormData fdlSetModificationDateToOriginal = new FormData();
        fdlSetModificationDateToOriginal.left = new FormAttachment(0, 0);
        fdlSetModificationDateToOriginal.top = new FormAttachment((Control)this.wlAddOriginalTimestamp, 2 * margin);
        fdlSetModificationDateToOriginal.right = new FormAttachment(middle, -margin);
        wlSetModificationDateToOriginal.setLayoutData((Object)fdlSetModificationDateToOriginal);
        this.wSetModificationDateToOriginal = new Button((Composite)wUnzippedFiles, 32);
        this.props.setLook((Control)this.wSetModificationDateToOriginal);
        this.wSetModificationDateToOriginal.setToolTipText(BaseMessages.getString(PKG, (String)"ActionUnZip.SetModificationDateToOriginal.Tooltip", (String[])new String[0]));
        FormData fdSetModificationDateToOriginal = new FormData();
        fdSetModificationDateToOriginal.left = new FormAttachment(middle, 0);
        fdSetModificationDateToOriginal.top = new FormAttachment((Control)wlSetModificationDateToOriginal, 0, 0x1000000);
        fdSetModificationDateToOriginal.right = new FormAttachment(100, 0);
        this.wSetModificationDateToOriginal.setLayoutData((Object)fdSetModificationDateToOriginal);
        this.wSetModificationDateToOriginal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionUnZipDialog.this.action.setChanged();
            }
        });
        Label wlIfFileExists = new Label((Composite)wUnzippedFiles, 131072);
        wlIfFileExists.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.IfFileExists.Label", (String[])new String[0]));
        this.props.setLook((Control)wlIfFileExists);
        FormData fdlIfFileExists = new FormData();
        fdlIfFileExists.left = new FormAttachment(0, 0);
        fdlIfFileExists.right = new FormAttachment(middle, -margin);
        fdlIfFileExists.top = new FormAttachment((Control)wlSetModificationDateToOriginal, 2 * margin);
        wlIfFileExists.setLayoutData((Object)fdlIfFileExists);
        this.wIfFileExists = new CCombo((Composite)wUnzippedFiles, 2060);
        this.wIfFileExists.setItems(ActionUnZip.typeIfFileExistsDesc);
        this.wIfFileExists.select(0);
        this.props.setLook((Control)this.wIfFileExists);
        FormData fdIfFileExists = new FormData();
        fdIfFileExists.left = new FormAttachment(middle, 0);
        fdIfFileExists.top = new FormAttachment((Control)wlIfFileExists, 0, 0x1000000);
        fdIfFileExists.right = new FormAttachment(100, 0);
        this.wIfFileExists.setLayoutData((Object)fdIfFileExists);
        this.wIfFileExists.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        Label wlAfterUnZip = new Label((Composite)wUnzippedFiles, 131072);
        wlAfterUnZip.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.AfterUnZip.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAfterUnZip);
        FormData fdlAfterUnZip = new FormData();
        fdlAfterUnZip.left = new FormAttachment(0, 0);
        fdlAfterUnZip.right = new FormAttachment(middle, 0);
        fdlAfterUnZip.top = new FormAttachment((Control)this.wIfFileExists, margin);
        wlAfterUnZip.setLayoutData((Object)fdlAfterUnZip);
        this.wAfterUnZip = new CCombo((Composite)wUnzippedFiles, 2060);
        this.wAfterUnZip.add(BaseMessages.getString(PKG, (String)"ActionUnZip.Do_Nothing_AfterUnZip.Label", (String[])new String[0]));
        this.wAfterUnZip.add(BaseMessages.getString(PKG, (String)"ActionUnZip.Delete_Files_AfterUnZip.Label", (String[])new String[0]));
        this.wAfterUnZip.add(BaseMessages.getString(PKG, (String)"ActionUnZip.Move_Files_AfterUnZip.Label", (String[])new String[0]));
        this.wAfterUnZip.select(0);
        this.props.setLook((Control)this.wAfterUnZip);
        FormData fdAfterUnZip = new FormData();
        fdAfterUnZip.left = new FormAttachment(middle, 0);
        fdAfterUnZip.top = new FormAttachment((Control)this.wIfFileExists, margin);
        fdAfterUnZip.right = new FormAttachment(100, 0);
        this.wAfterUnZip.setLayoutData((Object)fdAfterUnZip);
        this.wAfterUnZip.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionUnZipDialog.this.afterUnZipActivate();
            }
        });
        this.wlMovetoDirectory = new Label((Composite)wUnzippedFiles, 131072);
        this.wlMovetoDirectory.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.MovetoDirectory.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlMovetoDirectory);
        FormData fdlMovetoDirectory = new FormData();
        fdlMovetoDirectory.left = new FormAttachment(0, 0);
        fdlMovetoDirectory.top = new FormAttachment((Control)this.wAfterUnZip, margin);
        fdlMovetoDirectory.right = new FormAttachment(middle, -margin);
        this.wlMovetoDirectory.setLayoutData((Object)fdlMovetoDirectory);
        this.wMovetoDirectory = new TextVar(this.variables, (Composite)wUnzippedFiles, 18436, BaseMessages.getString(PKG, (String)"ActionUnZip.MovetoDirectory.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wMovetoDirectory);
        this.wbMovetoDirectory = new Button((Composite)wUnzippedFiles, 0x1000008);
        this.props.setLook((Control)this.wbMovetoDirectory);
        this.wbMovetoDirectory.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.BrowseFolders.Label", (String[])new String[0]));
        FormData fdbMovetoDirectory = new FormData();
        fdbMovetoDirectory.right = new FormAttachment(100, 0);
        fdbMovetoDirectory.top = new FormAttachment((Control)this.wAfterUnZip, margin);
        this.wbMovetoDirectory.setLayoutData((Object)fdbMovetoDirectory);
        this.wbMovetoDirectory.addListener(13, e -> BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wMovetoDirectory, (IVariables)this.variables));
        this.wMovetoDirectory.addModifyListener(lsMod);
        FormData fdMovetoDirectory = new FormData();
        fdMovetoDirectory.left = new FormAttachment(middle, 0);
        fdMovetoDirectory.top = new FormAttachment((Control)this.wAfterUnZip, margin);
        fdMovetoDirectory.right = new FormAttachment((Control)this.wbMovetoDirectory, -margin);
        this.wMovetoDirectory.setLayoutData((Object)fdMovetoDirectory);
        this.wlCreateMoveToDirectory = new Label((Composite)wUnzippedFiles, 131072);
        this.wlCreateMoveToDirectory.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.createMoveToFolder.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCreateMoveToDirectory);
        FormData fdlcreateMoveToDirectory = new FormData();
        fdlcreateMoveToDirectory.left = new FormAttachment(0, 0);
        fdlcreateMoveToDirectory.top = new FormAttachment((Control)this.wMovetoDirectory, margin);
        fdlcreateMoveToDirectory.right = new FormAttachment(middle, -margin);
        this.wlCreateMoveToDirectory.setLayoutData((Object)fdlcreateMoveToDirectory);
        this.wCreateMoveToDirectory = new Button((Composite)wUnzippedFiles, 32);
        this.props.setLook((Control)this.wCreateMoveToDirectory);
        this.wCreateMoveToDirectory.setToolTipText(BaseMessages.getString(PKG, (String)"ActionUnZip.createMoveToFolder.Tooltip", (String[])new String[0]));
        FormData fdCreateMoveToDirectory = new FormData();
        fdCreateMoveToDirectory.left = new FormAttachment(middle, 0);
        fdCreateMoveToDirectory.top = new FormAttachment((Control)this.wlCreateMoveToDirectory, 0, 0x1000000);
        fdCreateMoveToDirectory.right = new FormAttachment(100, 0);
        this.wCreateMoveToDirectory.setLayoutData((Object)fdCreateMoveToDirectory);
        this.wCreateMoveToDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionUnZipDialog.this.action.setChanged();
            }
        });
        FormData fdUnzippedFiles = new FormData();
        fdUnzippedFiles.left = new FormAttachment(0, margin);
        fdUnzippedFiles.top = new FormAttachment((Control)wSource, margin);
        fdUnzippedFiles.right = new FormAttachment(100, -margin);
        wUnzippedFiles.setLayoutData((Object)fdUnzippedFiles);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(500, -margin);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        this.props.setLook((Control)wGeneralComp);
        CTabItem wAdvancedTab = new CTabItem(wTabFolder, 0);
        wAdvancedTab.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.Tab.Advanced.Label", (String[])new String[0]));
        Composite wAdvancedComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wAdvancedComp);
        FormLayout advancedLayout = new FormLayout();
        advancedLayout.marginWidth = 3;
        advancedLayout.marginHeight = 3;
        wAdvancedComp.setLayout((Layout)advancedLayout);
        Group wFileResult = new Group(wAdvancedComp, 32);
        this.props.setLook((Control)wFileResult);
        wFileResult.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.FileResult.Group.Label", (String[])new String[0]));
        FormLayout groupLayout = new FormLayout();
        groupLayout.marginWidth = 10;
        groupLayout.marginHeight = 10;
        wFileResult.setLayout((Layout)groupLayout);
        Label wlAddFileToResult = new Label((Composite)wFileResult, 131072);
        wlAddFileToResult.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.AddFileToResult.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAddFileToResult);
        FormData fdlAddFileToResult = new FormData();
        fdlAddFileToResult.left = new FormAttachment(0, 0);
        fdlAddFileToResult.top = new FormAttachment((Control)wSource, margin);
        fdlAddFileToResult.right = new FormAttachment(middle, -margin);
        wlAddFileToResult.setLayoutData((Object)fdlAddFileToResult);
        this.wAddFileToResult = new Button((Composite)wFileResult, 32);
        this.props.setLook((Control)this.wAddFileToResult);
        this.wAddFileToResult.setToolTipText(BaseMessages.getString(PKG, (String)"ActionUnZip.AddFileToResult.Tooltip", (String[])new String[0]));
        FormData fdAddFileToResult = new FormData();
        fdAddFileToResult.left = new FormAttachment(middle, 0);
        fdAddFileToResult.top = new FormAttachment((Control)wlAddFileToResult, 0, 0x1000000);
        fdAddFileToResult.right = new FormAttachment(100, 0);
        this.wAddFileToResult.setLayoutData((Object)fdAddFileToResult);
        this.wAddFileToResult.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionUnZipDialog.this.action.setChanged();
            }
        });
        FormData fdFileResult = new FormData();
        fdFileResult.left = new FormAttachment(0, margin);
        fdFileResult.top = new FormAttachment((Control)wUnzippedFiles, margin);
        fdFileResult.right = new FormAttachment(100, -margin);
        wFileResult.setLayoutData((Object)fdFileResult);
        Group wSuccessOn = new Group(wAdvancedComp, 32);
        this.props.setLook((Control)wSuccessOn);
        wSuccessOn.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.SuccessOn.Group.Label", (String[])new String[0]));
        FormLayout successongroupLayout = new FormLayout();
        successongroupLayout.marginWidth = 10;
        successongroupLayout.marginHeight = 10;
        wSuccessOn.setLayout((Layout)successongroupLayout);
        Label wlSuccessCondition = new Label((Composite)wSuccessOn, 131072);
        wlSuccessCondition.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.SuccessCondition.Label", (String[])new String[0]) + " ");
        this.props.setLook((Control)wlSuccessCondition);
        FormData fdlSuccessCondition = new FormData();
        fdlSuccessCondition.left = new FormAttachment(0, 0);
        fdlSuccessCondition.right = new FormAttachment(middle, 0);
        fdlSuccessCondition.top = new FormAttachment((Control)wFileResult, margin);
        wlSuccessCondition.setLayoutData((Object)fdlSuccessCondition);
        this.wSuccessCondition = new CCombo((Composite)wSuccessOn, 2060);
        this.wSuccessCondition.add(BaseMessages.getString(PKG, (String)"ActionUnZip.SuccessWhenAllWorksFine.Label", (String[])new String[0]));
        this.wSuccessCondition.add(BaseMessages.getString(PKG, (String)"ActionUnZip.SuccessWhenAtLeat.Label", (String[])new String[0]));
        this.wSuccessCondition.add(BaseMessages.getString(PKG, (String)"ActionUnZip.SuccessWhenNrErrorsLessThan.Label", (String[])new String[0]));
        this.wSuccessCondition.select(0);
        this.props.setLook((Control)this.wSuccessCondition);
        FormData fdSuccessCondition = new FormData();
        fdSuccessCondition.left = new FormAttachment(middle, 0);
        fdSuccessCondition.top = new FormAttachment((Control)wFileResult, margin);
        fdSuccessCondition.right = new FormAttachment(100, 0);
        this.wSuccessCondition.setLayoutData((Object)fdSuccessCondition);
        this.wSuccessCondition.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionUnZipDialog.this.activeSuccessCondition();
            }
        });
        this.wlNrErrorsLessThan = new Label((Composite)wSuccessOn, 131072);
        this.wlNrErrorsLessThan.setText(BaseMessages.getString(PKG, (String)"ActionUnZip.NrBadFormedLessThan.Label", (String[])new String[0]) + " ");
        this.props.setLook((Control)this.wlNrErrorsLessThan);
        FormData fdlNrErrorsLessThan = new FormData();
        fdlNrErrorsLessThan.left = new FormAttachment(0, 0);
        fdlNrErrorsLessThan.top = new FormAttachment((Control)this.wSuccessCondition, margin);
        fdlNrErrorsLessThan.right = new FormAttachment(middle, -margin);
        this.wlNrErrorsLessThan.setLayoutData((Object)fdlNrErrorsLessThan);
        this.wNrErrorsLessThan = new TextVar(this.variables, (Composite)wSuccessOn, 18436, BaseMessages.getString(PKG, (String)"ActionUnZip.NrBadFormedLessThan.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wNrErrorsLessThan);
        this.wNrErrorsLessThan.addModifyListener(lsMod);
        FormData fdNrErrorsLessThan = new FormData();
        fdNrErrorsLessThan.left = new FormAttachment(middle, 0);
        fdNrErrorsLessThan.top = new FormAttachment((Control)this.wSuccessCondition, margin);
        fdNrErrorsLessThan.right = new FormAttachment(100, -margin);
        this.wNrErrorsLessThan.setLayoutData((Object)fdNrErrorsLessThan);
        FormData fdSuccessOn = new FormData();
        fdSuccessOn.left = new FormAttachment(0, margin);
        fdSuccessOn.top = new FormAttachment((Control)wFileResult, margin);
        fdSuccessOn.right = new FormAttachment(100, -margin);
        wSuccessOn.setLayoutData((Object)fdSuccessOn);
        FormData fdAdvancedComp = new FormData();
        fdAdvancedComp.left = new FormAttachment(0, 0);
        fdAdvancedComp.top = new FormAttachment(0, 0);
        fdAdvancedComp.right = new FormAttachment(100, 0);
        fdAdvancedComp.bottom = new FormAttachment(500, -margin);
        wAdvancedComp.setLayoutData((Object)fdAdvancedComp);
        wAdvancedComp.layout();
        wAdvancedTab.setControl((Control)wAdvancedComp);
        this.props.setLook((Control)wAdvancedComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.getData();
        this.setArgdPrevious();
        this.afterUnZipActivate();
        this.setDateTimeFormat();
        this.activeSuccessCondition();
        wTabFolder.setSelection(0);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    private void setDateTimeFormat() {
        if (this.wSpecifyFormat.getSelection()) {
            this.wAddDate.setSelection(false);
            this.wAddTime.setSelection(false);
        }
        this.wDateTimeFormat.setEnabled(this.wSpecifyFormat.getSelection());
        this.wlDateTimeFormat.setEnabled(this.wSpecifyFormat.getSelection());
        this.wAddDate.setEnabled(!this.wSpecifyFormat.getSelection());
        this.wlAddDate.setEnabled(!this.wSpecifyFormat.getSelection());
        this.wAddTime.setEnabled(!this.wSpecifyFormat.getSelection());
        this.wlAddTime.setEnabled(!this.wSpecifyFormat.getSelection());
        this.setDateTime();
    }

    private void setDateTime() {
        boolean enable = this.wAddDate.getSelection() || this.wAddTime.getSelection() || this.wSpecifyFormat.getSelection();
        this.wlAddOriginalTimestamp.setEnabled(enable);
        this.wAddOriginalTimestamp.setEnabled(enable);
    }

    public void afterUnZipActivate() {
        this.action.setChanged();
        if (this.wAfterUnZip.getSelectionIndex() == 2) {
            this.wMovetoDirectory.setEnabled(true);
            this.wlMovetoDirectory.setEnabled(true);
            this.wbMovetoDirectory.setEnabled(true);
            this.wCreateMoveToDirectory.setEnabled(true);
            this.wlCreateMoveToDirectory.setEnabled(true);
        } else {
            this.wMovetoDirectory.setEnabled(false);
            this.wlMovetoDirectory.setEnabled(false);
            this.wbMovetoDirectory.setEnabled(false);
            this.wCreateMoveToDirectory.setEnabled(false);
            this.wlCreateMoveToDirectory.setEnabled(false);
        }
    }

    private void activeSuccessCondition() {
        this.wlNrErrorsLessThan.setEnabled(this.wSuccessCondition.getSelectionIndex() != 0);
        this.wNrErrorsLessThan.setEnabled(this.wSuccessCondition.getSelectionIndex() != 0);
    }

    private void setArgdPrevious() {
        this.wlZipFilename.setEnabled(!this.wArgsPrevious.getSelection());
        this.wZipFilename.setEnabled(!this.wArgsPrevious.getSelection());
        this.wbZipFilename.setEnabled(!this.wArgsPrevious.getSelection());
        this.wbSourceDirectory.setEnabled(!this.wArgsPrevious.getSelection());
        this.wWildcardSource.setEnabled(!this.wArgsPrevious.getSelection());
        this.wlWildcardSource.setEnabled(!this.wArgsPrevious.getSelection());
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        this.wZipFilename.setText(Const.nullToEmpty((String)this.action.getZipFilename()));
        this.wWildcardSource.setText(Const.nullToEmpty((String)this.action.getWildcardSource()));
        this.wWildcard.setText(Const.nullToEmpty((String)this.action.getWildcard()));
        this.wWildcardExclude.setText(Const.nullToEmpty((String)this.action.getWildcardExclude()));
        this.wTargetDirectory.setText(Const.nullToEmpty((String)this.action.getSourceDirectory()));
        this.wMovetoDirectory.setText(Const.nullToEmpty((String)this.action.getMoveToDirectory()));
        if (this.action.afterunzip >= 0) {
            this.wAfterUnZip.select(this.action.afterunzip);
        } else {
            this.wAfterUnZip.select(0);
        }
        this.wAddFileToResult.setSelection(this.action.isAddFileToResult());
        this.wArgsPrevious.setSelection(this.action.getDatafromprevious());
        this.wAddDate.setSelection(this.action.isDateInFilename());
        this.wAddTime.setSelection(this.action.isTimeInFilename());
        this.wDateTimeFormat.setText(Const.nullToEmpty((String)this.action.getDateTimeFormat()));
        this.wSpecifyFormat.setSelection(this.action.isSpecifyFormat());
        this.wRootZip.setSelection(this.action.isCreateRootFolder());
        this.wCreateFolder.setSelection(this.action.isCreateFolder());
        this.wNrErrorsLessThan.setText(Const.NVL((String)this.action.getLimit(), (String)"10"));
        if (this.action.getSuccessCondition() != null) {
            if (this.action.getSuccessCondition().equals(this.action.SUCCESS_IF_AT_LEAST_X_FILES_UN_ZIPPED)) {
                this.wSuccessCondition.select(1);
            } else if (this.action.getSuccessCondition().equals(this.action.SUCCESS_IF_ERRORS_LESS)) {
                this.wSuccessCondition.select(2);
            } else {
                this.wSuccessCondition.select(0);
            }
        } else {
            this.wSuccessCondition.select(0);
        }
        this.wAddOriginalTimestamp.setSelection(this.action.isOriginalTimestamp());
        this.wSetModificationDateToOriginal.setSelection(this.action.isOriginalModificationDate());
        this.wIfFileExists.select(this.action.getIfFileExist());
        this.wCreateMoveToDirectory.setSelection(this.action.isCreateMoveToDirectory());
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setZipFilename(this.wZipFilename.getText());
        this.action.setWildcardSource(this.wWildcardSource.getText());
        this.action.setWildcard(this.wWildcard.getText());
        this.action.setWildcardExclude(this.wWildcardExclude.getText());
        this.action.setSourceDirectory(this.wTargetDirectory.getText());
        this.action.setMoveToDirectory(this.wMovetoDirectory.getText());
        this.action.afterunzip = this.wAfterUnZip.getSelectionIndex();
        this.action.setAddFileToResult(this.wAddFileToResult.getSelection());
        this.action.setDatafromprevious(this.wArgsPrevious.getSelection());
        this.action.setDateInFilename(this.wAddDate.getSelection());
        this.action.setTimeInFilename(this.wAddTime.getSelection());
        this.action.setSpecifyFormat(this.wSpecifyFormat.getSelection());
        this.action.setDateTimeFormat(this.wDateTimeFormat.getText());
        this.action.setCreateRootFolder(this.wRootZip.getSelection());
        this.action.setCreateFolder(this.wCreateFolder.getSelection());
        this.action.setLimit(this.wNrErrorsLessThan.getText());
        if (this.wSuccessCondition.getSelectionIndex() == 1) {
            this.action.setSuccessCondition(this.action.SUCCESS_IF_AT_LEAST_X_FILES_UN_ZIPPED);
        } else if (this.wSuccessCondition.getSelectionIndex() == 2) {
            this.action.setSuccessCondition(this.action.SUCCESS_IF_ERRORS_LESS);
        } else {
            this.action.setSuccessCondition(this.action.SUCCESS_IF_NO_ERRORS);
        }
        this.action.setIfFileExists(this.wIfFileExists.getSelectionIndex());
        this.action.setCreateMoveToDirectory(this.wCreateMoveToDirectory.getSelection());
        this.action.setAddOriginalTimestamp(this.wAddOriginalTimestamp.getSelection());
        this.action.setOriginalModificationDate(this.wSetModificationDateToOriginal.getSelection());
        this.dispose();
    }
}

