/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import javax.crypto.SecretKey;

public class KeyStoreHelper {
    private boolean signed;
    private URL pvtKeyStoreURL;
    private char[] pvtKeyStorePwd;
    private String pvtKeyAlias;
    private char[] pvtKeyPassword;
    private URL pubKeyStoreURL;
    private char[] pubKeyStorePwd;
    private URL pwdKeyStoreURL;
    private char[] pwdKeyStorePwd;
    private KeyStore pvtKeyStore;
    private KeyStore pubKeyStore;
    private KeyStore pwdKeyStore;

    KeyStoreHelper() {
        try {
            this.signed = Boolean.valueOf(System.getProperty("drools.serialization.sign", "false"));
            this.loadPrivateKeyStoreProperties();
            this.loadPublicKeyStoreProperties();
            this.loadPasswordKeyStoreProperties();
            this.initKeyStore();
        }
        catch (Exception e) {
            throw new RuntimeException("Error initialising KeyStore: " + e.getMessage(), e);
        }
    }

    public static KeyStoreHelper get() {
        return KeyStoreHelperHolder.INSTANCE;
    }

    public static void reInit() {
        KeyStoreHelperHolder.INSTANCE = new KeyStoreHelper();
    }

    private void loadPrivateKeyStoreProperties() throws MalformedURLException {
        String url = System.getProperty("drools.serialization.private.keyStoreURL", "");
        if (url.length() > 0) {
            this.pvtKeyStoreURL = new URL(url);
        }
        this.pvtKeyStorePwd = System.getProperty("drools.serialization.private.keyStorePwd", "").toCharArray();
        this.pvtKeyAlias = System.getProperty("drools.serialization.private.keyAlias", "");
        this.pvtKeyPassword = System.getProperty("drools.serialization.private.keyPwd", "").toCharArray();
    }

    private void loadPublicKeyStoreProperties() throws MalformedURLException {
        String url = System.getProperty("drools.serialization.public.keyStoreURL", "");
        if (url.length() > 0) {
            this.pubKeyStoreURL = new URL(url);
        }
        this.pubKeyStorePwd = System.getProperty("drools.serialization.public.keyStorePwd", "").toCharArray();
    }

    private void loadPasswordKeyStoreProperties() throws MalformedURLException {
        String url = System.getProperty("kie.keystore.keyStoreURL", "");
        if (url.length() > 0) {
            this.pwdKeyStoreURL = new URL(url);
        }
        this.pwdKeyStorePwd = System.getProperty("kie.keystore.keyStorePwd", "").toCharArray();
    }

    private void initKeyStore() throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException {
        if (this.pvtKeyStoreURL != null) {
            this.pvtKeyStore = this.loadKeystore("JKS", this.pvtKeyStoreURL, this.pvtKeyStorePwd);
        }
        if (this.pubKeyStoreURL != null) {
            this.pubKeyStore = this.loadKeystore("JKS", this.pubKeyStoreURL, this.pubKeyStorePwd);
        }
        if (this.pwdKeyStoreURL != null) {
            this.pwdKeyStore = this.loadKeystore("JCEKS", this.pwdKeyStoreURL, this.pwdKeyStorePwd);
        }
    }

    private KeyStore loadKeystore(String keyCertificateType, URL url, char[] password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(keyCertificateType);
        keyStore.load(url.openStream(), password);
        return keyStore;
    }

    public byte[] signDataWithPrivateKey(byte[] data) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (this.pvtKeyStore == null) {
            throw new RuntimeException("Key store with private key not configured. Please configure it properly before using signed serialization.");
        }
        PrivateKey pvtkey = (PrivateKey)this.pvtKeyStore.getKey(this.pvtKeyAlias, this.pvtKeyPassword);
        Signature sig = Signature.getInstance("MD5withRSA");
        sig.initSign(pvtkey);
        sig.update(data);
        return sig.sign();
    }

    public boolean checkDataWithPublicKey(String publicKeyAlias, byte[] data, byte[] signature) throws KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (this.pubKeyStore == null) {
            throw new RuntimeException("Key store with public key not configured. Please configure it properly before using signed serialization.");
        }
        Certificate cert = this.pubKeyStore.getCertificate(publicKeyAlias);
        if (cert == null) {
            throw new RuntimeException("Public certificate for key '" + publicKeyAlias + "' not found in the configured key store. Impossible to deserialize the object.");
        }
        Signature sig = Signature.getInstance("MD5withRSA");
        sig.initVerify(cert.getPublicKey());
        sig.update(data);
        return sig.verify(signature);
    }

    public String getPasswordKey(String pwdKeyAlias, char[] pwdKeyPassword) {
        SecretKey passwordKey;
        try {
            passwordKey = (SecretKey)this.pwdKeyStore.getKey(pwdKeyAlias, pwdKeyPassword);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load a key from Key Store. Source " + e.getCause());
        }
        return new String(passwordKey.getEncoded());
    }

    public boolean isSigned() {
        return this.signed;
    }

    public URL getPvtKeyStoreURL() {
        return this.pvtKeyStoreURL;
    }

    public char[] getPvtKeyStorePwd() {
        return this.pvtKeyStorePwd;
    }

    public String getPvtKeyAlias() {
        return this.pvtKeyAlias;
    }

    public char[] getPvtKeyPassword() {
        return this.pvtKeyPassword;
    }

    public URL getPubKeyStoreURL() {
        return this.pubKeyStoreURL;
    }

    public char[] getPubKeyStorePwd() {
        return this.pubKeyStorePwd;
    }

    public KeyStore getPvtKeyStore() {
        return this.pvtKeyStore;
    }

    public KeyStore getPubKeyStore() {
        return this.pubKeyStore;
    }

    private static class KeyStoreHelperHolder {
        private static KeyStoreHelper INSTANCE = new KeyStoreHelper();

        private KeyStoreHelperHolder() {
        }
    }
}

