/*
 * Decompiled with CFR 0.152.
 */
package cc.blynk.clickhouse.domain;

import java.util.regex.Pattern;

public enum ClickHouseFormat {
    TabSeparated,
    TabSeparatedRaw,
    TabSeparatedWithNames,
    TabSeparatedWithNamesAndTypes,
    CSV,
    CSVWithNames,
    Values,
    Vertical,
    JSON,
    JSONCompact,
    JSONEachRow,
    TSKV,
    Pretty,
    PrettyCompact,
    PrettyCompactMonoBlock,
    PrettyNoEscapes,
    PrettySpace,
    Protobuf,
    RowBinary,
    Native,
    Null,
    XML,
    CapnProto;

    private static final ClickHouseFormat[] values;
    private static final Pattern PRECOMPILED_PATTERN;

    public static ClickHouseFormat detectFormat(String statement) {
        if (statement != null && !statement.isEmpty()) {
            String s = PRECOMPILED_PATTERN.matcher(statement).replaceAll("");
            for (ClickHouseFormat format : values) {
                if (!s.endsWith(format.name())) continue;
                return format;
            }
        }
        return null;
    }

    static {
        values = ClickHouseFormat.values();
        PRECOMPILED_PATTERN = Pattern.compile("[;\\s]");
    }
}

