/*
 * Decompiled with CFR 0.152.
 */
package cc.blynk.clickhouse;

import cc.blynk.clickhouse.ClickHouseConnection;
import cc.blynk.clickhouse.ClickHouseExternalData;
import cc.blynk.clickhouse.ClickHousePreparedStatement;
import cc.blynk.clickhouse.ClickHousePreparedStatementParameter;
import cc.blynk.clickhouse.ClickHouseStatementImpl;
import cc.blynk.clickhouse.PreparedStatementParser;
import cc.blynk.clickhouse.domain.ClickHouseFormat;
import cc.blynk.clickhouse.http.HttpConnector;
import cc.blynk.clickhouse.settings.ClickHouseProperties;
import cc.blynk.clickhouse.settings.ClickHouseQueryParam;
import cc.blynk.clickhouse.util.ClickHouseArrayUtil;
import cc.blynk.clickhouse.util.ClickHouseValueFormatter;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ClickHousePreparedStatementImpl
extends ClickHouseStatementImpl
implements ClickHousePreparedStatement {
    static final String PARAM_MARKER = "?";
    private static final Pattern VALUES = Pattern.compile("(?i)VALUES[\\s]*\\(");
    private final TimeZone dateTimeZone;
    private final TimeZone dateTimeTimeZone;
    private final String sql;
    private final List<String> sqlParts;
    private final ClickHousePreparedStatementParameter[] binds;
    private final String[][] parameterList;
    private final List<byte[]> batchRows = new ArrayList<byte[]>();

    ClickHousePreparedStatementImpl(HttpConnector connector, ClickHouseConnection connection, ClickHouseProperties properties, String sql, TimeZone serverTimeZone, int resultSetType) {
        super(connector, connection, properties, resultSetType);
        this.sql = sql;
        PreparedStatementParser parser = PreparedStatementParser.parse(sql);
        this.parameterList = parser.getParameters();
        this.sqlParts = parser.getParts();
        int numParams = this.countNonConstantParams();
        this.binds = new ClickHousePreparedStatementParameter[numParams];
        this.dateTimeTimeZone = serverTimeZone;
        this.dateTimeZone = properties.isUseServerTimeZoneForDates() ? serverTimeZone : TimeZone.getDefault();
    }

    @Override
    public void clearParameters() {
        Arrays.fill(this.binds, null);
    }

    private String buildSql() throws SQLException {
        if (this.sqlParts.size() == 1) {
            return this.sqlParts.get(0);
        }
        this.checkBinded();
        StringBuilder sb = new StringBuilder(this.sqlParts.get(0));
        int p = 0;
        for (int i = 1; i < this.sqlParts.size(); ++i) {
            String pValue = this.getParameter(i - 1);
            if (PARAM_MARKER.equals(pValue)) {
                sb.append(this.binds[p++].getRegularValue());
            } else {
                sb.append(pValue);
            }
            sb.append(this.sqlParts.get(i));
        }
        return sb.toString();
    }

    private void checkBinded() throws SQLException {
        int i = 0;
        for (ClickHousePreparedStatementParameter b : this.binds) {
            ++i;
            if (b != null) continue;
            throw new SQLException("Not all parameters binded (placeholder " + i + " is undefined)");
        }
    }

    @Override
    public boolean execute() throws SQLException {
        return super.execute(this.buildSql());
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return super.executeQuery(this.buildSql());
    }

    @Override
    public void clearBatch() {
        this.batchRows.clear();
        this.clearParameters();
    }

    @Override
    public void close() throws SQLException {
        super.close();
        this.clearBatch();
    }

    @Override
    public ResultSet executeQuery(Map<ClickHouseQueryParam, String> additionalDBParams) throws SQLException {
        return super.executeQuery(this.buildSql(), additionalDBParams);
    }

    @Override
    public ResultSet executeQuery(Map<ClickHouseQueryParam, String> additionalDBParams, List<ClickHouseExternalData> externalData) throws SQLException {
        return super.executeQuery(this.buildSql(), additionalDBParams, externalData);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return super.executeUpdate(this.buildSql());
    }

    private void setBind(int parameterIndex, String bind, boolean quote) {
        this.setBind(parameterIndex, new ClickHousePreparedStatementParameter(bind, quote));
    }

    private void setBind(int parameterIndex, ClickHousePreparedStatementParameter parameter) {
        this.binds[parameterIndex - 1] = parameter;
    }

    private void setNull(int parameterIndex) {
        this.setBind(parameterIndex, ClickHousePreparedStatementParameter.NULL_PARAM);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setNull(parameterIndex);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setBind(parameterIndex, x ? ClickHousePreparedStatementParameter.TRUE_PARAM : ClickHousePreparedStatementParameter.FALSE_PARAM);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setBind(parameterIndex, ClickHouseValueFormatter.formatByte(x), false);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setBind(parameterIndex, ClickHouseValueFormatter.formatShort(x), false);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setBind(parameterIndex, ClickHouseValueFormatter.formatInt(x), false);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setBind(parameterIndex, ClickHouseValueFormatter.formatLong(x), false);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setBind(parameterIndex, ClickHouseValueFormatter.formatFloat(x), false);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setBind(parameterIndex, ClickHouseValueFormatter.formatDouble(x), false);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setBind(parameterIndex, ClickHouseValueFormatter.formatBigDecimal(x), false);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setBind(parameterIndex, ClickHouseValueFormatter.formatString(x), x != null);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setBind(parameterIndex, ClickHouseValueFormatter.formatBytes(x), true);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (x != null) {
            String bind = ClickHouseValueFormatter.formatDate(x, this.dateTimeZone);
            this.setBind(parameterIndex, bind, true);
        } else {
            this.setNull(parameterIndex);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (x != null) {
            String bind = ClickHouseValueFormatter.formatTime(x, this.dateTimeTimeZone);
            this.setBind(parameterIndex, bind, true);
        } else {
            this.setNull(parameterIndex);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (x != null) {
            String bind = ClickHouseValueFormatter.formatTimestamp(x, this.dateTimeTimeZone);
            this.setBind(parameterIndex, bind, true);
        } else {
            this.setNull(parameterIndex);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Collection collection) throws SQLException {
        this.setBind(parameterIndex, ClickHouseArrayUtil.toString(collection, this.dateTimeZone, this.dateTimeTimeZone), false);
    }

    @Override
    public void setArray(int parameterIndex, Object[] array) throws SQLException {
        this.setBind(parameterIndex, ClickHouseArrayUtil.toString(array, this.dateTimeZone, this.dateTimeTimeZone), false);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.setBind(parameterIndex, ClickHouseArrayUtil.arrayToString(x.getArray(), this.dateTimeZone, this.dateTimeTimeZone), false);
    }

    @Override
    public void setIn(int parameterIndex, int[] array) throws SQLException {
        this.setBind(parameterIndex, ClickHouseArrayUtil.buildCollectionString(array), false);
    }

    @Override
    public void setIn(int parameterIndex, long[] array) throws SQLException {
        this.setBind(parameterIndex, ClickHouseArrayUtil.buildCollectionString(array), false);
    }

    @Override
    public void setIn(int parameterIndex, Collection array) throws SQLException {
        this.setBind(parameterIndex, ClickHouseArrayUtil.buildCollectionString(array), false);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x != null) {
            String bind = ClickHouseValueFormatter.formatObject(x, this.dateTimeZone, this.dateTimeTimeZone);
            boolean needQuoting = ClickHouseValueFormatter.needsQuoting(x);
            ClickHousePreparedStatementParameter bindParam = new ClickHousePreparedStatementParameter(bind, needQuoting);
            this.setBind(parameterIndex, bindParam);
        } else {
            this.setNull(parameterIndex);
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkBinded();
        int p = 0;
        for (int i = 0; i < this.parameterList.length; ++i) {
            StringBuilder sb = new StringBuilder();
            String[] batchParams = this.parameterList[i];
            int batchParamsLength = batchParams.length;
            for (int j = 0; j < batchParamsLength; ++j) {
                String batchVal = batchParams[j];
                if (PARAM_MARKER.equals(batchVal)) {
                    ClickHousePreparedStatementParameter param = this.binds[p++];
                    batchVal = param.getBatchValue();
                }
                sb.append(batchVal);
                char appendChar = j < batchParamsLength - 1 ? (char)'\t' : '\n';
                sb.append(appendChar);
            }
            byte[] batchBytes = sb.toString().getBytes(StandardCharsets.UTF_8);
            this.batchRows.add(batchBytes);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.executeBatch(null);
    }

    @Override
    public int[] executeBatch(Map<ClickHouseQueryParam, String> additionalDBParams) throws SQLException {
        Matcher matcher = VALUES.matcher(this.sql);
        if (!matcher.find()) {
            throw new SQLSyntaxErrorException("Query must be like 'INSERT INTO [db.]table [(c1, c2, c3)] VALUES (?, ?, ?)'. Got: " + this.sql);
        }
        int valuePosition = matcher.start();
        String insertSql = this.sql.substring(0, valuePosition);
        URI uri = this.buildRequestUri(null, null, additionalDBParams, null, false);
        insertSql = insertSql + " FORMAT " + (Object)((Object)ClickHouseFormat.TabSeparated);
        this.httpConnector.post(insertSql, this.batchRows, uri);
        int[] result = new int[this.batchRows.size()];
        Arrays.fill(result, 1);
        this.batchRows.clear();
        return result;
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet currentResult = this.getResultSet();
        if (currentResult != null) {
            return currentResult.getMetaData();
        }
        if (!this.isSelect(this.sql)) {
            return null;
        }
        EnumMap<ClickHouseQueryParam, String> map = new EnumMap<ClickHouseQueryParam, String>(ClickHouseQueryParam.class);
        map.put(ClickHouseQueryParam.MAX_RESULT_ROWS, "0");
        ResultSet myRs = this.executeQuery(map);
        return myRs != null ? myRs.getMetaData() : null;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private int countNonConstantParams() {
        int count = 0;
        String[][] stringArray = this.parameterList;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] pList;
            for (String aPList : pList = stringArray[i]) {
                if (!PARAM_MARKER.equals(aPList)) continue;
                ++count;
            }
        }
        return count;
    }

    private String getParameter(int paramIndex) {
        int count = paramIndex;
        for (int i = 0; i < this.parameterList.length; ++i) {
            String[] pList = this.parameterList[i];
            if ((count -= pList.length) >= 0) continue;
            return pList[pList.length + count];
        }
        return null;
    }

    @Override
    public String asSql() {
        try {
            return this.buildSql();
        }
        catch (SQLException e) {
            return this.sql;
        }
    }
}

