/*
 * Decompiled with CFR 0.152.
 */
package cc.blynk.clickhouse;

import cc.blynk.clickhouse.ClickHouseConnection;
import cc.blynk.clickhouse.ClickHouseConnectionImpl;
import cc.blynk.clickhouse.ClickhouseJdbcUrlParser;
import cc.blynk.clickhouse.settings.ClickHouseConnectionSettings;
import cc.blynk.clickhouse.settings.ClickHouseProperties;
import cc.blynk.clickhouse.settings.ClickHouseQueryParam;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClickHouseDriver
implements Driver {
    private static final Logger logger = LoggerFactory.getLogger(ClickHouseDriver.class);

    @Override
    public ClickHouseConnection connect(String url, Properties info) {
        return this.connect(url, new ClickHouseProperties(info));
    }

    ClickHouseConnection connect(String url, ClickHouseProperties properties) {
        if (!this.acceptsURL(url)) {
            return null;
        }
        logger.debug("Creating connection");
        return new ClickHouseConnectionImpl(url, properties);
    }

    @Override
    public boolean acceptsURL(String url) {
        return url.startsWith("jdbc:clickhouse:");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        Properties properties;
        Properties copy = new Properties(info);
        try {
            properties = ClickhouseJdbcUrlParser.parse(url, copy).asProperties();
        }
        catch (Exception ex) {
            properties = copy;
            logger.error("could not parse url {}", (Object)url, (Object)ex);
        }
        ClickHouseQueryParam[] querySettings = ClickHouseQueryParam.values();
        ClickHouseConnectionSettings[] connectionSettings = ClickHouseConnectionSettings.values();
        DriverPropertyInfo[] result = new DriverPropertyInfo[querySettings.length + connectionSettings.length];
        int i = 0;
        for (ClickHouseQueryParam clickHouseQueryParam : querySettings) {
            result[i++] = clickHouseQueryParam.createDriverPropertyInfo(properties);
        }
        for (Enum enum_ : connectionSettings) {
            result[i++] = ((ClickHouseConnectionSettings)enum_).createDriverPropertyInfo(properties);
        }
        return result;
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        ClickHouseDriver driver = new ClickHouseDriver();
        try {
            DriverManager.registerDriver(driver);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        logger.info("Driver registered");
    }
}

