/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.workflow.delegates;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.gui.IGuiPosition;
import org.apache.hop.core.gui.IUndo;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.plugins.ActionPluginType;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.workflow.HopGuiWorkflowGraph;
import org.apache.hop.ui.workflow.actions.missing.MissingActionDialog;
import org.apache.hop.workflow.WorkflowHopMeta;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class HopGuiWorkflowActionDelegate {
    private static final Class<?> PKG = HopGui.class;
    private HopGui hopGui;
    private HopGuiWorkflowGraph workflowGraph;

    public HopGuiWorkflowActionDelegate(HopGui hopGui, HopGuiWorkflowGraph workflowGraph) {
        this.hopGui = hopGui;
        this.workflowGraph = workflowGraph;
    }

    public ActionMeta newAction(WorkflowMeta workflowMeta, String pluginId, String pluginName, boolean openIt, Point location) {
        PluginRegistry registry = PluginRegistry.getInstance();
        try {
            IPlugin actionPlugin = pluginId == null ? PluginRegistry.getInstance().findPluginWithName(ActionPluginType.class, pluginName) : PluginRegistry.getInstance().findPluginWithId(ActionPluginType.class, pluginId);
            if (actionPlugin != null) {
                Object actionName = pluginName;
                int nr = 2;
                ActionMeta check = workflowMeta.findAction((String)actionName);
                while (check != null) {
                    actionName = pluginName + " " + nr++;
                    check = workflowMeta.findAction((String)actionName);
                }
                IAction action = (IAction)registry.loadClass(actionPlugin);
                action.setPluginId(actionPlugin.getIds()[0]);
                action.setName((String)actionName);
                if (action.isStart() && workflowMeta.findStart() != null) {
                    HopGuiWorkflowGraph.showOnlyStartOnceMessage(this.hopGui.getShell());
                    return null;
                }
                if (openIt) {
                    IActionDialog d = this.getActionDialog(action, workflowMeta);
                    if (d != null && d.open() != null) {
                        ActionMeta actionMeta = new ActionMeta();
                        actionMeta.setAction(action);
                        if (location == null) {
                            location = new Point(50, 50);
                        }
                        PropsUi.setLocation((IGuiPosition)actionMeta, location.x, location.y);
                        workflowMeta.addAction(actionMeta);
                        workflowMeta.renameActionIfNameCollides(actionMeta);
                        this.hopGui.undoDelegate.addUndoNew((IUndo)workflowMeta, new ActionMeta[]{actionMeta}, new int[]{workflowMeta.indexOfAction(actionMeta)});
                        this.workflowGraph.adjustScrolling();
                        this.workflowGraph.updateGui();
                        return actionMeta;
                    }
                    return null;
                }
                ActionMeta actionMeta = new ActionMeta();
                actionMeta.setAction(action);
                if (location == null) {
                    location = new Point(50, 50);
                }
                PropsUi.setLocation((IGuiPosition)actionMeta, location.x, location.y);
                workflowMeta.addAction(actionMeta);
                this.hopGui.undoDelegate.addUndoNew((IUndo)workflowMeta, new ActionMeta[]{actionMeta}, new int[]{workflowMeta.indexOfAction(actionMeta)});
                this.workflowGraph.adjustScrolling();
                this.workflowGraph.updateGui();
                return actionMeta;
            }
            return null;
        }
        catch (Throwable e) {
            new ErrorDialog(this.hopGui.getShell(), BaseMessages.getString(PKG, (String)"HopGui.ErrorDialog.UnexpectedErrorCreatingNewJobGraphEntry.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGui.ErrorDialog.UnexpectedErrorCreatingNewJobGraphEntry.Message", (String[])new String[0]), new Exception(e));
            return null;
        }
    }

    public IActionDialog getActionDialog(IAction action, WorkflowMeta workflowMeta) {
        Class[] paramClasses = new Class[]{Shell.class, IAction.class, WorkflowMeta.class, IVariables.class};
        Object[] paramArgs = new Object[]{this.hopGui.getShell(), action, workflowMeta, this.workflowGraph.getVariables()};
        if ("MISSING".equals(action.getPluginId())) {
            return new MissingActionDialog(this.hopGui.getShell(), action, workflowMeta, this.workflowGraph.getVariables());
        }
        PluginRegistry registry = PluginRegistry.getInstance();
        IPlugin plugin = registry.getPlugin(ActionPluginType.class, (Object)action);
        Object dialogClassName = action.getDialogClassName();
        if (dialogClassName == null) {
            dialogClassName = action.getClass().getCanonicalName();
            dialogClassName = (String)dialogClassName + "Dialog";
            try {
                ClassLoader pluginClassLoader = registry.getClassLoader(plugin);
                String alternateName = ((String)dialogClassName).replaceFirst("\\.hop\\.", ".hop.ui.");
                Class<?> clazz = pluginClassLoader.loadClass(alternateName);
                dialogClassName = clazz.getName();
            }
            catch (Exception pluginClassLoader) {
                // empty catch block
            }
        }
        try {
            Class dialogClass = (Class)registry.getClass(plugin, (String)dialogClassName);
            Constructor dialogConstructor = dialogClass.getConstructor(paramClasses);
            IActionDialog entryDialogInterface = (IActionDialog)dialogConstructor.newInstance(paramArgs);
            entryDialogInterface.setMetadataProvider((IHopMetadataProvider)this.hopGui.getMetadataProvider());
            return entryDialogInterface;
        }
        catch (Throwable t) {
            t.printStackTrace();
            String errorTitle = BaseMessages.getString(PKG, (String)"HopGui.Dialog.ErrorCreatingWorkflowDialog.Title", (String[])new String[0]);
            String errorMsg = BaseMessages.getString(PKG, (String)"HopGui.Dialog.ErrorCreatingActionDialog.Message", (String[])new String[]{dialogClassName});
            this.hopGui.getLog().logError(errorMsg);
            new ErrorDialog(this.hopGui.getShell(), errorTitle, errorMsg, t);
            return null;
        }
    }

    public void editAction(WorkflowMeta workflowMeta, ActionMeta action) {
        block5: {
            try {
                this.hopGui.getLog().logDetailed(BaseMessages.getString(PKG, (String)"HopGui.Log.EditAction", (String[])new String[]{action.getName()}));
                ActionMeta before = (ActionMeta)action.cloneDeep();
                IAction jei = action.getAction();
                IActionDialog d = this.getActionDialog(jei, workflowMeta);
                if (d != null) {
                    if (d.open() != null) {
                        workflowMeta.renameActionIfNameCollides(action);
                        ActionMeta after = action.clone();
                        this.hopGui.undoDelegate.addUndoChange((IUndo)workflowMeta, new ActionMeta[]{before}, new ActionMeta[]{after}, new int[]{workflowMeta.indexOfAction(action)});
                    }
                    this.workflowGraph.updateGui();
                } else {
                    MessageBox mb = new MessageBox(this.hopGui.getShell(), 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"HopGui.Dialog.ActionCanNotBeChanged.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"HopGui.Dialog.ActionCanNotBeChanged.Title", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                if (this.hopGui.getShell().isDisposed()) break block5;
                new ErrorDialog(this.hopGui.getShell(), BaseMessages.getString(PKG, (String)"HopGui.ErrorDialog.ErrorEditingAction.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGui.ErrorDialog.ErrorEditingAction.Message", (String[])new String[0]), e);
            }
        }
    }

    public void deleteActions(WorkflowMeta workflow, List<ActionMeta> actions) {
        ArrayList<WorkflowHopMeta> workflowHops = new ArrayList<WorkflowHopMeta>();
        int[] hopIndexes = new int[workflow.nrWorkflowHops()];
        int hopIndex = 0;
        block0: for (int i = workflow.nrWorkflowHops() - 1; i >= 0; --i) {
            WorkflowHopMeta hi = workflow.getWorkflowHop(i);
            for (int j = 0; j < actions.size() && hopIndex < hopIndexes.length; ++j) {
                if (!hi.getFromAction().equals((Object)actions.get(j)) && !hi.getToAction().equals((Object)actions.get(j))) continue;
                int idx = workflow.indexOfWorkflowHop(hi);
                workflowHops.add(hi.clone());
                hopIndexes[hopIndex] = idx;
                workflow.removeWorkflowHop(idx);
                ++hopIndex;
                continue block0;
            }
        }
        if (!workflowHops.isEmpty()) {
            Object[] hops = workflowHops.toArray(new WorkflowHopMeta[workflowHops.size()]);
            this.hopGui.undoDelegate.addUndoDelete((IUndo)workflow, hops, hopIndexes);
        }
        int[] positions = new int[actions.size()];
        for (int i = 0; i < actions.size(); ++i) {
            int pos = workflow.indexOfAction(actions.get(i));
            workflow.removeAction(pos);
            positions[i] = pos;
        }
        this.hopGui.undoDelegate.addUndoDelete((IUndo)workflow, actions.toArray(new ActionMeta[0]), positions);
        this.workflowGraph.updateGui();
    }

    public void deleteAction(WorkflowMeta workflowMeta, ActionMeta action) {
        for (int i = workflowMeta.nrWorkflowHops() - 1; i >= 0; --i) {
            WorkflowHopMeta hi = workflowMeta.getWorkflowHop(i);
            if (!hi.getFromAction().equals((Object)action) && !hi.getToAction().equals((Object)action)) continue;
            int idx = workflowMeta.indexOfWorkflowHop(hi);
            this.hopGui.undoDelegate.addUndoDelete((IUndo)workflowMeta, new WorkflowHopMeta[]{hi.clone()}, new int[]{idx});
            workflowMeta.removeWorkflowHop(idx);
        }
        int pos = workflowMeta.indexOfAction(action);
        workflowMeta.removeAction(pos);
        this.hopGui.undoDelegate.addUndoDelete((IUndo)workflowMeta, new ActionMeta[]{action}, new int[]{pos});
        this.workflowGraph.updateGui();
    }

    public void dupeAction(WorkflowMeta workflowMeta, ActionMeta action) {
        if (action == null) {
            return;
        }
        if (action.isStart()) {
            MessageBox mb = new MessageBox(this.hopGui.getShell(), 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"HopGui.Dialog.OnlyUseStartOnce.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"HopGui.Dialog.OnlyUseStartOnce.Title", (String[])new String[0]));
            mb.open();
            return;
        }
        ActionMeta copyOfAction = action.clone();
        Point p = action.getLocation();
        PropsUi.setLocation((IGuiPosition)copyOfAction, p.x + 10, p.y + 10);
        copyOfAction.setLocation(p.x + 10, p.y + 10);
        workflowMeta.addAction(copyOfAction);
        this.workflowGraph.updateGui();
    }
}

