/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import org.apache.hop.core.Const;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EnterSearchDialog {
    private static final Class<?> PKG = EnterSearchDialog.class;
    private static final PropsUi props = PropsUi.getInstance();
    private Shell parentShell;
    private Shell shell;
    private boolean retval;
    private Display display;
    private boolean searchingTransforms;
    private boolean searchingDatabases;
    private boolean searchingNotes;
    private String filterString;
    private Button wTransform;
    private Button wDB;
    private Button wNote;
    private Text wFilter;

    public EnterSearchDialog(Shell parentShell) {
        this.parentShell = parentShell;
        this.display = parentShell.getDisplay();
        this.retval = true;
        this.searchingTransforms = true;
        this.searchingDatabases = true;
        this.searchingNotes = true;
    }

    public boolean open() {
        this.shell = new Shell(this.parentShell, 3312);
        props.setLook((Control)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        this.shell.setText(BaseMessages.getString(PKG, (String)"EnterSearchDialog.Shell.Title", (String[])new String[0]));
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        int middle = props.getMiddlePct();
        int margin = props.getMargin();
        Label wlTransform = new Label((Composite)this.shell, 131072);
        wlTransform.setText(BaseMessages.getString(PKG, (String)"EnterSearchDialog.Transform.Label", (String[])new String[0]));
        props.setLook((Control)wlTransform);
        FormData fdlTransform = new FormData();
        fdlTransform.left = new FormAttachment(0, 0);
        fdlTransform.top = new FormAttachment(0, 0);
        fdlTransform.right = new FormAttachment(middle, -margin);
        wlTransform.setLayoutData((Object)fdlTransform);
        this.wTransform = new Button((Composite)this.shell, 32);
        props.setLook((Control)this.wTransform);
        this.wTransform.setToolTipText(BaseMessages.getString(PKG, (String)"EnterSearchDialog.Transform.Tooltip", (String[])new String[0]));
        FormData fdTransform = new FormData();
        fdTransform.left = new FormAttachment(middle, 0);
        fdTransform.top = new FormAttachment(0, 0);
        fdTransform.right = new FormAttachment(100, 0);
        this.wTransform.setLayoutData((Object)fdTransform);
        Label wlDB = new Label((Composite)this.shell, 131072);
        wlDB.setText(BaseMessages.getString(PKG, (String)"EnterSearchDialog.DB.Label", (String[])new String[0]));
        props.setLook((Control)wlDB);
        FormData fdlDB = new FormData();
        fdlDB.left = new FormAttachment(0, 0);
        fdlDB.top = new FormAttachment((Control)this.wTransform, margin);
        fdlDB.right = new FormAttachment(middle, -margin);
        wlDB.setLayoutData((Object)fdlDB);
        this.wDB = new Button((Composite)this.shell, 32);
        props.setLook((Control)this.wDB);
        this.wDB.setToolTipText(BaseMessages.getString(PKG, (String)"EnterSearchDialog.DB.Tooltip", (String[])new String[0]));
        FormData fdDB = new FormData();
        fdDB.left = new FormAttachment(middle, 0);
        fdDB.top = new FormAttachment((Control)this.wTransform, margin);
        fdDB.right = new FormAttachment(100, 0);
        this.wDB.setLayoutData((Object)fdDB);
        Label wlNote = new Label((Composite)this.shell, 131072);
        wlNote.setText(BaseMessages.getString(PKG, (String)"EnterSearchDialog.Note.Label", (String[])new String[0]));
        props.setLook((Control)wlNote);
        FormData fdlNote = new FormData();
        fdlNote.left = new FormAttachment(0, 0);
        fdlNote.top = new FormAttachment((Control)this.wDB, margin);
        fdlNote.right = new FormAttachment(middle, -margin);
        wlNote.setLayoutData((Object)fdlNote);
        this.wNote = new Button((Composite)this.shell, 32);
        props.setLook((Control)this.wNote);
        this.wNote.setToolTipText(BaseMessages.getString(PKG, (String)"EnterSearchDialog.Note.Tooltip", (String[])new String[0]));
        FormData fdNote = new FormData();
        fdNote.left = new FormAttachment(middle, 0);
        fdNote.top = new FormAttachment((Control)this.wDB, margin);
        fdNote.right = new FormAttachment(100, 0);
        this.wNote.setLayoutData((Object)fdNote);
        Label wlFilter = new Label((Composite)this.shell, 131072);
        wlFilter.setText(BaseMessages.getString(PKG, (String)"EnterSearchDialog.FilterSelection.Label", (String[])new String[0]));
        props.setLook((Control)wlFilter);
        FormData fdlFilter = new FormData();
        fdlFilter.left = new FormAttachment(0, 0);
        fdlFilter.right = new FormAttachment(middle, -margin);
        fdlFilter.top = new FormAttachment((Control)this.wNote, 3 * margin);
        wlFilter.setLayoutData((Object)fdlFilter);
        this.wFilter = new Text((Composite)this.shell, 2052);
        props.setLook((Control)this.wFilter);
        FormData fdFilter = new FormData();
        fdFilter.left = new FormAttachment(middle, 0);
        fdFilter.top = new FormAttachment((Control)this.wNote, 3 * margin);
        fdFilter.right = new FormAttachment(100, 0);
        this.wFilter.setLayoutData((Object)fdFilter);
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterSearchDialog.this.ok();
            }
        });
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterSearchDialog.this.cancel();
            }
        });
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{wOk, wCancel}, props.getMargin(), (Control)this.wFilter);
        this.getData();
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.cancel());
        return this.retval;
    }

    private void getData() {
        this.wTransform.setSelection(this.searchingTransforms);
        this.wDB.setSelection(this.searchingDatabases);
        this.wNote.setSelection(this.searchingNotes);
        this.wFilter.setText(Const.NVL((String)this.filterString, (String)""));
        this.wFilter.setFocus();
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        props.setScreen(winprop);
        this.shell.dispose();
    }

    public void cancel() {
        this.retval = false;
        this.dispose();
    }

    public void ok() {
        this.retval = true;
        this.searchingTransforms = this.wTransform.getSelection();
        this.searchingDatabases = this.wDB.getSelection();
        this.searchingNotes = this.wNote.getSelection();
        this.filterString = this.wFilter.getText();
        this.dispose();
    }

    public boolean isSearchingTransforms() {
        return this.searchingTransforms;
    }

    public boolean isSearchingDatabases() {
        return this.searchingDatabases;
    }

    public boolean isSearchingNotes() {
        return this.searchingNotes;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }
}

