/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.metadata.serializer.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.encryption.ITwoWayPasswordEncoder;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.metadata.api.HopMetadataObject;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataObjectFactory;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.util.ReflectionUtil;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JsonMetadataParser<T extends IHopMetadata> {
    private Class<T> managedClass;
    private IHopMetadataProvider metadataProvider;

    public JsonMetadataParser(Class<T> managedClass, IHopMetadataProvider metadataProvider) {
        this.managedClass = managedClass;
        this.metadataProvider = metadataProvider;
    }

    public T loadJsonObject(Class<T> managedClass, JsonParser jsonParser) throws HopException {
        try {
            IHopMetadata object = (IHopMetadata)managedClass.newInstance();
            this.loadProperties(object, jsonParser);
            return (T)object;
        }
        catch (Exception e) {
            throw new HopException("Unable to load JSON object", e);
        }
    }

    private void loadProperties(Object object, JsonParser jsonParser) throws HopException {
        Class<?> objectClass = object.getClass();
        HashMap<String, Field> keyFieldMap = new HashMap<String, Field>();
        for (Field field : ReflectionUtil.findAllFields(objectClass)) {
            HopMetadataProperty metadataProperty = field.getAnnotation(HopMetadataProperty.class);
            if (metadataProperty == null) continue;
            String key = StringUtils.isNotEmpty((String)metadataProperty.key()) ? metadataProperty.key() : field.getName();
            keyFieldMap.put(key, field);
            Class<?> fieldType = field.getType();
            if (!Boolean.class.equals(fieldType) && !Boolean.TYPE.equals(fieldType)) continue;
            ReflectionUtil.setFieldValue(object, field.getName(), fieldType, metadataProperty.defaultBoolean());
        }
        try {
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                Field field;
                String key = jsonParser.getCurrentName();
                field = (Field)keyFieldMap.get(key);
                if (field == null) continue;
                this.loadProperty(object, jsonParser, key, field);
            }
        }
        catch (Exception e) {
            throw new HopException("Error loading fields for object class " + objectClass.getName(), e);
        }
    }

    private void loadProperty(Object object, JsonParser jsonParser, String key, Field field) throws HopException {
        Class<?> objectClass = object.getClass();
        Class<?> fieldType = field.getType();
        HopMetadataProperty metadataProperty = field.getAnnotation(HopMetadataProperty.class);
        try {
            jsonParser.nextToken();
            ArrayList<String> fieldValue = null;
            if ("null".equals(jsonParser.getText()) && jsonParser.getValueAsString() == null) {
                fieldValue = null;
            } else if (fieldType.isEnum()) {
                Class<?> enumerationClass = field.getType();
                String enumerationName = jsonParser.getText();
                if (StringUtils.isNotEmpty((String)enumerationName)) {
                    fieldValue = Enum.valueOf(enumerationClass, enumerationName);
                }
            } else if (String.class.equals(fieldType)) {
                String string = jsonParser.getText();
                if (metadataProperty.password()) {
                    string = this.metadataProvider.getTwoWayPasswordEncoder().decode(string, true);
                }
                fieldValue = string;
            } else if (Integer.TYPE.equals(fieldType) || Integer.class.equals(fieldType)) {
                fieldValue = jsonParser.getIntValue();
            } else if (Long.TYPE.equals(fieldType) || Long.class.equals(fieldType)) {
                fieldValue = jsonParser.getLongValue();
            } else if (Boolean.class.equals(fieldType) || Boolean.TYPE.equals(fieldType)) {
                fieldValue = jsonParser.getBooleanValue();
            } else if (Date.class.equals(fieldType)) {
                String dateString = jsonParser.getText();
                fieldValue = new SimpleDateFormat("yyyy/MM/dd'T'HH:mm:ss").parse(dateString);
            } else if (Map.class.equals(fieldType)) {
                HashMap<String, String> map = new HashMap<String, String>();
                while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    String mapKey = jsonParser.getText();
                    jsonParser.nextToken();
                    String mapValue = jsonParser.getText();
                    map.put(mapKey, mapValue);
                }
                fieldValue = map;
            } else if (List.class.equals(fieldType)) {
                ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
                Class listClass = (Class)parameterizedType.getActualTypeArguments()[0];
                if (String.class.equals((Object)listClass)) {
                    ArrayList<String> list = new ArrayList<String>();
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        list.add(jsonParser.getText());
                    }
                    fieldValue = list;
                } else {
                    IHopMetadataSerializer serializer = null;
                    if (metadataProperty.storeWithName()) {
                        if (!IHopMetadata.class.isAssignableFrom(listClass)) {
                            throw new HopException("Error: metadata objects that need to be stored with a name reference need to implement IHopMetadata: " + listClass.getName());
                        }
                        serializer = this.metadataProvider.getSerializer(listClass);
                    }
                    ArrayList<Object> list = new ArrayList<Object>();
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        if (metadataProperty.storeWithName()) {
                            String name = jsonParser.getText();
                            Object listObject = serializer.load(name);
                            list.add(listObject);
                            continue;
                        }
                        Object listObject = this.loadPojoProperties(listClass, jsonParser);
                        list.add(listObject);
                    }
                    fieldValue = list;
                }
            } else if (metadataProperty.storeWithName()) {
                if (!IHopMetadata.class.isAssignableFrom(fieldType)) {
                    throw new HopException("Error: metadata objects that need to be stored with a name reference need to implement IHopMetadata: " + fieldType.getName());
                }
                IHopMetadataSerializer<?> serializer = this.metadataProvider.getSerializer(fieldType);
                String name = jsonParser.getText();
                fieldValue = serializer.load(name);
            } else {
                fieldValue = this.loadPojoProperties(fieldType, jsonParser);
            }
            ReflectionUtil.setFieldValue(object, field.getName(), fieldType, fieldValue);
        }
        catch (Exception e) {
            throw new HopException("Error loading field with key '" + key + "' for field '" + field.getName() + " in class " + objectClass.getName(), e);
        }
    }

    private Object loadPojoProperties(Class<?> fieldType, JsonParser jsonParser) throws HopException {
        try {
            Object fieldValue;
            HopMetadataObject hopMetadataObject = fieldType.getAnnotation(HopMetadataObject.class);
            if (hopMetadataObject == null) {
                fieldValue = fieldType.newInstance();
                this.loadProperties(fieldValue, jsonParser);
            } else {
                jsonParser.nextToken();
                String fieldValueId = jsonParser.getText();
                IHopMetadataObjectFactory objectFactory = hopMetadataObject.objectFactory().newInstance();
                fieldValue = objectFactory.createObject(fieldValueId, null);
                this.loadProperties(fieldValue, jsonParser);
                jsonParser.nextToken();
            }
            return fieldValue;
        }
        catch (Exception e) {
            throw new HopException("Error loading POJO field '" + fieldType.getName() + "'", e);
        }
    }

    public JSONObject getJsonObject(T object) throws HopException {
        JSONObject jObject = new JSONObject();
        this.saveProperties(jObject, object, this.managedClass);
        return jObject;
    }

    private void saveProperties(JSONObject jObject, Object object, Class<?> objectClass) throws HopException {
        if (object == null) {
            return;
        }
        for (Field objectField : ReflectionUtil.findAllFields(object.getClass())) {
            HopMetadataProperty metadataProperty = objectField.getAnnotation(HopMetadataProperty.class);
            if (metadataProperty == null) continue;
            this.saveProperty(jObject, object, metadataProperty, objectField);
        }
    }

    private void saveProperty(JSONObject jObject, Object object, HopMetadataProperty metadataProperty, Field objectField) throws HopException {
        Class<?> fieldType;
        String key = objectField.getName();
        if (StringUtils.isNotEmpty((String)metadataProperty.key())) {
            key = metadataProperty.key();
        }
        boolean isBoolean = Boolean.class.equals(fieldType = objectField.getType()) || Boolean.TYPE.equals(fieldType);
        try {
            Object fieldValue = ReflectionUtil.getFieldValue(object, objectField.getName(), isBoolean);
            if (fieldValue == null) {
                jObject.put((Object)key, null);
            } else if (fieldType.isEnum()) {
                jObject.put((Object)key, (Object)((Enum)fieldValue).name());
            } else if (String.class.equals(fieldType)) {
                String fieldStringValue = (String)fieldValue;
                if (metadataProperty.password()) {
                    ITwoWayPasswordEncoder passwordEncoder = this.metadataProvider.getTwoWayPasswordEncoder();
                    fieldStringValue = passwordEncoder.encode(fieldStringValue, true);
                }
                jObject.put((Object)key, (Object)fieldStringValue);
            } else if (Integer.TYPE.equals(fieldType) || Integer.class.equals(fieldType)) {
                jObject.put((Object)key, fieldValue);
            } else if (Long.TYPE.equals(fieldType) || Long.class.equals(fieldType)) {
                jObject.put((Object)key, fieldValue);
            } else if (isBoolean) {
                jObject.put((Object)key, fieldValue);
            } else if (Date.class.equals(fieldType)) {
                String dateString = new SimpleDateFormat("yyyy/MM/dd'T'HH:mm:ss").format((Date)fieldValue);
                jObject.put((Object)key, (Object)dateString);
            } else if (Map.class.equals(fieldType)) {
                jObject.put((Object)key, (Object)new JSONObject((Map)fieldValue));
            } else if (List.class.equals(fieldType)) {
                JSONArray jListObjects = new JSONArray();
                ParameterizedType parameterizedType = (ParameterizedType)objectField.getGenericType();
                Class listClass = (Class)parameterizedType.getActualTypeArguments()[0];
                List fieldListObjects = (List)fieldValue;
                for (Object fieldListObject : fieldListObjects) {
                    if (String.class.equals((Object)listClass)) {
                        jListObjects.add(fieldListObject);
                        continue;
                    }
                    if (metadataProperty.storeWithName()) {
                        String name = ReflectionUtil.getObjectName(fieldListObject);
                        jListObjects.add((Object)name);
                        continue;
                    }
                    JSONObject jListObject = this.savePojoProperty(key, fieldListObject, listClass);
                    jListObjects.add((Object)jListObject);
                }
                jObject.put((Object)key, (Object)jListObjects);
            } else if (metadataProperty.storeWithName()) {
                String name = ReflectionUtil.getObjectName(fieldValue);
                jObject.put((Object)key, (Object)name);
            } else {
                JSONObject jPojo = this.savePojoProperty(key, fieldValue, fieldType);
                jObject.put((Object)key, (Object)jPojo);
            }
        }
        catch (Exception e) {
            throw new HopException("Error serializing field '" + objectField.getName() + "' with type '" + fieldType.toString() + "'", e);
        }
    }

    private JSONObject savePojoProperty(String key, Object fieldValue, Class<?> fieldType) throws HopException {
        try {
            JSONObject jPojoObject = new JSONObject();
            this.saveProperties(jPojoObject, fieldValue, fieldType);
            HopMetadataObject hopMetadataObject = fieldType.getAnnotation(HopMetadataObject.class);
            if (hopMetadataObject == null) {
                return jPojoObject;
            }
            IHopMetadataObjectFactory objectFactory = hopMetadataObject.objectFactory().newInstance();
            String fieldValueId = objectFactory.getObjectId(fieldValue);
            JSONObject jPojoBlock = new JSONObject();
            jPojoBlock.put((Object)fieldValueId, (Object)jPojoObject);
            return jPojoBlock;
        }
        catch (Exception e) {
            throw new HopException("Error saving POJO field with key " + key + ", field type '" + fieldType.getName() + "'", e);
        }
    }

    public IHopMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(IHopMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }
}

