/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss.abbvGapsHmm;

import com.wcohen.ss.abbvGapsHmm.AbbvGapsHMM;
import com.wcohen.ss.abbvGapsHmm.Acronym;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbbreviationAlignmentContainer<T extends Enum<T>, S extends Enum<S>> {
    private List<String> _lAlign;
    private List<String> _sAlign;
    private Double _bestProbability;
    private List<T> _emissionsPath;
    private List<S> _statesPath;
    private int _numDeletionsInAcronym = -1;
    private int _acronymScore = 0;

    AbbreviationAlignmentContainer(List<String> sAlign, List<String> lAlign, List<T> emissionsPath, List<S> statesPath, Double probability) {
        this._sAlign = sAlign;
        this._lAlign = lAlign;
        this._emissionsPath = emissionsPath;
        this._statesPath = statesPath;
        this._bestProbability = probability;
    }

    AbbreviationAlignmentContainer(List<String> sAlign, List<String> lAlign, List<T> emissionsPath, Double probability) {
        this._sAlign = sAlign;
        this._lAlign = lAlign;
        this._emissionsPath = emissionsPath;
        this._statesPath = null;
        this._bestProbability = probability;
    }

    public Double getProbability() {
        return this._bestProbability;
    }

    public List<String> getLAlign() {
        return this._lAlign;
    }

    public List<String> getSAlign() {
        return this._sAlign;
    }

    public List<T> retrunBestStates() {
        return this._emissionsPath;
    }

    protected String getStrByEmission(String str, T emission) {
        String out = str;
        if (AbbvGapsHMM.Emissions.e_END_end.equals(emission) || AbbvGapsHMM.Emissions.e_M_nonAlphaNumeric_to_none.equals(emission)) {
            out = "";
        } else if (AbbvGapsHMM.Emissions.e_M_partialWord_to_letter.equals(emission) || AbbvGapsHMM.Emissions.e_M_word_to_firstLetter.equals(emission)) {
            out = str.substring(0, 1);
        }
        if (AbbvGapsHMM.Emissions.e_M_AND_to_symbol.equals(emission)) {
            out = "&";
        }
        return out;
    }

    public Acronym getAcronym() {
        String sf = "";
        String lf = "";
        String preSF = "";
        String preLF = "";
        boolean started = false;
        int latestWordStart = -1;
        int numDeletions = 0;
        int score = 0;
        for (int i = 0; i < this._sAlign.size(); ++i) {
            String sPart = this._sAlign.get(i);
            String lPart = this._lAlign.get(i);
            Enum emission = (Enum)this._emissionsPath.get(i);
            if (!started && emission.name().contains("none")) {
                if (Character.isDigit(lPart.charAt(0))) {
                    latestWordStart = i;
                } else if (Character.isWhitespace(lPart.charAt(0)) || Character.isLetter(lPart.charAt(0))) {
                    latestWordStart = -1;
                    preSF = "";
                    preLF = "";
                    numDeletions = 0;
                    score = 0;
                }
                if (latestWordStart == -1) continue;
                preSF = preSF + sPart;
                preLF = preLF + lPart;
                if (emission.name().startsWith("e_D_") || emission.name().startsWith("e_DL_")) {
                    ++numDeletions;
                    --score;
                    continue;
                }
                if (!emission.name().startsWith("e_M_") && !emission.name().contains("word")) continue;
                ++score;
                continue;
            }
            started = true;
            if (emission.name().startsWith("e_D_") || emission.name().startsWith("e_DL_")) {
                ++numDeletions;
                --score;
            } else if (emission.name().startsWith("e_M_") && (emission.name().contains("word") || emission.name().contains("Word"))) {
                ++score;
            }
            sf = sf + sPart;
            lf = lf + lPart;
        }
        if (sf.isEmpty() || lf.isEmpty()) {
            return null;
        }
        if (sf.equalsIgnoreCase(lf)) {
            return null;
        }
        String finalSF = preSF + sf;
        String finalLF = preLF + lf;
        if (finalSF.length() == 1 && finalLF.indexOf(" ") != -1) {
            return null;
        }
        this._numDeletionsInAcronym = numDeletions;
        this._acronymScore = score;
        if (this._acronymScore < 0) {
            return null;
        }
        return new Acronym(finalSF, finalLF);
    }

    public int getAcronymScore() {
        return this._acronymScore;
    }

    public int getNumDeletionsInAcronym() {
        return this._numDeletionsInAcronym;
    }

    public String toString() {
        if (this._statesPath == null) {
            return this.toStringNoStates();
        }
        return this.toStringWithStates();
    }

    public String toStringNoStates() {
        String sFinal = "";
        String lFinal = "";
        for (int i = 0; i < this._sAlign.size(); ++i) {
            String sPart = this._sAlign.get(i);
            String lPart = this._lAlign.get(i);
            int maxLen = Math.max(sPart.length(), lPart.length());
            sFinal = sFinal + String.format("%-" + maxLen + "s", sPart) + "|";
            lFinal = lFinal + String.format("%-" + maxLen + "s", lPart) + "|";
        }
        return sFinal + "\n" + lFinal;
    }

    public String toStringWithStates() {
        String sFinal = "";
        String lFinal = "";
        String stateFinal = "";
        for (int i = 0; i < this._sAlign.size(); ++i) {
            String sPart = this._sAlign.get(i);
            String lPart = this._lAlign.get(i);
            String statePart = ((Enum)this._statesPath.get(i)).name();
            int maxLen = Math.max(sPart.length(), lPart.length());
            maxLen = Math.max(maxLen, statePart.length());
            stateFinal = stateFinal + String.format("%-" + maxLen + "s", statePart) + "|";
            sFinal = sFinal + String.format("%-" + maxLen + "s", sPart) + "|";
            lFinal = lFinal + String.format("%-" + maxLen + "s", lPart) + "|";
        }
        return stateFinal + "\n" + sFinal + "\n" + lFinal;
    }

    public String toStringWithEmissions() {
        String sFinal = "";
        String lFinal = "";
        String stateFinal = "";
        String emissionsFinal = "Emissions: ";
        for (int i = 0; i < this._sAlign.size(); ++i) {
            String sPart = this._sAlign.get(i);
            String lPart = this._lAlign.get(i);
            String statePart = ((Enum)this._statesPath.get(i)).name();
            String emissionPart = ((Enum)this._emissionsPath.get(i)).name();
            int maxLen = Math.max(sPart.length(), lPart.length());
            maxLen = Math.max(maxLen, statePart.length());
            emissionsFinal = emissionsFinal + emissionPart + "|";
            stateFinal = stateFinal + String.format("%-" + maxLen + "s", statePart) + "|";
            sFinal = sFinal + String.format("%-" + maxLen + "s", sPart) + "|";
            lFinal = lFinal + String.format("%-" + maxLen + "s", lPart) + "|";
        }
        return stateFinal + "\n" + sFinal + "\n" + lFinal + "\n\n" + emissionsFinal;
    }
}

