/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.StringUtils;
import org.apache.beam.runners.core.construction.SplittableParDo;
import org.apache.beam.runners.spark.SparkRunner;
import org.apache.beam.runners.spark.translation.EvaluationContext;
import org.apache.beam.runners.spark.translation.SparkPipelineTranslator;
import org.apache.beam.runners.spark.translation.TransformEvaluator;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;

public class SparkNativePipelineVisitor
extends SparkRunner.Evaluator {
    private final List<NativeTransform> transforms;
    private final List<String> knownCompositesPackages = Lists.newArrayList((Object[])new String[]{"org.apache.beam.sdk.transforms", "org.apache.beam.runners.spark.examples"});

    SparkNativePipelineVisitor(SparkPipelineTranslator translator, EvaluationContext ctxt) {
        super(translator, ctxt);
        this.transforms = new ArrayList<NativeTransform>();
    }

    @Override
    public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
        Pipeline.PipelineVisitor.CompositeBehavior compositeBehavior = super.enterCompositeTransform(node);
        PTransform transform = node.getTransform();
        if (transform != null) {
            Class<PTransform<?, ?>> transformClass = transform.getClass();
            if (compositeBehavior == Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM && !this.knownComposite(transformClass) && this.shouldDebug(node)) {
                this.transforms.add(new NativeTransform(node, null, transform, true));
            }
        }
        return compositeBehavior;
    }

    private boolean knownComposite(Class<PTransform<?, ?>> transform) {
        String transformPackage = transform.getPackage().getName();
        for (String knownCompositePackage : this.knownCompositesPackages) {
            if (!transformPackage.startsWith(knownCompositePackage)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldDebug(TransformHierarchy.Node node) {
        return node == null || this.transforms.stream().noneMatch(debugTransform -> debugTransform.getNode().equals(node) && debugTransform.isComposite()) && this.shouldDebug(node.getEnclosingNode());
    }

    @Override
    <TransformT extends PTransform<? super PInput, POutput>> void doVisitTransform(TransformHierarchy.Node node) {
        PTransform transform = node.getTransform();
        TransformEvaluator<PTransform> evaluator = this.translate(node, transform);
        if (this.shouldDebug(node)) {
            this.transforms.add(new NativeTransform(node, evaluator, transform, false));
        }
    }

    String getDebugString() {
        return Joiner.on((String)"\n").join(this.transforms);
    }

    private static class NativeTransform {
        private final TransformHierarchy.Node node;
        private final TransformEvaluator<?> transformEvaluator;
        private final PTransform<?, ?> transform;
        private final boolean composite;

        NativeTransform(TransformHierarchy.Node node, TransformEvaluator<?> transformEvaluator, PTransform<?, ?> transform, boolean composite) {
            this.node = node;
            this.transformEvaluator = transformEvaluator;
            this.transform = transform;
            this.composite = composite;
        }

        TransformHierarchy.Node getNode() {
            return this.node;
        }

        boolean isComposite() {
            return this.composite;
        }

        public String toString() {
            try {
                Class<?> transformClass = this.transform.getClass();
                if ("KafkaIO.Read".equals(this.node.getFullName())) {
                    return "KafkaUtils.createDirectStream(...)";
                }
                if (this.composite) {
                    return "_.<" + transformClass.getName() + ">";
                }
                String transformString = this.transformEvaluator.toNativeString();
                if (transformString.contains("<fn>")) {
                    transformString = this.replaceFnString(transformClass, transformString, "fn");
                } else if (transformString.contains("<windowFn>")) {
                    transformString = this.replaceFnString(transformClass, transformString, "windowFn");
                } else if (transformString.contains("<source>")) {
                    String sourceName = "...";
                    if (this.transform instanceof SplittableParDo.PrimitiveBoundedRead) {
                        sourceName = ((SplittableParDo.PrimitiveBoundedRead)this.transform).getSource().getClass().getName();
                    } else if (this.transform instanceof SplittableParDo.PrimitiveUnboundedRead) {
                        sourceName = ((SplittableParDo.PrimitiveUnboundedRead)this.transform).getSource().getClass().getName();
                    }
                    transformString = transformString.replace("<source>", sourceName);
                }
                if (transformString.startsWith("sparkContext") || transformString.startsWith("streamingContext")) {
                    return transformString;
                }
                return "_." + transformString;
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                return "<FailedTranslation>";
            }
        }

        private String replaceFnString(Class<? extends PTransform> transformClass, String transformString, String fnFieldName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, NoSuchFieldException {
            String doFnName;
            Object fn = transformClass.getMethod("get" + StringUtils.capitalize((String)fnFieldName), new Class[0]).invoke(this.transform, new Object[0]);
            Class<?> fnClass = fn.getClass();
            Class<?> enclosingClass = fnClass.getEnclosingClass();
            if (enclosingClass != null && enclosingClass.equals(MapElements.class)) {
                Field parent = fnClass.getDeclaredField("this$0");
                parent.setAccessible(true);
                Field fnField = enclosingClass.getDeclaredField(fnFieldName);
                fnField.setAccessible(true);
                doFnName = fnField.get(parent.get(fn)).getClass().getName();
            } else {
                doFnName = fnClass.getName();
            }
            transformString = transformString.replace("<" + fnFieldName + ">", doFnName);
            return transformString;
        }
    }
}

