/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.databasejoin;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaNone;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.databasejoin.DatabaseJoin;
import org.apache.hop.pipeline.transforms.databasejoin.DatabaseJoinData;
import org.apache.hop.pipeline.transforms.databasejoin.ParameterField;

@Transform(id="DBJoin", image="dbjoin.svg", name="i18n::DatabaseJoin.Name", description="i18n::DatabaseJoin.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Lookup", keywords={"i18n::DatabaseJoinMeta.keyword"}, documentationUrl="/pipeline/transforms/databasejoin.html")
public class DatabaseJoinMeta
extends BaseTransformMeta<DatabaseJoin, DatabaseJoinData> {
    private static final Class<?> PKG = DatabaseJoinMeta.class;
    @HopMetadataProperty(key="connection", injectionKeyDescription="DatabaseJoinMeta.Injection.Connection")
    private String connection;
    @HopMetadataProperty(key="sql", injectionKeyDescription="DatabaseJoinMeta.Injection.SQL")
    private String sql;
    @HopMetadataProperty(key="rowlimit", injectionKeyDescription="DatabaseJoinMeta.Injection.RowLimit")
    private int rowLimit;
    @HopMetadataProperty(key="outer_join", injectionKeyDescription="DatabaseJoinMeta.Injection.OuterJoin")
    private boolean outerJoin;
    @HopMetadataProperty(key="field", groupKey="parameter", injectionGroupDescription="DatabaseJoinMeta.Injection.Parameters", injectionKeyDescription="DatabaseJoinMeta.Injection.Field")
    private List<ParameterField> parameters = new ArrayList<ParameterField>();
    @HopMetadataProperty(key="replace_vars", injectionKeyDescription="DatabaseJoinMeta.Injection.ReplaceVariables")
    private boolean replaceVariables;

    public DatabaseJoinMeta() {
    }

    public DatabaseJoinMeta(DatabaseJoinMeta clone) {
        this.connection = clone.connection;
        this.sql = clone.sql;
        this.rowLimit = clone.rowLimit;
        this.outerJoin = clone.outerJoin;
        this.replaceVariables = clone.replaceVariables;
        for (ParameterField field : clone.parameters) {
            this.parameters.add(new ParameterField(field));
        }
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public boolean isOuterJoin() {
        return this.outerJoin;
    }

    public void setOuterJoin(boolean outerJoin) {
        this.outerJoin = outerJoin;
    }

    public boolean isReplaceVariables() {
        return this.replaceVariables;
    }

    public void setReplaceVariables(boolean enabled) {
        this.replaceVariables = enabled;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public Object clone() {
        return new DatabaseJoinMeta(this);
    }

    public void setDefault() {
        this.rowLimit = 0;
        this.sql = "";
        this.outerJoin = false;
        this.replaceVariables = false;
        this.parameters = new ArrayList<ParameterField>();
    }

    public IRowMeta getParameterRow(IRowMeta fields) {
        RowMeta param = new RowMeta();
        if (fields != null) {
            for (ParameterField field : this.parameters) {
                IValueMeta valueMeta = fields.searchValueMeta(field.getName());
                if (valueMeta == null) continue;
                param.addValueMeta(valueMeta);
            }
        }
        return param;
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.connection == null) {
            return;
        }
        DatabaseMeta databaseMeta = null;
        try {
            databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
        }
        catch (HopException e) {
            throw new HopTransformException("Unable to get databaseMeta for connection: " + Const.CR + variables.resolve(this.connection), (Throwable)e);
        }
        Database db = new Database(loggingObject, variables, databaseMeta);
        this.databases = new Database[]{db};
        IRowMeta param = this.getParameterRow(row);
        IRowMeta add = null;
        try {
            add = db.getQueryFields(variables.resolve(this.sql), true, param, new Object[param.size()]);
        }
        catch (HopDatabaseException dbe) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.Exception.UnableToDetermineQueryFields", (String[])new String[0]) + Const.CR + this.sql, (Throwable)dbe);
        }
        if (add != null) {
            for (int i = 0; i < add.size(); ++i) {
                IValueMeta v = add.getValueMeta(i);
                v.setOrigin(name);
            }
            row.addRowMeta(add);
        } else {
            try {
                db.connect();
                add = db.getQueryFields(variables.resolve(this.sql), true, param, new Object[param.size()]);
                for (int i = 0; i < add.size(); ++i) {
                    IValueMeta v = add.getValueMeta(i);
                    v.setOrigin(name);
                }
                row.addRowMeta(add);
                db.disconnect();
            }
            catch (HopDatabaseException dbe) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.Exception.ErrorObtainingFields", (String[])new String[0]), (Throwable)dbe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        Object errorMessage = "";
        DatabaseMeta databaseMeta = null;
        try {
            databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
        }
        catch (HopException e) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.DatabaseMetaError", (String[])new String[]{variables.resolve(this.connection)}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (databaseMeta != null) {
            Database db = new Database(loggingObject, variables, databaseMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                if (this.sql != null && this.sql.length() != 0) {
                    IRowMeta param = this.getParameterRow(prev);
                    errorMessage = "";
                    IRowMeta r = db.getQueryFields(variables.resolve(this.sql), true, param, new Object[param.size()]);
                    if (r != null) {
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.QueryOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    } else {
                        errorMessage = BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.InvalidDBQuery", (String[])new String[0]);
                        cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    }
                    int q = db.countParameters(variables.resolve(this.sql));
                    if (q != this.parameters.size()) {
                        errorMessage = BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.DismatchBetweenParametersAndQuestion", (String[])new String[0]) + Const.CR;
                        errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.DismatchBetweenParametersAndQuestion2", (String[])new String[0]) + q + Const.CR;
                        errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.DismatchBetweenParametersAndQuestion3", (String[])new String[0]) + this.parameters.size();
                        cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    } else {
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.NumberOfParamCorrect", (String[])new String[0]) + q + ")", (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    boolean first = true;
                    errorMessage = "";
                    boolean errorFound = false;
                    for (ParameterField field : this.parameters) {
                        IValueMeta v = prev.searchValueMeta(field.getName());
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.MissingFields", (String[])new String[0]) + Const.CR;
                        }
                        errorFound = true;
                        errorMessage = (String)errorMessage + "\t\t" + field.getName() + Const.CR;
                    }
                    cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                errorMessage = BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.CounldNotReadFields", (String[])new String[0]) + Const.CR;
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopException e) {
                errorMessage = BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.ErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.ReceivingInfo", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRowMeta getTableFields(IVariables variables) {
        DatabaseMeta databaseMeta = this.getParentTransformMeta().getParentPipelineMeta().findDatabase(this.connection, variables);
        RowMeta param = new RowMeta();
        for (ParameterField field : this.parameters) {
            ValueMetaNone v;
            try {
                int id = ValueMetaFactory.getIdForValueMeta((String)field.getType());
                v = ValueMetaFactory.createValueMeta((String)field.getName(), (int)id);
            }
            catch (HopPluginException e) {
                v = new ValueMetaNone(field.getName());
            }
            param.addValueMeta((IValueMeta)v);
        }
        IRowMeta fields = null;
        if (databaseMeta != null) {
            Database db = new Database(loggingObject, variables, databaseMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                fields = db.getQueryFields(variables.resolve(this.sql), true, (IRowMeta)param, new Object[param.size()]);
            }
            catch (HopDatabaseException dbe) {
                this.logError(BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.Log.DatabaseErrorOccurred", (String[])new String[0]) + dbe.getMessage());
            }
            finally {
                db.disconnect();
            }
        }
        return fields;
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
        IRowMeta out = prev.clone();
        this.getFields(out, transformMeta.getName(), new IRowMeta[]{info}, null, variables, metadataProvider);
        try {
            DatabaseMeta databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
            if (out != null) {
                for (int i = 0; i < out.size(); ++i) {
                    IValueMeta outvalue = out.getValueMeta(i);
                    DatabaseImpact di = new DatabaseImpact(1, pipelineMeta.getName(), transformMeta.getName(), databaseMeta.getDatabaseName(), "", outvalue.getName(), outvalue.getName(), transformMeta.getName(), variables.resolve(this.sql), BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.DatabaseImpact.Title", (String[])new String[0]));
                    impact.add(di);
                }
            }
        }
        catch (HopException e) {
            throw new HopTransformException("Unable to get databaseMeta for connection: " + Const.CR + variables.resolve(this.connection), (Throwable)e);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public List<ParameterField> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ParameterField> parameters) {
        this.parameters = parameters;
    }
}

