/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.concurrent.TimeUnit;
import org.apache.beam.runners.direct.Clock;
import org.joda.time.Instant;

class NanosOffsetClock
implements Clock {
    private final long baseMillis = System.currentTimeMillis();
    private final long nanosAtBaseMillis = System.nanoTime();

    public static NanosOffsetClock create() {
        return new NanosOffsetClock();
    }

    private NanosOffsetClock() {
    }

    @Override
    public Instant now() {
        return new Instant(this.baseMillis + TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.nanosAtBaseMillis, TimeUnit.NANOSECONDS));
    }
}

