/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.ClientProto;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.compute.ComputeCredential;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.util.CredentialAdapter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import com.google.storage.v2.StorageGrpc;
import com.google.storage.v2.StorageProto;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import io.grpc.alts.GoogleDefaultChannelBuilder;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.stub.AbstractStub;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

class StorageStubProvider {
    private static final double GRPC_MAX_RETRY_ATTEMPTS = 10.0;
    private static final ImmutableSet<Status.Code> STUB_BROKEN_ERROR_CODES = ImmutableSet.of((Object)Status.Code.DEADLINE_EXCEEDED, (Object)Status.Code.UNAVAILABLE);
    private static final String DEFAULT_GCS_GRPC_SERVER_ADDRESS = (String)StorageProto.getDescriptor().findServiceByName("Storage").getOptions().getExtension(ClientProto.defaultHost);
    private final GoogleCloudStorageReadOptions readOptions;
    private final String userAgent;
    private final ExecutorService backgroundTasksThreadPool;
    private final GrpcDecorator grpcDecorator;
    private ManagedChannel channel;

    @VisibleForTesting
    GrpcDecorator getGrpcDecorator() {
        return this.grpcDecorator;
    }

    StorageStubProvider(GoogleCloudStorageOptions options, ExecutorService backgroundTasksThreadPool, GrpcDecorator grpcDecorator) {
        this.readOptions = options.getReadChannelOptions();
        this.userAgent = options.getAppName();
        this.backgroundTasksThreadPool = backgroundTasksThreadPool;
        this.grpcDecorator = (GrpcDecorator)Preconditions.checkNotNull((Object)grpcDecorator, (Object)"grpcDecorator cannot be null");
    }

    private ManagedChannel buildManagedChannel() {
        String target = Strings.isNullOrEmpty((String)this.readOptions.getGrpcServerAddress()) ? DEFAULT_GCS_GRPC_SERVER_ADDRESS : this.readOptions.getGrpcServerAddress();
        ManagedChannel channel = this.grpcDecorator.createChannelBuilder(target).enableRetry().userAgent(this.userAgent).build();
        return channel;
    }

    public static boolean isStubBroken(Status.Code statusCode) {
        return STUB_BROKEN_ERROR_CODES.contains((Object)statusCode);
    }

    public StorageGrpc.StorageBlockingStub newBlockingStub() {
        StorageGrpc.StorageBlockingStub stub = StorageGrpc.newBlockingStub((Channel)this.getManagedChannel());
        return (StorageGrpc.StorageBlockingStub)this.grpcDecorator.applyCallOption((AbstractStub<?>)stub);
    }

    public StorageGrpc.StorageStub newAsyncStub() {
        StorageGrpc.StorageStub stub = (StorageGrpc.StorageStub)StorageGrpc.newStub((Channel)this.getManagedChannel()).withExecutor((Executor)this.backgroundTasksThreadPool);
        return (StorageGrpc.StorageStub)this.grpcDecorator.applyCallOption((AbstractStub<?>)stub);
    }

    private synchronized ManagedChannel getManagedChannel() {
        if (this.channel == null) {
            this.channel = this.buildManagedChannel();
        }
        return this.channel;
    }

    public void shutdown() {
        this.channel.shutdownNow();
    }

    public static StorageStubProvider newInstance(GoogleCloudStorageOptions options, ExecutorService backgroundTasksThreadPool, Credential credential) {
        boolean useDirectpath = options.isDirectPathPreffered() && credential != null && Objects.equals(credential.getTokenServerEncodedUrl(), ComputeCredential.TOKEN_SERVER_ENCODED_URL);
        return new StorageStubProvider(options, backgroundTasksThreadPool, useDirectpath ? new DirectPathGrpcDecorator(options.getReadChannelOptions()) : new CloudPathGrpcDecorator((Credentials)new CredentialAdapter(credential)));
    }

    public static StorageStubProvider newInstance(GoogleCloudStorageOptions options, ExecutorService backgroundTasksThreadPool, Credentials credentials) {
        boolean useDirectpath = options.isDirectPathPreffered() && credentials instanceof ComputeEngineCredentials;
        return new StorageStubProvider(options, backgroundTasksThreadPool, useDirectpath ? new DirectPathGrpcDecorator(options.getReadChannelOptions()) : new CloudPathGrpcDecorator(credentials));
    }

    static class DirectPathGrpcDecorator
    implements GrpcDecorator {
        private final GoogleCloudStorageReadOptions readOptions;

        DirectPathGrpcDecorator(GoogleCloudStorageReadOptions readOptions) {
            this.readOptions = readOptions;
        }

        @Override
        public ManagedChannelBuilder<?> createChannelBuilder(String target) {
            return GoogleDefaultChannelBuilder.forTarget((String)target).defaultServiceConfig(this.getGrpcServiceConfig());
        }

        @Override
        public AbstractStub<?> applyCallOption(AbstractStub<?> stub) {
            return stub;
        }

        private Map<String, Object> getGrpcServiceConfig() {
            ImmutableMap name = ImmutableMap.of((Object)"service", (Object)"google.storage.v1.Storage");
            ImmutableMap retryPolicy = ImmutableMap.builder().put((Object)"maxAttempts", (Object)10.0).put((Object)"initialBackoff", (Object)Durations.toString((Duration)Durations.fromMillis((long)this.readOptions.getBackoffInitialIntervalMillis()))).put((Object)"maxBackoff", (Object)Durations.toString((Duration)Durations.fromMillis((long)this.readOptions.getBackoffMaxIntervalMillis()))).put((Object)"backoffMultiplier", (Object)this.readOptions.getBackoffMultiplier()).put((Object)"retryableStatusCodes", (Object)ImmutableList.of((Object)"UNAVAILABLE", (Object)"RESOURCE_EXHAUSTED")).build();
            ImmutableMap methodConfig = ImmutableMap.of((Object)"name", (Object)ImmutableList.of((Object)name), (Object)"retryPolicy", (Object)retryPolicy);
            ImmutableMap childLbStrategy = ImmutableMap.of((Object)"round_robin", (Object)ImmutableMap.of());
            ImmutableMap childPolicy = ImmutableMap.of((Object)"childPolicy", (Object)ImmutableList.of((Object)childLbStrategy));
            ImmutableMap grpcLbPolicy = ImmutableMap.of((Object)"grpclb", (Object)childPolicy);
            return ImmutableMap.of((Object)"methodConfig", (Object)ImmutableList.of((Object)methodConfig), (Object)"loadBalancingConfig", (Object)ImmutableList.of((Object)grpcLbPolicy));
        }
    }

    static class CloudPathGrpcDecorator
    implements GrpcDecorator {
        private final Credentials credentials;

        CloudPathGrpcDecorator(Credentials credentials) {
            this.credentials = credentials;
        }

        @Override
        public ManagedChannelBuilder<?> createChannelBuilder(String target) {
            return ManagedChannelBuilder.forTarget((String)target);
        }

        @Override
        public AbstractStub<?> applyCallOption(AbstractStub<?> stub) {
            return stub.withCallCredentials(MoreCallCredentials.from((Credentials)this.credentials));
        }
    }

    static interface GrpcDecorator {
        public ManagedChannelBuilder<?> createChannelBuilder(String var1);

        public AbstractStub<?> applyCallOption(AbstractStub<?> var1);
    }
}

