/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.rowgenerator;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.rowgenerator.GeneratorField;
import org.apache.hop.pipeline.transforms.rowgenerator.RowGeneratorData;
import org.apache.hop.pipeline.transforms.rowgenerator.RowGeneratorMeta;

public class RowGenerator
extends BaseTransform<RowGeneratorMeta, RowGeneratorData> {
    private static final Class<?> PKG = RowGeneratorMeta.class;

    public RowGenerator(TransformMeta transformMeta, RowGeneratorMeta meta, RowGeneratorData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public static final RowMetaAndData buildRow(RowGeneratorMeta meta, List<ICheckResult> remarks, String origin) throws HopPluginException {
        RowMeta rowMeta = new RowMeta();
        Object[] rowData = RowDataUtil.allocateRowData((int)(meta.getFields().size() + 2));
        int index = 0;
        if (meta.isNeverEnding()) {
            if (!Utils.isEmpty((CharSequence)meta.getRowTimeField())) {
                rowMeta.addValueMeta((IValueMeta)new ValueMetaDate(meta.getRowTimeField()));
                rowData[index++] = null;
            }
            if (!Utils.isEmpty((CharSequence)meta.getLastTimeField())) {
                rowMeta.addValueMeta((IValueMeta)new ValueMetaDate(meta.getLastTimeField()));
                rowData[index++] = null;
            }
        }
        for (GeneratorField field : meta.getFields()) {
            int typeString = ValueMetaFactory.getIdForValueMeta((String)field.getType());
            if (!StringUtils.isNotEmpty((String)field.getType())) continue;
            IValueMeta valueMeta = ValueMetaFactory.createValueMeta((String)field.getName(), (int)typeString);
            valueMeta.setLength(field.getLength());
            valueMeta.setPrecision(field.getPrecision());
            valueMeta.setConversionMask(field.getFormat());
            valueMeta.setCurrencySymbol(field.getCurrency());
            valueMeta.setGroupingSymbol(field.getGroup());
            valueMeta.setDecimalSymbol(field.getDecimal());
            valueMeta.setOrigin(origin);
            IValueMeta stringMeta = ValueMetaFactory.cloneValueMeta((IValueMeta)valueMeta, (int)2);
            if (field.isSetEmptyString()) {
                rowData[index] = "";
            } else {
                String stringValue = field.getValue();
                if (Utils.isEmpty((CharSequence)stringValue)) {
                    rowData[index] = null;
                    if (valueMeta.getType() == 0) {
                        String message = BaseMessages.getString(PKG, (String)"RowGenerator.CheckResult.SpecifyTypeError", (String[])new String[]{valueMeta.getName(), stringValue});
                        remarks.add((ICheckResult)new CheckResult(4, message, null));
                    }
                } else {
                    try {
                        rowData[index] = valueMeta.convertData(stringMeta, (Object)stringValue);
                    }
                    catch (HopValueException e) {
                        switch (valueMeta.getType()) {
                            case 1: {
                                String message = BaseMessages.getString(PKG, (String)"RowGenerator.BuildRow.Error.Parsing.Number", (String[])new String[]{valueMeta.getName(), stringValue, e.toString()});
                                remarks.add((ICheckResult)new CheckResult(4, message, null));
                                break;
                            }
                            case 3: {
                                String message = BaseMessages.getString(PKG, (String)"RowGenerator.BuildRow.Error.Parsing.Date", (String[])new String[]{valueMeta.getName(), stringValue, e.toString()});
                                remarks.add((ICheckResult)new CheckResult(4, message, null));
                                break;
                            }
                            case 5: {
                                String message = BaseMessages.getString(PKG, (String)"RowGenerator.BuildRow.Error.Parsing.Integer", (String[])new String[]{valueMeta.getName(), stringValue, e.toString()});
                                remarks.add((ICheckResult)new CheckResult(4, message, null));
                                break;
                            }
                            case 6: {
                                String message = BaseMessages.getString(PKG, (String)"RowGenerator.BuildRow.Error.Parsing.BigNumber", (String[])new String[]{valueMeta.getName(), stringValue, e.toString()});
                                remarks.add((ICheckResult)new CheckResult(4, message, null));
                                break;
                            }
                            case 9: {
                                String message = BaseMessages.getString(PKG, (String)"RowGenerator.BuildRow.Error.Parsing.Timestamp", (String[])new String[]{valueMeta.getName(), stringValue, e.toString()});
                                remarks.add((ICheckResult)new CheckResult(4, message, null));
                                break;
                            }
                            default: {
                                String message = BaseMessages.getString(PKG, (String)"RowGenerator.CheckResult.SpecifyTypeError", (String[])new String[]{valueMeta.getName(), stringValue});
                                remarks.add((ICheckResult)new CheckResult(4, message, null));
                            }
                        }
                    }
                }
            }
            rowMeta.addValueMeta(valueMeta);
            ++index;
        }
        return new RowMetaAndData((IRowMeta)rowMeta, rowData);
    }

    public synchronized boolean processRow() throws HopException {
        Object[] r = null;
        boolean retval = true;
        if (this.first) {
            this.first = false;
            this.getRow();
        } else if (((RowGeneratorMeta)this.meta).isNeverEnding() && ((RowGeneratorData)this.data).delay > 0L) {
            try {
                Thread.sleep(((RowGeneratorData)this.data).delay);
            }
            catch (InterruptedException e) {
                throw new HopException((Throwable)e);
            }
        }
        if (!((RowGeneratorMeta)this.meta).isNeverEnding() && ((RowGeneratorData)this.data).rowsWritten >= ((RowGeneratorData)this.data).rowLimit || this.isStopped()) {
            this.setOutputDone();
            return false;
        }
        r = ((RowGeneratorData)this.data).outputRowMeta.cloneRow(((RowGeneratorData)this.data).outputRowData);
        if (((RowGeneratorMeta)this.meta).isNeverEnding()) {
            ((RowGeneratorData)this.data).prevDate = ((RowGeneratorData)this.data).rowDate;
            ((RowGeneratorData)this.data).rowDate = new Date();
            int index = 0;
            if (!Utils.isEmpty((CharSequence)((RowGeneratorMeta)this.meta).getRowTimeField())) {
                r[index++] = ((RowGeneratorData)this.data).rowDate;
            }
            if (!Utils.isEmpty((CharSequence)((RowGeneratorMeta)this.meta).getLastTimeField())) {
                r[index++] = ((RowGeneratorData)this.data).prevDate;
            }
        }
        this.putRow(((RowGeneratorData)this.data).outputRowMeta, r);
        ++((RowGeneratorData)this.data).rowsWritten;
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"RowGenerator.Log.Wrote.Row", (String[])new String[]{Long.toString(((RowGeneratorData)this.data).rowsWritten), ((RowGeneratorData)this.data).outputRowMeta.getString(r)}));
        }
        if (this.checkFeedback(((RowGeneratorData)this.data).rowsWritten) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"RowGenerator.Log.LineNr", (String[])new String[]{Long.toString(((RowGeneratorData)this.data).rowsWritten)}));
        }
        return retval;
    }

    public boolean init() {
        try {
            if (super.init()) {
                ((RowGeneratorData)this.data).rowLimit = Const.toLong((String)this.resolve(((RowGeneratorMeta)this.meta).getRowLimit()), (long)-1L);
                ((RowGeneratorData)this.data).rowsWritten = 0L;
                ((RowGeneratorData)this.data).delay = Const.toLong((String)this.resolve(((RowGeneratorMeta)this.meta).getIntervalInMs()), (long)-1L);
                if (((RowGeneratorData)this.data).rowLimit < 0L) {
                    this.logError(BaseMessages.getString(PKG, (String)"RowGenerator.Wrong.RowLimit.Number", (String[])new String[0]));
                    return false;
                }
                ArrayList<ICheckResult> remarks = new ArrayList<ICheckResult>();
                RowMetaAndData outputRow = RowGenerator.buildRow((RowGeneratorMeta)this.meta, remarks, this.getTransformName());
                if (!remarks.isEmpty()) {
                    for (int i = 0; i < remarks.size(); ++i) {
                        CheckResult cr = (CheckResult)remarks.get(i);
                        this.logError(cr.getText());
                    }
                    return false;
                }
                ((RowGeneratorData)this.data).outputRowData = outputRow.getData();
                ((RowGeneratorData)this.data).outputRowMeta = outputRow.getRowMeta();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.setErrors(1L);
            this.logError("Error initializing transform", e);
            return false;
        }
    }

    public boolean canProcessOneRow() {
        return true;
    }
}

