/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl.io.compression;

import akka.annotation.InternalApi;
import akka.stream.impl.io.compression.DeflateCompressor;
import akka.stream.impl.io.compression.GzipCompressor$;
import akka.stream.impl.io.compression.GzipDecompressor$;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import scala.Predef$;
import scala.collection.Seq;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b!B\u0001\u0003\u0001)a!AD${SB\u001cu.\u001c9sKN\u001cxN\u001d\u0006\u0003\u0007\u0011\t1bY8naJ,7o]5p]*\u0011QAB\u0001\u0003S>T!a\u0002\u0005\u0002\t%l\u0007\u000f\u001c\u0006\u0003\u0013)\taa\u001d;sK\u0006l'\"A\u0006\u0002\t\u0005\\7.Y\n\u0003\u00015\u0001\"AD\b\u000e\u0003\tI!\u0001\u0005\u0002\u0003#\u0011+g\r\\1uK\u000e{W\u000e\u001d:fgN|'\u000f\u0003\u0005\u0013\u0001\t\u0005\t\u0015!\u0003\u0015\u0003A\u0019w.\u001c9sKN\u001c\u0018n\u001c8MKZ,Gn\u0001\u0001\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\u0007%sG\u000fC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0003;y\u0001\"A\u0004\u0001\t\u000fIQ\u0002\u0013!a\u0001)!A\u0001\u0005\u0001EC\u0002\u0013E\u0013%\u0001\u0005eK\u001ad\u0017\r^3s+\u0005\u0011\u0003CA\u0012+\u001b\u0005!#BA\u0013'\u0003\rQ\u0018\u000e\u001d\u0006\u0003O!\nA!\u001e;jY*\t\u0011&\u0001\u0003kCZ\f\u0017BA\u0016%\u0005!!UM\u001a7bi\u0016\u0014\b\u0002C\u0017\u0001\u0011\u0003\u0005\u000b\u0015\u0002\u0012\u0002\u0013\u0011,g\r\\1uKJ\u0004\u0003bB\u0018\u0001\u0005\u0004%I\u0001M\u0001\tG\",7m[*v[V\t\u0011\u0007\u0005\u0002$e%\u00111\u0007\n\u0002\u0006\u0007J\u001b5G\r\u0005\u0007k\u0001\u0001\u000b\u0011B\u0019\u0002\u0013\rDWmY6Tk6\u0004\u0003bB\u001c\u0001\u0001\u0004%I\u0001O\u0001\u000bQ\u0016\fG-\u001a:TK:$X#A\u001d\u0011\u0005UQ\u0014BA\u001e\u0017\u0005\u001d\u0011un\u001c7fC:Dq!\u0010\u0001A\u0002\u0013%a(\u0001\biK\u0006$WM]*f]R|F%Z9\u0015\u0005}\u0012\u0005CA\u000bA\u0013\t\teC\u0001\u0003V]&$\bbB\"=\u0003\u0003\u0005\r!O\u0001\u0004q\u0012\n\u0004BB#\u0001A\u0003&\u0011(A\u0006iK\u0006$WM]*f]R\u0004\u0003bB$\u0001\u0001\u0004%I\u0001S\u0001\nEf$Xm\u001d*fC\u0012,\u0012!\u0013\t\u0003+)K!a\u0013\f\u0003\t1{gn\u001a\u0005\b\u001b\u0002\u0001\r\u0011\"\u0003O\u00035\u0011\u0017\u0010^3t%\u0016\fGm\u0018\u0013fcR\u0011qh\u0014\u0005\b\u00072\u000b\t\u00111\u0001J\u0011\u0019\t\u0006\u0001)Q\u0005\u0013\u0006Q!-\u001f;fgJ+\u0017\r\u001a\u0011\t\u000bM\u0003A\u0011\u000b+\u0002%\r|W\u000e\u001d:fgN<\u0016\u000e\u001e5Ck\u001a4WM\u001d\u000b\u0004+jc\u0006C\u0001,Y\u001b\u00059&BA\u0014\u000b\u0013\tIvK\u0001\u0006CsR,7\u000b\u001e:j]\u001eDQa\u0017*A\u0002U\u000bQ!\u001b8qkRDQ!\u0018*A\u0002y\u000baAY;gM\u0016\u0014\bcA\u000b`C&\u0011\u0001M\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003+\tL!a\u0019\f\u0003\t\tKH/\u001a\u0005\u0006K\u0002!\tFZ\u0001\u0010M2,8\u000f[,ji\"\u0014UO\u001a4feR\u0011Qk\u001a\u0005\u0006;\u0012\u0004\rA\u0018\u0005\u0006S\u0002!\tF[\u0001\u0011M&t\u0017n\u001d5XSRD')\u001e4gKJ$\"!V6\t\u000buC\u0007\u0019\u00010\t\u000b5\u0004A\u0011\u00028\u0002\u0013U\u0004H-\u0019;f\u0007J\u001cGCA p\u0011\u0015YF\u000e1\u0001V\u0011\u0015\t\b\u0001\"\u0003s\u0003\u0019AW-\u00193feR\tQ\u000bC\u0003u\u0001\u0011%!/A\u0004ue\u0006LG.\u001a:)\u0005\u00011\bCA<{\u001b\u0005A(BA=\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0003wb\u00141\"\u00138uKJt\u0017\r\\!qS\u001eAQPAA\u0001\u0012\u0003Qa0\u0001\bHu&\u00048i\\7qe\u0016\u001c8o\u001c:\u0011\u00059yh!C\u0001\u0003\u0003\u0003E\tACA\u0001'\ry\u00181\u0001\t\u0004+\u0005\u0015\u0011bAA\u0004-\t1\u0011I\\=SK\u001aDaaG@\u0005\u0002\u0005-A#\u0001@\t\u0013\u0005=q0%A\u0005\u0002\u0005E\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0014)\u001aA#!\u0006,\u0005\u0005]\u0001\u0003BA\r\u0003Ci!!a\u0007\u000b\t\u0005u\u0011qD\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u001f\f\n\t\u0005\r\u00121\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
@InternalApi
public class GzipCompressor
extends DeflateCompressor {
    private final int compressionLevel;
    private Deflater deflater;
    private final CRC32 checkSum;
    private boolean headerSent;
    private long bytesRead;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$1() {
        return GzipCompressor$.MODULE$.$lessinit$greater$default$1();
    }

    private Deflater deflater$lzycompute() {
        GzipCompressor gzipCompressor = this;
        synchronized (gzipCompressor) {
            if (!this.bitmap$0) {
                this.deflater = new Deflater(this.compressionLevel, true);
                this.bitmap$0 = true;
            }
            return this.deflater;
        }
    }

    @Override
    public Deflater deflater() {
        return this.bitmap$0 ? this.deflater : this.deflater$lzycompute();
    }

    private CRC32 checkSum() {
        return this.checkSum;
    }

    private boolean headerSent() {
        return this.headerSent;
    }

    private void headerSent_$eq(boolean x$1) {
        this.headerSent = x$1;
    }

    private long bytesRead() {
        return this.bytesRead;
    }

    private void bytesRead_$eq(long x$1) {
        this.bytesRead = x$1;
    }

    @Override
    public ByteString compressWithBuffer(ByteString input, byte[] buffer) {
        this.updateCrc(input);
        return this.header().$plus$plus(super.compressWithBuffer(input, buffer));
    }

    @Override
    public ByteString flushWithBuffer(byte[] buffer) {
        return this.header().$plus$plus(super.flushWithBuffer(buffer));
    }

    @Override
    public ByteString finishWithBuffer(byte[] buffer) {
        return this.header().$plus$plus(super.finishWithBuffer(buffer)).$plus$plus(this.trailer());
    }

    private void updateCrc(ByteString input) {
        this.checkSum().update((byte[])input.toArray(ClassTag$.MODULE$.Byte()));
        this.bytesRead_$eq(this.bytesRead() + (long)input.length());
    }

    private ByteString header() {
        ByteString byteString;
        if (this.headerSent()) {
            byteString = ByteString$.MODULE$.empty();
        } else {
            this.headerSent_$eq(true);
            byteString = GzipDecompressor$.MODULE$.Header();
        }
        return byteString;
    }

    /*
     * WARNING - void declaration
     */
    private ByteString trailer() {
        void var3_3;
        int crc = (int)this.checkSum().getValue();
        int tot = (int)this.bytesRead();
        ByteString trailer = this.int32$1(crc).$plus$plus(this.int32$1(tot));
        return var3_3;
    }

    private final ByteString int32$1(int i) {
        return ByteString$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{i, i >> 8, i >> 16, i >> 24}), (Integral)Numeric.IntIsIntegral$.MODULE$);
    }

    public GzipCompressor(int compressionLevel) {
        this.compressionLevel = compressionLevel;
        super(compressionLevel, true);
        this.checkSum = new CRC32();
        this.headerSent = false;
        this.bytesRead = 0L;
    }
}

