/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

public final class VersionUtils$ {
    public static VersionUtils$ MODULE$;
    private final Regex majorMinorRegex;
    private final Regex shortVersionRegex;

    static {
        new VersionUtils$();
    }

    private Regex majorMinorRegex() {
        return this.majorMinorRegex;
    }

    private Regex shortVersionRegex() {
        return this.shortVersionRegex;
    }

    public int majorVersion(String sparkVersion) {
        return this.majorMinorVersion(sparkVersion)._1$mcI$sp();
    }

    public int minorVersion(String sparkVersion) {
        return this.majorMinorVersion(sparkVersion)._2$mcI$sp();
    }

    public String shortVersion(String sparkVersion) {
        Option option = this.shortVersionRegex().findFirstMatchIn((CharSequence)sparkVersion);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(new StringBuilder(117).append("Spark tried to parse '").append(sparkVersion).append("' as a Spark").append(" version string, but it could not find the major/minor/maintenance version numbers.").toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Regex.Match m = (Regex.Match)some.value();
        String string = m.group(1);
        return string;
    }

    public Tuple2<Object, Object> majorMinorVersion(String sparkVersion) {
        Option option = this.majorMinorRegex().findFirstMatchIn((CharSequence)sparkVersion);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(new StringBuilder(109).append("Spark tried to parse '").append(sparkVersion).append("' as a Spark").append(" version string, but it could not find the major and minor version numbers.").toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Regex.Match m = (Regex.Match)some.value();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(new StringOps(Predef$.MODULE$.augmentString(m.group(1))).toInt(), new StringOps(Predef$.MODULE$.augmentString(m.group(2))).toInt());
        return sp2;
    }

    private VersionUtils$() {
        MODULE$ = this;
        this.majorMinorRegex = new StringOps(Predef$.MODULE$.augmentString("^(\\d+)\\.(\\d+)(\\..*)?$")).r();
        this.shortVersionRegex = new StringOps(Predef$.MODULE$.augmentString("^(\\d+\\.\\d+\\.\\d+)(.*)?$")).r();
    }
}

