/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.jobs;

import java.io.Serializable;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.internal.config.package$;
import org.apache.spark.scheduler.SchedulingMode$;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.AppSummary;
import org.apache.spark.status.api.v1.ApplicationAttemptInfo;
import org.apache.spark.status.api.v1.ApplicationInfo;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.ui.ToolTips$;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUIPage;
import org.apache.spark.ui.jobs.ApiHelper$;
import org.apache.spark.ui.jobs.JobPagedTable;
import org.apache.spark.ui.jobs.JobsTab;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;
import scala.xml.Utility$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua!B\u0007\u000f\u0001AA\u0002\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\t\u0011\r\u0002!\u0011!Q\u0001\n\u0011BQA\u000b\u0001\u0005\u0002-Bqa\f\u0001C\u0002\u0013%\u0001\u0007\u0003\u0004?\u0001\u0001\u0006I!\r\u0005\b\u007f\u0001\u0011\r\u0011\"\u00031\u0011\u0019\u0001\u0005\u0001)A\u0005c!)\u0011\t\u0001C\u0005\u0005\")a\u000b\u0001C\u0005/\")a\f\u0001C\u0005?\")q\u000e\u0001C\u0005a\"9\u0011q\u0002\u0001\u0005\u0002\u0005E!aC!mY*{'m\u001d)bO\u0016T!a\u0004\t\u0002\t)|'m\u001d\u0006\u0003#I\t!!^5\u000b\u0005M!\u0012!B:qCJ\\'BA\u000b\u0017\u0003\u0019\t\u0007/Y2iK*\tq#A\u0002pe\u001e\u001c\"\u0001A\r\u0011\u0005iYR\"\u0001\t\n\u0005q\u0001\"!C,fEVK\u0005+Y4f\u0003\u0019\u0001\u0018M]3oi\u000e\u0001\u0001C\u0001\u0011\"\u001b\u0005q\u0011B\u0001\u0012\u000f\u0005\u001dQuNY:UC\n\fQa\u001d;pe\u0016\u0004\"!\n\u0015\u000e\u0003\u0019R!a\n\n\u0002\rM$\u0018\r^;t\u0013\tIcE\u0001\bBaB\u001cF/\u0019;vgN#xN]3\u0002\rqJg.\u001b;?)\raSF\f\t\u0003A\u0001AQ!H\u0002A\u0002}AQaI\u0002A\u0002\u0011\n1BS(C'~cUiR#O\tV\t\u0011\u0007\u0005\u00023w9\u00111'\u000f\t\u0003i]j\u0011!\u000e\u0006\u0003my\ta\u0001\u0010:p_Rt$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:\u0014A\u0002)sK\u0012,g-\u0003\u0002={\t11\u000b\u001e:j]\u001eT!AO\u001c\u0002\u0019){%iU0M\u000b\u001e+e\n\u0012\u0011\u0002!\u0015CViQ+U\u001fJ\u001bv\fT#H\u000b:#\u0015!E#Y\u000b\u000e+Fk\u0014*T?2+u)\u0012(EA\u0005aQ.Y6f\u0015>\u0014WI^3oiR\u00111\t\u0014\t\u0004\t&\u000bdBA#H\u001d\t!d)C\u00019\u0013\tAu'A\u0004qC\u000e\\\u0017mZ3\n\u0005)[%aA*fc*\u0011\u0001j\u000e\u0005\u0006\u001f!\u0001\r!\u0014\t\u0004\t&s\u0005CA(U\u001b\u0005\u0001&BA)S\u0003\t1\u0018G\u0003\u0002TM\u0005\u0019\u0011\r]5\n\u0005U\u0003&a\u0002&pE\u0012\u000bG/Y\u0001\u0012[\u0006\\W-\u0012=fGV$xN]#wK:$HCA\"Y\u0011\u0015I\u0016\u00021\u0001[\u0003%)\u00070Z2vi>\u00148\u000fE\u0002E\u0013n\u0003\"a\u0014/\n\u0005u\u0003&aD#yK\u000e,Ho\u001c:Tk6l\u0017M]=\u0002\u00195\f7.\u001a+j[\u0016d\u0017N\\3\u0015\t\u0001<\u0007.\u001b\t\u0004\t&\u000b\u0007C\u00012f\u001b\u0005\u0019'B\u000138\u0003\rAX\u000e\\\u0005\u0003M\u000e\u0014AAT8eK\")qB\u0003a\u0001\u001b\")\u0011L\u0003a\u00015\")!N\u0003a\u0001W\u0006I1\u000f^1siRKW.\u001a\t\u0003Y6l\u0011aN\u0005\u0003]^\u0012A\u0001T8oO\u0006I!n\u001c2t)\u0006\u0014G.\u001a\u000b\tAFlx0a\u0001\u0002\u0006!)!o\u0003a\u0001g\u00069!/Z9vKN$\bC\u0001;|\u001b\u0005)(B\u0001<x\u0003\u0011AG\u000f\u001e9\u000b\u0005aL\u0018aB:feZdW\r\u001e\u0006\u0002u\u0006)!.\u0019<bq&\u0011A0\u001e\u0002\u0013\u0011R$\boU3sm2,GOU3rk\u0016\u001cH\u000fC\u0003\u007f\u0017\u0001\u0007\u0011'A\u0007uC\ndW\rS3bI\u0016\u0014\u0018\n\u001a\u0005\u0007\u0003\u0003Y\u0001\u0019A\u0019\u0002\r)|'\rV1h\u0011\u0015y1\u00021\u0001N\u0011\u001d\t9a\u0003a\u0001\u0003\u0013\t1b[5mY\u0016s\u0017M\u00197fIB\u0019A.a\u0003\n\u0007\u00055qGA\u0004C_>dW-\u00198\u0002\rI,g\u000eZ3s)\r\u0001\u00171\u0003\u0005\u0006e2\u0001\ra\u001d")
public class AllJobsPage
extends WebUIPage {
    private final JobsTab parent;
    private final AppStatusStore store;
    private final String JOBS_LEGEND;
    private final String EXECUTORS_LEGEND;

    private String JOBS_LEGEND() {
        return this.JOBS_LEGEND;
    }

    private String EXECUTORS_LEGEND() {
        return this.EXECUTORS_LEGEND;
    }

    private Seq<String> makeJobEvent(Seq<JobData> jobs) {
        return (Seq)((TraversableLike)jobs.filter((Function1 & Serializable & scala.Serializable)job -> BoxesRunTime.boxToBoolean((boolean)AllJobsPage.$anonfun$makeJobEvent$1(job)))).map((Function1 & Serializable & scala.Serializable)job -> {
            String string;
            String lastStageDescription;
            int jobId = job.jobId();
            JobExecutionStatus status = job.status();
            Tuple2<String, String> tuple2 = ApiHelper$.MODULE$.lastStageNameAndDescription($this.store, (JobData)job);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String string2 = lastStageDescription = (String)tuple2._2();
            String lastStageDescription2 = string2;
            String jobDescription = UIUtils$.MODULE$.makeDescription((String)job.description().getOrElse((Function0 & Serializable & scala.Serializable)() -> lastStageDescription2), "", true).text();
            long submissionTime = ((Date)job.submissionTime().get()).getTime();
            long completionTime = BoxesRunTime.unboxToLong((Object)job.completionTime().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> System.currentTimeMillis()));
            JobExecutionStatus jobExecutionStatus = status;
            if (((Object)((Object)JobExecutionStatus.SUCCEEDED)).equals((Object)jobExecutionStatus)) {
                string = "succeeded";
            } else if (((Object)((Object)JobExecutionStatus.FAILED)).equals((Object)jobExecutionStatus)) {
                string = "failed";
            } else if (((Object)((Object)JobExecutionStatus.RUNNING)).equals((Object)jobExecutionStatus)) {
                string = "running";
            } else if (((Object)((Object)JobExecutionStatus.UNKNOWN)).equals((Object)jobExecutionStatus)) {
                string = "unknown";
            } else {
                throw new MatchError((Object)jobExecutionStatus);
            }
            String classNameByStatus = string;
            String escapedDesc = Utility$.MODULE$.escape(jobDescription);
            String jsEscapedDescForTooltip = StringEscapeUtils.escapeEcmaScript((String)Utility$.MODULE$.escape(escapedDesc));
            String jsEscapedDescForLabel = StringEscapeUtils.escapeEcmaScript((String)escapedDesc);
            JobExecutionStatus jobExecutionStatus2 = status;
            JobExecutionStatus jobExecutionStatus3 = JobExecutionStatus.RUNNING;
            String jobEventJsonAsStr = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(520).append("\n           |{\n           |  'className': 'job application-timeline-object ").append(classNameByStatus).append("',\n           |  'group': 'jobs',\n           |  'start': new Date(").append(submissionTime).append("),\n           |  'end': new Date(").append(completionTime).append("),\n           |  'content': '<div class=\"application-timeline-content\"' +\n           |     'data-html=\"true\" data-placement=\"top\" data-toggle=\"tooltip\"' +\n           |     'data-title=\"").append(jsEscapedDescForTooltip).append(" (Job ").append(jobId).append(")<br>' +\n           |     'Status: ").append((Object)status).append("<br>' +\n           |     'Submitted: ").append(UIUtils$.MODULE$.formatDate(new Date(submissionTime))).append("' +\n           |     '").append((Object)((jobExecutionStatus2 == null ? jobExecutionStatus3 != null : !((Object)((Object)jobExecutionStatus2)).equals((Object)jobExecutionStatus3)) ? new StringBuilder(15).append("<br>Completed: ").append(UIUtils$.MODULE$.formatDate(new Date(completionTime))).toString() : "")).append("\">' +\n           |    '").append(jsEscapedDescForLabel).append(" (Job ").append(jobId).append(")</div>'\n           |}\n         ").toString())).stripMargin();
            return jobEventJsonAsStr;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<String> makeExecutorEvent(Seq<ExecutorSummary> executors) {
        ListBuffer events = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        executors.foreach((Function1 & Serializable & scala.Serializable)e -> {
            AllJobsPage.$anonfun$makeExecutorEvent$1(events, e);
            return BoxedUnit.UNIT;
        });
        return events.toSeq();
    }

    private Seq<Node> makeTimeline(Seq<JobData> jobs, Seq<ExecutorSummary> executors, long startTime) {
        Seq<String> jobEventJsonAsStrSeq = this.makeJobEvent(jobs);
        Seq<String> executorEventJsonAsStrSeq = this.makeExecutorEvent(executors);
        String groupJsonArrayAsStr = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(254).append("\n          |[\n          |  {\n          |    'id': 'executors',\n          |    'content': '<div>Executors</div>").append(this.EXECUTORS_LEGEND()).append("',\n          |  },\n          |  {\n          |    'id': 'jobs',\n          |    'content': '<div>Jobs</div>").append(this.JOBS_LEGEND()).append("',\n          |  }\n          |]\n        ").toString())).stripMargin();
        String eventArrayAsStr = ((TraversableOnce)jobEventJsonAsStrSeq.$plus$plus(executorEventJsonAsStrSeq, Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("expand-application-timeline"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("expand-application-timeline-arrow arrow-closed"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("data-placement", (Seq)new Text("top"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("title", ToolTips$.MODULE$.JOB_TIMELINE(), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md3);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        Event Timeline\n      "));
        $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n    "));
        Elem elem = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("collapsed"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("id", (Seq)new Text("application-timeline"), (MetaData)$md4);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("class", (Seq)new Text("control-panel"), (MetaData)$md5);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("id", (Seq)new Text("application-timeline-zoom-lock"), (MetaData)$md6);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n          "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md7);
        $buf5.$amp$plus((Object)new Elem(null, "input", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf5.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("Enable zooming"));
        $buf5.$amp$plus((Object)new Elem(null, "span", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)new Elem(null, "div", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf3.$amp$plus((Object)new Elem(null, "div", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n    "));
        TraversableLike traversableLike = (TraversableLike)elem.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3), NodeSeq$.MODULE$.canBuildFrom());
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("type", (Seq)new Text("text/javascript"), (MetaData)$md8);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n      "));
        $buf7.$amp$plus((Object)Unparsed$.MODULE$.apply(new StringBuilder(31).append("drawApplicationTimeline(").append(groupJsonArrayAsStr).append(",").append(eventArrayAsStr).append(", ").append(startTime).append(", ").append(UIUtils$.MODULE$.getTimeZoneOffset()).append(");").toString()));
        $buf7.$amp$plus((Object)new Text("\n    "));
        return (Seq)traversableLike.$plus$plus((GenTraversableOnce)new Elem(null, "script", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7), NodeSeq$.MODULE$.canBuildFrom());
    }

    private Seq<Node> jobsTable(HttpServletRequest request, String tableHeaderId, String jobTag, Seq<JobData> jobs, boolean killEnabled) {
        Elem elem;
        boolean someJobHasJobGroup = jobs.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AllJobsPage.$anonfun$jobsTable$1(x$4)));
        String jobIdTitle = someJobHasJobGroup ? "Job Id (Job Group)" : "Job Id";
        int jobPage = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)request.getParameter(new StringBuilder(5).append(jobTag).append(".page").toString())).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)AllJobsPage.$anonfun$jobsTable$2(x$5))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
        try {
            elem = new JobPagedTable(request, this.store, jobs, tableHeaderId, jobTag, UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3()), "jobs", killEnabled, jobIdTitle).table(jobPage);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IllegalArgumentException ? true : throwable2 instanceof IndexOutOfBoundsException;
            if (!bl) {
                throw throwable;
            }
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("alert alert-error"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("Error while rendering job table:"));
            $buf.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n            "));
            $buf3.$amp$plus((Object)Utils$.MODULE$.exceptionString(throwable2));
            $buf3.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)new Elem(null, "pre", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
            $buf.$amp$plus((Object)new Text("\n        "));
            Elem elem2 = new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            elem = elem2;
        }
        return elem;
    }

    @Override
    public Seq<Node> render(HttpServletRequest request) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        ApplicationInfo appInfo = this.store.applicationInfo();
        long startTime = ((ApplicationAttemptInfo)appInfo.attempts().head()).startTime().getTime();
        long endTime = ((ApplicationAttemptInfo)appInfo.attempts().head()).endTime().getTime();
        ListBuffer activeJobs = new ListBuffer();
        ListBuffer completedJobs = new ListBuffer();
        ListBuffer failedJobs = new ListBuffer();
        this.store.jobsList(null).foreach((Function1 & Serializable & scala.Serializable)job -> {
            JobExecutionStatus jobExecutionStatus = job.status();
            ListBuffer listBuffer = ((Object)((Object)JobExecutionStatus.SUCCEEDED)).equals((Object)jobExecutionStatus) ? completedJobs.$plus$eq(job) : (((Object)((Object)JobExecutionStatus.FAILED)).equals((Object)jobExecutionStatus) ? failedJobs.$plus$eq(job) : activeJobs.$plus$eq(job));
            return listBuffer;
        });
        Seq<Node> activeJobsTable = this.jobsTable(request, "active", "activeJob", (Seq<JobData>)activeJobs.toSeq(), this.parent.killEnabled());
        Seq<Node> completedJobsTable = this.jobsTable(request, "completed", "completedJob", (Seq<JobData>)completedJobs.toSeq(), false);
        Seq<Node> failedJobsTable = this.jobsTable(request, "failed", "failedJob", (Seq<JobData>)failedJobs.toSeq(), false);
        boolean shouldShowActiveJobs = activeJobs.nonEmpty();
        boolean shouldShowCompletedJobs = completedJobs.nonEmpty();
        boolean shouldShowFailedJobs = failedJobs.nonEmpty();
        AppSummary appSummary = this.store.appSummary();
        String completedJobNumStr = completedJobs.size() == appSummary.numCompletedJobs() ? String.valueOf(BoxesRunTime.boxToInteger((int)completedJobs.size())) : new StringBuilder(15).append(appSummary.numCompletedJobs()).append(", only showing ").append(completedJobs.size()).toString();
        String schedulingMode = (String)this.store.environmentInfo().sparkProperties().toMap(Predef$.MODULE$.$conforms()).get((Object)package$.MODULE$.SCHEDULER_MODE().key()).map((Function1 & Serializable & scala.Serializable)mode -> SchedulingMode$.MODULE$.withName((String)mode).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "Unknown");
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("list-unstyled"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("User:"));
        $buf3.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n            "));
        $buf3.$amp$plus((Object)this.parent.getSparkUser());
        $buf3.$amp$plus((Object)new Text("\n          "));
        $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("Total Uptime:"));
        $buf5.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf5.$amp$plus((Object)new Text("\n            "));
        $buf5.$amp$plus((Object)(endTime < 0L && this.parent.sc().isDefined() ? UIUtils$.MODULE$.formatDuration(System.currentTimeMillis() - startTime) : (endTime > 0L ? UIUtils$.MODULE$.formatDuration(endTime - startTime) : BoxedUnit.UNIT)));
        $buf5.$amp$plus((Object)new Text("\n          "));
        $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf2.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Scheduling Mode: "));
        $buf7.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf7.$amp$plus((Object)new Text("\n            "));
        $buf7.$amp$plus((Object)schedulingMode);
        $buf7.$amp$plus((Object)new Text("\n          "));
        $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf2.$amp$plus((Object)new Text("\n          "));
        if (shouldShowActiveJobs) {
            NodeBuffer $buf9 = new NodeBuffer();
            $buf9.$amp$plus((Object)new Text("\n                "));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("href", (Seq)new Text("#active"), (MetaData)$md2);
            NodeBuffer $buf10 = new NodeBuffer();
            NodeBuffer $buf11 = new NodeBuffer();
            $buf11.$amp$plus((Object)new Text("Active Jobs:"));
            $buf10.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
            $buf9.$amp$plus((Object)new Elem(null, "a", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
            $buf9.$amp$plus((Object)new Text("\n                "));
            $buf9.$amp$plus((Object)BoxesRunTime.boxToInteger((int)activeJobs.size()));
            $buf9.$amp$plus((Object)new Text("\n              "));
            Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9);
            boxedUnit3 = elem;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        $buf2.$amp$plus((Object)boxedUnit3);
        $buf2.$amp$plus((Object)new Text("\n          "));
        if (shouldShowCompletedJobs) {
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("id", (Seq)new Text("completed-summary"), (MetaData)$md3);
            NodeBuffer $buf12 = new NodeBuffer();
            $buf12.$amp$plus((Object)new Text("\n                "));
            Null$ $md4 = Null$.MODULE$;
            $md4 = new UnprefixedAttribute("href", (Seq)new Text("#completed"), (MetaData)$md4);
            NodeBuffer $buf13 = new NodeBuffer();
            NodeBuffer $buf14 = new NodeBuffer();
            $buf14.$amp$plus((Object)new Text("Completed Jobs:"));
            $buf13.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf14));
            $buf12.$amp$plus((Object)new Elem(null, "a", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf13));
            $buf12.$amp$plus((Object)new Text("\n                "));
            $buf12.$amp$plus((Object)completedJobNumStr);
            $buf12.$amp$plus((Object)new Text("\n              "));
            Elem elem = new Elem(null, "li", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf12);
            boxedUnit2 = elem;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        $buf2.$amp$plus((Object)boxedUnit2);
        $buf2.$amp$plus((Object)new Text("\n          "));
        if (shouldShowFailedJobs) {
            NodeBuffer $buf15 = new NodeBuffer();
            $buf15.$amp$plus((Object)new Text("\n                "));
            Null$ $md5 = Null$.MODULE$;
            $md5 = new UnprefixedAttribute("href", (Seq)new Text("#failed"), (MetaData)$md5);
            NodeBuffer $buf16 = new NodeBuffer();
            NodeBuffer $buf17 = new NodeBuffer();
            $buf17.$amp$plus((Object)new Text("Failed Jobs:"));
            $buf16.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf17));
            $buf15.$amp$plus((Object)new Elem(null, "a", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf16));
            $buf15.$amp$plus((Object)new Text("\n                "));
            $buf15.$amp$plus((Object)BoxesRunTime.boxToInteger((int)failedJobs.size()));
            $buf15.$amp$plus((Object)new Text("\n              "));
            Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf15);
            boxedUnit = elem;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        $buf2.$amp$plus((Object)boxedUnit);
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        Elem summary = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        ObjectRef content = ObjectRef.create((Object)summary);
        content.elem = (NodeSeq)((NodeSeq)content.elem).$plus$plus(this.makeTimeline((Seq<JobData>)((TraversableForwarder)activeJobs.$plus$plus((GenTraversableOnce)completedJobs).$plus$plus((GenTraversableOnce)failedJobs)).toSeq(), this.store.executorList(false), startTime), NodeSeq$.MODULE$.canBuildFrom());
        if (shouldShowActiveJobs) {
            NodeSeq nodeSeq = (NodeSeq)content.elem;
            Null$ $md6 = Null$.MODULE$;
            $md6 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-activeJobs','aggregated-activeJobs')"), (MetaData)$md6);
            $md6 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-activeJobs collapse-table"), (MetaData)$md6);
            $md6 = new UnprefixedAttribute("id", (Seq)new Text("active"), (MetaData)$md6);
            NodeBuffer $buf18 = new NodeBuffer();
            $buf18.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf19 = new NodeBuffer();
            $buf19.$amp$plus((Object)new Text("\n            "));
            Null$ $md7 = Null$.MODULE$;
            $md7 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md7);
            $buf19.$amp$plus((Object)new Elem(null, "span", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf19.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf20 = new NodeBuffer();
            $buf20.$amp$plus((Object)new Text("Active Jobs ("));
            $buf20.$amp$plus((Object)BoxesRunTime.boxToInteger((int)activeJobs.size()));
            $buf20.$amp$plus((Object)new Text(")"));
            $buf19.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf20));
            $buf19.$amp$plus((Object)new Text("\n          "));
            $buf18.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf19));
            $buf18.$amp$plus((Object)new Text("\n        "));
            Elem elem = new Elem(null, "span", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf18);
            Null$ $md8 = Null$.MODULE$;
            $md8 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-activeJobs collapsible-table"), (MetaData)$md8);
            NodeBuffer $buf21 = new NodeBuffer();
            $buf21.$amp$plus((Object)new Text("\n          "));
            $buf21.$amp$plus(activeJobsTable);
            $buf21.$amp$plus((Object)new Text("\n        "));
            content.elem = (NodeSeq)nodeSeq.$plus$plus((GenTraversableOnce)elem.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf21), NodeSeq$.MODULE$.canBuildFrom()), NodeSeq$.MODULE$.canBuildFrom());
        }
        if (shouldShowCompletedJobs) {
            NodeSeq nodeSeq = (NodeSeq)content.elem;
            Null$ $md9 = Null$.MODULE$;
            $md9 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-completedJobs','aggregated-completedJobs')"), (MetaData)$md9);
            $md9 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-completedJobs collapse-table"), (MetaData)$md9);
            $md9 = new UnprefixedAttribute("id", (Seq)new Text("completed"), (MetaData)$md9);
            NodeBuffer $buf22 = new NodeBuffer();
            $buf22.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf23 = new NodeBuffer();
            $buf23.$amp$plus((Object)new Text("\n            "));
            Null$ $md10 = Null$.MODULE$;
            $md10 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md10);
            $buf23.$amp$plus((Object)new Elem(null, "span", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf23.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf24 = new NodeBuffer();
            $buf24.$amp$plus((Object)new Text("Completed Jobs ("));
            $buf24.$amp$plus((Object)completedJobNumStr);
            $buf24.$amp$plus((Object)new Text(")"));
            $buf23.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf24));
            $buf23.$amp$plus((Object)new Text("\n          "));
            $buf22.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf23));
            $buf22.$amp$plus((Object)new Text("\n        "));
            Elem elem = new Elem(null, "span", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf22);
            Null$ $md11 = Null$.MODULE$;
            $md11 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-completedJobs collapsible-table"), (MetaData)$md11);
            NodeBuffer $buf25 = new NodeBuffer();
            $buf25.$amp$plus((Object)new Text("\n          "));
            $buf25.$amp$plus(completedJobsTable);
            $buf25.$amp$plus((Object)new Text("\n        "));
            content.elem = (NodeSeq)nodeSeq.$plus$plus((GenTraversableOnce)elem.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf25), NodeSeq$.MODULE$.canBuildFrom()), NodeSeq$.MODULE$.canBuildFrom());
        }
        if (shouldShowFailedJobs) {
            NodeSeq nodeSeq = (NodeSeq)content.elem;
            Null$ $md12 = Null$.MODULE$;
            $md12 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-failedJobs','aggregated-failedJobs')"), (MetaData)$md12);
            $md12 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-failedJobs collapse-table"), (MetaData)$md12);
            $md12 = new UnprefixedAttribute("id", (Seq)new Text("failed"), (MetaData)$md12);
            NodeBuffer $buf26 = new NodeBuffer();
            $buf26.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf27 = new NodeBuffer();
            $buf27.$amp$plus((Object)new Text("\n            "));
            Null$ $md13 = Null$.MODULE$;
            $md13 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md13);
            $buf27.$amp$plus((Object)new Elem(null, "span", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf27.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf28 = new NodeBuffer();
            $buf28.$amp$plus((Object)new Text("Failed Jobs ("));
            $buf28.$amp$plus((Object)BoxesRunTime.boxToInteger((int)failedJobs.size()));
            $buf28.$amp$plus((Object)new Text(")"));
            $buf27.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf28));
            $buf27.$amp$plus((Object)new Text("\n          "));
            $buf26.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf27));
            $buf26.$amp$plus((Object)new Text("\n        "));
            Elem elem = new Elem(null, "span", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf26);
            Null$ $md14 = Null$.MODULE$;
            $md14 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-failedJobs collapsible-table"), (MetaData)$md14);
            NodeBuffer $buf29 = new NodeBuffer();
            $buf29.$amp$plus((Object)new Text("\n        "));
            $buf29.$amp$plus(failedJobsTable);
            $buf29.$amp$plus((Object)new Text("\n      "));
            content.elem = (NodeSeq)nodeSeq.$plus$plus((GenTraversableOnce)elem.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf29), NodeSeq$.MODULE$.canBuildFrom()), NodeSeq$.MODULE$.canBuildFrom());
        }
        String helpText = "A job is triggered by an action, like count() or saveAsTextFile(). Click on a job to see information about the stages of tasks inside it.";
        return UIUtils$.MODULE$.headerSparkPage(request, "Spark Jobs", (Function0<Seq<Node>>)(Function0 & Serializable & scala.Serializable)() -> (NodeSeq)content$1.elem, this.parent, (Option<String>)new Some((Object)helpText), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7());
    }

    public static final /* synthetic */ boolean $anonfun$JOBS_LEGEND$1(char x$1) {
        return x$1 != '\n';
    }

    public static final /* synthetic */ boolean $anonfun$EXECUTORS_LEGEND$1(char x$2) {
        return x$2 != '\n';
    }

    public static final /* synthetic */ boolean $anonfun$makeJobEvent$1(JobData job) {
        JobExecutionStatus jobExecutionStatus = job.status();
        JobExecutionStatus jobExecutionStatus2 = JobExecutionStatus.UNKNOWN;
        return (jobExecutionStatus == null ? jobExecutionStatus2 != null : !((Object)((Object)jobExecutionStatus)).equals((Object)jobExecutionStatus2)) && job.submissionTime().isDefined();
    }

    public static final /* synthetic */ void $anonfun$makeExecutorEvent$1(ListBuffer events$1, ExecutorSummary e) {
        String addedEvent = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(416).append("\n           |{\n           |  'className': 'executor added',\n           |  'group': 'executors',\n           |  'start': new Date(").append(e.addTime().getTime()).append("),\n           |  'content': '<div class=\"executor-event-content\"' +\n           |    'data-toggle=\"tooltip\" data-placement=\"top\"' +\n           |    'data-title=\"Executor ").append(e.id()).append("<br>' +\n           |    'Added at ").append(UIUtils$.MODULE$.formatDate(e.addTime())).append("\"' +\n           |    'data-html=\"true\">Executor ").append(e.id()).append(" added</div>'\n           |}\n         ").toString())).stripMargin();
        events$1.$plus$eq((Object)addedEvent);
        e.removeTime().foreach((Function1 & Serializable & scala.Serializable)removeTime -> {
            String removedEvent = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(467).append("\n             |{\n             |  'className': 'executor removed',\n             |  'group': 'executors',\n             |  'start': new Date(").append(removeTime.getTime()).append("),\n             |  'content': '<div class=\"executor-event-content\"' +\n             |    'data-toggle=\"tooltip\" data-placement=\"top\"' +\n             |    'data-title=\"Executor ").append(e.id()).append("<br>' +\n             |    'Removed at ").append(UIUtils$.MODULE$.formatDate((Date)removeTime)).append("' +\n             |    '").append(e.removeReason().map((Function1 & Serializable & scala.Serializable)reason -> new StringBuilder(12).append("<br>Reason: ").append(StringEscapeUtils.escapeEcmaScript((String)reason.replace("\n", " "))).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("\"' +\n             |    'data-html=\"true\">Executor ").append(e.id()).append(" removed</div>'\n             |}\n           ").toString())).stripMargin();
            return events$1.$plus$eq((Object)removedEvent);
        });
    }

    public static final /* synthetic */ boolean $anonfun$jobsTable$1(JobData x$4) {
        return x$4.jobGroup().isDefined();
    }

    public static final /* synthetic */ int $anonfun$jobsTable$2(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toInt();
    }

    public AllJobsPage(JobsTab parent, AppStatusStore store) {
        this.parent = parent;
        this.store = store;
        super("");
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("legend-area"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("height", (Seq)new Text("85px"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("width", (Seq)new Text("150px"), (MetaData)$md2);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("y", (Seq)new Text("5px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("succeeded-job-legend"), (MetaData)$md3);
        $buf2.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("y", (Seq)new Text("17px"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md4);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("Succeeded"));
        $buf2.$amp$plus((Object)new Elem(null, "text", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("y", (Seq)new Text("30px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("class", (Seq)new Text("failed-job-legend"), (MetaData)$md5);
        $buf2.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("y", (Seq)new Text("42px"), (MetaData)$md6);
        $md6 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md6);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("Failed"));
        $buf2.$amp$plus((Object)new Elem(null, "text", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("y", (Seq)new Text("55px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("running-job-legend"), (MetaData)$md7);
        $buf2.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("y", (Seq)new Text("67px"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md8);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Running"));
        $buf2.$amp$plus((Object)new Elem(null, "text", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf2.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "svg", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        this.JOBS_LEGEND = (String)new StringOps(Predef$.MODULE$.augmentString(new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf).toString())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AllJobsPage.$anonfun$JOBS_LEGEND$1(BoxesRunTime.unboxToChar((Object)x$1))));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("class", (Seq)new Text("legend-area"), (MetaData)$md9);
        NodeBuffer $buf6 = new NodeBuffer();
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("height", (Seq)new Text("55px"), (MetaData)$md10);
        $md10 = new UnprefixedAttribute("width", (Seq)new Text("150px"), (MetaData)$md10);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md11 = Null$.MODULE$;
        $md11 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("y", (Seq)new Text("5px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("class", (Seq)new Text("executor-added-legend"), (MetaData)$md11);
        $buf7.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md12 = Null$.MODULE$;
        $md12 = new UnprefixedAttribute("y", (Seq)new Text("17px"), (MetaData)$md12);
        $md12 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md12);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Added"));
        $buf7.$amp$plus((Object)new Elem(null, "text", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md13 = Null$.MODULE$;
        $md13 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("y", (Seq)new Text("30px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("class", (Seq)new Text("executor-removed-legend"), (MetaData)$md13);
        $buf7.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md14 = Null$.MODULE$;
        $md14 = new UnprefixedAttribute("y", (Seq)new Text("42px"), (MetaData)$md14);
        $md14 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md14);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Removed"));
        $buf7.$amp$plus((Object)new Elem(null, "text", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf7.$amp$plus((Object)new Text("\n    "));
        $buf6.$amp$plus((Object)new Elem(null, "svg", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        this.EXECUTORS_LEGEND = (String)new StringOps(Predef$.MODULE$.augmentString(new Elem(null, "div", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6).toString())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AllJobsPage.$anonfun$EXECUTORS_LEGEND$1(BoxesRunTime.unboxToChar((Object)x$2))));
    }
}

