/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.shuffle.ShuffleBlockInfo;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerMessages;
import org.apache.spark.storage.FallbackStorage;
import org.apache.spark.storage.FallbackStorage$;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t]c!\u0002\u001e<\u0001m\u001a\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\t\u0011Y\u0003!\u0011!Q\u0001\n]CQa\u0017\u0001\u0005\u0002qCq\u0001\u0019\u0001C\u0002\u0013%\u0011\r\u0003\u0004i\u0001\u0001\u0006IA\u0019\u0005\bS\u0002\u0011\r\u0011\"\u0003k\u0011\u0019q\u0007\u0001)A\u0005W\"Aq\u000e\u0001a\u0001\n\u0003Y\u0004\u000f\u0003\u0005u\u0001\u0001\u0007I\u0011A\u001ev\u0011\u0019Y\b\u0001)Q\u0005c\"I\u0011\u0011\u0001\u0001A\u0002\u0013\u00051\b\u001d\u0005\u000b\u0003\u0007\u0001\u0001\u0019!C\u0001w\u0005\u0015\u0001bBA\u0005\u0001\u0001\u0006K!\u001d\u0005\u000b\u0003\u001b\u0001\u0001\u0019!C\u0001w\u0005=\u0001BCA\f\u0001\u0001\u0007I\u0011A\u001e\u0002\u001a!A\u0011Q\u0004\u0001!B\u0013\t\t\u0002\u0003\u0006\u0002\"\u0001\u0001\r\u0011\"\u0001<\u0003\u001fA!\"a\t\u0001\u0001\u0004%\taOA\u0013\u0011!\tI\u0003\u0001Q!\n\u0005EaABA\u0017\u0001\u0011\ty\u0003\u0003\u0006\u0002HQ\u0011\t\u0011)A\u0005\u0003\u0013Baa\u0017\u000b\u0005\u0002\u0005=\u0003\"CA,)\u0001\u0007I\u0011AA\b\u0011%\tI\u0006\u0006a\u0001\n\u0003\tY\u0006\u0003\u0005\u0002`Q\u0001\u000b\u0015BA\t\u0011\u001d\t\u0019\u0007\u0006C!\u0003KB!\"a\u001a\u0001\u0005\u0004%\tbOA5\u0011!\t9\t\u0001Q\u0001\n\u0005-\u0004BCAE\u0001\t\u0007I\u0011A\u001e\u0002\f\"A\u0011\u0011\u0015\u0001!\u0002\u0013\ti\t\u0003\u0006\u0002$\u0002\u0011\r\u0011\"\u0001<\u0003KC\u0001\"!.\u0001A\u0003%\u0011q\u0015\u0005\n\u0003o\u0003\u0001\u0019!C\u0005\u0003\u001fA\u0011\"!/\u0001\u0001\u0004%I!a/\t\u0011\u0005}\u0006\u0001)Q\u0005\u0003#A\u0011\"a1\u0001\u0001\u0004%I!a\u0004\t\u0013\u0005\u0015\u0007\u00011A\u0005\n\u0005\u001d\u0007\u0002CAf\u0001\u0001\u0006K!!\u0005\t\u0013\u0005=\u0007\u00011A\u0005\n\u0005=\u0001\"CAi\u0001\u0001\u0007I\u0011BAj\u0011!\t9\u000e\u0001Q!\n\u0005E\u0001\"CAn\u0001\t\u0007I\u0011BAo\u0011!\t)\u000f\u0001Q\u0001\n\u0005}\u0007BCAt\u0001!\u0015\r\u0011\"\u0003\u0002j\"I\u0011\u0011\u001f\u0001C\u0002\u0013%\u00111\u001f\u0005\t\u0003w\u0004\u0001\u0015!\u0003\u0002v\"Q!\u0011\u0001\u0001\t\u0006\u0004%I!!;\t\u0013\t\r\u0001A1A\u0005\n\t\u0015\u0001\u0002\u0003B\u0006\u0001\u0001\u0006IAa\u0002\t\u0015\t=\u0001\u0001#b\u0001\n\u0003\u0011\t\u0002\u0003\u0005\u0003\u001a\u0001!\ta\u000fB\u000e\u0011!\u0011i\u0002\u0001C\u0001w\u0005\u0015\u0004\u0002\u0003B\u0010\u0001\u0011\u00051Ha\u0007\t\u000f\t\u0005\u0002\u0001\"\u0003\u0003$!9!Q\n\u0001\u0005\u0002\u0005\u0015\u0004b\u0002B(\u0001\u0011\u0005\u0011Q\r\u0005\t\u0005#\u0002A\u0011A\u001e\u0003T\tQ\"\t\\8dW6\u000bg.Y4fe\u0012+7m\\7nSN\u001c\u0018n\u001c8fe*\u0011A(P\u0001\bgR|'/Y4f\u0015\tqt(A\u0003ta\u0006\u00148N\u0003\u0002A\u0003\u00061\u0011\r]1dQ\u0016T\u0011AQ\u0001\u0004_J<7c\u0001\u0001E\u0015B\u0011Q\tS\u0007\u0002\r*\tq)A\u0003tG\u0006d\u0017-\u0003\u0002J\r\n1\u0011I\\=SK\u001a\u0004\"a\u0013(\u000e\u00031S!!T\u001f\u0002\u0011%tG/\u001a:oC2L!a\u0014'\u0003\u000f1{wmZ5oO\u0006!1m\u001c8g\u0007\u0001\u0001\"a\u0015+\u000e\u0003uJ!!V\u001f\u0003\u0013M\u0003\u0018M]6D_:4\u0017A\u00012n!\tA\u0016,D\u0001<\u0013\tQ6H\u0001\u0007CY>\u001c7.T1oC\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\u0004;z{\u0006C\u0001-\u0001\u0011\u0015\u00016\u00011\u0001S\u0011\u001516\u00011\u0001X\u0003=1\u0017\r\u001c7cC\u000e\\7\u000b^8sC\u001e,W#\u00012\u0011\u0007\u0015\u001bW-\u0003\u0002e\r\n1q\n\u001d;j_:\u0004\"\u0001\u00174\n\u0005\u001d\\$a\u0004$bY2\u0014\u0017mY6Ti>\u0014\u0018mZ3\u0002!\u0019\fG\u000e\u001c2bG.\u001cFo\u001c:bO\u0016\u0004\u0013!J7bqJ+\u0007\u000f\\5dCRLwN\u001c$bS2,(/Z:G_J$UmY8n[&\u001c8/[8o+\u0005Y\u0007CA#m\u0013\tigIA\u0002J]R\fa%\\1y%\u0016\u0004H.[2bi&|gNR1jYV\u0014Xm\u001d$pe\u0012+7m\\7nSN\u001c\u0018n\u001c8!\u0003Qa\u0017m\u001d;S\t\u0012k\u0015n\u001a:bi&|g\u000eV5nKV\t\u0011\u000f\u0005\u0002Fe&\u00111O\u0012\u0002\u0005\u0019>tw-\u0001\rmCN$(\u000b\u0012#NS\u001e\u0014\u0018\r^5p]RKW.Z0%KF$\"A^=\u0011\u0005\u0015;\u0018B\u0001=G\u0005\u0011)f.\u001b;\t\u000fiL\u0011\u0011!a\u0001c\u0006\u0019\u0001\u0010J\u0019\u0002+1\f7\u000f\u001e*E\t6KwM]1uS>tG+[7fA!\u0012!\" \t\u0003\u000bzL!a $\u0003\u0011Y|G.\u0019;jY\u0016\f\u0001\u0004\\1tiNCWO\u001a4mK6KwM]1uS>tG+[7f\u0003qa\u0017m\u001d;TQV4g\r\\3NS\u001e\u0014\u0018\r^5p]RKW.Z0%KF$2A^A\u0004\u0011\u001dQH\"!AA\u0002E\f\u0011\u0004\\1tiNCWO\u001a4mK6KwM]1uS>tG+[7fA!\u0012Q\"`\u0001\u000ee\u0012$'\t\\8dWNdUM\u001a;\u0016\u0005\u0005E\u0001cA#\u0002\u0014%\u0019\u0011Q\u0003$\u0003\u000f\t{w\u000e\\3b]\u0006\t\"\u000f\u001a3CY>\u001c7n\u001d'fMR|F%Z9\u0015\u0007Y\fY\u0002\u0003\u0005{\u001f\u0005\u0005\t\u0019AA\t\u00039\u0011H\r\u001a\"m_\u000e\\7\u000fT3gi\u0002B#\u0001E?\u0002#MDWO\u001a4mK\ncwnY6t\u0019\u00164G/A\u000btQV4g\r\\3CY>\u001c7n\u001d'fMR|F%Z9\u0015\u0007Y\f9\u0003\u0003\u0005{%\u0005\u0005\t\u0019AA\t\u0003I\u0019\b.\u001e4gY\u0016\u0014En\\2lg2+g\r\u001e\u0011)\u0005Mi(\u0001G*ik\u001a4G.Z'jOJ\fG/[8o%Vtg.\u00192mKN)A#!\r\u0002BA!\u00111GA\u001f\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012\u0001\u00027b]\u001eT!!a\u000f\u0002\t)\fg/Y\u0005\u0005\u0003\u007f\t)D\u0001\u0004PE*,7\r\u001e\t\u0005\u0003g\t\u0019%\u0003\u0003\u0002F\u0005U\"\u0001\u0003*v]:\f'\r\\3\u0002\tA,WM\u001d\t\u00041\u0006-\u0013bAA'w\tq!\t\\8dW6\u000bg.Y4fe&#G\u0003BA)\u0003+\u00022!a\u0015\u0015\u001b\u0005\u0001\u0001bBA$-\u0001\u0007\u0011\u0011J\u0001\beVtg.\u001b8h\u0003-\u0011XO\u001c8j]\u001e|F%Z9\u0015\u0007Y\fi\u0006\u0003\u0005{1\u0005\u0005\t\u0019AA\t\u0003!\u0011XO\u001c8j]\u001e\u0004\u0003FA\r~\u0003\r\u0011XO\u001c\u000b\u0002m\u0006\tR.[4sCRLgnZ*ik\u001a4G.Z:\u0016\u0005\u0005-\u0004CBA7\u0003o\nY(\u0004\u0002\u0002p)!\u0011\u0011OA:\u0003\u001diW\u000f^1cY\u0016T1!!\u001eG\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003s\nyGA\u0004ICND7+\u001a;\u0011\t\u0005u\u00141Q\u0007\u0003\u0003\u007fR1!!!>\u0003\u001d\u0019\b.\u001e4gY\u0016LA!!\"\u0002\u0000\t\u00012\u000b[;gM2,'\t\\8dW&sgm\\\u0001\u0013[&<'/\u0019;j]\u001e\u001c\u0006.\u001e4gY\u0016\u001c\b%A\nok6l\u0015n\u001a:bi\u0016$7\u000b[;gM2,7/\u0006\u0002\u0002\u000eB!\u0011qRAO\u001b\t\t\tJ\u0003\u0003\u0002\u0014\u0006U\u0015AB1u_6L7M\u0003\u0003\u0002\u0018\u0006e\u0015AC2p]\u000e,(O]3oi*!\u00111TA\u001d\u0003\u0011)H/\u001b7\n\t\u0005}\u0015\u0011\u0013\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\u0002)9,X.T5he\u0006$X\rZ*ik\u001a4G.Z:!\u0003E\u0019\b.\u001e4gY\u0016\u001cHk\\'jOJ\fG/Z\u000b\u0003\u0003O\u0003b!!+\u0002,\u0006=VBAAK\u0013\u0011\ti+!&\u0003+\r{gnY;se\u0016tG\u000fT5oW\u0016$\u0017+^3vKB1Q)!-\u0002|-L1!a-G\u0005\u0019!V\u000f\u001d7fe\u0005\u00112\u000f[;gM2,7\u000fV8NS\u001e\u0014\u0018\r^3!\u0003\u001d\u0019Ho\u001c9qK\u0012\f1b\u001d;paB,Gm\u0018\u0013fcR\u0019a/!0\t\u0011i\u0014\u0013\u0011!a\u0001\u0003#\t\u0001b\u001d;paB,G\r\t\u0015\u0003Gu\f!b\u001d;paB,GM\u0015#E\u00039\u0019Ho\u001c9qK\u0012\u0014F\tR0%KF$2A^Ae\u0011!QX%!AA\u0002\u0005E\u0011aC:u_B\u0004X\r\u001a*E\t\u0002B#AJ?\u0002\u001dM$x\u000e\u001d9fINCWO\u001a4mK\u0006\u00112\u000f^8qa\u0016$7\u000b[;gM2,w\fJ3r)\r1\u0018Q\u001b\u0005\tu\"\n\t\u00111\u0001\u0002\u0012\u0005y1\u000f^8qa\u0016$7\u000b[;gM2,\u0007\u0005\u000b\u0002*{\u0006qQ.[4sCRLwN\u001c)fKJ\u001cXCAAp!!\ti'!9\u0002J\u0005E\u0013\u0002BAr\u0003_\u0012q\u0001S1tQ6\u000b\u0007/A\bnS\u001e\u0014\u0018\r^5p]B+WM]:!\u0003e\u0011H\r\u001a\"m_\u000e\\W*[4sCRLwN\\#yK\u000e,Ho\u001c:\u0016\u0005\u0005-\b\u0003BAU\u0003[LA!a<\u0002\u0016\nyQ\t_3dkR|'oU3sm&\u001cW-A\rsI\u0012\u0014En\\2l\u001b&<'/\u0019;j_:\u0014VO\u001c8bE2,WCAA{%\u0019\t90!\r\u0002B\u00191\u0011\u0011 \u0018\u0001\u0003k\u0014A\u0002\u0010:fM&tW-\\3oiz\n!D\u001d3e\u00052|7m['jOJ\fG/[8o%Vtg.\u00192mK\u0002B\u0011\"a@\u0002x\n\u0007I\u0011\u00019\u0002\u001bMdW-\u001a9J]R,'O^1m\u0003\u0011\u001a\b.\u001e4gY\u0016\u0014En\\2l\u001b&<'/\u0019;j_:\u0014VM\u001a:fg\",\u00050Z2vi>\u0014\u0018\u0001J:ik\u001a4G.\u001a\"m_\u000e\\W*[4sCRLwN\u001c*fMJ,7\u000f\u001b*v]:\f'\r\\3\u0016\u0005\t\u001d!C\u0002B\u0005\u0003c\t\tE\u0002\u0004\u0002zF\u0002!qA\u0001&g\",hM\u001a7f\u00052|7m['jOJ\fG/[8o%\u00164'/Z:i%Vtg.\u00192mK\u0002B\u0011\"a@\u0003\n\t\u0007I\u0011\u00019\u0002)MDWO\u001a4mK6KwM]1uS>t\u0007k\\8m+\t\u0011\u0019\u0002\u0005\u0003\u0002*\nU\u0011\u0002\u0002B\f\u0003+\u0013!\u0003\u00165sK\u0006$\u0007k\\8m\u000bb,7-\u001e;pe\u0006q\"/\u001a4sKNDwJ\u001a4m_\u0006$\u0017N\\4TQV4g\r\\3CY>\u001c7n\u001d\u000b\u0003\u0003#\t1d\u001d;pa>3g\r\\8bI&twm\u00155vM\u001adWM\u00117pG.\u001c\u0018A\u00073fG>lW.[:tS>t'\u000b\u001a3DC\u000eDWM\u00117pG.\u001c\u0018\u0001D7jOJ\fG/\u001a\"m_\u000e\\G\u0003BA\t\u0005KAqAa\n7\u0001\u0004\u0011I#\u0001\tcY>\u001c7\u000eV8SKBd\u0017nY1uKB!!1\u0006B$\u001d\u0011\u0011iCa\u0011\u000f\t\t=\"\u0011\t\b\u0005\u0005c\u0011yD\u0004\u0003\u00034\tub\u0002\u0002B\u001b\u0005wi!Aa\u000e\u000b\u0007\te\u0012+\u0001\u0004=e>|GOP\u0005\u0002\u0005&\u0011\u0001)Q\u0005\u0003}}J!\u0001P\u001f\n\u0007\t\u00153(\u0001\u000bCY>\u001c7.T1oC\u001e,'/T3tg\u0006<Wm]\u0005\u0005\u0005\u0013\u0012YE\u0001\bSKBd\u0017nY1uK\ncwnY6\u000b\u0007\t\u00153(A\u0003ti\u0006\u0014H/\u0001\u0003ti>\u0004\u0018!\u00057bgRl\u0015n\u001a:bi&|g.\u00138g_R\u0011!Q\u000b\t\u0007\u000b\u0006E\u0016/!\u0005")
public class BlockManagerDecommissioner
implements Logging {
    private ExecutorService rddBlockMigrationExecutor;
    private ExecutorService shuffleBlockMigrationRefreshExecutor;
    private ThreadPoolExecutor shuffleMigrationPool;
    public final SparkConf org$apache$spark$storage$BlockManagerDecommissioner$$conf;
    public final BlockManager org$apache$spark$storage$BlockManagerDecommissioner$$bm;
    private final Option<FallbackStorage> org$apache$spark$storage$BlockManagerDecommissioner$$fallbackStorage;
    private final int org$apache$spark$storage$BlockManagerDecommissioner$$maxReplicationFailuresForDecommission;
    private volatile long lastRDDMigrationTime;
    private volatile long lastShuffleMigrationTime;
    private volatile boolean rddBlocksLeft;
    private volatile boolean shuffleBlocksLeft;
    private final HashSet<ShuffleBlockInfo> migratingShuffles;
    private final AtomicInteger numMigratedShuffles;
    private final ConcurrentLinkedQueue<Tuple2<ShuffleBlockInfo, Object>> shufflesToMigrate;
    private volatile boolean org$apache$spark$storage$BlockManagerDecommissioner$$stopped;
    private volatile boolean org$apache$spark$storage$BlockManagerDecommissioner$$stoppedRDD;
    private volatile boolean org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle;
    private final HashMap<BlockManagerId, ShuffleMigrationRunnable> migrationPeers;
    private final Runnable rddBlockMigrationRunnable;
    private final Runnable shuffleBlockMigrationRefreshRunnable;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<FallbackStorage> org$apache$spark$storage$BlockManagerDecommissioner$$fallbackStorage() {
        return this.org$apache$spark$storage$BlockManagerDecommissioner$$fallbackStorage;
    }

    public int org$apache$spark$storage$BlockManagerDecommissioner$$maxReplicationFailuresForDecommission() {
        return this.org$apache$spark$storage$BlockManagerDecommissioner$$maxReplicationFailuresForDecommission;
    }

    public long lastRDDMigrationTime() {
        return this.lastRDDMigrationTime;
    }

    public void lastRDDMigrationTime_$eq(long x$1) {
        this.lastRDDMigrationTime = x$1;
    }

    public long lastShuffleMigrationTime() {
        return this.lastShuffleMigrationTime;
    }

    public void lastShuffleMigrationTime_$eq(long x$1) {
        this.lastShuffleMigrationTime = x$1;
    }

    public boolean rddBlocksLeft() {
        return this.rddBlocksLeft;
    }

    public void rddBlocksLeft_$eq(boolean x$1) {
        this.rddBlocksLeft = x$1;
    }

    public boolean shuffleBlocksLeft() {
        return this.shuffleBlocksLeft;
    }

    public void shuffleBlocksLeft_$eq(boolean x$1) {
        this.shuffleBlocksLeft = x$1;
    }

    public HashSet<ShuffleBlockInfo> migratingShuffles() {
        return this.migratingShuffles;
    }

    public AtomicInteger numMigratedShuffles() {
        return this.numMigratedShuffles;
    }

    public ConcurrentLinkedQueue<Tuple2<ShuffleBlockInfo, Object>> shufflesToMigrate() {
        return this.shufflesToMigrate;
    }

    public boolean org$apache$spark$storage$BlockManagerDecommissioner$$stopped() {
        return this.org$apache$spark$storage$BlockManagerDecommissioner$$stopped;
    }

    public void org$apache$spark$storage$BlockManagerDecommissioner$$stopped_$eq(boolean x$1) {
        this.org$apache$spark$storage$BlockManagerDecommissioner$$stopped = x$1;
    }

    public boolean org$apache$spark$storage$BlockManagerDecommissioner$$stoppedRDD() {
        return this.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedRDD;
    }

    public void org$apache$spark$storage$BlockManagerDecommissioner$$stoppedRDD_$eq(boolean x$1) {
        this.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedRDD = x$1;
    }

    public boolean org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle() {
        return this.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle;
    }

    public void org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle_$eq(boolean x$1) {
        this.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle = x$1;
    }

    private HashMap<BlockManagerId, ShuffleMigrationRunnable> migrationPeers() {
        return this.migrationPeers;
    }

    private ExecutorService rddBlockMigrationExecutor$lzycompute() {
        BlockManagerDecommissioner blockManagerDecommissioner = this;
        synchronized (blockManagerDecommissioner) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.rddBlockMigrationExecutor = ThreadUtils$.MODULE$.newDaemonSingleThreadExecutor("block-manager-decommission-rdd");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.rddBlockMigrationExecutor;
    }

    private ExecutorService rddBlockMigrationExecutor() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.rddBlockMigrationExecutor$lzycompute() : this.rddBlockMigrationExecutor;
    }

    private Runnable rddBlockMigrationRunnable() {
        return this.rddBlockMigrationRunnable;
    }

    private ExecutorService shuffleBlockMigrationRefreshExecutor$lzycompute() {
        BlockManagerDecommissioner blockManagerDecommissioner = this;
        synchronized (blockManagerDecommissioner) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.shuffleBlockMigrationRefreshExecutor = ThreadUtils$.MODULE$.newDaemonSingleThreadExecutor("block-manager-decommission-shuffle");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.shuffleBlockMigrationRefreshExecutor;
    }

    private ExecutorService shuffleBlockMigrationRefreshExecutor() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.shuffleBlockMigrationRefreshExecutor$lzycompute() : this.shuffleBlockMigrationRefreshExecutor;
    }

    private Runnable shuffleBlockMigrationRefreshRunnable() {
        return this.shuffleBlockMigrationRefreshRunnable;
    }

    private ThreadPoolExecutor shuffleMigrationPool$lzycompute() {
        BlockManagerDecommissioner blockManagerDecommissioner = this;
        synchronized (blockManagerDecommissioner) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.shuffleMigrationPool = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("migrate-shuffles", BoxesRunTime.unboxToInt((Object)this.org$apache$spark$storage$BlockManagerDecommissioner$$conf.get(package$.MODULE$.STORAGE_DECOMMISSION_SHUFFLE_MAX_THREADS())), ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.shuffleMigrationPool;
    }

    public ThreadPoolExecutor shuffleMigrationPool() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.shuffleMigrationPool$lzycompute() : this.shuffleMigrationPool;
    }

    public boolean refreshOffloadingShuffleBlocks() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Offloading shuffle blocks");
        Set localShuffles = this.org$apache$spark$storage$BlockManagerDecommissioner$$bm.migratableResolver().getStoredShuffles().toSet();
        Seq newShufflesToMigrate = (Seq)localShuffles.diff(this.migratingShuffles()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)b -> new Tuple2.mcIJ.sp(b.shuffleId(), b.mapId()), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Long$.MODULE$));
        this.shufflesToMigrate().addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)newShufflesToMigrate.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)0)), Seq$.MODULE$.canBuildFrom())).asJava());
        this.migratingShuffles().$plus$plus$eq((TraversableOnce)newShufflesToMigrate);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append(newShufflesToMigrate.size()).append(" of ").append(localShuffles.size()).append(" local shuffles ").append("are added. In total, ").append(this.migratingShuffles().size()).append(" shuffles are remained.").toString());
        Set livePeerSet = this.org$apache$spark$storage$BlockManagerDecommissioner$$bm.getPeers(false).toSet();
        Set currentPeerSet = this.migrationPeers().keys().toSet();
        Set deadPeers = (Set)currentPeerSet.diff((GenSet)livePeerSet);
        Set newPeers = (Set)livePeerSet.diff((GenSet)currentPeerSet);
        this.migrationPeers().$plus$plus$eq((TraversableOnce)newPeers.map((Function1 & Serializable & scala.Serializable)peer -> {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Starting thread to migrate shuffle blocks to ").append(peer).toString());
            ShuffleMigrationRunnable runnable = new ShuffleMigrationRunnable(this, (BlockManagerId)peer);
            this.shuffleMigrationPool().submit(runnable);
            return new Tuple2(peer, (Object)runnable);
        }, Set$.MODULE$.canBuildFrom()));
        deadPeers.foreach((Function1 & Serializable & scala.Serializable)peer -> {
            BlockManagerDecommissioner.$anonfun$refreshOffloadingShuffleBlocks$7(this, peer);
            return BoxedUnit.UNIT;
        });
        if (this.migrationPeers().values().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)BlockManagerDecommissioner.$anonfun$refreshOffloadingShuffleBlocks$9(x$3))).isEmpty()) {
            this.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle_$eq(true);
        }
        return newShufflesToMigrate.nonEmpty() || this.migratingShuffles().size() > this.numMigratedShuffles().get();
    }

    public void stopOffloadingShuffleBlocks() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping offloading shuffle blocks.");
        this.migrationPeers().values().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.running_$eq(false);
            return BoxedUnit.UNIT;
        });
        this.shuffleMigrationPool().shutdown();
        this.shuffleMigrationPool().shutdownNow();
    }

    public boolean decommissionRddCacheBlocks() {
        Seq<BlockManagerMessages.ReplicateBlock> replicateBlocksInfo = this.org$apache$spark$storage$BlockManagerDecommissioner$$bm.getMigratableRDDBlocks();
        if (!replicateBlocksInfo.nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Asked to decommission RDD cache blocks, but no blocks to migrate");
            return false;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Need to replicate ").append(replicateBlocksInfo.size()).append(" RDD blocks ").append("for block manager decommissioning").toString());
        Seq blocksFailedReplication = (Seq)((TraversableLike)((TraversableLike)replicateBlocksInfo.map((Function1 & Serializable & scala.Serializable)replicateBlock -> {
            boolean replicatedSuccessfully = this.migrateBlock((BlockManagerMessages.ReplicateBlock)replicateBlock);
            return new Tuple2((Object)replicateBlock.blockId(), (Object)BoxesRunTime.boxToBoolean((boolean)replicatedSuccessfully));
        }, Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5._2$mcZ$sp()))).map((Function1 & Serializable & scala.Serializable)x$6 -> (BlockId)x$6._1(), Seq$.MODULE$.canBuildFrom());
        if (blocksFailedReplication.nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Blocks failed replication in cache decommissioning ").append("process: ").append(blocksFailedReplication.mkString(",")).toString());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean migrateBlock(BlockManagerMessages.ReplicateBlock blockToReplicate) {
        void var2_2;
        boolean replicatedSuccessfully = this.org$apache$spark$storage$BlockManagerDecommissioner$$bm.replicateBlock(blockToReplicate.blockId(), (Set<BlockManagerId>)blockToReplicate.replicas().toSet(), blockToReplicate.maxReplicas(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.org$apache$spark$storage$BlockManagerDecommissioner$$maxReplicationFailuresForDecommission())));
        if (replicatedSuccessfully) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Block ").append(blockToReplicate.blockId()).append(" offloaded successfully, Removing block now").toString());
            this.org$apache$spark$storage$BlockManagerDecommissioner$$bm.removeBlock(blockToReplicate.blockId(), this.org$apache$spark$storage$BlockManagerDecommissioner$$bm.removeBlock$default$2());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Block ").append(blockToReplicate.blockId()).append(" removed").toString());
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Failed to offload block ").append(blockToReplicate.blockId()).toString());
        }
        return (boolean)var2_2;
    }

    public void start() {
        block0: {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting block migration thread");
            Object object = BoxesRunTime.unboxToBoolean((Object)this.org$apache$spark$storage$BlockManagerDecommissioner$$conf.get(package$.MODULE$.STORAGE_DECOMMISSION_RDD_BLOCKS_ENABLED())) ? this.rddBlockMigrationExecutor().submit(this.rddBlockMigrationRunnable()) : BoxedUnit.UNIT;
            Object object2 = BoxesRunTime.unboxToBoolean((Object)this.org$apache$spark$storage$BlockManagerDecommissioner$$conf.get(package$.MODULE$.STORAGE_DECOMMISSION_SHUFFLE_BLOCKS_ENABLED())) ? this.shuffleBlockMigrationRefreshExecutor().submit(this.shuffleBlockMigrationRefreshRunnable()) : BoxedUnit.UNIT;
            if (BoxesRunTime.unboxToBoolean((Object)this.org$apache$spark$storage$BlockManagerDecommissioner$$conf.get(package$.MODULE$.STORAGE_DECOMMISSION_SHUFFLE_BLOCKS_ENABLED())) || BoxesRunTime.unboxToBoolean((Object)this.org$apache$spark$storage$BlockManagerDecommissioner$$conf.get(package$.MODULE$.STORAGE_DECOMMISSION_RDD_BLOCKS_ENABLED()))) break block0;
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Storage decommissioning attempted but neither ").append(package$.MODULE$.STORAGE_DECOMMISSION_SHUFFLE_BLOCKS_ENABLED().key()).append(" or ").append(package$.MODULE$.STORAGE_DECOMMISSION_RDD_BLOCKS_ENABLED().key()).append(" is enabled ").toString());
            this.org$apache$spark$storage$BlockManagerDecommissioner$$stopped_$eq(true);
        }
    }

    public void stop() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.org$apache$spark$storage$BlockManagerDecommissioner$$stopped()) {
            return;
        }
        this.org$apache$spark$storage$BlockManagerDecommissioner$$stopped_$eq(true);
        try {
            this.rddBlockMigrationExecutor().shutdown();
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error during shutdown", e);
        }
        try {
            this.shuffleBlockMigrationRefreshExecutor().shutdown();
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error during shutdown", e);
        }
        try {
            this.stopOffloadingShuffleBlocks();
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error during shutdown", e);
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Forcing block migrations threads to stop");
        try {
            boxedUnit2 = this.rddBlockMigrationExecutor().shutdownNow();
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error during shutdown", e);
            boxedUnit2 = BoxedUnit.UNIT;
        }
        try {
            boxedUnit = this.shuffleBlockMigrationRefreshExecutor().shutdownNow();
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error during shutdown", e);
            boxedUnit = BoxedUnit.UNIT;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped storage decommissioner");
    }

    public Tuple2<Object, Object> lastMigrationInfo() {
        Tuple2.mcJZ.sp sp2;
        if (this.org$apache$spark$storage$BlockManagerDecommissioner$$stopped() || this.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedRDD() && this.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle()) {
            sp2 = new Tuple2.mcJZ.sp(Long.MAX_VALUE, true);
        } else {
            long lastMigrationTime = !this.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedRDD() && !this.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle() ? Math.min(this.lastRDDMigrationTime(), this.lastShuffleMigrationTime()) : (!this.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle() ? this.lastShuffleMigrationTime() : this.lastRDDMigrationTime());
            boolean blocksMigrated = !(this.shuffleBlocksLeft() && !this.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle() || this.rddBlocksLeft() && !this.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedRDD());
            sp2 = new Tuple2.mcJZ.sp(lastMigrationTime, blocksMigrated);
        }
        return sp2;
    }

    public static final /* synthetic */ void $anonfun$refreshOffloadingShuffleBlocks$7(BlockManagerDecommissioner $this, BlockManagerId peer) {
        $this.migrationPeers().get((Object)peer).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.running_$eq(false);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$refreshOffloadingShuffleBlocks$9(ShuffleMigrationRunnable x$3) {
        return x$3.running();
    }

    public BlockManagerDecommissioner(SparkConf conf, BlockManager bm) {
        this.org$apache$spark$storage$BlockManagerDecommissioner$$conf = conf;
        this.org$apache$spark$storage$BlockManagerDecommissioner$$bm = bm;
        Logging.$init$(this);
        this.org$apache$spark$storage$BlockManagerDecommissioner$$fallbackStorage = FallbackStorage$.MODULE$.getFallbackStorage(conf);
        this.org$apache$spark$storage$BlockManagerDecommissioner$$maxReplicationFailuresForDecommission = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_MAX_REPLICATION_FAILURE_PER_BLOCK()));
        this.lastRDDMigrationTime = 0L;
        this.lastShuffleMigrationTime = 0L;
        this.rddBlocksLeft = true;
        this.shuffleBlocksLeft = true;
        this.migratingShuffles = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.numMigratedShuffles = new AtomicInteger(0);
        this.shufflesToMigrate = new ConcurrentLinkedQueue();
        this.org$apache$spark$storage$BlockManagerDecommissioner$$stopped = false;
        this.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedRDD = !BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_RDD_BLOCKS_ENABLED()));
        this.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle = !BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_SHUFFLE_BLOCKS_ENABLED()));
        this.migrationPeers = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.rddBlockMigrationRunnable = new Runnable(this){
            private final long sleepInterval;
            private final /* synthetic */ BlockManagerDecommissioner $outer;

            public long sleepInterval() {
                return this.sleepInterval;
            }

            public void run() {
                Predef$.MODULE$.assert(BoxesRunTime.unboxToBoolean((Object)this.$outer.org$apache$spark$storage$BlockManagerDecommissioner$$conf.get(package$.MODULE$.STORAGE_DECOMMISSION_RDD_BLOCKS_ENABLED())));
                while (!(this.$outer.org$apache$spark$storage$BlockManagerDecommissioner$$stopped() || this.$outer.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedRDD() || Thread.interrupted())) {
                    this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Iterating on migrating from the block manager.");
                    Seq<BlockManagerId> peers = this.$outer.org$apache$spark$storage$BlockManagerDecommissioner$$bm.getPeers(false);
                    if (peers.isEmpty()) {
                        this.$outer.org$apache$spark$storage$BlockManagerDecommissioner$$stopped_$eq(true);
                        this.$outer.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedRDD_$eq(true);
                    }
                    try {
                        long startTime = System.nanoTime();
                        this.$outer.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempting to replicate all cached RDD blocks");
                        this.$outer.rddBlocksLeft_$eq(this.$outer.decommissionRddCacheBlocks());
                        this.$outer.lastRDDMigrationTime_$eq(startTime);
                        this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempt to replicate all cached blocks done");
                        this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Waiting for ").append(this.sleepInterval()).append(" before refreshing migrations.").toString());
                        Thread.sleep(this.sleepInterval());
                    }
                    catch (Throwable throwable) {
                        BoxedUnit boxedUnit;
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof InterruptedException) {
                            this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Interrupted during RDD migration, stopping");
                            this.$outer.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedRDD_$eq(true);
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred replicating RDD for block manager decommissioning.", e);
                            this.$outer.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedRDD_$eq(true);
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        throw throwable;
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sleepInterval = BoxesRunTime.unboxToLong((Object)$outer.org$apache$spark$storage$BlockManagerDecommissioner$$conf.get(package$.MODULE$.STORAGE_DECOMMISSION_REPLICATION_REATTEMPT_INTERVAL()));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$15(), $anonfun$run$16(), $anonfun$run$17(), $anonfun$run$18(org.apache.spark.storage.BlockManagerDecommissioner$$anon$1 ), $anonfun$run$19(), $anonfun$run$20()}, serializedLambda);
            }
        };
        this.shuffleBlockMigrationRefreshRunnable = new Runnable(this){
            private final long sleepInterval;
            private final /* synthetic */ BlockManagerDecommissioner $outer;

            public long sleepInterval() {
                return this.sleepInterval;
            }

            public void run() {
                Predef$.MODULE$.assert(BoxesRunTime.unboxToBoolean((Object)this.$outer.org$apache$spark$storage$BlockManagerDecommissioner$$conf.get(package$.MODULE$.STORAGE_DECOMMISSION_SHUFFLE_BLOCKS_ENABLED())));
                while (!(this.$outer.org$apache$spark$storage$BlockManagerDecommissioner$$stopped() || this.$outer.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle() || Thread.interrupted())) {
                    try {
                        this.$outer.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempting to replicate all shuffle blocks");
                        long startTime = System.nanoTime();
                        this.$outer.shuffleBlocksLeft_$eq(this.$outer.refreshOffloadingShuffleBlocks());
                        this.$outer.lastShuffleMigrationTime_$eq(startTime);
                        this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Done starting workers to migrate shuffle blocks");
                        Thread.sleep(this.sleepInterval());
                    }
                    catch (Throwable throwable) {
                        BoxedUnit boxedUnit;
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof InterruptedException) {
                            this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Interrupted during migration, will not refresh migrations.");
                            this.$outer.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle_$eq(true);
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred while trying to replicate for block manager decommissioning.", e);
                            this.$outer.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle_$eq(true);
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        throw throwable;
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sleepInterval = BoxesRunTime.unboxToLong((Object)$outer.org$apache$spark$storage$BlockManagerDecommissioner$$conf.get(package$.MODULE$.STORAGE_DECOMMISSION_REPLICATION_REATTEMPT_INTERVAL()));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$21(), $anonfun$run$22(), $anonfun$run$23(), $anonfun$run$24()}, serializedLambda);
            }
        };
    }

    public class ShuffleMigrationRunnable
    implements Runnable {
        private final BlockManagerId peer;
        private volatile boolean running;
        public final /* synthetic */ BlockManagerDecommissioner $outer;

        public boolean running() {
            return this.running;
        }

        public void running_$eq(boolean x$1) {
            this.running = x$1;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            None$ migrating = None$.MODULE$;
            this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Starting migration thread for ").append($this.peer).toString());
            try {
                while (this.running()) {
                    block10: {
                        int retryCount;
                        ShuffleBlockInfo shuffleBlockInfo;
                        block11: {
                            if (Thread.interrupted()) return;
                            migrating = Option$.MODULE$.apply(this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().shufflesToMigrate().poll());
                            None$ none$ = migrating;
                            if (None$.MODULE$.equals(none$)) {
                                this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Nothing to migrate");
                                int SLEEP_TIME_SECS = 1;
                                Thread.sleep((long)SLEEP_TIME_SECS * 1000L);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                continue;
                            }
                            if (!(none$ instanceof Some)) throw new MatchError((Object)none$);
                            Some some = (Some)none$;
                            Tuple2 tuple2 = (Tuple2)some.value();
                            if (tuple2 == null) throw new MatchError((Object)none$);
                            shuffleBlockInfo = (ShuffleBlockInfo)tuple2._1();
                            retryCount = tuple2._2$mcI$sp();
                            if (retryCount >= this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().org$apache$spark$storage$BlockManagerDecommissioner$$maxReplicationFailuresForDecommission()) break block11;
                            List<Tuple2<BlockId, ManagedBuffer>> blocks = this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().org$apache$spark$storage$BlockManagerDecommissioner$$bm.migratableResolver().getMigrationBlocks(shuffleBlockInfo);
                            if (blocks.isEmpty()) {
                                this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Ignore empty shuffle block ").append(shuffleBlockInfo).toString());
                                break block10;
                            } else {
                                this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Got migration sub-blocks ").append(blocks).toString());
                                this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Trying to migrate shuffle ").append(shuffleBlockInfo).append(" to ").append($this.peer).append(" ").append("(").append(retryCount).append(" / ").append(this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().org$apache$spark$storage$BlockManagerDecommissioner$$maxReplicationFailuresForDecommission()).append(")").toString());
                                try {
                                    blocks.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                                        ShuffleMigrationRunnable.$anonfun$run$6(this, x0$1);
                                        return BoxedUnit.UNIT;
                                    });
                                    this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Migrated ").append(shuffleBlockInfo).append(" to ").append($this.peer).toString());
                                }
                                catch (IOException e) {
                                    if (this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().org$apache$spark$storage$BlockManagerDecommissioner$$bm.migratableResolver().getMigrationBlocks(shuffleBlockInfo).isEmpty()) {
                                        this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Skipping block ").append(shuffleBlockInfo).append(", block deleted.").toString());
                                        break block10;
                                    }
                                    if (!this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().org$apache$spark$storage$BlockManagerDecommissioner$$fallbackStorage().isDefined()) throw e;
                                    this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().org$apache$spark$storage$BlockManagerDecommissioner$$fallbackStorage().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                                        x$1.copy(shuffleBlockInfo, this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().org$apache$spark$storage$BlockManagerDecommissioner$$bm);
                                        return BoxedUnit.UNIT;
                                    });
                                }
                            }
                            break block10;
                        }
                        this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Skipping block ").append(shuffleBlockInfo).append(" because it has failed ").append(retryCount).toString());
                    }
                    Integer n = BoxesRunTime.boxToInteger((int)this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().numMigratedShuffles().incrementAndGet());
                }
                return;
            }
            catch (Exception e) {
                Some some;
                Tuple2 tuple2;
                None$ none$ = migrating;
                if (none$ instanceof Some && (tuple2 = (Tuple2)(some = (Some)none$).value()) != null) {
                    ShuffleBlockInfo shuffleMap = (ShuffleBlockInfo)tuple2._1();
                    int retryCount = tuple2._2$mcI$sp();
                    this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Error during migration, adding ").append(shuffleMap).append(" back to migration queue").toString(), e);
                    this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().shufflesToMigrate().add((Tuple2<ShuffleBlockInfo, Object>)new Tuple2((Object)shuffleMap, (Object)BoxesRunTime.boxToInteger((int)(retryCount + 1))));
                    this.running_$eq(false);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (!None$.MODULE$.equals(none$)) throw new MatchError((Object)none$);
                this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while waiting for block to migrate", e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }

        public /* synthetic */ BlockManagerDecommissioner org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$run$6(ShuffleMigrationRunnable $this, Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BlockId blockId = (BlockId)tuple2._1();
            ManagedBuffer buffer = (ManagedBuffer)tuple2._2();
            $this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Migrating sub-block ").append(blockId).toString());
            $this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().org$apache$spark$storage$BlockManagerDecommissioner$$bm.blockTransferService().uploadBlockSync($this.peer.host(), $this.peer.port(), $this.peer.executorId(), blockId, buffer, StorageLevel$.MODULE$.DISK_ONLY(), null);
            $this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Migrated sub block ").append(blockId).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        public ShuffleMigrationRunnable(BlockManagerDecommissioner $outer, BlockManagerId peer) {
            this.peer = peer;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.running = true;
        }
    }
}

