/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status.api.v1;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.status.api.v1.ApiRequestContext;
import org.apache.spark.status.api.v1.ApplicationEnvironmentInfo;
import org.apache.spark.status.api.v1.BadParameterException;
import org.apache.spark.status.api.v1.BaseAppResource;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.status.api.v1.NotFoundException;
import org.apache.spark.status.api.v1.OneApplicationAttemptResource;
import org.apache.spark.status.api.v1.RDDStorageInfo;
import org.apache.spark.status.api.v1.ResourceProfileInfo;
import org.apache.spark.status.api.v1.ServiceUnavailable;
import org.apache.spark.status.api.v1.StagesResource;
import org.apache.spark.status.api.v1.ThreadStackTrace;
import org.apache.spark.status.api.v1.UIRoot;
import org.apache.spark.ui.SparkUI;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\u0005uf!B\u0007\u000f\u00019Q\u0002\"B\u0013\u0001\t\u00039\u0003\"B\u0015\u0001\t\u0003Q\u0003\"B0\u0001\t\u0003\u0001\u0007\"B8\u0001\t\u0003\u0001\b\"B=\u0001\t\u0003Q\bBBA\u0013\u0001\u0011\u0005\u0001\u000fC\u0004\u00020\u0001!\t!!\r\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002F!9\u0011q\u000b\u0001\u0005\u0002\u0005e\u0003bBA6\u0001\u0011\u0005\u0011Q\u000e\u0005\b\u0003{\u0002A\u0011AA@\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003K\u00131$\u00112tiJ\f7\r^!qa2L7-\u0019;j_:\u0014Vm]8ve\u000e,'BA\b\u0011\u0003\t1\u0018G\u0003\u0002\u0012%\u0005\u0019\u0011\r]5\u000b\u0005M!\u0012AB:uCR,8O\u0003\u0002\u0016-\u0005)1\u000f]1sW*\u0011q\u0003G\u0001\u0007CB\f7\r[3\u000b\u0003e\t1a\u001c:h'\r\u00011$\t\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\t\u001aS\"\u0001\b\n\u0005\u0011r!a\u0004\"bg\u0016\f\u0005\u000f\u001d*fg>,(oY3\u0002\rqJg.\u001b;?\u0007\u0001!\u0012\u0001\u000b\t\u0003E\u0001\t\u0001B[8cg2K7\u000f\u001e\u000b\u0003Wi\u00022\u0001\f\u001b8\u001d\ti#G\u0004\u0002/c5\tqF\u0003\u00021M\u00051AH]8pizJ\u0011AH\u0005\u0003gu\tq\u0001]1dW\u0006<W-\u0003\u00026m\t\u00191+Z9\u000b\u0005Mj\u0002C\u0001\u00129\u0013\tIdBA\u0004K_\n$\u0015\r^1\t\u000bm\u0012\u0001\u0019\u0001\u001f\u0002\u0011M$\u0018\r^;tKN\u00042!\u0010\"E\u001b\u0005q$BA A\u0003\u0011)H/\u001b7\u000b\u0003\u0005\u000bAA[1wC&\u00111I\u0010\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002F\r6\tA#\u0003\u0002H)\t\u0011\"j\u001c2Fq\u0016\u001cW\u000f^5p]N#\u0018\r^;tQ\u0011Q\u0014j\u0015+\u0011\u0005)\u000bV\"A&\u000b\u00051k\u0015A\u0001:t\u0015\tqu*\u0001\u0002xg*\t\u0001+A\u0003kCZ\f\u00070\u0003\u0002S\u0017\nQ\u0011+^3ssB\u000b'/Y7\u0002\u000bY\fG.^3\"\u0003MACA\u0001,T3B\u0011!jV\u0005\u00031.\u0013A\u0001U1uQ\u0006\n!,\u0001\u0003k_\n\u001c\bF\u0001\u0002]!\tQU,\u0003\u0002_\u0017\n\u0019q)\u0012+\u0002\r=tWMS8c)\t9\u0014\rC\u0003c\u0007\u0001\u00071-A\u0003k_\nLE\r\u0005\u0002\u001dI&\u0011Q-\b\u0002\u0004\u0013:$\b\u0006B1h'*\u0004\"A\u00135\n\u0005%\\%!\u0003)bi\"\u0004\u0016M]1nC\u0005\u0011\u0007\u0006B\u0002W'2\f\u0013!\\\u0001\u0012U>\u00147oL>k_\nLEM\u000f\u0011]I.j\bFA\u0002]\u00031)\u00070Z2vi>\u0014H*[:u)\u0005\t\bc\u0001\u00175eB\u0011!e]\u0005\u0003i:\u0011q\"\u0012=fGV$xN]*v[6\f'/\u001f\u0015\u0005\tY\u001bf/I\u0001x\u0003%)\u00070Z2vi>\u00148\u000f\u000b\u0002\u00059\u0006QA\u000f\u001b:fC\u0012$U/\u001c9\u0015\u0007m\f\u0019\u0001E\u0002\u001dyzL!!`\u000f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\tz\u0018bAA\u0001\u001d\t\u0001B\u000b\u001b:fC\u0012\u001cF/Y2l)J\f7-\u001a\u0005\b\u0003\u000b)\u0001\u0019AA\u0004\u0003\u0019)\u00070Z2JIB!\u0011\u0011BA\t\u001d\u0011\tY!!\u0004\u0011\u00059j\u0012bAA\b;\u00051\u0001K]3eK\u001aLA!a\u0005\u0002\u0016\t11\u000b\u001e:j]\u001eT1!a\u0004\u001eQ\u0019\t\u0019aZ*\u0002\u001a\u0005\u0012\u00111D\u0001\u000bKb,7-\u001e;pe&#\u0007&B\u0003W'\u0006}\u0011EAA\u0011\u0003y)\u00070Z2vi>\u00148oL>fq\u0016\u001cW\u000f^8s\u0013\u0012lx\u0006\u001e5sK\u0006$7\u000f\u000b\u0002\u00069\u0006y\u0011\r\u001c7Fq\u0016\u001cW\u000f^8s\u0019&\u001cH\u000fK\u0003\u0007-N\u000bI#\t\u0002\u0002,\u0005a\u0011\r\u001c7fq\u0016\u001cW\u000f^8sg\"\u0012a\u0001X\u0001\u0007gR\fw-Z:\u0015\u0005\u0005M\u0002CBA\u0005\u0003k\tI$\u0003\u0003\u00028\u0005U!!B\"mCN\u001c\bc\u0001\u0012\u0002<%\u0019\u0011Q\b\b\u0003\u001dM#\u0018mZ3t%\u0016\u001cx.\u001e:dK\"*qAV*\u0002B\u0005\u0012\u0011qF\u0001\be\u0012$G*[:u)\t\t9\u0005\u0005\u0003-i\u0005%\u0003c\u0001\u0012\u0002L%\u0019\u0011Q\n\b\u0003\u001dI#Ei\u0015;pe\u0006<W-\u00138g_\"*\u0001BV*\u0002R\u0005\u0012\u00111K\u0001\fgR|'/Y4f_I$G\r\u000b\u0002\t9\u00069!\u000f\u001a3ECR\fG\u0003BA%\u00037Ba!!\u0018\n\u0001\u0004\u0019\u0017!\u0002:eI&#\u0007FBA.ON\u000b\t'\t\u0002\u0002^!*\u0011BV*\u0002f\u0005\u0012\u0011qM\u0001\u0019gR|'/Y4f_I$GmL>sI\u0012LEM\u000f\u0011]I.j\bFA\u0005]\u0003=)gN^5s_:lWM\u001c;J]\u001a|GCAA8!\r\u0011\u0013\u0011O\u0005\u0004\u0003gr!AG!qa2L7-\u0019;j_:,eN^5s_:lWM\u001c;J]\u001a|\u0007&\u0002\u0006W'\u0006]\u0014EAA=\u0003-)gN^5s_:lWM\u001c;)\u0005)a\u0016\u0001D4fi\u00163XM\u001c;M_\u001e\u001cHCAAA!\u0011\t\u0019)!#\u000e\u0005\u0005\u0015%bAAD\u0017\u0006!1m\u001c:f\u0013\u0011\tY)!\"\u0003\u0011I+7\u000f]8og\u0016DcaCAH'\u0006U\u0005c\u0001&\u0002\u0012&\u0019\u00111S&\u0003\u0011A\u0013x\u000eZ;dKNd#!a&\"\u0005\u0005e\u0015\u0001G1qa2L7-\u0019;j_:|sn\u0019;fi6\u001aHO]3b[\"*1BV*\u0002\u001e\u0006\u0012\u0011qT\u0001\u0005Y><7\u000f\u000b\u0002\f9\u0006\u0011\u0012\r\u001d9mS\u000e\fG/[8o\u0003R$X-\u001c9u)\t\t9\u000b\u0005\u0004\u0002\n\u0005U\u0012\u0011\u0016\t\u0004E\u0005-\u0016bAAW\u001d\tirJ\\3BaBd\u0017nY1uS>t\u0017\t\u001e;f[B$(+Z:pkJ\u001cW\rK\u0003\r-N\u000b\t,\t\u0002\u00024\u0006Y10\u0019;uK6\u0004H/\u00133~Q\u0019\u0001\u0011qR*\u000282\u0012\u0011\u0011X\u0011\u0003\u0003w\u000b\u0001#\u00199qY&\u001c\u0017\r^5p]>R7o\u001c8")
public class AbstractApplicationResource
implements BaseAppResource {
    @PathParam(value="appId")
    private String appId;
    @PathParam(value="attemptId")
    private String attemptId;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    @Override
    public <T> T withUI(Function1<SparkUI, T> fn) {
        return (T)BaseAppResource.withUI$(this, fn);
    }

    @Override
    public void checkUIViewPermissions() {
        BaseAppResource.checkUIViewPermissions$(this);
    }

    @Override
    public UIRoot uiRoot() {
        return ApiRequestContext.uiRoot$(this);
    }

    @Override
    public String appId() {
        return this.appId;
    }

    @Override
    public void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    @Override
    public String attemptId() {
        return this.attemptId;
    }

    @Override
    public void attemptId_$eq(String x$1) {
        this.attemptId = x$1;
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    @GET
    @Path(value="jobs")
    public Seq<JobData> jobsList(@QueryParam(value="status") List<JobExecutionStatus> statuses) {
        return (Seq)this.withUI((Function1 & Serializable & scala.Serializable)x$1 -> x$1.store().jobsList(statuses));
    }

    @GET
    @Path(value="jobs/{jobId: \\d+}")
    public JobData oneJob(@PathParam(value="jobId") int jobId) {
        return (JobData)this.withUI((Function1 & Serializable & scala.Serializable)ui -> {
            JobData jobData;
            try {
                jobData = ui.store().job(jobId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotFoundException(new StringBuilder(13).append("unknown job: ").append(jobId).toString());
            }
            return jobData;
        });
    }

    @GET
    @Path(value="executors")
    public Seq<ExecutorSummary> executorList() {
        return (Seq)this.withUI((Function1 & Serializable & scala.Serializable)x$2 -> x$2.store().executorList(true));
    }

    @GET
    @Path(value="executors/{executorId}/threads")
    public ThreadStackTrace[] threadDump(@PathParam(value="executorId") String execId) {
        return (ThreadStackTrace[])this.withUI((Function1 & Serializable & scala.Serializable)ui -> {
            ThreadStackTrace[] safeThreadDump;
            SparkContext safeSparkContext;
            block6: {
                boolean bl;
                block5: {
                    String string = execId;
                    String string2 = SparkContext$.MODULE$.DRIVER_IDENTIFIER();
                    if ((string == null ? string2 != null : !string.equals(string2)) && !new StringOps(Predef$.MODULE$.augmentString(execId)).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractApplicationResource.$anonfun$threadDump$2(BoxesRunTime.unboxToChar((Object)x$1))))) {
                        throw new BadParameterException(new StringBuilder(42).append("Invalid executorId: neither '").append(SparkContext$.MODULE$.DRIVER_IDENTIFIER()).append("' nor number.").toString());
                    }
                    safeSparkContext = (SparkContext)ui.sc().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                        throw new ServiceUnavailable("Thread dumps not available through the history server.");
                    });
                    bl = false;
                    Some some = null;
                    Option option = ui.store().asOption((Function0 & Serializable & scala.Serializable)() -> ui.store().executorSummary(execId));
                    if (!(option instanceof Some)) break block5;
                    bl = true;
                    some = (Some)option;
                    ExecutorSummary executorSummary = (ExecutorSummary)some.value();
                    if (executorSummary.isActive()) break block6;
                }
                if (bl) {
                    throw new BadParameterException("Executor is not active.");
                }
                throw new NotFoundException("Executor does not exist.");
            }
            ThreadStackTrace[] threadStackTraceArray = safeThreadDump = (ThreadStackTrace[])safeSparkContext.getExecutorThreadDump(execId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NotFoundException("No thread dump is available.");
            });
            return threadStackTraceArray;
        });
    }

    @GET
    @Path(value="allexecutors")
    public Seq<ExecutorSummary> allExecutorList() {
        return (Seq)this.withUI((Function1 & Serializable & scala.Serializable)x$3 -> x$3.store().executorList(false));
    }

    @Path(value="stages")
    public Class<StagesResource> stages() {
        return StagesResource.class;
    }

    @GET
    @Path(value="storage/rdd")
    public Seq<RDDStorageInfo> rddList() {
        return (Seq)this.withUI((Function1 & Serializable & scala.Serializable)x$4 -> x$4.store().rddList(x$4.store().rddList$default$1()));
    }

    @GET
    @Path(value="storage/rdd/{rddId: \\d+}")
    public RDDStorageInfo rddData(@PathParam(value="rddId") int rddId) {
        return (RDDStorageInfo)this.withUI((Function1 & Serializable & scala.Serializable)ui -> {
            RDDStorageInfo rDDStorageInfo;
            try {
                rDDStorageInfo = ui.store().rdd(rddId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotFoundException(new StringBuilder(19).append("no rdd found w/ id ").append(rddId).toString());
            }
            return rDDStorageInfo;
        });
    }

    @GET
    @Path(value="environment")
    public ApplicationEnvironmentInfo environmentInfo() {
        return (ApplicationEnvironmentInfo)this.withUI((Function1 & Serializable & scala.Serializable)ui -> {
            ApplicationEnvironmentInfo envInfo = ui.store().environmentInfo();
            Seq<ResourceProfileInfo> resourceProfileInfo = ui.store().resourceProfileInfo();
            return new ApplicationEnvironmentInfo(envInfo.runtime(), (Seq<Tuple2<String, String>>)((Seq)Utils$.MODULE$.redact(ui.conf(), envInfo.sparkProperties()).sortBy((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5._1(), (Ordering)Ordering.String$.MODULE$)), (Seq<Tuple2<String, String>>)((Seq)Utils$.MODULE$.redact(ui.conf(), envInfo.hadoopProperties()).sortBy((Function1 & Serializable & scala.Serializable)x$6 -> (String)x$6._1(), (Ordering)Ordering.String$.MODULE$)), (Seq<Tuple2<String, String>>)((Seq)Utils$.MODULE$.redact(ui.conf(), envInfo.systemProperties()).sortBy((Function1 & Serializable & scala.Serializable)x$7 -> (String)x$7._1(), (Ordering)Ordering.String$.MODULE$)), (Seq<Tuple2<String, String>>)((Seq)envInfo.classpathEntries().sortBy((Function1 & Serializable & scala.Serializable)x$8 -> (String)x$8._1(), (Ordering)Ordering.String$.MODULE$)), resourceProfileInfo);
        });
    }

    @GET
    @Path(value="logs")
    @Produces(value={"application/octet-stream"})
    public Response getEventLogs() {
        Response response;
        try {
            this.checkUIViewPermissions();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof NotFoundException && this.attemptId() == null) {
                this.attemptId_$eq("1");
                this.checkUIViewPermissions();
                this.attemptId_$eq(null);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        try {
            String fileName = this.attemptId() != null ? new StringBuilder(15).append("eventLogs-").append(this.appId()).append("-").append(this.attemptId()).append(".zip").toString() : new StringBuilder(14).append("eventLogs-").append(this.appId()).append(".zip").toString();
            StreamingOutput stream = new StreamingOutput(this){
                private final /* synthetic */ AbstractApplicationResource $outer;

                public void write(OutputStream output) {
                    try (ZipOutputStream zipStream = new ZipOutputStream(output);){
                        this.$outer.uiRoot().writeEventLogs(this.$outer.appId(), (Option<String>)Option$.MODULE$.apply((Object)this.$outer.attemptId()), zipStream);
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            response = Response.ok((Object)stream).header("Content-Disposition", (Object)new StringBuilder(21).append("attachment; filename=").append(fileName).toString()).header("Content-Type", (Object)"application/octet-stream").build();
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable3);
            if (!option.isEmpty()) {
                throw new ServiceUnavailable(new StringBuilder(39).append("Event logs are not available for app: ").append(this.appId()).append(".").toString());
            }
            throw throwable;
        }
        return response;
    }

    @Path(value="{attemptId}")
    public Class<OneApplicationAttemptResource> applicationAttempt() {
        if (this.attemptId() != null) {
            throw new NotFoundException(this.httpRequest().getRequestURI());
        }
        return OneApplicationAttemptResource.class;
    }

    public static final /* synthetic */ boolean $anonfun$threadDump$2(char x$1) {
        return Character.isDigit(x$1);
    }

    public AbstractApplicationResource() {
        ApiRequestContext.$init$(this);
        BaseAppResource.$init$(this);
    }
}

