/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rdd;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.internal.Logging;
import org.apache.spark.partial.BoundedDouble;
import org.apache.spark.partial.MeanEvaluator;
import org.apache.spark.partial.PartialResult;
import org.apache.spark.partial.SumEvaluator;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.StatCounter;
import org.apache.spark.util.StatCounter$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001B\n\u0015\u0001uA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\u0006k\u0001!\tA\u000e\u0005\u0006s\u0001!\tA\u000f\u0005\u0006w\u0001!\t\u0001\u0010\u0005\u0006\u0007\u0002!\tA\u000f\u0005\u0006\t\u0002!\tA\u000f\u0005\u0006\u000b\u0002!\tA\u000f\u0005\u0006\r\u0002!\tA\u000f\u0005\u0006\u000f\u0002!\tA\u000f\u0005\u0006\u0011\u0002!\tA\u000f\u0005\u0006%\u0002!\tA\u000f\u0005\u0006)\u0002!\t!\u0016\u0005\bM\u0002\t\n\u0011\"\u0001h\u0011\u0015\t\b\u0001\"\u0001s\u0011\u001d)\b!%A\u0005\u0002\u001dDQA\u001e\u0001\u0005\u0002]DaA\u001e\u0001\u0005\u0002\u0005%\u0001\"CA\r\u0001E\u0005I\u0011AA\u000e\u0005I!u.\u001e2mKJ#EIR;oGRLwN\\:\u000b\u0005U1\u0012a\u0001:eI*\u0011q\u0003G\u0001\u0006gB\f'o\u001b\u0006\u00033i\ta!\u00199bG\",'\"A\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qBE\u000b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001d2\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005%2#a\u0002'pO\u001eLgn\u001a\t\u0003?-J!\u0001\f\u0011\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\tM,GN\u001a\t\u0004_A\u0012T\"\u0001\u000b\n\u0005E\"\"a\u0001*E\tB\u0011qdM\u0005\u0003i\u0001\u0012a\u0001R8vE2,\u0017A\u0002\u001fj]&$h\b\u0006\u00028qA\u0011q\u0006\u0001\u0005\u0006[\t\u0001\rAL\u0001\u0004gVlG#\u0001\u001a\u0002\u000bM$\u0018\r^:\u0015\u0003u\u0002\"AP!\u000e\u0003}R!\u0001\u0011\f\u0002\tU$\u0018\u000e\\\u0005\u0003\u0005~\u00121b\u0015;bi\u000e{WO\u001c;fe\u0006!Q.Z1o\u0003!1\u0018M]5b]\u000e,\u0017!B:uI\u00164\u0018aC:b[BdWm\u0015;eKZ\fab]1na2,g+\u0019:jC:\u001cW-\u0001\u0005q_B\u001cF\u000fZ3wQ\rQ!\n\u0015\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001bZ\t!\"\u00198o_R\fG/[8o\u0013\tyEJA\u0003TS:\u001cW-I\u0001R\u0003\u0015\u0011d&\r\u00181\u0003-\u0001x\u000e\u001d,be&\fgnY3)\u0007-Q\u0005+\u0001\u0006nK\u0006t\u0017\t\u001d9s_b$2AV0e!\r9&\fX\u0007\u00021*\u0011\u0011LF\u0001\ba\u0006\u0014H/[1m\u0013\tY\u0006LA\u0007QCJ$\u0018.\u00197SKN,H\u000e\u001e\t\u0003/vK!A\u0018-\u0003\u001b\t{WO\u001c3fI\u0012{WO\u00197f\u0011\u0015\u0001G\u00021\u0001b\u0003\u001d!\u0018.\\3pkR\u0004\"a\b2\n\u0005\r\u0004#\u0001\u0002'p]\u001eDq!\u001a\u0007\u0011\u0002\u0003\u0007!'\u0001\u0006d_:4\u0017\u000eZ3oG\u0016\fA#\\3b]\u0006\u0003\bO]8yI\u0011,g-Y;mi\u0012\u0012T#\u00015+\u0005IJ7&\u00016\u0011\u0005-|W\"\u00017\u000b\u00055t\u0017!C;oG\",7m[3e\u0015\ti\u0005%\u0003\u0002qY\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0013M,X.\u00119qe>DHc\u0001,ti\")\u0001M\u0004a\u0001C\"9QM\u0004I\u0001\u0002\u0004\u0011\u0014aE:v[\u0006\u0003\bO]8yI\u0011,g-Y;mi\u0012\u0012\u0014!\u00035jgR|wM]1n)\tAx\u0010\u0005\u0003 snt\u0018B\u0001>!\u0005\u0019!V\u000f\u001d7feA\u0019q\u0004 \u001a\n\u0005u\u0004#!B!se\u0006L\bcA\u0010}C\"9\u0011\u0011\u0001\tA\u0002\u0005\r\u0011a\u00032vG.,GoQ8v]R\u00042aHA\u0003\u0013\r\t9\u0001\t\u0002\u0004\u0013:$H#\u0002@\u0002\f\u0005=\u0001BBA\u0007#\u0001\u000710A\u0004ck\u000e\\W\r^:\t\u0013\u0005E\u0011\u0003%AA\u0002\u0005M\u0011aC3wK:\u0014UoY6fiN\u00042aHA\u000b\u0013\r\t9\u0002\t\u0002\b\u0005>|G.Z1o\u0003MA\u0017n\u001d;pOJ\fW\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\tiBK\u0002\u0002\u0014%\u0004")
public class DoubleRDDFunctions
implements Logging,
scala.Serializable {
    private final RDD<Object> self;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public double sum() {
        return BoxesRunTime.unboxToDouble(this.self.withScope((JFunction0.mcD.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToDouble((Object)$this.self.fold(BoxesRunTime.boxToDouble((double)0.0), (Function2<Object, Object, Object>)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x$1, x$2) -> x$1 + x$2))));
    }

    public StatCounter stats() {
        return (StatCounter)this.self.withScope((Function0 & Serializable & scala.Serializable)() -> (StatCounter)$this.self.mapPartitions((Function1 & Serializable & scala.Serializable)nums -> package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StatCounter[]{StatCounter$.MODULE$.apply((TraversableOnce<Object>)nums)})), $this.self.mapPartitions$default$2(), ClassTag$.MODULE$.apply(StatCounter.class)).reduce((Function2 & Serializable & scala.Serializable)(a, b) -> a.merge((StatCounter)b)));
    }

    public double mean() {
        return BoxesRunTime.unboxToDouble(this.self.withScope((JFunction0.mcD.sp & Serializable & scala.Serializable)() -> this.stats().mean()));
    }

    public double variance() {
        return BoxesRunTime.unboxToDouble(this.self.withScope((JFunction0.mcD.sp & Serializable & scala.Serializable)() -> this.stats().variance()));
    }

    public double stdev() {
        return BoxesRunTime.unboxToDouble(this.self.withScope((JFunction0.mcD.sp & Serializable & scala.Serializable)() -> this.stats().stdev()));
    }

    public double sampleStdev() {
        return BoxesRunTime.unboxToDouble(this.self.withScope((JFunction0.mcD.sp & Serializable & scala.Serializable)() -> this.stats().sampleStdev()));
    }

    public double sampleVariance() {
        return BoxesRunTime.unboxToDouble(this.self.withScope((JFunction0.mcD.sp & Serializable & scala.Serializable)() -> this.stats().sampleVariance()));
    }

    public double popStdev() {
        return BoxesRunTime.unboxToDouble(this.self.withScope((JFunction0.mcD.sp & Serializable & scala.Serializable)() -> this.stats().popStdev()));
    }

    public double popVariance() {
        return BoxesRunTime.unboxToDouble(this.self.withScope((JFunction0.mcD.sp & Serializable & scala.Serializable)() -> this.stats().popVariance()));
    }

    public PartialResult<BoundedDouble> meanApprox(long timeout, double confidence) {
        return (PartialResult)this.self.withScope((Function0 & Serializable & scala.Serializable)() -> {
            Function2 & Serializable & scala.Serializable processPartition = (Function2 & Serializable & scala.Serializable)(ctx, ns) -> StatCounter$.MODULE$.apply((TraversableOnce<Object>)ns);
            MeanEvaluator evaluator = new MeanEvaluator($this.self.partitions().length, confidence);
            return $this.self.context().runApproximateJob($this.self, processPartition, evaluator, timeout);
        });
    }

    public double meanApprox$default$2() {
        return 0.95;
    }

    public PartialResult<BoundedDouble> sumApprox(long timeout, double confidence) {
        return (PartialResult)this.self.withScope((Function0 & Serializable & scala.Serializable)() -> {
            Function2 & Serializable & scala.Serializable processPartition = (Function2 & Serializable & scala.Serializable)(ctx, ns) -> StatCounter$.MODULE$.apply((TraversableOnce<Object>)ns);
            SumEvaluator evaluator = new SumEvaluator($this.self.partitions().length, confidence);
            return $this.self.context().runApproximateJob($this.self, processPartition, evaluator, timeout);
        });
    }

    public double sumApprox$default$2() {
        return 0.95;
    }

    public Tuple2<double[], long[]> histogram(int bucketCount) {
        return (Tuple2)this.self.withScope((Function0 & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = (Tuple2)$this.self.mapPartitions((Function1 & Serializable & scala.Serializable)items -> package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{(Tuple2)items.foldRight((Object)new Tuple2.mcDD.sp(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), (Function2 & Serializable & scala.Serializable)(e, x) -> DoubleRDDFunctions.$anonfun$histogram$4(BoxesRunTime.unboxToDouble((Object)e), x))})), $this.self.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)).reduce((Function2 & Serializable & scala.Serializable)(maxmin1, maxmin2) -> new Tuple2.mcDD.sp(RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(maxmin1._1$mcD$sp()), maxmin2._1$mcD$sp()), RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(maxmin1._2$mcD$sp()), maxmin2._2$mcD$sp())));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double max = tuple2._1$mcD$sp();
            double min = tuple2._2$mcD$sp();
            double d = max;
            double d2 = min;
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(d, d2);
            Tuple2.mcDD.sp sp3 = sp2;
            double max2 = sp3._1$mcD$sp();
            double min2 = sp3._2$mcD$sp();
            if (Predef$.MODULE$.double2Double(min2).isNaN() || Predef$.MODULE$.double2Double(max2).isNaN() || RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(max2)) || RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(min2))) {
                throw new UnsupportedOperationException("Histogram on either an empty RDD or RDD containing +/-infinity or NaN");
            }
            IndexedSeq range = min2 != max2 ? DoubleRDDFunctions.customRange$1(min2, max2, bucketCount) : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{min2, min2}));
            double[] buckets = (double[])range.toArray(ClassTag$.MODULE$.Double());
            return new Tuple2((Object)buckets, (Object)this.histogram(buckets, true));
        });
    }

    public long[] histogram(double[] buckets, boolean evenBuckets) {
        return (long[])this.self.withScope((Function0 & Serializable & scala.Serializable)() -> {
            Function1 & Serializable & scala.Serializable intersect;
            if (buckets.length < 2) {
                throw new IllegalArgumentException("buckets array must have at least two elements");
            }
            if (evenBuckets) {
                double d = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(buckets)).head());
                double d2 = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(buckets)).last());
                int n = buckets.length - 1;
                intersect = (Function1 & Serializable & scala.Serializable)e -> DoubleRDDFunctions.fastBucketFunction$1(d, d2, n, BoxesRunTime.unboxToDouble((Object)e));
            } else {
                intersect = (Function1 & Serializable & scala.Serializable)e -> DoubleRDDFunctions.basicBucketFunction$1(BoxesRunTime.unboxToDouble((Object)e), buckets);
            }
            Function1 & Serializable & scala.Serializable bucketFunction = intersect;
            return $this.self.partitions().length == 0 ? new long[buckets.length - 1] : (long[])$this.self.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> DoubleRDDFunctions.histogramPartition$1(bucketFunction, iter, buckets), $this.self.mapPartitions$default$2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE))).reduce((Function2 & Serializable & scala.Serializable)(a1, a2) -> DoubleRDDFunctions.mergeCounters$1(a1, a2));
        });
    }

    public boolean histogram$default$2() {
        return false;
    }

    private static final IndexedSeq customRange$1(double min, double max, int steps) {
        double span = max - min;
        return (IndexedSeq)((SeqLike)Range.Int$.MODULE$.apply(0, steps, 1).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)s -> min + (double)s * span / (double)steps, IndexedSeq$.MODULE$.canBuildFrom())).$colon$plus((Object)BoxesRunTime.boxToDouble((double)max), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Tuple2 $anonfun$histogram$4(double e, Tuple2 x) {
        return new Tuple2.mcDD.sp(RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(x._1$mcD$sp()), e), RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(x._2$mcD$sp()), e));
    }

    private static final Iterator histogramPartition$1(Function1 bucketFunction, Iterator iter, double[] buckets$1) {
        long[] counters = new long[buckets$1.length - 1];
        while (iter.hasNext()) {
            BoxedUnit boxedUnit;
            Option option = (Option)bucketFunction.apply(iter.next());
            if (option instanceof Some) {
                int x;
                Some some = (Some)option;
                int n = x = BoxesRunTime.unboxToInt((Object)some.value());
                counters[n] = counters[n] + 1L;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new long[][]{counters}));
    }

    private static final long[] mergeCounters$1(long[] a1, long[] a2) {
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(a1)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            a1$1[i] = a1[i] + a2[i];
        });
        return a1;
    }

    private static final Option basicBucketFunction$1(double e, double[] buckets$1) {
        int insertionPoint;
        int location = Arrays.binarySearch(buckets$1, e);
        return location < 0 ? ((insertionPoint = -location - 1) > 0 && insertionPoint < buckets$1.length ? new Some((Object)BoxesRunTime.boxToInteger((int)(insertionPoint - 1))) : None$.MODULE$) : (location < buckets$1.length - 1 ? new Some((Object)BoxesRunTime.boxToInteger((int)location)) : new Some((Object)BoxesRunTime.boxToInteger((int)(location - 1))));
    }

    private static final Option fastBucketFunction$1(double min, double max, int count, double e) {
        None$ none$;
        if (Predef$.MODULE$.double2Double(e).isNaN() || e < min || e > max) {
            none$ = None$.MODULE$;
        } else {
            int bucketNumber = (int)((e - min) / (max - min) * (double)count);
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)scala.math.package$.MODULE$.min(bucketNumber, count - 1)));
        }
        return none$;
    }

    public DoubleRDDFunctions(RDD<Object> self) {
        this.self = self;
        Logging.$init$(this);
    }
}

