/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.metrics.MetricsConfig;
import org.apache.spark.metrics.MetricsSystem$;
import org.apache.spark.metrics.sink.MetricsServlet;
import org.apache.spark.metrics.sink.PrometheusServlet;
import org.apache.spark.metrics.sink.Sink;
import org.apache.spark.metrics.source.Source;
import org.apache.spark.metrics.source.StaticSources$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.sparkproject.jetty.servlet.ServletContextHandler;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t\u001db!\u0002\u0017.\u0001=*\u0004\u0002\u0003\"\u0001\u0005\u000b\u0007I\u0011\u0001#\t\u0011A\u0003!\u0011!Q\u0001\n\u0015C\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\t-\u0002\u0011\t\u0011)A\u0005/\")!\f\u0001C\u00057\"1\u0011\r\u0001Q\u0001\n\tDq!\u001a\u0001C\u0002\u0013%a\r\u0003\u0004v\u0001\u0001\u0006Ia\u001a\u0005\bm\u0002\u0011\r\u0011\"\u0003x\u0011\u0019y\b\u0001)A\u0005q\"I\u0011\u0011\u0001\u0001C\u0002\u0013%\u00111\u0001\u0005\t\u0003/\u0001\u0001\u0015!\u0003\u0002\u0006!I\u0011\u0011\u0004\u0001A\u0002\u0013%\u00111\u0004\u0005\n\u0003G\u0001\u0001\u0019!C\u0005\u0003KA\u0001\"!\r\u0001A\u0003&\u0011Q\u0004\u0005\n\u0003g\u0001\u0001\u0019!C\u0005\u0003kA\u0011\"a\u0011\u0001\u0001\u0004%I!!\u0012\t\u0011\u0005%\u0003\u0001)Q\u0005\u0003oA\u0011\"a\u0013\u0001\u0001\u0004%I!!\u0014\t\u0013\u0005]\u0003\u00011A\u0005\n\u0005e\u0003\u0002CA/\u0001\u0001\u0006K!a\u0014\t\u000f\u0005}\u0003\u0001\"\u0001\u0002b!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0004\"CAC\u0001E\u0005I\u0011AAD\u0011\u001d\ti\n\u0001C\u0001\u0003?Cq!!)\u0001\t\u0003\ty\n\u0003\u0005\u0002$\u0002!\taLAS\u0011\u001d\tI\u000b\u0001C\u0001\u0003WCq!a1\u0001\t\u0003\t)\rC\u0004\u0002J\u0002!\t!a3\t\u000f\u0005=\u0007\u0001\"\u0003\u0002 \"9\u0011\u0011\u001b\u0001\u0005\n\u0005}u\u0001CAj[!\u0005q&!6\u0007\u000f1j\u0003\u0012A\u0018\u0002X\"1!L\tC\u0001\u00033D\u0011\"a7#\u0005\u0004%\t!!8\t\u0011\u0005=(\u0005)A\u0005\u0003?D\u0011\"!=#\u0005\u0004%\t!!8\t\u0011\u0005M(\u0005)A\u0005\u0003?D\u0001\"!>#A\u0003%\u0011q\u001f\u0005\t\u0005\u0013\u0011\u0003\u0015!\u0003\u0003\f!9!\u0011\u0003\u0012\u0005\u0002\tM\u0001b\u0002B\u000fE\u0011\u0005!q\u0004\u0002\u000e\u001b\u0016$(/[2t'f\u001cH/Z7\u000b\u00059z\u0013aB7fiJL7m\u001d\u0006\u0003aE\nQa\u001d9be.T!AM\u001a\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0014aA8sON\u0019\u0001A\u000e\u001f\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\r\u0005s\u0017PU3g!\ti\u0004)D\u0001?\u0015\tyt&\u0001\u0005j]R,'O\\1m\u0013\t\teHA\u0004M_\u001e<\u0017N\\4\u0002\u0011%t7\u000f^1oG\u0016\u001c\u0001!F\u0001F!\t1UJ\u0004\u0002H\u0017B\u0011\u0001\nO\u0007\u0002\u0013*\u0011!jQ\u0001\u0007yI|w\u000e\u001e \n\u00051C\u0014A\u0002)sK\u0012,g-\u0003\u0002O\u001f\n11\u000b\u001e:j]\u001eT!\u0001\u0014\u001d\u0002\u0013%t7\u000f^1oG\u0016\u0004\u0013\u0001B2p]\u001a\u0004\"a\u0015+\u000e\u0003=J!!V\u0018\u0003\u0013M\u0003\u0018M]6D_:4\u0017aC:fGV\u0014\u0018\u000e^=NOJ\u0004\"a\u0015-\n\u0005e{#aD*fGV\u0014\u0018\u000e^=NC:\fw-\u001a:\u0002\rqJg.\u001b;?)\u0011afl\u00181\u0011\u0005u\u0003Q\"A\u0017\t\u000b\t+\u0001\u0019A#\t\u000bE+\u0001\u0019\u0001*\t\u000bY+\u0001\u0019A,\u0002\u001b5,GO]5dg\u000e{gNZ5h!\ti6-\u0003\u0002e[\tiQ*\u001a;sS\u000e\u001c8i\u001c8gS\u001e\fQa]5oWN,\u0012a\u001a\t\u0004Q6|W\"A5\u000b\u0005)\\\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003Yb\n!bY8mY\u0016\u001cG/[8o\u0013\tq\u0017NA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bC\u00019t\u001b\u0005\t(B\u0001:.\u0003\u0011\u0019\u0018N\\6\n\u0005Q\f(\u0001B*j].\faa]5oWN\u0004\u0013aB:pkJ\u001cWm]\u000b\u0002qB\u0019\u0001.\\=\u0011\u0005ilX\"A>\u000b\u0005ql\u0013AB:pkJ\u001cW-\u0003\u0002\u007fw\n11k\\;sG\u0016\f\u0001b]8ve\u000e,7\u000fI\u0001\te\u0016<\u0017n\u001d;ssV\u0011\u0011Q\u0001\t\u0005\u0003\u000f\t\u0019\"\u0004\u0002\u0002\n)\u0019a&a\u0003\u000b\t\u00055\u0011qB\u0001\tG>$\u0017\r[1mK*\u0011\u0011\u0011C\u0001\u0004G>l\u0017\u0002BA\u000b\u0003\u0013\u0011a\"T3ue&\u001c'+Z4jgR\u0014\u00180A\u0005sK\u001eL7\u000f\u001e:zA\u00059!/\u001e8oS:<WCAA\u000f!\r9\u0014qD\u0005\u0004\u0003CA$a\u0002\"p_2,\u0017M\\\u0001\feVtg.\u001b8h?\u0012*\u0017\u000f\u0006\u0003\u0002(\u00055\u0002cA\u001c\u0002*%\u0019\u00111\u0006\u001d\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003_q\u0011\u0011!a\u0001\u0003;\t1\u0001\u001f\u00132\u0003!\u0011XO\u001c8j]\u001e\u0004\u0013AD7fiJL7m]*feZdW\r^\u000b\u0003\u0003o\u0001RaNA\u001d\u0003{I1!a\u000f9\u0005\u0019y\u0005\u000f^5p]B\u0019\u0001/a\u0010\n\u0007\u0005\u0005\u0013O\u0001\bNKR\u0014\u0018nY:TKJ4H.\u001a;\u0002%5,GO]5dgN+'O\u001e7fi~#S-\u001d\u000b\u0005\u0003O\t9\u0005C\u0005\u00020E\t\t\u00111\u0001\u00028\u0005yQ.\u001a;sS\u000e\u001c8+\u001a:wY\u0016$\b%A\tqe>lW\r\u001e5fkN\u001cVM\u001d<mKR,\"!a\u0014\u0011\u000b]\nI$!\u0015\u0011\u0007A\f\u0019&C\u0002\u0002VE\u0014\u0011\u0003\u0015:p[\u0016$\b.Z;t'\u0016\u0014h\u000f\\3u\u0003U\u0001(o\\7fi\",Wo]*feZdW\r^0%KF$B!a\n\u0002\\!I\u0011q\u0006\u000b\u0002\u0002\u0003\u0007\u0011qJ\u0001\u0013aJ|W.\u001a;iKV\u001c8+\u001a:wY\u0016$\b%\u0001\nhKR\u001cVM\u001d<mKRD\u0015M\u001c3mKJ\u001cXCAA2!\u00159\u0014QMA5\u0013\r\t9\u0007\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003W\nI(\u0004\u0002\u0002n)!\u0011qNA9\u0003\u001d\u0019XM\u001d<mKRTA!a\u001d\u0002v\u0005)!.\u001a;us*\u0019\u0011qO\u001a\u0002\u000f\u0015\u001cG.\u001b9tK&!\u00111PA7\u0005U\u0019VM\u001d<mKR\u001cuN\u001c;fqRD\u0015M\u001c3mKJ\fQa\u001d;beR$B!a\n\u0002\u0002\"I\u00111Q\f\u0011\u0002\u0003\u0007\u0011QD\u0001\u0016e\u0016<\u0017n\u001d;feN#\u0018\r^5d'>,(oY3t\u0003=\u0019H/\u0019:uI\u0011,g-Y;mi\u0012\nTCAAEU\u0011\ti\"a#,\u0005\u00055\u0005\u0003BAH\u00033k!!!%\u000b\t\u0005M\u0015QS\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a&9\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00037\u000b\tJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAa\u001d;paR\u0011\u0011qE\u0001\u0007e\u0016\u0004xN\u001d;\u0002#\t,\u0018\u000e\u001c3SK\u001eL7\u000f\u001e:z\u001d\u0006lW\rF\u0002F\u0003OCQ\u0001`\u000eA\u0002e\f\u0001cZ3u'>,(oY3t\u0005ft\u0015-\\3\u0015\t\u00055\u0016q\u0018\t\u0006\u0003_\u000bI,\u001f\b\u0005\u0003c\u000b)LD\u0002I\u0003gK\u0011!O\u0005\u0004\u0003oC\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003w\u000biLA\u0002TKFT1!a.9\u0011\u0019\t\t\r\ba\u0001\u000b\u0006Q1o\\;sG\u0016t\u0015-\\3\u0002\u001dI,w-[:uKJ\u001cv.\u001e:dKR!\u0011qEAd\u0011\u0015aX\u00041\u0001z\u00031\u0011X-\\8wKN{WO]2f)\u0011\t9#!4\t\u000bqt\u0002\u0019A=\u0002\u001fI,w-[:uKJ\u001cv.\u001e:dKN\fQB]3hSN$XM]*j].\u001c\u0018!D'fiJL7m]*zgR,W\u000e\u0005\u0002^EM\u0011!E\u000e\u000b\u0003\u0003+\f!bU%O\u0017~\u0013ViR#Y+\t\ty\u000e\u0005\u0003\u0002b\u0006-XBAAr\u0015\u0011\t)/a:\u0002\u00115\fGo\u00195j]\u001eT1!!;9\u0003\u0011)H/\u001b7\n\t\u00055\u00181\u001d\u0002\u0006%\u0016<W\r_\u0001\f'&s5j\u0018*F\u000f\u0016C\u0006%\u0001\u0007T\u001fV\u00136)R0S\u000b\u001e+\u0005,A\u0007T\u001fV\u00136)R0S\u000b\u001e+\u0005\fI\u0001\u0012\u001b&s\u0015*T!M?B{E\nT0V\u001d&#\u0006\u0003BA}\u0005\u000bi!!a?\u000b\t\u0005u\u0018q`\u0001\u000bG>t7-\u001e:sK:$(\u0002BAu\u0005\u0003Q!Aa\u0001\u0002\t)\fg/Y\u0005\u0005\u0005\u000f\tYP\u0001\u0005US6,WK\\5u\u0003Mi\u0015JT%N\u00032{\u0006k\u0014'M?B+%+S(E!\r9$QB\u0005\u0004\u0005\u001fA$aA%oi\u0006I2\r[3dW6Kg.[7bYB{G\u000e\\5oOB+'/[8e)\u0019\t9C!\u0006\u0003\u001a!9!q\u0003\u0016A\u0002\u0005]\u0018\u0001\u00039pY2,f.\u001b;\t\u000f\tm!\u00061\u0001\u0003\f\u0005Q\u0001o\u001c7m!\u0016\u0014\u0018n\u001c3\u0002'\r\u0014X-\u0019;f\u001b\u0016$(/[2t'f\u001cH/Z7\u0015\u000fq\u0013\tCa\t\u0003&!)!i\u000ba\u0001\u000b\")\u0011k\u000ba\u0001%\")ak\u000ba\u0001/\u0002")
public class MetricsSystem
implements Logging {
    private final String instance;
    private final SparkConf conf;
    private final SecurityManager securityMgr;
    private final MetricsConfig metricsConfig;
    private final ArrayBuffer<Sink> sinks;
    private final ArrayBuffer<Source> sources;
    private final MetricRegistry registry;
    private boolean running;
    private Option<MetricsServlet> metricsServlet;
    private Option<PrometheusServlet> prometheusServlet;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static MetricsSystem createMetricsSystem(String string, SparkConf sparkConf, SecurityManager securityManager) {
        return MetricsSystem$.MODULE$.createMetricsSystem(string, sparkConf, securityManager);
    }

    public static void checkMinimalPollingPeriod(TimeUnit timeUnit, int n) {
        MetricsSystem$.MODULE$.checkMinimalPollingPeriod(timeUnit, n);
    }

    public static Regex SOURCE_REGEX() {
        return MetricsSystem$.MODULE$.SOURCE_REGEX();
    }

    public static Regex SINK_REGEX() {
        return MetricsSystem$.MODULE$.SINK_REGEX();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String instance() {
        return this.instance;
    }

    private ArrayBuffer<Sink> sinks() {
        return this.sinks;
    }

    private ArrayBuffer<Source> sources() {
        return this.sources;
    }

    private MetricRegistry registry() {
        return this.registry;
    }

    private boolean running() {
        return this.running;
    }

    private void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    private Option<MetricsServlet> metricsServlet() {
        return this.metricsServlet;
    }

    private void metricsServlet_$eq(Option<MetricsServlet> x$1) {
        this.metricsServlet = x$1;
    }

    private Option<PrometheusServlet> prometheusServlet() {
        return this.prometheusServlet;
    }

    private void prometheusServlet_$eq(Option<PrometheusServlet> x$1) {
        this.prometheusServlet = x$1;
    }

    public ServletContextHandler[] getServletHandlers() {
        Predef$.MODULE$.require(this.running(), (Function0 & Serializable & scala.Serializable)() -> "Can only call getServletHandlers on a running MetricsSystem");
        return (ServletContextHandler[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.metricsServlet().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getHandlers($this.conf)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (ServletContextHandler[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ServletContextHandler.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.prometheusServlet().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getHandlers($this.conf)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (ServletContextHandler[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ServletContextHandler.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ServletContextHandler.class)));
    }

    public void start(boolean registerStaticSources) {
        Predef$.MODULE$.require(!this.running(), (Function0 & Serializable & scala.Serializable)() -> "Attempting to start a MetricsSystem that is already running");
        this.running_$eq(true);
        if (registerStaticSources) {
            StaticSources$.MODULE$.allSources().foreach((Function1 & Serializable & scala.Serializable)source -> {
                this.registerSource(source);
                return BoxedUnit.UNIT;
            });
            this.registerSources();
        }
        this.registerSinks();
        this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.start();
            return BoxedUnit.UNIT;
        });
    }

    public boolean start$default$1() {
        return true;
    }

    public void stop() {
        if (this.running()) {
            this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.stop();
                return BoxedUnit.UNIT;
            });
            this.registry().removeMatching((x$5, x$6) -> true);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping a MetricsSystem that is not running");
        }
        this.running_$eq(false);
    }

    public void report() {
        this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.report();
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public String buildRegistryName(Source source) {
        String string;
        String defaultName;
        block7: {
            Option executorId;
            Option metricsNamespace;
            block6: {
                metricsNamespace = ((Option)this.conf.get(package$.MODULE$.METRICS_NAMESPACE())).orElse((Function0 & Serializable & scala.Serializable)() -> $this.conf.getOption("spark.app.id"));
                executorId = (Option)this.conf.get(package$.MODULE$.EXECUTOR_ID());
                defaultName = MetricRegistry.name((String)source.sourceName(), (String[])new String[0]);
                String string2 = this.instance();
                String string3 = "driver";
                if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block6;
                String string4 = this.instance();
                String string5 = "executor";
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block7;
            }
            if (metricsNamespace.isDefined() && executorId.isDefined()) {
                string = MetricRegistry.name((String)((String)metricsNamespace.get()), (String[])new String[]{(String)executorId.get(), source.sourceName()});
                return string;
            }
            if (metricsNamespace.isEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Using default name ").append(defaultName).append(" for source because neither ").append(package$.MODULE$.METRICS_NAMESPACE().key()).append(" nor spark.app.id is set.").toString());
            }
            if (executorId.isEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Using default name ").append(defaultName).append(" for source because spark.executor.id is ").append("not set.").toString());
            }
            string = defaultName;
            return string;
        }
        string = defaultName;
        return string;
    }

    public Seq<Source> getSourcesByName(String sourceName) {
        return ((SeqLike)this.sources().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)MetricsSystem.$anonfun$getSourcesByName$1(sourceName, x$8)))).toSeq();
    }

    public void registerSource(Source source) {
        this.sources().$plus$eq((Object)source);
        try {
            String regName = this.buildRegistryName(source);
            this.registry().register(regName, (Metric)source.metricRegistry());
        }
        catch (IllegalArgumentException e) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Metrics already registered", e);
        }
    }

    public void removeSource(Source source) {
        this.sources().$minus$eq((Object)source);
        String regName = this.buildRegistryName(source);
        this.registry().removeMatching((name, x$9) -> name.startsWith(regName));
    }

    private void registerSources() {
        Properties instConfig = this.metricsConfig.getInstance(this.instance());
        HashMap<String, Properties> sourceConfigs = this.metricsConfig.subProperties(instConfig, MetricsSystem$.MODULE$.SOURCE_REGEX());
        sourceConfigs.foreach((Function1 & Serializable & scala.Serializable)kv -> {
            MetricsSystem.$anonfun$registerSources$1(this, kv);
            return BoxedUnit.UNIT;
        });
    }

    private void registerSinks() {
        Properties instConfig = this.metricsConfig.getInstance(this.instance());
        HashMap<String, Properties> sinkConfigs = this.metricsConfig.subProperties(instConfig, MetricsSystem$.MODULE$.SINK_REGEX());
        sinkConfigs.foreach((Function1 & Serializable & scala.Serializable)kv -> {
            BoxedUnit boxedUnit;
            String classPath = ((Properties)kv._2()).getProperty("class");
            if (classPath != null) {
                try {
                    Object object = kv._1();
                    String string = "servlet";
                    if (!(object != null ? !object.equals(string) : string != null)) {
                        MetricsServlet servlet = (MetricsServlet)Utils$.MODULE$.classForName(classPath, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getConstructor(Properties.class, MetricRegistry.class, SecurityManager.class).newInstance(kv._2(), this.registry(), $this.securityMgr);
                        this.metricsServlet_$eq((Option<MetricsServlet>)new Some((Object)servlet));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Object object2 = kv._1();
                    String string2 = "prometheusServlet";
                    if (!(object2 != null ? !object2.equals(string2) : string2 != null)) {
                        PrometheusServlet servlet = (PrometheusServlet)Utils$.MODULE$.classForName(classPath, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getConstructor(Properties.class, MetricRegistry.class, SecurityManager.class).newInstance(kv._2(), this.registry(), $this.securityMgr);
                        this.prometheusServlet_$eq((Option<PrometheusServlet>)new Some((Object)servlet));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Sink sink = (Sink)Utils$.MODULE$.classForName(classPath, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getConstructor(Properties.class, MetricRegistry.class, SecurityManager.class).newInstance(kv._2(), this.registry(), $this.securityMgr);
                    boxedUnit = this.sinks().$plus$eq((Object)sink);
                }
                catch (Exception e) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Sink class ").append(classPath).append(" cannot be instantiated").toString());
                    throw e;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getSourcesByName$1(String sourceName$1, Source x$8) {
        String string = x$8.sourceName();
        String string2 = sourceName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$registerSources$1(MetricsSystem $this, Tuple2 kv) {
        String classPath = ((Properties)kv._2()).getProperty("class");
        try {
            Source source = (Source)Utils$.MODULE$.classForName(classPath, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getConstructor(new Class[0]).newInstance(new Object[0]);
            $this.registerSource(source);
        }
        catch (Exception e) {
            $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Source class ").append(classPath).append(" cannot be instantiated").toString(), e);
        }
    }

    public MetricsSystem(String instance, SparkConf conf, SecurityManager securityMgr) {
        this.instance = instance;
        this.conf = conf;
        this.securityMgr = securityMgr;
        Logging.$init$(this);
        this.metricsConfig = new MetricsConfig(conf);
        this.sinks = new ArrayBuffer();
        this.sources = new ArrayBuffer();
        this.registry = new MetricRegistry();
        this.running = false;
        this.metricsServlet = None$.MODULE$;
        this.prometheusServlet = None$.MODULE$;
        this.metricsConfig.initialize();
    }
}

