/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import io.netty.buffer.ByteBuf;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.sparkproject.guava.base.Objects;

public class PushBlockStream
extends BlockTransferMessage {
    public final String appId;
    public final int shuffleId;
    public final int mapIndex;
    public final int reduceId;
    public final int index;

    public PushBlockStream(String appId, int shuffleId, int mapIndex, int reduceId, int index) {
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.mapIndex = mapIndex;
        this.reduceId = reduceId;
        this.index = index;
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.PUSH_BLOCK_STREAM;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.appId, this.shuffleId, this.mapIndex, this.reduceId, this.index});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("appId", (Object)this.appId).add("shuffleId", this.shuffleId).add("mapIndex", this.mapIndex).add("reduceId", this.reduceId).add("index", this.index).toString();
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof PushBlockStream) {
            PushBlockStream o = (PushBlockStream)other;
            return Objects.equal((Object)this.appId, (Object)o.appId) && this.shuffleId == o.shuffleId && this.mapIndex == o.mapIndex && this.reduceId == o.reduceId && this.index == o.index;
        }
        return false;
    }

    public int encodedLength() {
        return Encoders.Strings.encodedLength((String)this.appId) + 16;
    }

    public void encode(ByteBuf buf) {
        Encoders.Strings.encode((ByteBuf)buf, (String)this.appId);
        buf.writeInt(this.shuffleId);
        buf.writeInt(this.mapIndex);
        buf.writeInt(this.reduceId);
        buf.writeInt(this.index);
    }

    public static PushBlockStream decode(ByteBuf buf) {
        String appId = Encoders.Strings.decode((ByteBuf)buf);
        int shuffleId = buf.readInt();
        int mapIdx = buf.readInt();
        int reduceId = buf.readInt();
        int index = buf.readInt();
        return new PushBlockStream(appId, shuffleId, mapIdx, reduceId, index);
    }
}

