/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBSQLDADataFormat;
import java.io.UnsupportedEncodingException;

class DBReplyPackageInfo {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private byte[] data_;
    private int offset_;
    private int length_;
    private int jobCCSID_;

    public DBReplyPackageInfo(byte[] byArray, int n, int n2, int n3) {
        this.data_ = byArray;
        this.offset_ = n;
        this.length_ = n2;
        this.jobCCSID_ = n3;
    }

    public DBDataFormat getDataFormat(int n) throws DBDataStreamException {
        int n2 = BinaryConverter.byteArrayToInt(this.data_, this.offset_ + this.getPackageEntryInfoOffset(n) + 40);
        int n3 = BinaryConverter.byteArrayToInt(this.data_, this.offset_ + this.getPackageEntryInfoOffset(n) + 44);
        if (n3 != 6 && n3 != 0) {
            DBSQLDADataFormat dBSQLDADataFormat = new DBSQLDADataFormat(this.jobCCSID_);
            dBSQLDADataFormat.overlay(this.data_, this.offset_ - 6 + n2);
            return dBSQLDADataFormat;
        }
        return null;
    }

    public String getDefaultCollection(ConvTable convTable) throws DBDataStreamException {
        return convTable.byteArrayToString(this.data_, this.offset_ + 6, 18);
    }

    public int getCCSID() throws DBDataStreamException {
        return BinaryConverter.byteArrayToShort(this.data_, this.offset_ + 4);
    }

    private int getPackageEntryInfoOffset(int n) {
        return 42 + 64 * n;
    }

    public DBDataFormat getParameterMarkerFormat(int n) throws DBDataStreamException {
        int n2 = BinaryConverter.byteArrayToInt(this.data_, this.offset_ + this.getPackageEntryInfoOffset(n) + 56);
        int n3 = BinaryConverter.byteArrayToInt(this.data_, this.offset_ + this.getPackageEntryInfoOffset(n) + 60);
        if (n3 != 6 && n3 != 0) {
            DBSQLDADataFormat dBSQLDADataFormat = new DBSQLDADataFormat(this.jobCCSID_);
            dBSQLDADataFormat.overlay(this.data_, this.offset_ - 6 + n2);
            return dBSQLDADataFormat;
        }
        return null;
    }

    public int getStatementCount() throws DBDataStreamException {
        return BinaryConverter.byteArrayToShort(this.data_, this.offset_ + 24);
    }

    public String getStatementName(int n, ConvTable convTable) throws DBDataStreamException {
        try {
            return ConvTable.getTable(this.jobCCSID_, null).byteArrayToString(this.data_, this.offset_ + this.getPackageEntryInfoOffset(n) + 3, 18);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public int getStatementNeedsDefaultCollection(int n) throws DBDataStreamException {
        return this.data_[this.offset_ + this.getPackageEntryInfoOffset(n)];
    }

    public String getStatementText(int n, ConvTable convTable) throws DBDataStreamException {
        int n2 = BinaryConverter.byteArrayToInt(this.data_, this.offset_ + this.getPackageEntryInfoOffset(n) + 48);
        int n3 = BinaryConverter.byteArrayToInt(this.data_, this.offset_ + this.getPackageEntryInfoOffset(n) + 52);
        return convTable.byteArrayToString(this.data_, this.offset_ - 6 + n2, n3);
    }

    public int getStatementTextLength(int n) throws DBDataStreamException {
        return BinaryConverter.byteArrayToInt(this.data_, this.offset_ + this.getPackageEntryInfoOffset(n) + 52);
    }

    public int getStatementType(int n) throws DBDataStreamException {
        return BinaryConverter.byteArrayToShort(this.data_, this.offset_ + this.getPackageEntryInfoOffset(n) + 1);
    }

    public int getTotalLength() throws DBDataStreamException {
        return BinaryConverter.byteArrayToInt(this.data_, this.offset_);
    }
}

