/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.ldapinput;

import org.apache.hop.core.Const;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.ldapinput.LdapConnection;
import org.apache.hop.pipeline.transforms.ldapinput.LdapInputField;
import org.apache.hop.pipeline.transforms.ldapinput.LdapInputMeta;
import org.apache.hop.pipeline.transforms.ldapinput.LdapProtocol;
import org.apache.hop.pipeline.transforms.ldapinput.LdapProtocolFactory;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.ControlSpaceKeyAdapter;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ComponentSelectionListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class LdapInputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = LdapInputMeta.class;
    private Button wInclRownum;
    private Button wSetPaging;
    private Label wlPageSize;
    private TextVar wPageSize;
    private Button wUsingAuthentication;
    private Label wlInclRownumField;
    private TextVar wInclRownumField;
    private Text wLimit;
    private TextVar wTimeLimit;
    private TextVar wMultiValuedSeparator;
    private TableView wFields;
    private final LdapInputMeta input;
    private TextVar wHost;
    private Label wlUserName;
    private TextVar wUserName;
    private Label wlPassword;
    private TextVar wPassword;
    private TextVar wPort;
    private Label wlSearchBase;
    private TextVar wSearchBase;
    private Label wlTrustStorePath;
    private TextVar wTrustStorePath;
    private Label wlTrustStorePassword;
    private TextVar wTrustStorePassword;
    private Label wlSetTrustStore;
    private Button wSetTrustStore;
    private Label wlTrustAll;
    private Button wTrustAll;
    private Label wlFilterString;
    private StyledTextComp wFilterString;
    private Button wDynamicBase;
    private Label wlSearchBaseField;
    private CCombo wSearchBaseField;
    private Button wDynamicFilter;
    private Label wlFilterField;
    private CCombo wFilterField;
    private CCombo wSearchScope;
    public static final int[] dateLengths = new int[]{23, 19, 14, 10, 10, 10, 10, 8, 8, 8, 8, 6, 6};
    private ColumnInfo[] colinf;
    private boolean gotPreviousFields = false;
    private ComboVar wProtocol;
    private Button wbbFilename;

    public LdapInputDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (LdapInputMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.Button.PreviewRows", (String[])new String[0]));
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.General.Tab", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wGeneralComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)fileLayout);
        Group wHostGroup = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wHostGroup);
        wHostGroup.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.Group.HostGroup.Label", (String[])new String[0]));
        FormLayout hostGroupLayout = new FormLayout();
        hostGroupLayout.marginWidth = 10;
        hostGroupLayout.marginHeight = 10;
        wHostGroup.setLayout((Layout)hostGroupLayout);
        Label wlHost = new Label((Composite)wHostGroup, 131072);
        wlHost.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.Host.Label", (String[])new String[0]));
        this.props.setLook((Control)wlHost);
        FormData fdlHost = new FormData();
        fdlHost.left = new FormAttachment(0, 0);
        fdlHost.top = new FormAttachment((Control)this.wTransformName, margin);
        fdlHost.right = new FormAttachment(middle, -margin);
        wlHost.setLayoutData((Object)fdlHost);
        this.wHost = new TextVar(this.variables, (Composite)wHostGroup, 18436);
        this.wHost.setToolTipText(BaseMessages.getString(PKG, (String)"LdapInputDialog.Host.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wHost);
        this.wHost.addModifyListener(lsMod);
        FormData fdHost = new FormData();
        fdHost.left = new FormAttachment(middle, 0);
        fdHost.top = new FormAttachment((Control)this.wTransformName, margin);
        fdHost.right = new FormAttachment(100, 0);
        this.wHost.setLayoutData((Object)fdHost);
        Label wlPort = new Label((Composite)wHostGroup, 131072);
        wlPort.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.Port.Label", (String[])new String[0]));
        this.props.setLook((Control)wlPort);
        FormData fdlPort = new FormData();
        fdlPort.left = new FormAttachment(0, 0);
        fdlPort.top = new FormAttachment((Control)this.wHost, margin);
        fdlPort.right = new FormAttachment(middle, -margin);
        wlPort.setLayoutData((Object)fdlPort);
        this.wPort = new TextVar(this.variables, (Composite)wHostGroup, 18436);
        this.props.setLook((Control)this.wPort);
        this.wPort.setToolTipText(BaseMessages.getString(PKG, (String)"LdapInputDialog.Port.Tooltip", (String[])new String[0]));
        this.wPort.addModifyListener(lsMod);
        FormData fdPort = new FormData();
        fdPort.left = new FormAttachment(middle, 0);
        fdPort.top = new FormAttachment((Control)this.wHost, margin);
        fdPort.right = new FormAttachment(100, 0);
        this.wPort.setLayoutData((Object)fdPort);
        Label wlProtocol = new Label((Composite)wHostGroup, 131072);
        wlProtocol.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.Protocol.Label", (String[])new String[0]));
        this.props.setLook((Control)wlProtocol);
        FormData fdlProtocol = new FormData();
        fdlProtocol.left = new FormAttachment(0, 0);
        fdlProtocol.right = new FormAttachment(middle, -margin);
        fdlProtocol.top = new FormAttachment((Control)this.wPort, margin);
        wlProtocol.setLayoutData((Object)fdlProtocol);
        this.wProtocol = new ComboVar(this.variables, (Composite)wHostGroup, 2056);
        this.wProtocol.setEditable(true);
        this.props.setLook((Control)this.wProtocol);
        this.wProtocol.addModifyListener(lsMod);
        FormData fdProtocol = new FormData();
        fdProtocol.left = new FormAttachment(middle, 0);
        fdProtocol.top = new FormAttachment((Control)this.wPort, margin);
        fdProtocol.right = new FormAttachment(100, -margin);
        this.wProtocol.setLayoutData((Object)fdProtocol);
        this.wProtocol.setItems(LdapProtocolFactory.getConnectionTypes((ILogChannel)this.log).toArray(new String[0]));
        this.wProtocol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LdapInputDialog.this.setProtocol();
            }
        });
        FormData fdHostGroup = new FormData();
        fdHostGroup.left = new FormAttachment(0, margin);
        fdHostGroup.top = new FormAttachment(0, margin);
        fdHostGroup.right = new FormAttachment(100, -margin);
        wHostGroup.setLayoutData((Object)fdHostGroup);
        Group wAuthenticationGroup = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wAuthenticationGroup);
        wAuthenticationGroup.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.Group.AuthenticationGroup.Label", (String[])new String[0]));
        FormLayout authenticationGroupLayout = new FormLayout();
        authenticationGroupLayout.marginWidth = 10;
        authenticationGroupLayout.marginHeight = 10;
        wAuthenticationGroup.setLayout((Layout)authenticationGroupLayout);
        Label wlUsingAuthentication = new Label((Composite)wAuthenticationGroup, 131072);
        wlUsingAuthentication.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.usingAuthentication.Label", (String[])new String[0]));
        this.props.setLook((Control)wlUsingAuthentication);
        FormData fdlUsingAuthentication = new FormData();
        fdlUsingAuthentication.left = new FormAttachment(0, 0);
        fdlUsingAuthentication.top = new FormAttachment((Control)wHostGroup, margin);
        fdlUsingAuthentication.right = new FormAttachment(middle, -margin);
        wlUsingAuthentication.setLayoutData((Object)fdlUsingAuthentication);
        this.wUsingAuthentication = new Button((Composite)wAuthenticationGroup, 32);
        this.props.setLook((Control)this.wUsingAuthentication);
        this.wUsingAuthentication.setToolTipText(BaseMessages.getString(PKG, (String)"LdapInputDialog.usingAuthentication.Tooltip", (String[])new String[0]));
        FormData fdUsingAuthentication = new FormData();
        fdUsingAuthentication.left = new FormAttachment(middle, 0);
        fdUsingAuthentication.top = new FormAttachment((Control)wlUsingAuthentication, 0, 0x1000000);
        this.wUsingAuthentication.setLayoutData((Object)fdUsingAuthentication);
        this.wUsingAuthentication.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LdapInputDialog.this.useAuthentication();
                LdapInputDialog.this.input.setChanged();
            }
        });
        this.wlUserName = new Label((Composite)wAuthenticationGroup, 131072);
        this.wlUserName.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.Username.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlUserName);
        FormData fdlUserName = new FormData();
        fdlUserName.left = new FormAttachment(0, 0);
        fdlUserName.top = new FormAttachment((Control)this.wUsingAuthentication, margin);
        fdlUserName.right = new FormAttachment(middle, -margin);
        this.wlUserName.setLayoutData((Object)fdlUserName);
        this.wUserName = new TextVar(this.variables, (Composite)wAuthenticationGroup, 18436);
        this.props.setLook((Control)this.wUserName);
        this.wUserName.setToolTipText(BaseMessages.getString(PKG, (String)"LdapInputDialog.Username.Tooltip", (String[])new String[0]));
        this.wUserName.addModifyListener(lsMod);
        FormData fdUserName = new FormData();
        fdUserName.left = new FormAttachment(middle, 0);
        fdUserName.top = new FormAttachment((Control)this.wUsingAuthentication, margin);
        fdUserName.right = new FormAttachment(100, 0);
        this.wUserName.setLayoutData((Object)fdUserName);
        this.wlPassword = new Label((Composite)wAuthenticationGroup, 131072);
        this.wlPassword.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.Password.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPassword);
        FormData fdlPassword = new FormData();
        fdlPassword.left = new FormAttachment(0, 0);
        fdlPassword.top = new FormAttachment((Control)this.wUserName, margin);
        fdlPassword.right = new FormAttachment(middle, -margin);
        this.wlPassword.setLayoutData((Object)fdlPassword);
        this.wPassword = new PasswordTextVar(this.variables, (Composite)wAuthenticationGroup, 18436);
        this.wPassword.setToolTipText(BaseMessages.getString(PKG, (String)"LdapInputDialog.Password.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wPassword);
        this.wPassword.addModifyListener(lsMod);
        FormData fdPassword = new FormData();
        fdPassword.left = new FormAttachment(middle, 0);
        fdPassword.top = new FormAttachment((Control)this.wUserName, margin);
        fdPassword.right = new FormAttachment(100, 0);
        this.wPassword.setLayoutData((Object)fdPassword);
        FormData fdAuthenticationGroup = new FormData();
        fdAuthenticationGroup.left = new FormAttachment(0, margin);
        fdAuthenticationGroup.top = new FormAttachment((Control)wHostGroup, margin);
        fdAuthenticationGroup.right = new FormAttachment(100, -margin);
        wAuthenticationGroup.setLayoutData((Object)fdAuthenticationGroup);
        Group wCertificateGroup = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wCertificateGroup);
        wCertificateGroup.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.Group.CertificateGroup.Label", (String[])new String[0]));
        FormLayout certificateGroupLayout = new FormLayout();
        certificateGroupLayout.marginWidth = 10;
        certificateGroupLayout.marginHeight = 10;
        wCertificateGroup.setLayout((Layout)certificateGroupLayout);
        this.wlSetTrustStore = new Label((Composite)wCertificateGroup, 131072);
        this.wlSetTrustStore.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.setTrustStore.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSetTrustStore);
        FormData fdlsetTrustStore = new FormData();
        fdlsetTrustStore.left = new FormAttachment(0, 0);
        fdlsetTrustStore.top = new FormAttachment((Control)wAuthenticationGroup, margin);
        fdlsetTrustStore.right = new FormAttachment(middle, -margin);
        this.wlSetTrustStore.setLayoutData((Object)fdlsetTrustStore);
        this.wSetTrustStore = new Button((Composite)wCertificateGroup, 32);
        this.props.setLook((Control)this.wSetTrustStore);
        this.wSetTrustStore.setToolTipText(BaseMessages.getString(PKG, (String)"LdapInputDialog.setTrustStore.Tooltip", (String[])new String[0]));
        FormData fdsetTrustStore = new FormData();
        fdsetTrustStore.left = new FormAttachment(middle, 0);
        fdsetTrustStore.top = new FormAttachment((Control)this.wlSetTrustStore, 0, 0x1000000);
        this.wSetTrustStore.setLayoutData((Object)fdsetTrustStore);
        this.wSetTrustStore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LdapInputDialog.this.input.setChanged();
                LdapInputDialog.this.setTrustStore();
            }
        });
        this.wlTrustStorePath = new Label((Composite)wCertificateGroup, 131072);
        this.wlTrustStorePath.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.TrustStorePath.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTrustStorePath);
        FormData fdlTrustStorePath = new FormData();
        fdlTrustStorePath.left = new FormAttachment(0, -margin);
        fdlTrustStorePath.top = new FormAttachment((Control)this.wSetTrustStore, margin);
        fdlTrustStorePath.right = new FormAttachment(middle, -margin);
        this.wlTrustStorePath.setLayoutData((Object)fdlTrustStorePath);
        this.wbbFilename = new Button((Composite)wCertificateGroup, 0x1000008);
        this.props.setLook((Control)this.wbbFilename);
        this.wbbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)this.wSetTrustStore, margin);
        this.wbbFilename.setLayoutData((Object)fdbFilename);
        this.wbbFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wTrustStorePath, (IVariables)this.variables, (String[])new String[]{"*"}, (String[])new String[]{"All files"}, (boolean)true));
        this.wTrustStorePath = new TextVar(this.variables, (Composite)wCertificateGroup, 18436);
        this.props.setLook((Control)this.wTrustStorePath);
        this.wTrustStorePath.setToolTipText(BaseMessages.getString(PKG, (String)"LdapInputDialog.TrustStorePath.Tooltip", (String[])new String[0]));
        this.wTrustStorePath.addModifyListener(lsMod);
        FormData fdTrustStorePath = new FormData();
        fdTrustStorePath.left = new FormAttachment(middle, 0);
        fdTrustStorePath.top = new FormAttachment((Control)this.wSetTrustStore, margin);
        fdTrustStorePath.right = new FormAttachment((Control)this.wbbFilename, -margin);
        this.wTrustStorePath.setLayoutData((Object)fdTrustStorePath);
        this.wlTrustStorePassword = new Label((Composite)wCertificateGroup, 131072);
        this.wlTrustStorePassword.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.TrustStorePassword.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTrustStorePassword);
        FormData fdlTrustStorePassword = new FormData();
        fdlTrustStorePassword.left = new FormAttachment(0, -margin);
        fdlTrustStorePassword.top = new FormAttachment((Control)this.wbbFilename, margin);
        fdlTrustStorePassword.right = new FormAttachment(middle, -margin);
        this.wlTrustStorePassword.setLayoutData((Object)fdlTrustStorePassword);
        this.wTrustStorePassword = new PasswordTextVar(this.variables, (Composite)wCertificateGroup, 18436);
        this.props.setLook((Control)this.wTrustStorePassword);
        this.wTrustStorePassword.setToolTipText(BaseMessages.getString(PKG, (String)"LdapInputDialog.TrustStorePassword.Tooltip", (String[])new String[0]));
        this.wTrustStorePassword.addModifyListener(lsMod);
        FormData fdTrustStorePassword = new FormData();
        fdTrustStorePassword.left = new FormAttachment(middle, 0);
        fdTrustStorePassword.top = new FormAttachment((Control)this.wbbFilename, margin);
        fdTrustStorePassword.right = new FormAttachment(100, -margin);
        this.wTrustStorePassword.setLayoutData((Object)fdTrustStorePassword);
        this.wlTrustAll = new Label((Composite)wCertificateGroup, 131072);
        this.wlTrustAll.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.TrustAll.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTrustAll);
        FormData fdlTrustAll = new FormData();
        fdlTrustAll.left = new FormAttachment(0, 0);
        fdlTrustAll.top = new FormAttachment((Control)this.wTrustStorePassword, margin);
        fdlTrustAll.right = new FormAttachment(middle, -margin);
        this.wlTrustAll.setLayoutData((Object)fdlTrustAll);
        this.wTrustAll = new Button((Composite)wCertificateGroup, 32);
        this.props.setLook((Control)this.wTrustAll);
        this.wTrustAll.setToolTipText(BaseMessages.getString(PKG, (String)"LdapInputDialog.TrustAll.Tooltip", (String[])new String[0]));
        FormData fdTrustAll = new FormData();
        fdTrustAll.left = new FormAttachment(middle, 0);
        fdTrustAll.top = new FormAttachment((Control)this.wlTrustAll, 0, 0x1000000);
        this.wTrustAll.setLayoutData((Object)fdTrustAll);
        this.wTrustAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LdapInputDialog.this.input.setChanged();
                LdapInputDialog.this.trustAll();
            }
        });
        FormData fdCertificateGroup = new FormData();
        fdCertificateGroup.left = new FormAttachment(0, margin);
        fdCertificateGroup.top = new FormAttachment((Control)wAuthenticationGroup, margin);
        fdCertificateGroup.right = new FormAttachment(100, -margin);
        wCertificateGroup.setLayoutData((Object)fdCertificateGroup);
        Button wTest = new Button(wGeneralComp, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.TestConnection.Label", (String[])new String[0]));
        this.props.setLook((Control)wTest);
        FormData fdTest = new FormData();
        wTest.setToolTipText(BaseMessages.getString(PKG, (String)"LdapInputDialog.TestConnection.Tooltip", (String[])new String[0]));
        fdTest.top = new FormAttachment((Control)wCertificateGroup, margin);
        fdTest.right = new FormAttachment(100, 0);
        wTest.setLayoutData((Object)fdTest);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        CTabItem wSearchTab = new CTabItem(wTabFolder, 0);
        wSearchTab.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.Search.Tab", (String[])new String[0]));
        FormLayout searchLayout = new FormLayout();
        searchLayout.marginWidth = 3;
        searchLayout.marginHeight = 3;
        Composite wSearchComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wSearchComp);
        wSearchComp.setLayout((Layout)searchLayout);
        Group wSearchGroup = new Group(wSearchComp, 32);
        this.props.setLook((Control)wSearchGroup);
        wSearchGroup.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.Group.SearchGroup.Label", (String[])new String[0]));
        FormLayout searchgroupLayout = new FormLayout();
        searchgroupLayout.marginWidth = 10;
        searchgroupLayout.marginHeight = 10;
        wSearchGroup.setLayout((Layout)searchgroupLayout);
        Label wlDynamicBase = new Label((Composite)wSearchGroup, 131072);
        wlDynamicBase.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.dynamicBase.Label", (String[])new String[0]));
        this.props.setLook((Control)wlDynamicBase);
        FormData fdlDynamicBase = new FormData();
        fdlDynamicBase.left = new FormAttachment(0, -margin);
        fdlDynamicBase.top = new FormAttachment((Control)this.wTransformName, margin);
        fdlDynamicBase.right = new FormAttachment(middle, -2 * margin);
        wlDynamicBase.setLayoutData((Object)fdlDynamicBase);
        this.wDynamicBase = new Button((Composite)wSearchGroup, 32);
        this.props.setLook((Control)this.wDynamicBase);
        this.wDynamicBase.setToolTipText(BaseMessages.getString(PKG, (String)"LdapInputDialog.dynamicBase.Tooltip", (String[])new String[0]));
        FormData fdDynamicBase = new FormData();
        fdDynamicBase.left = new FormAttachment(middle, -margin);
        fdDynamicBase.top = new FormAttachment((Control)wlDynamicBase, 0, 0x1000000);
        this.wDynamicBase.setLayoutData((Object)fdDynamicBase);
        SelectionAdapter ldynamicBase = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LdapInputDialog.this.activateDynamicBase();
                LdapInputDialog.this.input.setChanged();
            }
        };
        this.wDynamicBase.addSelectionListener((SelectionListener)ldynamicBase);
        this.wlSearchBaseField = new Label((Composite)wSearchGroup, 131072);
        this.wlSearchBaseField.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.wsearchBaseField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSearchBaseField);
        FormData fdlsearchBaseField = new FormData();
        fdlsearchBaseField.left = new FormAttachment(0, -margin);
        fdlsearchBaseField.top = new FormAttachment((Control)this.wDynamicBase, margin);
        fdlsearchBaseField.right = new FormAttachment(middle, -2 * margin);
        this.wlSearchBaseField.setLayoutData((Object)fdlsearchBaseField);
        this.wSearchBaseField = new CCombo((Composite)wSearchGroup, 2056);
        this.wSearchBaseField.setEditable(true);
        this.props.setLook((Control)this.wSearchBaseField);
        this.wSearchBaseField.addModifyListener(lsMod);
        FormData fdsearchBaseField = new FormData();
        fdsearchBaseField.left = new FormAttachment(middle, -margin);
        fdsearchBaseField.top = new FormAttachment((Control)this.wDynamicBase, margin);
        fdsearchBaseField.right = new FormAttachment(100, -2 * margin);
        this.wSearchBaseField.setLayoutData((Object)fdsearchBaseField);
        this.wSearchBaseField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                LdapInputDialog.this.setSearchBaseField();
            }
        });
        this.wlSearchBase = new Label((Composite)wSearchGroup, 131072);
        this.wlSearchBase.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.SearchBase.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSearchBase);
        FormData fdlSearchBase = new FormData();
        fdlSearchBase.left = new FormAttachment(0, -margin);
        fdlSearchBase.top = new FormAttachment((Control)this.wSearchBaseField, margin);
        fdlSearchBase.right = new FormAttachment(middle, -2 * margin);
        this.wlSearchBase.setLayoutData((Object)fdlSearchBase);
        this.wSearchBase = new TextVar(this.variables, (Composite)wSearchGroup, 18436);
        this.props.setLook((Control)this.wSearchBase);
        this.wSearchBase.setToolTipText(BaseMessages.getString(PKG, (String)"LdapInputDialog.SearchBase.Tooltip", (String[])new String[0]));
        this.wSearchBase.addModifyListener(lsMod);
        FormData fdSearchBase = new FormData();
        fdSearchBase.left = new FormAttachment(middle, -margin);
        fdSearchBase.top = new FormAttachment((Control)this.wSearchBaseField, margin);
        fdSearchBase.right = new FormAttachment(100, -2 * margin);
        this.wSearchBase.setLayoutData((Object)fdSearchBase);
        Label wlDynamicFilter = new Label((Composite)wSearchGroup, 131072);
        wlDynamicFilter.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.dynamicFilter.Label", (String[])new String[0]));
        this.props.setLook((Control)wlDynamicFilter);
        FormData fdlDynamicFilter = new FormData();
        fdlDynamicFilter.left = new FormAttachment(0, -margin);
        fdlDynamicFilter.top = new FormAttachment((Control)this.wSearchBase, margin);
        fdlDynamicFilter.right = new FormAttachment(middle, -2 * margin);
        wlDynamicFilter.setLayoutData((Object)fdlDynamicFilter);
        this.wDynamicFilter = new Button((Composite)wSearchGroup, 32);
        this.props.setLook((Control)this.wDynamicFilter);
        this.wDynamicFilter.setToolTipText(BaseMessages.getString(PKG, (String)"LdapInputDialog.dynamicFilter.Tooltip", (String[])new String[0]));
        FormData fdynamicFilter = new FormData();
        fdynamicFilter.left = new FormAttachment(middle, -margin);
        fdynamicFilter.top = new FormAttachment((Control)wlDynamicFilter, 0, 0x1000000);
        this.wDynamicFilter.setLayoutData((Object)fdynamicFilter);
        SelectionAdapter ldynamicFilter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LdapInputDialog.this.activateDynamicFilter();
                LdapInputDialog.this.input.setChanged();
            }
        };
        this.wDynamicFilter.addSelectionListener((SelectionListener)ldynamicFilter);
        this.wlFilterField = new Label((Composite)wSearchGroup, 131072);
        this.wlFilterField.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.filterField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilterField);
        FormData fdlfilterField = new FormData();
        fdlfilterField.left = new FormAttachment(0, -margin);
        fdlfilterField.top = new FormAttachment((Control)this.wDynamicFilter, margin);
        fdlfilterField.right = new FormAttachment(middle, -2 * margin);
        this.wlFilterField.setLayoutData((Object)fdlfilterField);
        this.wFilterField = new CCombo((Composite)wSearchGroup, 2056);
        this.wFilterField.setEditable(true);
        this.props.setLook((Control)this.wFilterField);
        this.wFilterField.addModifyListener(lsMod);
        FormData fdfilterField = new FormData();
        fdfilterField.left = new FormAttachment(middle, -margin);
        fdfilterField.top = new FormAttachment((Control)this.wDynamicFilter, margin);
        fdfilterField.right = new FormAttachment(100, -2 * margin);
        this.wFilterField.setLayoutData((Object)fdfilterField);
        this.wFilterField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                LdapInputDialog.this.setSearchBaseField();
            }
        });
        this.wlFilterString = new Label((Composite)wSearchGroup, 131072);
        this.wlFilterString.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.FilterString.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilterString);
        FormData fdlFilterString = new FormData();
        fdlFilterString.left = new FormAttachment(0, 0);
        fdlFilterString.top = new FormAttachment((Control)this.wFilterField, margin);
        fdlFilterString.right = new FormAttachment(middle, -2 * margin);
        this.wlFilterString.setLayoutData((Object)fdlFilterString);
        this.wFilterString = new StyledTextComp(this.variables, (Composite)wSearchGroup, 19202);
        this.wFilterString.setToolTipText(BaseMessages.getString(PKG, (String)"LdapInputDialog.FilterString.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wFilterString);
        this.wFilterString.addModifyListener(lsMod);
        FormData fdFilterString = new FormData();
        fdFilterString.left = new FormAttachment(middle, -margin);
        fdFilterString.top = new FormAttachment((Control)this.wFilterField, margin);
        fdFilterString.right = new FormAttachment(100, -2 * margin);
        fdFilterString.bottom = new FormAttachment(100, -margin);
        this.wFilterString.setLayoutData((Object)fdFilterString);
        this.wFilterString.addKeyListener((KeyAdapter)new ControlSpaceKeyAdapter(this.variables, (Control)this.wFilterString));
        FormData fdSearchGroup = new FormData();
        fdSearchGroup.left = new FormAttachment(0, margin);
        fdSearchGroup.top = new FormAttachment((Control)this.wTransformName, margin);
        fdSearchGroup.right = new FormAttachment(100, -margin);
        fdSearchGroup.bottom = new FormAttachment(100, -margin);
        wSearchGroup.setLayoutData((Object)fdSearchGroup);
        FormData fdSearchComp = new FormData();
        fdSearchComp.left = new FormAttachment(0, 0);
        fdSearchComp.top = new FormAttachment(0, 0);
        fdSearchComp.right = new FormAttachment(100, 0);
        fdSearchComp.bottom = new FormAttachment(100, 0);
        wSearchComp.setLayoutData((Object)fdSearchComp);
        wSearchComp.layout();
        wSearchTab.setControl((Control)wSearchComp);
        CTabItem wContentTab = new CTabItem(wTabFolder, 0);
        wContentTab.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.Content.Tab", (String[])new String[0]));
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = 3;
        contentLayout.marginHeight = 3;
        Composite wContentComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wContentComp);
        wContentComp.setLayout((Layout)contentLayout);
        Group wAdditionalGroup = new Group(wContentComp, 32);
        this.props.setLook((Control)wAdditionalGroup);
        wAdditionalGroup.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.Group.AdditionalGroup.Label", (String[])new String[0]));
        FormLayout additionalgroupLayout = new FormLayout();
        additionalgroupLayout.marginWidth = 10;
        additionalgroupLayout.marginHeight = 10;
        wAdditionalGroup.setLayout((Layout)additionalgroupLayout);
        Label wlInclRownum = new Label((Composite)wAdditionalGroup, 131072);
        wlInclRownum.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.InclRownum.Label", (String[])new String[0]));
        this.props.setLook((Control)wlInclRownum);
        FormData fdlInclRownum = new FormData();
        fdlInclRownum.left = new FormAttachment(0, 0);
        fdlInclRownum.top = new FormAttachment(0, margin);
        fdlInclRownum.right = new FormAttachment(middle, -margin);
        wlInclRownum.setLayoutData((Object)fdlInclRownum);
        this.wInclRownum = new Button((Composite)wAdditionalGroup, 32);
        this.props.setLook((Control)this.wInclRownum);
        this.wInclRownum.setToolTipText(BaseMessages.getString(PKG, (String)"LdapInputDialog.InclRownum.Tooltip", (String[])new String[0]));
        FormData fdRownum = new FormData();
        fdRownum.left = new FormAttachment(middle, 0);
        fdRownum.top = new FormAttachment((Control)wlInclRownum, 0, 0x1000000);
        this.wInclRownum.setLayoutData((Object)fdRownum);
        this.wInclRownum.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        this.wlInclRownumField = new Label((Composite)wAdditionalGroup, 131072);
        this.wlInclRownumField.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.InclRownumField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlInclRownumField);
        FormData fdlInclRownumField = new FormData();
        fdlInclRownumField.left = new FormAttachment((Control)this.wInclRownum, margin);
        fdlInclRownumField.top = new FormAttachment(0, margin);
        this.wlInclRownumField.setLayoutData((Object)fdlInclRownumField);
        this.wInclRownumField = new TextVar(this.variables, (Composite)wAdditionalGroup, 18436);
        this.props.setLook((Control)this.wInclRownumField);
        this.wInclRownumField.addModifyListener(lsMod);
        FormData fdInclRownumField = new FormData();
        fdInclRownumField.left = new FormAttachment((Control)this.wlInclRownumField, margin);
        fdInclRownumField.top = new FormAttachment(0, margin);
        fdInclRownumField.right = new FormAttachment(100, 0);
        this.wInclRownumField.setLayoutData((Object)fdInclRownumField);
        FormData fdAdditionalGroup = new FormData();
        fdAdditionalGroup.left = new FormAttachment(0, margin);
        fdAdditionalGroup.top = new FormAttachment(0, margin);
        fdAdditionalGroup.right = new FormAttachment(100, -margin);
        wAdditionalGroup.setLayoutData((Object)fdAdditionalGroup);
        Label wlLimit = new Label(wContentComp, 131072);
        wlLimit.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.Limit.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLimit);
        FormData fdlLimit = new FormData();
        fdlLimit.left = new FormAttachment(0, 0);
        fdlLimit.top = new FormAttachment((Control)wAdditionalGroup, 2 * margin);
        fdlLimit.right = new FormAttachment(middle, -margin);
        wlLimit.setLayoutData((Object)fdlLimit);
        this.wLimit = new Text(wContentComp, 18436);
        this.props.setLook((Control)this.wLimit);
        this.wLimit.addModifyListener(lsMod);
        FormData fdLimit = new FormData();
        fdLimit.left = new FormAttachment(middle, 0);
        fdLimit.top = new FormAttachment((Control)wAdditionalGroup, 2 * margin);
        fdLimit.right = new FormAttachment(100, 0);
        this.wLimit.setLayoutData((Object)fdLimit);
        Label wlTimeLimit = new Label(wContentComp, 131072);
        wlTimeLimit.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.TimeLimit.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTimeLimit);
        FormData fdlTimeLimit = new FormData();
        fdlTimeLimit.left = new FormAttachment(0, 0);
        fdlTimeLimit.top = new FormAttachment((Control)this.wLimit, margin);
        fdlTimeLimit.right = new FormAttachment(middle, -margin);
        wlTimeLimit.setLayoutData((Object)fdlTimeLimit);
        this.wTimeLimit = new TextVar(this.variables, wContentComp, 18436);
        this.props.setLook((Control)this.wTimeLimit);
        this.wTimeLimit.setToolTipText(BaseMessages.getString(PKG, (String)"LdapInputDialog.TimeLimit.Tooltip", (String[])new String[0]));
        this.wTimeLimit.addModifyListener(lsMod);
        FormData fdTimeLimit = new FormData();
        fdTimeLimit.left = new FormAttachment(middle, 0);
        fdTimeLimit.top = new FormAttachment((Control)this.wLimit, margin);
        fdTimeLimit.right = new FormAttachment(100, 0);
        this.wTimeLimit.setLayoutData((Object)fdTimeLimit);
        Label wlMultiValuedSeparator = new Label(wContentComp, 131072);
        wlMultiValuedSeparator.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.MultiValuedSeparator.Label", (String[])new String[0]));
        this.props.setLook((Control)wlMultiValuedSeparator);
        FormData fdlMultiValuedSeparator = new FormData();
        fdlMultiValuedSeparator.left = new FormAttachment(0, 0);
        fdlMultiValuedSeparator.top = new FormAttachment((Control)this.wTimeLimit, margin);
        fdlMultiValuedSeparator.right = new FormAttachment(middle, -margin);
        wlMultiValuedSeparator.setLayoutData((Object)fdlMultiValuedSeparator);
        this.wMultiValuedSeparator = new TextVar(this.variables, wContentComp, 18436);
        this.props.setLook((Control)this.wMultiValuedSeparator);
        this.wMultiValuedSeparator.setToolTipText(BaseMessages.getString(PKG, (String)"LdapInputDialog.MultiValuedSeparator.Tooltip", (String[])new String[0]));
        this.wMultiValuedSeparator.addModifyListener(lsMod);
        FormData fdMultiValuedSeparator = new FormData();
        fdMultiValuedSeparator.left = new FormAttachment(middle, 0);
        fdMultiValuedSeparator.top = new FormAttachment((Control)this.wTimeLimit, margin);
        fdMultiValuedSeparator.right = new FormAttachment(100, 0);
        this.wMultiValuedSeparator.setLayoutData((Object)fdMultiValuedSeparator);
        Label wlSetPaging = new Label(wContentComp, 131072);
        wlSetPaging.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.setPaging.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSetPaging);
        FormData fdlSetPaging = new FormData();
        fdlSetPaging.left = new FormAttachment(0, 0);
        fdlSetPaging.top = new FormAttachment((Control)this.wMultiValuedSeparator, margin);
        fdlSetPaging.right = new FormAttachment(middle, -margin);
        wlSetPaging.setLayoutData((Object)fdlSetPaging);
        this.wSetPaging = new Button(wContentComp, 32);
        this.props.setLook((Control)this.wSetPaging);
        this.wSetPaging.setToolTipText(BaseMessages.getString(PKG, (String)"LdapInputDialog.setPaging.Tooltip", (String[])new String[0]));
        FormData fdSetPaging = new FormData();
        fdSetPaging.left = new FormAttachment(middle, 0);
        fdSetPaging.top = new FormAttachment((Control)wlSetPaging, 0, 0x1000000);
        this.wSetPaging.setLayoutData((Object)fdSetPaging);
        this.wSetPaging.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LdapInputDialog.this.setPaging();
                LdapInputDialog.this.input.setChanged();
            }
        });
        this.wlPageSize = new Label(wContentComp, 131072);
        this.wlPageSize.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.PageSize.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPageSize);
        FormData fdlPageSize = new FormData();
        fdlPageSize.left = new FormAttachment((Control)this.wSetPaging, margin);
        fdlPageSize.top = new FormAttachment((Control)this.wMultiValuedSeparator, margin);
        this.wlPageSize.setLayoutData((Object)fdlPageSize);
        this.wPageSize = new TextVar(this.variables, wContentComp, 18436);
        this.props.setLook((Control)this.wPageSize);
        this.wPageSize.addModifyListener(lsMod);
        FormData fdPageSize = new FormData();
        fdPageSize.left = new FormAttachment((Control)this.wlPageSize, margin);
        fdPageSize.top = new FormAttachment((Control)this.wMultiValuedSeparator, margin);
        fdPageSize.right = new FormAttachment(100, 0);
        this.wPageSize.setLayoutData((Object)fdPageSize);
        Label wlsearchScope = new Label(wContentComp, 131072);
        wlsearchScope.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.SearchScope.Label", (String[])new String[0]));
        this.props.setLook((Control)wlsearchScope);
        FormData fdlsearchScope = new FormData();
        fdlsearchScope.left = new FormAttachment(0, 0);
        fdlsearchScope.right = new FormAttachment(middle, -margin);
        fdlsearchScope.top = new FormAttachment((Control)this.wPageSize, margin);
        wlsearchScope.setLayoutData((Object)fdlsearchScope);
        this.wSearchScope = new CCombo(wContentComp, 2056);
        this.props.setLook((Control)this.wSearchScope);
        this.wSearchScope.addModifyListener(lsMod);
        FormData fdsearchScope = new FormData();
        fdsearchScope.left = new FormAttachment(middle, 0);
        fdsearchScope.top = new FormAttachment((Control)this.wPageSize, margin);
        fdsearchScope.right = new FormAttachment(100, -margin);
        this.wSearchScope.setLayoutData((Object)fdsearchScope);
        this.wSearchScope.setItems(LdapInputMeta.searchScopeDesc);
        this.wSearchScope.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        FormData fdContentComp = new FormData();
        fdContentComp.left = new FormAttachment(0, 0);
        fdContentComp.top = new FormAttachment(0, 0);
        fdContentComp.right = new FormAttachment(100, 0);
        fdContentComp.bottom = new FormAttachment(100, 0);
        wContentComp.setLayoutData((Object)fdContentComp);
        wContentComp.layout();
        wContentTab.setControl((Control)wContentComp);
        CTabItem wFieldsTab = new CTabItem(wTabFolder, 0);
        wFieldsTab.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.Fields.Tab", (String[])new String[0]));
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 5;
        fieldsLayout.marginHeight = 5;
        Composite wFieldsComp = new Composite((Composite)wTabFolder, 0);
        wFieldsComp.setLayout((Layout)fieldsLayout);
        this.props.setLook((Control)wFieldsComp);
        this.wGet = new Button(wFieldsComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.GetFields.Button", (String[])new String[0]));
        this.fdGet = new FormData();
        this.fdGet.left = new FormAttachment(50, 0);
        this.fdGet.bottom = new FormAttachment(100, 0);
        this.wGet.setLayoutData((Object)this.fdGet);
        int FieldsRows = this.input.getInputFields().length;
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"LdapInputDialog.FieldsTable.Name.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"LdapInputDialog.FieldsTable.Attribute.Column", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"LdapInputDialog.FieldsTable.FetchAttributeAs.Column", (String[])new String[0]), 2, LdapInputField.FetchAttributeAsDesc, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"LdapInputDialog.FieldsTable.IsSortedKey.Column", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])}, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"LdapInputDialog.FieldsTable.Type.Column", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames(), true), new ColumnInfo(BaseMessages.getString(PKG, (String)"LdapInputDialog.FieldsTable.Format.Column", (String[])new String[0]), 5, 3), new ColumnInfo(BaseMessages.getString(PKG, (String)"LdapInputDialog.FieldsTable.Length.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"LdapInputDialog.FieldsTable.Precision.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"LdapInputDialog.FieldsTable.Currency.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"LdapInputDialog.FieldsTable.Decimal.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"LdapInputDialog.FieldsTable.Group.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"LdapInputDialog.FieldsTable.TrimType.Column", (String[])new String[0]), 2, LdapInputField.trimTypeDesc, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"LdapInputDialog.FieldsTable.Repeat.Column", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])}, true)};
        this.colinf[0].setUsingVariables(true);
        this.colinf[0].setToolTip(BaseMessages.getString(PKG, (String)"LdapInputDialog.FieldsTable.Name.Column.Tooltip", (String[])new String[0]));
        this.colinf[1].setUsingVariables(true);
        this.colinf[1].setToolTip(BaseMessages.getString(PKG, (String)"LdapInputDialog.FieldsTable.Attribute.Column.Tooltip", (String[])new String[0]));
        this.wFields = new TableView(this.variables, wFieldsComp, 65538, this.colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wGet, -margin);
        this.wFields.setLayoutData((Object)fdFields);
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        wFieldsComp.layout();
        wFieldsTab.setControl((Control)wFieldsComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wGet.addListener(13, e -> this.get());
        wTest.addListener(13, e -> this.test());
        this.wInclRownum.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LdapInputDialog.this.setIncludeRownum();
            }
        });
        wTabFolder.setSelection(0);
        this.getData(this.input);
        this.setProtocol();
        this.setTrustStore();
        this.useAuthentication();
        this.setPaging();
        this.activateDynamicBase();
        this.activateDynamicFilter();
        this.input.setChanged(this.changed);
        this.wFields.optWidth(true);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test() {
        LdapConnection connection = null;
        try {
            LdapInputMeta meta = new LdapInputMeta();
            this.getInfo(meta);
            connection = new LdapConnection((ILogChannel)this.log, this.variables, meta, null);
            if (this.wUsingAuthentication.getSelection()) {
                connection.connect(this.variables.resolve(meta.getUserName()), Encr.decryptPasswordOptionallyEncrypted((String)this.variables.resolve(meta.getPassword())));
            } else {
                connection.connect();
            }
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"LdapInputDialog.Connected.OK", (String[])new String[0]) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"LdapInputDialog.Connected.Title.Ok", (String[])new String[0]));
            mb.open();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"LdapInputDialog.Connected.Title.Error", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapInputDialog.Connected.NOK", (String[])new String[0]), e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void get() {
        LdapConnection connection = null;
        try {
            LdapInputMeta meta = new LdapInputMeta();
            this.getInfo(meta);
            this.wFields.removeAll();
            connection = new LdapConnection((ILogChannel)this.log, this.variables, meta, null);
            if (meta.isUseAuthentication()) {
                String username = this.variables.resolve(meta.getUserName());
                String password = Encr.decryptPasswordOptionallyEncrypted((String)this.variables.resolve(meta.getPassword()));
                connection.connect(username, password);
            } else {
                connection.connect();
            }
            RowMeta listattributes = connection.getFields(this.variables.resolve(meta.getSearchBase()));
            String[] fieldsName = new String[listattributes.size()];
            for (int i = 0; i < listattributes.size(); ++i) {
                IValueMeta v = listattributes.getValueMeta(i);
                fieldsName[i] = v.getName();
                TableItem item = new TableItem(this.wFields.table, 0);
                item.setText(1, v.getName());
                item.setText(2, v.getName());
                if (LdapInputField.binaryAttributes.contains(v.getName())) {
                    item.setText(3, BaseMessages.getString(PKG, (String)"LdapInputField.FetchAttributeAs.Binary", (String[])new String[0]));
                } else {
                    item.setText(3, BaseMessages.getString(PKG, (String)"LdapInputField.FetchAttributeAs.String", (String[])new String[0]));
                }
                item.setText(4, BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
                item.setText(5, v.getTypeDesc());
            }
            this.colinf[1].setComboValues(fieldsName);
            this.wFields.removeEmptyRows();
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"LdapInputDialog.ErrorGettingColums.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapInputDialog.ErrorGettingColums.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"LdapInputDialog.ErrorGettingColums.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapInputDialog.ErrorGettingColums.DialogMessage", (String[])new String[0]), e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void setPaging() {
        this.wlPageSize.setEnabled(this.wSetPaging.getSelection());
        this.wPageSize.setEnabled(this.wSetPaging.getSelection());
    }

    public void setIncludeRownum() {
        this.wlInclRownumField.setEnabled(this.wInclRownum.getSelection());
        this.wInclRownumField.setEnabled(this.wInclRownum.getSelection());
    }

    public void getData(LdapInputMeta in) {
        this.wProtocol.setText(Const.NVL((String)in.getProtocol(), (String)LdapProtocolFactory.getConnectionTypes((ILogChannel)this.log).get(0)));
        this.wSetTrustStore.setSelection(in.isUseCertificate());
        if (in.getTrustStorePath() != null) {
            this.wTrustStorePath.setText(in.getTrustStorePath());
        }
        if (in.getTrustStorePassword() != null) {
            this.wTrustStorePassword.setText(in.getTrustStorePassword());
        }
        this.wTrustAll.setSelection(in.isTrustAllCertificates());
        this.wInclRownum.setSelection(in.isIncludeRowNumber());
        if (in.getRowNumberField() != null) {
            this.wInclRownumField.setText(in.getRowNumberField());
        }
        this.wUsingAuthentication.setSelection(in.isUseAuthentication());
        this.wSetPaging.setSelection(in.isPaging());
        if (in.getPageSize() != null) {
            this.wPageSize.setText(in.getPageSize());
        }
        this.wLimit.setText("" + in.getRowLimit());
        this.wTimeLimit.setText("" + in.getTimeLimit());
        if (in.getMultiValuedSeparator() != null) {
            this.wMultiValuedSeparator.setText(in.getMultiValuedSeparator());
        }
        if (in.getHost() != null) {
            this.wHost.setText(in.getHost());
        }
        if (in.getUserName() != null) {
            this.wUserName.setText(in.getUserName());
        }
        if (in.getPassword() != null) {
            this.wPassword.setText(in.getPassword());
        }
        if (in.getPort() != null) {
            this.wPort.setText(in.getPort());
        }
        if (in.getFilterString() != null) {
            this.wFilterString.setText(in.getFilterString());
        }
        if (in.getSearchBase() != null) {
            this.wSearchBase.setText(in.getSearchBase());
        }
        this.wDynamicBase.setSelection(in.isDynamicSearch());
        if (in.getDynamicSearchFieldName() != null) {
            this.wSearchBaseField.setText(in.getDynamicSearchFieldName());
        }
        this.wDynamicFilter.setSelection(in.isDynamicFilter());
        if (in.getDynamicFilterFieldName() != null) {
            this.wFilterField.setText(in.getDynamicFilterFieldName());
        }
        this.wSearchScope.setText(LdapInputMeta.getSearchScopeDesc(in.getSearchScope()));
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"LdapInputDialog.Log.GettingFieldsInfo", (String[])new String[0]));
        }
        for (int i = 0; i < in.getInputFields().length; ++i) {
            String rep;
            LdapInputField field = in.getInputFields()[i];
            if (field == null) continue;
            TableItem item = this.wFields.table.getItem(i);
            String name = field.getName();
            String path = field.getAttribute();
            String issortedkey = field.isSortedKey() ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]);
            String returntype = field.getFetchAttributeAsDesc();
            String type = field.getTypeDesc();
            String format = field.getFormat();
            String length = "" + field.getLength();
            String prec = "" + field.getPrecision();
            String curr = field.getCurrencySymbol();
            String group = field.getGroupSymbol();
            String decim = field.getDecimalSymbol();
            String trim = field.getTrimTypeDesc();
            String string = rep = field.isRepeated() ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]);
            if (name != null) {
                item.setText(1, name);
            }
            if (path != null) {
                item.setText(2, path);
            }
            if (returntype != null) {
                item.setText(3, returntype);
            }
            if (issortedkey != null) {
                item.setText(4, issortedkey);
            }
            if (type != null) {
                item.setText(5, type);
            }
            if (format != null) {
                item.setText(6, format);
            }
            if (length != null && !"-1".equals(length)) {
                item.setText(5, length);
            }
            if (prec != null && !"-1".equals(prec)) {
                item.setText(8, prec);
            }
            if (curr != null) {
                item.setText(9, curr);
            }
            if (decim != null) {
                item.setText(10, decim);
            }
            if (group != null) {
                item.setText(11, group);
            }
            if (trim != null) {
                item.setText(12, trim);
            }
            if (rep == null) continue;
            item.setText(13, rep);
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.setIncludeRownum();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        try {
            this.getInfo(this.input);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"LdapInputDialog.ErrorParsingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapInputDialog.ErrorParsingData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
        this.dispose();
    }

    private void getInfo(LdapInputMeta in) throws HopException {
        this.transformName = this.wTransformName.getText();
        in.setProtocol(this.wProtocol.getText());
        in.setUseCertificate(this.wSetTrustStore.getSelection());
        in.setTrustStorePath(this.wTrustStorePath.getText());
        in.setTrustStorePassword(this.wTrustStorePassword.getText());
        in.setTrustAllCertificates(this.wTrustAll.getSelection());
        in.setRowLimit(Const.toInt((String)this.wLimit.getText(), (int)0));
        in.setTimeLimit(Const.toInt((String)this.wTimeLimit.getText(), (int)0));
        in.setMultiValuedSeparator(this.wMultiValuedSeparator.getText());
        in.setIncludeRowNumber(this.wInclRownum.getSelection());
        in.setUseAuthentication(this.wUsingAuthentication.getSelection());
        in.setPaging(this.wSetPaging.getSelection());
        in.setPageSize(this.wPageSize.getText());
        in.setRowNumberField(this.wInclRownumField.getText());
        in.setHost(this.wHost.getText());
        in.setUserName(this.wUserName.getText());
        in.setPassword(this.wPassword.getText());
        in.setPort(this.wPort.getText());
        in.setFilterString(this.wFilterString.getText());
        in.setSearchBase(this.wSearchBase.getText());
        in.setDynamicSearch(this.wDynamicBase.getSelection());
        in.setDynamicSearchFieldName(this.wSearchBaseField.getText());
        in.setDynamicFilter(this.wDynamicFilter.getSelection());
        in.setDynamicFilterFieldName(this.wFilterField.getText());
        int nrFields = this.wFields.nrNonEmpty();
        in.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            LdapInputField field = new LdapInputField();
            TableItem item = this.wFields.getNonEmpty(i);
            field.setName(item.getText(1));
            field.setAttribute(item.getText(2));
            field.setFetchAttributeAs(LdapInputField.getFetchAttributeAsByDesc(item.getText(3)));
            field.setSortedKey(BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equalsIgnoreCase(item.getText(4)));
            field.setType(ValueMetaFactory.getIdForValueMeta((String)item.getText(5)));
            field.setFormat(item.getText(6));
            field.setLength(Const.toInt((String)item.getText(7), (int)-1));
            field.setPrecision(Const.toInt((String)item.getText(8), (int)-1));
            field.setCurrencySymbol(item.getText(9));
            field.setDecimalSymbol(item.getText(10));
            field.setGroupSymbol(item.getText(11));
            field.setTrimType(LdapInputField.getTrimTypeByDesc(item.getText(12)));
            field.setRepeated(BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equalsIgnoreCase(item.getText(13)));
            in.getInputFields()[i] = field;
        }
        in.setSearchScope(LdapInputMeta.getSearchScopeByDesc(this.wSearchScope.getText()));
    }

    private void useAuthentication() {
        this.wUserName.setEnabled(this.wUsingAuthentication.getSelection());
        this.wlUserName.setEnabled(this.wUsingAuthentication.getSelection());
        this.wPassword.setEnabled(this.wUsingAuthentication.getSelection());
        this.wlPassword.setEnabled(this.wUsingAuthentication.getSelection());
    }

    private void preview() {
        try {
            LdapInputMeta oneMeta = new LdapInputMeta();
            this.getInfo(oneMeta);
            PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.pipelineMeta.getMetadataProvider(), (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
            EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"LdapInputDialog.NumberRows.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapInputDialog.NumberRows.DialogMessage", (String[])new String[0]));
            int previewSize = numberDialog.open();
            if (previewSize > 0) {
                PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
                progressDialog.open();
                if (!progressDialog.isCancelled()) {
                    Pipeline pipeline = progressDialog.getPipeline();
                    String loggingText = progressDialog.getLoggingText();
                    if (pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                        EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                        etd.setReadOnly();
                        etd.open();
                    }
                    PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
                    prd.open();
                }
            }
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"LdapInputDialog.ErrorPreviewingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapInputDialog.ErrorPreviewingData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void activateDynamicBase() {
        this.wSearchBase.setEnabled(!this.wDynamicBase.getSelection());
        this.wlSearchBase.setEnabled(!this.wDynamicBase.getSelection());
        this.wlSearchBaseField.setEnabled(this.wDynamicBase.getSelection());
        this.wSearchBaseField.setEnabled(this.wDynamicBase.getSelection());
        this.activatePreview();
        this.activateGetFields();
    }

    private void activateDynamicFilter() {
        this.wlFilterString.setEnabled(!this.wDynamicFilter.getSelection());
        this.wFilterString.setEnabled(!this.wDynamicFilter.getSelection());
        this.wlFilterField.setEnabled(this.wDynamicFilter.getSelection());
        this.wFilterField.setEnabled(this.wDynamicFilter.getSelection());
        this.activatePreview();
    }

    private void activatePreview() {
        this.wPreview.setEnabled(!this.wDynamicBase.getSelection() && !this.wDynamicFilter.getSelection());
    }

    private void activateGetFields() {
        this.wGet.setEnabled(!this.wDynamicBase.getSelection());
    }

    private void setSearchBaseField() {
        if (!this.gotPreviousFields) {
            try {
                String basefield = this.wSearchBaseField.getText();
                String filterfield = this.wFilterField.getText();
                this.wSearchBaseField.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wSearchBaseField.setItems(r.getFieldNames());
                    this.wFilterField.setItems(r.getFieldNames());
                }
                if (basefield != null) {
                    this.wSearchBaseField.setText(basefield);
                }
                if (filterfield != null) {
                    this.wFilterField.setText(basefield);
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"LdapInputDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapInputDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            this.gotPreviousFields = true;
        }
    }

    private void setProtocol() {
        boolean enable = !LdapProtocol.getName().equals(this.wProtocol.getText());
        this.wlSetTrustStore.setEnabled(enable);
        this.wSetTrustStore.setEnabled(enable);
        this.setTrustStore();
    }

    private void setTrustStore() {
        boolean enable = this.wSetTrustStore.getSelection() && !LdapProtocol.getName().equals(this.wProtocol.getText());
        this.wlTrustAll.setEnabled(enable);
        this.wTrustAll.setEnabled(enable);
        this.trustAll();
    }

    private void trustAll() {
        boolean enable = this.wSetTrustStore.getSelection() && !LdapProtocol.getName().equals(this.wProtocol.getText()) && !this.wTrustAll.getSelection();
        this.wlTrustStorePath.setEnabled(enable);
        this.wTrustStorePath.setEnabled(enable);
        this.wlTrustStorePassword.setEnabled(enable);
        this.wTrustStorePassword.setEnabled(enable);
        this.wbbFilename.setEnabled(enable);
    }
}

