/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.hive.org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;

public class DefaultRule
implements Rule<JFieldVar, JFieldVar> {
    private final RuleFactory ruleFactory;

    public DefaultRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JFieldVar apply(String nodeName, JsonNode node, JsonNode parent, JFieldVar field, Schema currentSchema) {
        boolean defaultPresent = node != null && StringUtils.isNotEmpty(node.asText());
        String fieldType = field.type().fullName();
        if (defaultPresent && !field.type().isPrimitive() && node.isNull()) {
            field.init(JExpr._null());
        } else if (fieldType.startsWith(List.class.getName())) {
            field.init(this.getDefaultList(field.type(), node));
        } else if (fieldType.startsWith(Set.class.getName())) {
            field.init(this.getDefaultSet(field.type(), node));
        } else if (fieldType.startsWith(String.class.getName()) && node != null) {
            field.init(DefaultRule.getDefaultValue(field.type(), node));
        } else if (defaultPresent) {
            field.init(DefaultRule.getDefaultValue(field.type(), node));
        }
        return field;
    }

    static JExpression getDefaultValue(JType fieldType, JsonNode node) {
        return DefaultRule.getDefaultValue(fieldType, node.asText());
    }

    static JExpression getDefaultValue(JType fieldType, String value) {
        if ((fieldType = fieldType.unboxify()).fullName().equals(String.class.getName())) {
            return JExpr.lit(value);
        }
        if (fieldType.fullName().equals(Integer.TYPE.getName())) {
            return JExpr.lit(Integer.parseInt(value));
        }
        if (fieldType.fullName().equals(BigInteger.class.getName())) {
            return JExpr._new(fieldType).arg(JExpr.lit(value));
        }
        if (fieldType.fullName().equals(Double.TYPE.getName())) {
            return JExpr.lit(Double.parseDouble(value));
        }
        if (fieldType.fullName().equals(BigDecimal.class.getName())) {
            return JExpr._new(fieldType).arg(JExpr.lit(value));
        }
        if (fieldType.fullName().equals(Boolean.TYPE.getName())) {
            return JExpr.lit(Boolean.parseBoolean(value));
        }
        if (fieldType.fullName().equals(DateTime.class.getName()) || fieldType.fullName().equals(Date.class.getName())) {
            long millisecs = DefaultRule.parseDateToMillisecs(value);
            JInvocation newDateTime = JExpr._new(fieldType);
            newDateTime.arg(JExpr.lit(millisecs));
            return newDateTime;
        }
        if (fieldType.fullName().equals(LocalDate.class.getName()) || fieldType.fullName().equals(LocalTime.class.getName())) {
            JInvocation stringParseableTypeInstance = JExpr._new(fieldType);
            stringParseableTypeInstance.arg(JExpr.lit(value));
            return stringParseableTypeInstance;
        }
        if (fieldType.fullName().equals(Long.TYPE.getName())) {
            return JExpr.lit(Long.parseLong(value));
        }
        if (fieldType.fullName().equals(Float.TYPE.getName())) {
            return JExpr.lit(Float.parseFloat(value));
        }
        if (fieldType.fullName().equals(URI.class.getName())) {
            JInvocation invokeCreate = fieldType.owner().ref(URI.class).staticInvoke("create");
            return invokeCreate.arg(JExpr.lit(value));
        }
        if (fieldType instanceof JDefinedClass && ((JDefinedClass)fieldType).getClassType().equals(ClassType.ENUM)) {
            return DefaultRule.getDefaultEnum(fieldType, value);
        }
        return JExpr._null();
    }

    private JExpression getDefaultList(JType fieldType, JsonNode node) {
        JClass listGenericType = ((JClass)fieldType).getTypeParameters().get(0);
        JClass listImplClass = fieldType.owner().ref(ArrayList.class);
        listImplClass = listImplClass.narrow(listGenericType);
        JInvocation newListImpl = JExpr._new(listImplClass);
        if (node instanceof ArrayNode && node.size() > 0) {
            JInvocation invokeAsList = fieldType.owner().ref(Arrays.class).staticInvoke("asList");
            for (JsonNode defaultValue : node) {
                invokeAsList.arg(DefaultRule.getDefaultValue((JType)listGenericType, defaultValue));
            }
            newListImpl.arg(invokeAsList);
        } else if (!this.ruleFactory.getGenerationConfig().isInitializeCollections()) {
            return JExpr._null();
        }
        return newListImpl;
    }

    private JExpression getDefaultSet(JType fieldType, JsonNode node) {
        JClass setGenericType = ((JClass)fieldType).getTypeParameters().get(0);
        JClass setImplClass = fieldType.owner().ref(LinkedHashSet.class);
        setImplClass = setImplClass.narrow(setGenericType);
        JInvocation newSetImpl = JExpr._new(setImplClass);
        if (node instanceof ArrayNode && node.size() > 0) {
            JInvocation invokeAsList = fieldType.owner().ref(Arrays.class).staticInvoke("asList");
            for (JsonNode defaultValue : node) {
                invokeAsList.arg(DefaultRule.getDefaultValue((JType)setGenericType, defaultValue));
            }
            newSetImpl.arg(invokeAsList);
        } else if (!this.ruleFactory.getGenerationConfig().isInitializeCollections()) {
            return JExpr._null();
        }
        return newSetImpl;
    }

    private static JExpression getDefaultEnum(JType fieldType, String value) {
        JDefinedClass enumClass = (JDefinedClass)fieldType;
        JType backingType = enumClass.fields().get("value").type();
        JInvocation invokeFromValue = enumClass.staticInvoke("fromValue");
        invokeFromValue.arg(DefaultRule.getDefaultValue(backingType, value));
        return invokeFromValue;
    }

    private static long parseDateToMillisecs(String valueAsText) {
        try {
            return Long.parseLong(valueAsText);
        }
        catch (NumberFormatException nfe) {
            try {
                return new StdDateFormat().parse(valueAsText).getTime();
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException("Unable to parse this string as a date: " + valueAsText);
            }
        }
    }
}

