/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.shims.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftHttpFilter
implements Filter {
    public static final Logger LOG = LoggerFactory.getLogger(ThriftHttpFilter.class.getName());
    protected static final String X_CSRF_TOKEN = "X-CSRF-TOKEN";
    protected static final String X_XSRF_HEADER = "X-XSRF-HEADER";
    protected static final String ERROR_MESSAGE = "Request did not have valid XSRF header/CSRF token, rejecting.";
    protected HiveConf hiveConf;

    public ThriftHttpFilter(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        boolean xsrfFlag = this.hiveConf.getBoolean(HiveConf.ConfVars.HIVE_SERVER2_XSRF_FILTER_ENABLED.varname, false);
        boolean csrfFlag = this.hiveConf.getBoolean(HiveConf.ConfVars.HIVE_SERVER2_CSRF_FILTER_ENABLED.varname, false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Is {} filtering Enabled : {}", (Object)X_CSRF_TOKEN, (Object)csrfFlag);
            LOG.debug("Is {} filtering Enabled : {}", (Object)X_XSRF_HEADER, (Object)xsrfFlag);
        }
        if (!xsrfFlag && !csrfFlag || csrfFlag && Utils.doXsrfFilter(request, response, null, X_CSRF_TOKEN) || xsrfFlag && Utils.doXsrfFilter(request, response, null, X_XSRF_HEADER)) {
            filterChain.doFilter(request, response);
        } else {
            LOG.warn(ERROR_MESSAGE);
            ((HttpServletResponse)response).sendError(403, ERROR_MESSAGE);
        }
    }

    public void destroy() {
    }
}

