/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hive.service.cli.operation.TableTypeMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTableTypeMapping
implements TableTypeMapping {
    private static final Logger LOG = LoggerFactory.getLogger(HiveTableTypeMapping.class);

    @Override
    public String[] mapToHiveType(String clientTypeName) {
        return new String[]{this.mapToClientType(clientTypeName)};
    }

    @Override
    public String mapToClientType(String hiveTypeName) {
        try {
            TableType hiveType = TableType.valueOf(hiveTypeName.toUpperCase());
            return hiveType.name();
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Invalid hive table type " + hiveTypeName);
            return hiveTypeName;
        }
    }

    @Override
    public Set<String> getTableTypeNames() {
        HashSet<String> typeNameSet = new HashSet<String>();
        for (TableType typeNames : TableType.values()) {
            typeNameSet.add(typeNames.name());
        }
        return typeNameSet;
    }
}

