/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.io.IOException;
import java.util.Map;
import javax.security.sasl.SaslException;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hive.org.apache.thrift.TProcessor;
import org.apache.hive.org.apache.thrift.TProcessorFactory;
import org.apache.hive.org.apache.thrift.transport.TSaslClientTransport;
import org.apache.hive.org.apache.thrift.transport.TTransport;
import org.apache.hive.org.apache.thrift.transport.TTransportException;
import org.apache.hive.service.auth.TSubjectAssumingTransport;
import org.apache.hive.service.rpc.thrift.TCLIService;

public final class KerberosSaslHelper {
    public static TProcessorFactory getKerberosProcessorFactory(HadoopThriftAuthBridge.Server saslServer, TCLIService.Iface service) {
        return new CLIServiceProcessorFactory(saslServer, service);
    }

    public static TTransport getKerberosTransport(String principal, String host, TTransport underlyingTransport, Map<String, String> saslProps, boolean assumeSubject) throws SaslException {
        try {
            String[] names = principal.split("[/@]");
            if (names.length != 3) {
                throw new IllegalArgumentException("Kerberos principal should have 3 parts: " + principal);
            }
            if (assumeSubject) {
                return KerberosSaslHelper.createSubjectAssumedTransport(principal, host, underlyingTransport, saslProps);
            }
            HadoopThriftAuthBridge.Client authBridge = HadoopThriftAuthBridge.getBridge().createClientWithConf("kerberos");
            return authBridge.createClientTransport(principal, host, "KERBEROS", null, underlyingTransport, saslProps);
        }
        catch (IOException e) {
            throw new SaslException("Failed to open client transport", e);
        }
    }

    public static TTransport createSubjectAssumedTransport(String principal, String host, TTransport underlyingTransport, Map<String, String> saslProps) throws IOException {
        String resolvedPrincipal = SecurityUtil.getServerPrincipal(principal, host);
        String[] names = resolvedPrincipal.split("[/@]");
        try {
            TSaslClientTransport saslTransport = new TSaslClientTransport("GSSAPI", null, names[0], names[1], saslProps, null, underlyingTransport);
            return new TSubjectAssumingTransport(saslTransport);
        }
        catch (SaslException | TTransportException se) {
            throw new IOException("Could not instantiate transport", se);
        }
    }

    public static TTransport getTokenTransport(String tokenStr, String host, TTransport underlyingTransport, Map<String, String> saslProps) throws SaslException {
        HadoopThriftAuthBridge.Client authBridge = HadoopThriftAuthBridge.getBridge().createClientWithConf("kerberos");
        try {
            return authBridge.createClientTransport(null, host, "DIGEST", tokenStr, underlyingTransport, saslProps);
        }
        catch (IOException e) {
            throw new SaslException("Failed to open client transport", e);
        }
    }

    private KerberosSaslHelper() {
        throw new UnsupportedOperationException("Can't initialize class");
    }

    private static class CLIServiceProcessorFactory
    extends TProcessorFactory {
        private final TCLIService.Iface service;
        private final HadoopThriftAuthBridge.Server saslServer;

        public CLIServiceProcessorFactory(HadoopThriftAuthBridge.Server saslServer, TCLIService.Iface service) {
            super(null);
            this.service = service;
            this.saslServer = saslServer;
        }

        @Override
        public TProcessor getProcessor(TTransport trans) {
            TCLIService.Processor<TCLIService.Iface> sqlProcessor = new TCLIService.Processor<TCLIService.Iface>(this.service);
            return this.saslServer.wrapNonAssumingProcessor(sqlProcessor);
        }
    }
}

