/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.curator.framework.recipes.locks;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hive.org.apache.curator.framework.recipes.locks.InterProcessLock;

public class Locker
implements AutoCloseable {
    private final InterProcessLock lock;
    private final AtomicBoolean acquired = new AtomicBoolean(false);

    public Locker(InterProcessLock lock2, long timeout, TimeUnit unit) throws Exception {
        this.lock = lock2;
        this.acquired.set(this.acquireLock(lock2, timeout, unit));
        if (!this.acquired.get()) {
            throw new TimeoutException("Could not acquire lock within timeout of " + unit.toMillis(timeout) + "ms");
        }
    }

    public Locker(InterProcessLock lock2) throws Exception {
        this.lock = lock2;
        this.acquireLock(lock2);
        this.acquired.set(true);
    }

    @Override
    public void close() throws Exception {
        if (this.acquired.compareAndSet(true, false)) {
            this.releaseLock();
        }
    }

    protected void releaseLock() throws Exception {
        this.lock.release();
    }

    protected void acquireLock(InterProcessLock lock2) throws Exception {
        lock2.acquire();
    }

    protected boolean acquireLock(InterProcessLock lock2, long timeout, TimeUnit unit) throws Exception {
        return lock2.acquire(timeout, unit);
    }
}

