/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.IPStackUtils;
import org.apache.hadoop.hive.common.SSLZookeeperFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hive.com.google.common.base.Joiner;
import org.apache.hive.jdbc.Utils;
import org.apache.hive.jdbc.ZooKeeperHiveClientException;
import org.apache.hive.org.apache.commons.lang3.StringUtils;
import org.apache.hive.org.apache.curator.framework.CuratorFramework;
import org.apache.hive.org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.hive.org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.hive.org.apache.curator.utils.ZKPaths;
import org.apache.hive.service.server.HS2ActivePassiveHARegistry;
import org.apache.hive.service.server.HS2ActivePassiveHARegistryClient;
import org.apache.hive.service.server.HiveServer2Instance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZooKeeperHiveClientHelper {
    static final Logger LOG = LoggerFactory.getLogger(ZooKeeperHiveClientHelper.class);
    private static final Pattern kvPattern = Pattern.compile("([^=;]*)=([^;]*)[;]?");

    ZooKeeperHiveClientHelper() {
    }

    private static String getZooKeeperNamespace(Utils.JdbcConnectionParams connParams) {
        String zooKeeperNamespace = connParams.getSessionVars().get("zooKeeperNamespace");
        if (zooKeeperNamespace == null || zooKeeperNamespace.isEmpty()) {
            zooKeeperNamespace = ZooKeeperHiveClientHelper.isZkHADynamicDiscoveryMode(connParams.getSessionVars()) ? "hs2ActivePassiveHA" : "hiveserver2";
        }
        return zooKeeperNamespace;
    }

    public static boolean isZkHADynamicDiscoveryMode(Map<String, String> sessionConf) {
        String discoveryMode = sessionConf.get("serviceDiscoveryMode");
        return "zooKeeperHA".equalsIgnoreCase(discoveryMode);
    }

    public static boolean isZkDynamicDiscoveryMode(Map<String, String> sessionConf) {
        String discoveryMode = sessionConf.get("serviceDiscoveryMode");
        return "zooKeeper".equalsIgnoreCase(discoveryMode) || "zooKeeperHA".equalsIgnoreCase(discoveryMode);
    }

    static boolean isZkEnforceSASLClient(Map<String, String> sessionVars) {
        HiveConf.ConfVars confVars = HiveConf.ConfVars.HIVE_ZOOKEEPER_USE_KERBEROS;
        return sessionVars.containsKey("principal") && Boolean.parseBoolean(sessionVars.getOrDefault(confVars.varname, confVars.getDefaultValue()));
    }

    public static void setZkSSLParams(Utils.JdbcConnectionParams connParams) {
        Map<String, String> sessionConf = connParams.getSessionVars();
        boolean sslEnabled = false;
        if (sessionConf.containsKey("zooKeeperSSLEnable")) {
            sslEnabled = Boolean.parseBoolean(sessionConf.get("zooKeeperSSLEnable"));
            connParams.setZooKeeperSslEnabled(sslEnabled);
        }
        if (sslEnabled) {
            connParams.setZookeeperKeyStoreLocation(StringUtils.defaultString(sessionConf.get("zooKeeperKeystoreLocation"), ""));
            connParams.setZookeeperKeyStorePassword(StringUtils.defaultString(Utils.getPassword(sessionConf, "zooKeeperKeystorePassword"), ""));
            connParams.setZookeeperKeyStoreType(StringUtils.defaultString(sessionConf.get("zooKeeperKeystoreType"), ""));
            connParams.setZookeeperTrustStoreLocation(StringUtils.defaultString(sessionConf.get("zooKeeperTruststoreLocation"), ""));
            connParams.setZookeeperTrustStorePassword(StringUtils.defaultString(Utils.getPassword(sessionConf, "zooKeeperTruststorePassword"), ""));
            connParams.setZookeeperTrustStoreType(StringUtils.defaultString(sessionConf.get("zooKeeperTruststoreType"), ""));
        }
    }

    private static CuratorFramework getZkClient(Utils.JdbcConnectionParams connParams) throws Exception {
        String zooKeeperEnsemble = connParams.getZooKeeperEnsemble();
        CuratorFramework zooKeeperClient = CuratorFrameworkFactory.builder().connectString(zooKeeperEnsemble).retryPolicy(new ExponentialBackoffRetry(1000, 3)).zookeeperFactory(new SSLZookeeperFactory(connParams.isZooKeeperSslEnabled(), connParams.getZookeeperKeyStoreLocation(), connParams.getZookeeperKeyStorePassword(), connParams.getZookeeperKeyStoreType(), connParams.getZookeeperTrustStoreLocation(), connParams.getZookeeperTrustStorePassword(), connParams.getZookeeperTrustStoreType())).build();
        if (ZooKeeperHiveClientHelper.isZkEnforceSASLClient(connParams.getSessionVars())) {
            SecurityUtils.setZookeeperClientKerberosJaasConfig(null, null, new String[0]);
        }
        zooKeeperClient.start();
        return zooKeeperClient;
    }

    private static List<String> getServerHosts(Utils.JdbcConnectionParams connParams, CuratorFramework zooKeeperClient) throws ZooKeeperHiveClientException {
        String zookeeperNamespace = ZooKeeperHiveClientHelper.getZooKeeperNamespace(connParams);
        String zkPath = ZKPaths.makePath(null, zookeeperNamespace);
        try {
            List serverHosts = (List)zooKeeperClient.getChildren().forPath(zkPath);
            LOG.info("Discovered HiveServer2 hosts in ZooKeeper [{}]: {}", (Object)zkPath, (Object)serverHosts);
            if (serverHosts.isEmpty()) {
                LOG.warn("Did not find any HiveServer2 hosts in ZooKeeper [{}]. Check that the Hive ZooKeeper namespace is configured correctly.", (Object)zkPath);
            }
            serverHosts.removeAll(connParams.getRejectedHostZnodePaths());
            LOG.debug("Servers in ZooKeeper after removing rejected: {}", (Object)serverHosts);
            return serverHosts;
        }
        catch (Exception e) {
            throw new ZooKeeperHiveClientException("Unable to retrive HS2 host information from ZooKeeper", e);
        }
    }

    private static void updateParamsWithZKServerNode(Utils.JdbcConnectionParams connParams, CuratorFramework zooKeeperClient, String serverNode) throws Exception {
        String zooKeeperNamespace = ZooKeeperHiveClientHelper.getZooKeeperNamespace(connParams);
        connParams.setCurrentHostZnodePath(serverNode);
        String dataStr = new String((byte[])zooKeeperClient.getData().forPath(ZKPaths.makePath(null, zooKeeperNamespace, serverNode)), StandardCharsets.UTF_8);
        Matcher matcher = kvPattern.matcher(dataStr);
        if (dataStr != null && !matcher.find()) {
            try {
                IPStackUtils.HostPort hostPort = IPStackUtils.getHostAndPort(dataStr);
                connParams.setHost(hostPort.getHostname());
                connParams.setPort(hostPort.getPort());
            }
            catch (Exception e) {
                throw new ZooKeeperHiveClientException("Unable to parse HiveServer2 URI from ZooKeeper data: " + dataStr);
            }
        } else {
            ZooKeeperHiveClientHelper.applyConfs(dataStr, connParams);
        }
    }

    static void configureConnParams(Utils.JdbcConnectionParams connParams) throws ZooKeeperHiveClientException {
        if (ZooKeeperHiveClientHelper.isZkHADynamicDiscoveryMode(connParams.getSessionVars())) {
            ZooKeeperHiveClientHelper.configureConnParamsHA(connParams);
        } else {
            try (CuratorFramework zooKeeperClient = ZooKeeperHiveClientHelper.getZkClient(connParams);){
                List<String> serverHosts = ZooKeeperHiveClientHelper.getServerHosts(connParams, zooKeeperClient);
                if (serverHosts.isEmpty()) {
                    throw new ZooKeeperHiveClientException("Empty HiveServer2 URIs found from ZooKeeper to attempt");
                }
                String serverNode = serverHosts.get(ThreadLocalRandom.current().nextInt(serverHosts.size()));
                ZooKeeperHiveClientHelper.updateParamsWithZKServerNode(connParams, zooKeeperClient, serverNode);
            }
            catch (ZooKeeperHiveClientException zkhce) {
                throw zkhce;
            }
            catch (Exception e) {
                throw new ZooKeeperHiveClientException("Unable to read HiveServer2 configs from ZooKeeper", e);
            }
        }
    }

    private static void configureConnParamsHA(Utils.JdbcConnectionParams connParams) throws ZooKeeperHiveClientException {
        try {
            Configuration registryConf = new Configuration();
            registryConf.set(HiveConf.ConfVars.HIVE_ZOOKEEPER_QUORUM.varname, connParams.getZooKeeperEnsemble());
            registryConf.set(HiveConf.ConfVars.HIVE_SERVER2_ACTIVE_PASSIVE_HA_REGISTRY_NAMESPACE.varname, ZooKeeperHiveClientHelper.getZooKeeperNamespace(connParams));
            registryConf.setBoolean(HiveConf.ConfVars.HIVE_ZOOKEEPER_USE_KERBEROS.varname, ZooKeeperHiveClientHelper.isZkEnforceSASLClient(connParams.getSessionVars()));
            HS2ActivePassiveHARegistry haRegistryClient = HS2ActivePassiveHARegistryClient.getClient(registryConf);
            boolean foundLeader = false;
            String maxRetriesConf = connParams.getSessionVars().get("retries");
            int maxRetries = StringUtils.isEmpty(maxRetriesConf) ? 5 : Integer.parseInt(maxRetriesConf);
            int retries = 0;
            int sleepMs = 1000;
            while (!foundLeader && retries < maxRetries) {
                for (HiveServer2Instance hiveServer2Instance : haRegistryClient.getAll()) {
                    if (!hiveServer2Instance.isLeader()) continue;
                    foundLeader = true;
                    connParams.setHost(hiveServer2Instance.getHost());
                    connParams.setPort(hiveServer2Instance.getRpcPort());
                    Object mode = hiveServer2Instance.getTransportMode().equals("http") ? "http:/" + hiveServer2Instance.getHttpEndpoint() : hiveServer2Instance.getTransportMode();
                    LOG.info("Found HS2 Active Host: {} Port: {} Identity: {} Mode: {}", hiveServer2Instance.getHost(), hiveServer2Instance.getRpcPort(), hiveServer2Instance.getWorkerIdentity(), mode);
                    String serverConfStr = Joiner.on(';').withKeyValueSeparator("=").join(hiveServer2Instance.getProperties());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Configurations applied to JDBC connection params. {}", (Object)hiveServer2Instance.getProperties());
                    }
                    ZooKeeperHiveClientHelper.applyConfs(serverConfStr, connParams);
                    break;
                }
                if (foundLeader) continue;
                LOG.warn("Unable to connect to HS2 Active Host (No Leader Found!). Retrying after {} ms. retries: {}", (Object)sleepMs, (Object)retries);
                Thread.sleep(sleepMs);
                ++retries;
            }
            if (!foundLeader) {
                throw new ZooKeeperHiveClientException("Unable to connect to HiveServer2 Active host (No leader found!) after " + maxRetries + " retries.");
            }
        }
        catch (Exception e) {
            throw new ZooKeeperHiveClientException("Unable to read HiveServer2 configs from ZooKeeper", e);
        }
    }

    static List<Utils.JdbcConnectionParams> getDirectParamsList(Utils.JdbcConnectionParams connParams) throws ZooKeeperHiveClientException {
        try (CuratorFramework zooKeeperClient = null;){
            zooKeeperClient = ZooKeeperHiveClientHelper.getZkClient(connParams);
            List<String> serverHosts = ZooKeeperHiveClientHelper.getServerHosts(connParams, zooKeeperClient);
            if (serverHosts.isEmpty()) {
                throw new ZooKeeperHiveClientException("No more HiveServer2 URIs from ZooKeeper to attempt");
            }
            ArrayList<Utils.JdbcConnectionParams> directParamsList = new ArrayList<Utils.JdbcConnectionParams>(serverHosts.size());
            for (String serverNode : serverHosts) {
                Utils.JdbcConnectionParams directConnParams = new Utils.JdbcConnectionParams(connParams);
                directParamsList.add(directConnParams);
                ZooKeeperHiveClientHelper.updateParamsWithZKServerNode(directConnParams, zooKeeperClient, serverNode);
            }
            ArrayList<Utils.JdbcConnectionParams> arrayList = directParamsList;
            return arrayList;
        }
    }

    private static void applyConfs(String serverConfStr, Utils.JdbcConnectionParams connParams) throws Exception {
        Matcher matcher = kvPattern.matcher(serverConfStr);
        while (matcher.find()) {
            if (matcher.group(1) == null) continue;
            if (matcher.group(2) == null) {
                throw new Exception("Null config value for: " + matcher.group(1) + " published by the server.");
            }
            if (matcher.group(1).equals("hive.server2.thrift.bind.host")) {
                connParams.setHost(matcher.group(2));
            }
            if (matcher.group(1).equals("hive.server2.transport.mode") && !connParams.getSessionVars().containsKey("transportMode")) {
                connParams.getSessionVars().put("transportMode", matcher.group(2));
            }
            if (matcher.group(1).equals("hive.server2.thrift.port")) {
                connParams.setPort(Integer.parseInt(matcher.group(2)));
            }
            if (matcher.group(1).equals("hive.server2.thrift.http.port") && connParams.getPort() <= 0) {
                connParams.setPort(Integer.parseInt(matcher.group(2)));
            }
            if (matcher.group(1).equals("hive.server2.thrift.sasl.qop") && !connParams.getSessionVars().containsKey("saslQop")) {
                connParams.getSessionVars().put("saslQop", matcher.group(2));
            }
            if (matcher.group(1).equals("hive.server2.thrift.http.path") && !connParams.getSessionVars().containsKey("httpPath")) {
                connParams.getSessionVars().put("httpPath", matcher.group(2));
            }
            if (matcher.group(1) != null && matcher.group(1).equals("hive.server2.use.SSL") && !connParams.getSessionVars().containsKey("ssl")) {
                connParams.getSessionVars().put("ssl", matcher.group(2));
            }
            if (matcher.group(1).equals("hive.server2.authentication") && matcher.group(2).equalsIgnoreCase("NOSASL") && (!connParams.getSessionVars().containsKey("auth") || !connParams.getSessionVars().get("auth").equalsIgnoreCase("noSasl"))) {
                connParams.getSessionVars().put("auth", "noSasl");
            }
            if (!matcher.group(1).equalsIgnoreCase("hive.server2.authentication.kerberos.principal") || connParams.getSessionVars().containsKey("auth") && connParams.getSessionVars().get("auth").equalsIgnoreCase("delegationToken") || connParams.getSessionVars().containsKey("principal")) continue;
            connParams.getSessionVars().put("principal", matcher.group(2));
        }
    }
}

