/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.ganglia;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.sink.ganglia.GangliaConf;
import org.apache.hadoop.metrics2.sink.ganglia.GangliaMetricVisitor;
import org.apache.hadoop.metrics2.util.Servers;
import org.apache.hadoop.net.DNS;
import org.apache.hive.org.apache.commons.configuration2.SubsetConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGangliaSink
implements MetricsSink {
    public final Logger LOG = LoggerFactory.getLogger(this.getClass());
    public static final String DEFAULT_UNITS = "";
    public static final int DEFAULT_TMAX = 60;
    public static final int DEFAULT_DMAX = 0;
    public static final GangliaSlope DEFAULT_SLOPE = GangliaSlope.both;
    public static final int DEFAULT_PORT = 8649;
    public static final boolean DEFAULT_MULTICAST_ENABLED = false;
    public static final int DEFAULT_MULTICAST_TTL = 1;
    public static final String SERVERS_PROPERTY = "servers";
    public static final String MULTICAST_ENABLED_PROPERTY = "multicast";
    public static final String MULTICAST_TTL_PROPERTY = "multicast.ttl";
    public static final int BUFFER_SIZE = 1500;
    public static final String SUPPORT_SPARSE_METRICS_PROPERTY = "supportsparse";
    public static final boolean SUPPORT_SPARSE_METRICS_DEFAULT = false;
    public static final String EQUAL = "=";
    private String hostName = "UNKNOWN.example.com";
    private DatagramSocket datagramSocket;
    private List<? extends SocketAddress> metricsServers;
    private boolean multicastEnabled;
    private int multicastTtl;
    private byte[] buffer = new byte[1500];
    private int offset;
    private boolean supportSparseMetrics = false;
    protected final GangliaMetricVisitor gangliaMetricVisitor = new GangliaMetricVisitor();
    private SubsetConfiguration conf;
    private Map<String, GangliaConf> gangliaConfMap;
    private GangliaConf DEFAULT_GANGLIA_CONF = new GangliaConf();

    public List<? extends SocketAddress> getMetricsServers() {
        return this.metricsServers;
    }

    @Override
    public void init(SubsetConfiguration conf) {
        this.LOG.debug("Initializing the GangliaSink for Ganglia metrics.");
        this.conf = conf;
        if (conf.getString("slave.host.name") != null) {
            this.hostName = conf.getString("slave.host.name");
        } else {
            try {
                this.hostName = DNS.getDefaultHost(conf.getString("dfs.datanode.dns.interface", "default"), conf.getString("dfs.datanode.dns.nameserver", "default"));
            }
            catch (UnknownHostException uhe) {
                this.LOG.error(uhe.toString());
                this.hostName = "UNKNOWN.example.com";
            }
        }
        List<String> serversFromConf = conf.getList(String.class, SERVERS_PROPERTY, new ArrayList());
        this.metricsServers = Servers.parse(serversFromConf.size() > 0 ? String.join((CharSequence)",", serversFromConf) : null, 8649);
        this.multicastEnabled = conf.getBoolean(MULTICAST_ENABLED_PROPERTY, false);
        this.multicastTtl = conf.getInt(MULTICAST_TTL_PROPERTY, 1);
        this.gangliaConfMap = new HashMap<String, GangliaConf>();
        this.loadGangliaConf(GangliaConfType.units);
        this.loadGangliaConf(GangliaConfType.tmax);
        this.loadGangliaConf(GangliaConfType.dmax);
        this.loadGangliaConf(GangliaConfType.slope);
        try {
            if (this.multicastEnabled) {
                this.LOG.info("Enabling multicast for Ganglia with TTL " + this.multicastTtl);
                this.datagramSocket = new MulticastSocket();
                ((MulticastSocket)this.datagramSocket).setTimeToLive(this.multicastTtl);
            } else {
                this.datagramSocket = new DatagramSocket();
            }
        }
        catch (IOException e) {
            this.LOG.error(e.toString());
        }
        this.supportSparseMetrics = conf.getBoolean(SUPPORT_SPARSE_METRICS_PROPERTY, false);
    }

    @Override
    public void flush() {
    }

    private void loadGangliaConf(GangliaConfType gtype) {
        String[] propertyarr = this.conf.getStringArray(gtype.name());
        if (propertyarr != null && propertyarr.length > 0) {
            block6: for (String metricNValue : propertyarr) {
                String[] metricNValueArr = metricNValue.split(EQUAL);
                if (metricNValueArr.length != 2 || metricNValueArr[0].length() == 0) {
                    this.LOG.error("Invalid propertylist for " + gtype.name());
                }
                String metricName = metricNValueArr[0].trim();
                String metricValue = metricNValueArr[1].trim();
                GangliaConf gconf = this.gangliaConfMap.get(metricName);
                if (gconf == null) {
                    gconf = new GangliaConf();
                    this.gangliaConfMap.put(metricName, gconf);
                }
                switch (gtype) {
                    case units: {
                        gconf.setUnits(metricValue);
                        continue block6;
                    }
                    case dmax: {
                        gconf.setDmax(Integer.parseInt(metricValue));
                        continue block6;
                    }
                    case tmax: {
                        gconf.setTmax(Integer.parseInt(metricValue));
                        continue block6;
                    }
                    case slope: {
                        gconf.setSlope(GangliaSlope.valueOf(metricValue));
                    }
                }
            }
        }
    }

    protected GangliaConf getGangliaConfForMetric(String metricName) {
        GangliaConf gconf = this.gangliaConfMap.get(metricName);
        return gconf != null ? gconf : this.DEFAULT_GANGLIA_CONF;
    }

    protected String getHostName() {
        return this.hostName;
    }

    protected void xdr_string(String s2) {
        byte[] bytes = s2.getBytes(StandardCharsets.UTF_8);
        int len = bytes.length;
        this.xdr_int(len);
        System.arraycopy(bytes, 0, this.buffer, this.offset, len);
        this.offset += len;
        this.pad();
    }

    private void pad() {
        int newOffset = (this.offset + 3) / 4 * 4;
        while (this.offset < newOffset) {
            this.buffer[this.offset++] = 0;
        }
    }

    protected void xdr_int(int i) {
        this.buffer[this.offset++] = (byte)(i >> 24 & 0xFF);
        this.buffer[this.offset++] = (byte)(i >> 16 & 0xFF);
        this.buffer[this.offset++] = (byte)(i >> 8 & 0xFF);
        this.buffer[this.offset++] = (byte)(i & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void emitToGangliaHosts() throws IOException {
        try {
            for (SocketAddress socketAddress : this.metricsServers) {
                if (socketAddress == null || !(socketAddress instanceof InetSocketAddress)) {
                    throw new IllegalArgumentException("Unsupported Address type");
                }
                InetSocketAddress inetAddress = (InetSocketAddress)socketAddress;
                if (inetAddress.isUnresolved()) {
                    throw new UnknownHostException("Unresolved host: " + inetAddress);
                }
                DatagramPacket packet = new DatagramPacket(this.buffer, this.offset, socketAddress);
                this.datagramSocket.send(packet);
            }
        }
        finally {
            this.offset = 0;
        }
    }

    void resetBuffer() {
        this.offset = 0;
    }

    protected boolean isSupportSparseMetrics() {
        return this.supportSparseMetrics;
    }

    void setDatagramSocket(DatagramSocket datagramSocket) {
        this.datagramSocket = datagramSocket;
    }

    DatagramSocket getDatagramSocket() {
        return this.datagramSocket;
    }

    public static enum GangliaConfType {
        slope,
        units,
        dmax,
        tmax;

    }

    public static enum GangliaSlope {
        zero,
        positive,
        negative,
        both;

    }
}

