/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector.primitive;

import java.math.BigInteger;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;

public class JavaHiveDecimalObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements SettableHiveDecimalObjectInspector {
    public JavaHiveDecimalObjectInspector() {
    }

    public JavaHiveDecimalObjectInspector(DecimalTypeInfo typeInfo) {
        super(typeInfo);
    }

    @Override
    public HiveDecimalWritable getPrimitiveWritableObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            HiveDecimal dec = this.enforcePrecisionScale(HiveDecimal.create((String)o));
            return dec == null ? null : new HiveDecimalWritable(dec);
        }
        HiveDecimal dec = this.enforcePrecisionScale((HiveDecimal)o);
        return dec == null ? null : new HiveDecimalWritable(dec);
    }

    @Override
    public HiveDecimal getPrimitiveJavaObject(Object o) {
        return this.enforcePrecisionScale((HiveDecimal)o);
    }

    @Override
    public Object set(Object o, byte[] bytes, int scale) {
        return this.enforcePrecisionScale(HiveDecimal.create(new BigInteger(bytes), scale));
    }

    @Override
    public Object set(Object o, HiveDecimal t2) {
        return this.enforcePrecisionScale(t2);
    }

    @Override
    public Object set(Object o, HiveDecimalWritable t2) {
        return t2 == null ? null : this.enforcePrecisionScale(t2.getHiveDecimal());
    }

    @Override
    public Object create(byte[] bytes, int scale) {
        return HiveDecimal.create(new BigInteger(bytes), scale);
    }

    @Override
    public Object create(HiveDecimal t2) {
        return t2;
    }

    private HiveDecimal enforcePrecisionScale(HiveDecimal dec) {
        return HiveDecimalUtils.enforcePrecisionScale(dec, (DecimalTypeInfo)this.typeInfo);
    }
}

