/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.conf;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.conf.Validator;

public class TimeValidator
implements Validator {
    private final TimeUnit unit;
    private final Long min;
    private final boolean minInclusive;
    private final Long max;
    private final boolean maxInclusive;

    public TimeValidator(TimeUnit unit) {
        this(unit, null, false, null, false);
    }

    public TimeValidator(TimeUnit unit, Long min2, boolean minInclusive, Long max, boolean maxInclusive) {
        this.unit = unit;
        this.min = min2;
        this.minInclusive = minInclusive;
        this.max = max;
        this.maxInclusive = maxInclusive;
    }

    @Override
    public void validate(String value) {
        TimeUnit defaultUnit = this.unit;
        long time = MetastoreConf.convertTimeStr(value, defaultUnit, defaultUnit);
        if (this.min != null && (this.minInclusive ? time < this.min : time <= this.min)) {
            throw new IllegalArgumentException(value + " is smaller than minimum " + this.min + MetastoreConf.timeAbbreviationFor(defaultUnit));
        }
        if (this.max != null && (this.maxInclusive ? time > this.max : time >= this.max)) {
            throw new IllegalArgumentException(value + " is larger than maximum " + this.max + MetastoreConf.timeAbbreviationFor(defaultUnit));
        }
    }

    private String timeString(long time, TimeUnit timeUnit) {
        return time + " " + MetastoreConf.timeAbbreviationFor(timeUnit);
    }
}

