/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client.builder;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.client.HookEnabledMetaStoreClient;
import org.apache.hadoop.hive.metastore.client.SynchronizedMetaStoreClient;
import org.apache.hadoop.hive.metastore.client.ThriftHiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetaStoreClientBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMetaStoreClientBuilder.class);
    private final Configuration conf;
    private IMetaStoreClient client;

    public HiveMetaStoreClientBuilder(Configuration conf) {
        this.conf = Objects.requireNonNull(conf);
    }

    public HiveMetaStoreClientBuilder newClient(boolean allowEmbedded) throws MetaException {
        this.client = HiveMetaStoreClientBuilder.createClient(this.conf, allowEmbedded);
        return this;
    }

    public HiveMetaStoreClientBuilder client(IMetaStoreClient client) {
        this.client = client;
        return this;
    }

    public HiveMetaStoreClientBuilder enhanceWith(Function<IMetaStoreClient, IMetaStoreClient> wrapperFunction) {
        this.client = wrapperFunction.apply(this.client);
        return this;
    }

    public HiveMetaStoreClientBuilder withHooks(HiveMetaHookLoader hookLoader) {
        this.client = HookEnabledMetaStoreClient.newClient(this.conf, hookLoader, this.client);
        return this;
    }

    public HiveMetaStoreClientBuilder withRetry(Map<String, Long> metaCallTimeMap) throws MetaException {
        this.client = RetryingMetaStoreClient.getProxy(this.conf, metaCallTimeMap, this.client);
        return this;
    }

    public HiveMetaStoreClientBuilder threadSafe() {
        this.client = SynchronizedMetaStoreClient.newClient(this.conf, this.client);
        return this;
    }

    public IMetaStoreClient build() {
        return Objects.requireNonNull(this.client);
    }

    private static IMetaStoreClient createClient(Configuration conf, boolean allowEmbedded) throws MetaException {
        Class mscClass = MetastoreConf.getClass((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_CLIENT_IMPL, ThriftHiveMetaStoreClient.class, IMetaStoreClient.class);
        LOG.info("Using {} as a base MetaStoreClient", (Object)mscClass.getName());
        IMetaStoreClient baseMetaStoreClient = null;
        try {
            baseMetaStoreClient = (IMetaStoreClient)JavaUtils.newInstance((Class)mscClass, (Class[])new Class[]{Configuration.class, Boolean.TYPE}, (Object[])new Object[]{conf, allowEmbedded});
        }
        catch (Throwable t) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)t);
            if (rootCause instanceof MetaException) {
                throw (MetaException)rootCause;
            }
            throw new MetaException(rootCause.getMessage());
        }
        return baseMetaStoreClient;
    }
}

