/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.format;

import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.format.DateFormatSupplier;
import org.apache.accumulo.core.util.format.Formatter;
import org.apache.accumulo.core.util.format.FormatterConfig;
import org.apache.hadoop.io.Text;

public class DefaultFormatter
implements Formatter {
    private Iterator<Map.Entry<Key, Value>> si;
    protected FormatterConfig config;
    private static final ThreadLocal<DateFormat> formatter = DateFormatSupplier.createDefaultFormatSupplier();
    private static ThreadLocal<Date> tmpDate = new ThreadLocal<Date>(){

        @Override
        protected Date initialValue() {
            return new Date();
        }
    };

    @Override
    public void initialize(Iterable<Map.Entry<Key, Value>> scanner, FormatterConfig config) {
        this.checkState(false);
        this.si = scanner.iterator();
        this.config = new FormatterConfig(config);
    }

    @Override
    public boolean hasNext() {
        this.checkState(true);
        return this.si.hasNext();
    }

    @Override
    public String next() {
        this.checkState(true);
        return this.formatEntry(this.si.next());
    }

    @Override
    public void remove() {
        this.checkState(true);
        this.si.remove();
    }

    protected void checkState(boolean expectInitialized) {
        if (expectInitialized && this.si == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (!expectInitialized && this.si != null) {
            throw new IllegalStateException("Already initialized");
        }
    }

    public static String formatEntry(Map.Entry<Key, Value> entry, boolean showTimestamps) {
        DateFormat timestampFormat = null;
        if (showTimestamps) {
            timestampFormat = formatter.get();
        }
        return DefaultFormatter.formatEntry(entry, timestampFormat);
    }

    public static String formatEntry(Map.Entry<Key, Value> entry, DateFormat timestampFormat) {
        Value value;
        StringBuilder sb = new StringBuilder();
        Key key = entry.getKey();
        Text buffer = new Text();
        DefaultFormatter.appendText(sb, key.getRow(buffer)).append(" ");
        DefaultFormatter.appendText(sb, key.getColumnFamily(buffer)).append(":");
        DefaultFormatter.appendText(sb, key.getColumnQualifier(buffer)).append(" ");
        sb.append(new ColumnVisibility(key.getColumnVisibility(buffer)));
        if (timestampFormat != null) {
            tmpDate.get().setTime(entry.getKey().getTimestamp());
            sb.append(" ").append(timestampFormat.format(tmpDate.get()));
        }
        if ((value = entry.getValue()) != null && value.getSize() > 0) {
            sb.append("\t");
            DefaultFormatter.appendValue(sb, value);
        }
        return sb.toString();
    }

    public String formatEntry(Map.Entry<Key, Value> entry) {
        return DefaultFormatter.formatEntry(entry, this.config);
    }

    public static String formatEntry(Map.Entry<Key, Value> entry, FormatterConfig config) {
        Value value;
        StringBuilder sb = new StringBuilder();
        Key key = entry.getKey();
        Text buffer = new Text();
        int shownLength = config.getShownLength();
        DefaultFormatter.appendText(sb, key.getRow(buffer), shownLength).append(" ");
        DefaultFormatter.appendText(sb, key.getColumnFamily(buffer), shownLength).append(":");
        DefaultFormatter.appendText(sb, key.getColumnQualifier(buffer), shownLength).append(" ");
        sb.append(new ColumnVisibility(key.getColumnVisibility(buffer)));
        if (config.willPrintTimestamps() && config.getDateFormatSupplier() != null) {
            tmpDate.get().setTime(entry.getKey().getTimestamp());
            sb.append(" ").append(((DateFormat)config.getDateFormatSupplier().get()).format(tmpDate.get()));
        }
        if ((value = entry.getValue()) != null && value.getSize() > 0) {
            sb.append("\t");
            DefaultFormatter.appendValue(sb, value, shownLength);
        }
        return sb.toString();
    }

    static StringBuilder appendText(StringBuilder sb, Text t) {
        return DefaultFormatter.appendBytes(sb, t.getBytes(), 0, t.getLength());
    }

    public static StringBuilder appendText(StringBuilder sb, Text t, int shownLength) {
        return DefaultFormatter.appendBytes(sb, t.getBytes(), 0, t.getLength(), shownLength);
    }

    static StringBuilder appendValue(StringBuilder sb, Value value) {
        return DefaultFormatter.appendBytes(sb, value.get(), 0, value.get().length);
    }

    static StringBuilder appendValue(StringBuilder sb, Value value, int shownLength) {
        return DefaultFormatter.appendBytes(sb, value.get(), 0, value.get().length, shownLength);
    }

    static StringBuilder appendBytes(StringBuilder sb, byte[] ba, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            int c = 0xFF & ba[offset + i];
            if (c == 92) {
                sb.append("\\\\");
                continue;
            }
            if (c >= 32 && c <= 126) {
                sb.append((char)c);
                continue;
            }
            sb.append("\\x").append(String.format("%02X", c));
        }
        return sb;
    }

    static StringBuilder appendBytes(StringBuilder sb, byte[] ba, int offset, int len, int shownLength) {
        int length = Math.min(len, shownLength);
        return DefaultFormatter.appendBytes(sb, ba, offset, length);
    }

    public Iterator<Map.Entry<Key, Value>> getScannerIterator() {
        return this.si;
    }

    protected boolean isDoTimestamps() {
        return this.config.willPrintTimestamps();
    }
}

