/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.user.CfCqSliceOpts;

public class CfCqSliceFilter
extends Filter {
    private CfCqSliceOpts cso;

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.cso = new CfCqSliceOpts(options);
    }

    @Override
    public boolean accept(Key k, Value v) {
        PartialKey inSlice = this.isKeyInSlice(k);
        return inSlice == PartialKey.ROW_COLFAM_COLQUAL;
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        CfCqSliceFilter o = (CfCqSliceFilter)super.deepCopy(env);
        o.cso = new CfCqSliceOpts(this.cso);
        return o;
    }

    private PartialKey isKeyInSlice(Key k) {
        int maxCqComp;
        int minCqComp;
        int maxCfComp;
        int minCfComp;
        if (this.cso.minCf.getLength() > 0 && ((minCfComp = k.compareColumnFamily(this.cso.minCf)) < 0 || minCfComp == 0 && !this.cso.minInclusive)) {
            return PartialKey.ROW;
        }
        if (this.cso.maxCf.getLength() > 0 && ((maxCfComp = k.compareColumnFamily(this.cso.maxCf)) > 0 || maxCfComp == 0 && !this.cso.maxInclusive)) {
            return PartialKey.ROW;
        }
        if (this.cso.minCq.getLength() > 0 && ((minCqComp = k.compareColumnQualifier(this.cso.minCq)) < 0 || minCqComp == 0 && !this.cso.minInclusive)) {
            return PartialKey.ROW_COLFAM;
        }
        if (this.cso.maxCq.getLength() > 0 && ((maxCqComp = k.compareColumnQualifier(this.cso.maxCq)) > 0 || maxCqComp == 0 && !this.cso.maxInclusive)) {
            return PartialKey.ROW_COLFAM;
        }
        return PartialKey.ROW_COLFAM_COLQUAL;
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        return new CfCqSliceOpts.Describer().describeOptions();
    }

    @Override
    public boolean validateOptions(Map<String, String> options) {
        return new CfCqSliceOpts.Describer().validateOptions(options);
    }
}

