/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapreduce;

import java.io.IOException;
import org.apache.accumulo.core.client.mapreduce.lib.impl.ConfiguratorBase;
import org.apache.accumulo.core.client.mapreduce.lib.impl.FileOutputConfigurator;
import org.apache.accumulo.core.client.rfile.RFile;
import org.apache.accumulo.core.client.rfile.RFileWriter;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.log4j.Logger;

public class AccumuloFileOutputFormat
extends FileOutputFormat<Key, Value> {
    private static final Class<?> CLASS = AccumuloFileOutputFormat.class;
    protected static final Logger log = Logger.getLogger(CLASS);

    @Deprecated
    protected static AccumuloConfiguration getAccumuloConfiguration(JobContext context) {
        return FileOutputConfigurator.getAccumuloConfiguration(CLASS, context.getConfiguration());
    }

    public static void setCompressionType(Job job, String compressionType) {
        FileOutputConfigurator.setCompressionType(CLASS, job.getConfiguration(), compressionType);
    }

    public static void setDataBlockSize(Job job, long dataBlockSize) {
        FileOutputConfigurator.setDataBlockSize(CLASS, job.getConfiguration(), dataBlockSize);
    }

    public static void setFileBlockSize(Job job, long fileBlockSize) {
        FileOutputConfigurator.setFileBlockSize(CLASS, job.getConfiguration(), fileBlockSize);
    }

    public static void setIndexBlockSize(Job job, long indexBlockSize) {
        FileOutputConfigurator.setIndexBlockSize(CLASS, job.getConfiguration(), indexBlockSize);
    }

    public static void setReplication(Job job, int replication) {
        FileOutputConfigurator.setReplication(CLASS, job.getConfiguration(), replication);
    }

    public static void setSampler(Job job, SamplerConfiguration samplerConfig) {
        FileOutputConfigurator.setSampler(CLASS, job.getConfiguration(), samplerConfig);
    }

    public RecordWriter<Key, Value> getRecordWriter(TaskAttemptContext context) throws IOException {
        final Configuration conf = context.getConfiguration();
        final AccumuloConfiguration acuConf = FileOutputConfigurator.getAccumuloConfiguration(CLASS, context.getConfiguration());
        String extension = acuConf.get(Property.TABLE_FILE_TYPE);
        final Path file = this.getDefaultWorkFile(context, "." + extension);
        final int visCacheSize = ConfiguratorBase.getVisibilityCacheSize(conf);
        return new RecordWriter<Key, Value>(){
            RFileWriter out = null;

            public void close(TaskAttemptContext context) throws IOException {
                if (this.out != null) {
                    this.out.close();
                }
            }

            public void write(Key key, Value value) throws IOException {
                if (this.out == null) {
                    this.out = RFile.newWriter().to(file.toString()).withFileSystem(file.getFileSystem(conf)).withTableProperties(acuConf).withVisibilityCacheSize(visCacheSize).build();
                    this.out.startDefaultLocalityGroup();
                }
                this.out.append(key, value);
            }
        };
    }
}

