/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.binder.jvm;

import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.FunctionCounter;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.MeterRegistry;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.Tag;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.Tags;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.binder.MeterBinder;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.lang.NonNullApi;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.lang.NonNullFields;

@NonNullApi
@NonNullFields
public class JvmCompilationMetrics
implements MeterBinder {
    private final Iterable<Tag> tags;

    public JvmCompilationMetrics() {
        this(Collections.emptyList());
    }

    public JvmCompilationMetrics(Iterable<Tag> tags) {
        this.tags = tags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        CompilationMXBean compilationBean = ManagementFactory.getCompilationMXBean();
        if (compilationBean != null && compilationBean.isCompilationTimeMonitoringSupported()) {
            FunctionCounter.builder("jvm.compilation.time", compilationBean, CompilationMXBean::getTotalCompilationTime).tags(Tags.concat(this.tags, "compiler", compilationBean.getName())).description("The approximate accumulated elapsed time spent in compilation").baseUnit("ms").register(registry);
        }
    }
}

