/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.apache.hive.kudu.org.apache.kudu.Schema;
import org.apache.hive.kudu.org.apache.kudu.client.CallResponse;
import org.apache.hive.kudu.org.apache.kudu.client.CreateTableOptions;
import org.apache.hive.kudu.org.apache.kudu.client.CreateTableResponse;
import org.apache.hive.kudu.org.apache.kudu.client.KuduException;
import org.apache.hive.kudu.org.apache.kudu.client.KuduRpc;
import org.apache.hive.kudu.org.apache.kudu.client.KuduTable;
import org.apache.hive.kudu.org.apache.kudu.client.ProtobufHelper;
import org.apache.hive.kudu.org.apache.kudu.master.Master;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.util.Timer;
import org.apache.hive.kudu.org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class CreateTableRequest
extends KuduRpc<CreateTableResponse> {
    static final String CREATE_TABLE = "CreateTable";
    private final Schema schema;
    private final String name;
    private final Master.CreateTableRequestPB.Builder builder;
    private final List<Integer> featureFlags;

    CreateTableRequest(KuduTable masterTable, String name, Schema schema, CreateTableOptions cto, Timer timer, long timeoutMillis) {
        super(masterTable, timer, timeoutMillis);
        this.schema = schema;
        this.name = name;
        this.builder = cto.getBuilder();
        this.featureFlags = cto.getRequiredFeatureFlags(schema);
    }

    @Override
    Message createRequestPB() {
        this.builder.setName(this.name);
        this.builder.setSchema(ProtobufHelper.schemaToPb(this.schema, EnumSet.of(ProtobufHelper.SchemaPBConversionFlags.SCHEMA_PB_WITHOUT_ID)));
        return this.builder.build();
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return CREATE_TABLE;
    }

    @Override
    Pair<CreateTableResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Master.CreateTableResponsePB.Builder builder = Master.CreateTableResponsePB.newBuilder();
        CreateTableRequest.readProtobuf(callResponse.getPBMessage(), builder);
        CreateTableResponse response = new CreateTableResponse(this.timeoutTracker.getElapsedMillis(), tsUUID, builder.getTableId().toStringUtf8());
        return new Pair<CreateTableResponse, Object>(response, builder.hasError() ? builder.getError() : null);
    }

    @Override
    Collection<Integer> getRequiredFeatures() {
        return this.featureFlags;
    }
}

